/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.bgavailablebalance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.control.BillPreOpenCheckUtil;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.IBgControlCaller;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;
import kd.epm.eb.formplugin.control.ControlRuleHelper;
import org.jetbrains.annotations.NotNull;

public class BgAvailBalanceListPlugin
extends AbstractListPlugin
implements RowClickEventListener,
CellClickListener {
    private static final String upperentity = "upperentity";
    private static final String netherentity = "netherentity";
    private static final Log log = LogFactory.getLog(BgAvailBalanceListPlugin.class);
    private IBgControlCaller iBgControlCaller = new BgControlCallerImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(upperentity);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid netherEntryGrid = (EntryGrid)this.getView().getControl(netherentity);
        netherEntryGrid.addCellClickListener((CellClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCustomParamVisible();
        this.createUpperEntity();
    }

    private void setCustomParamVisible() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        DynamicObject dataEntity = parentView.getModel().getDataEntity(true);
        QFilter qFilter = new QFilter("bill.fieldtable", "=", (Object)dataEntity.getDataEntityType().getName());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_custom_param", (String)"bill,paramjson", (QFilter[])qFilter.toArray());
        String paramjson = dynamicObject != null ? dynamicObject.getString("paramjson") : "{\"modelname\":1,\"rorgunit\":0,\"account\":0,\"version\":1,\"currency\":1,\"period\":0,\"changetype\":1,\"auditTrail\":1,\"allmember\":0,\"groupname\":0,\"controltype\":0,\"isgroup\":1,\"coefficient\":1,\"isbeyond\":0,\"budget\":0,\"realbudget\":1\n,\"actual\":1,\"acturechanges\":0,\"budgetoccupation\":0,\"occupation\":0,\"execute\":0,\"balane\":0}";
        HashMap paramMap = (HashMap)JSONObject.parseObject((String)paramjson, HashMap.class);
        for (Map.Entry entry : paramMap.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{(String)entry.getKey()});
        }
    }

    private void createUpperEntity() {
        Object bizId = this.getView().getFormShowParameter().getCustomParam("bizId");
        Long _id = null;
        Long _modelId = null;
        HashSet<Long> modelIds = new HashSet<Long>(10);
        if (bizId instanceof Integer) {
            _id = Long.valueOf(((Integer)bizId).toString());
        }
        Collection bgBalances = null;
        try {
            if (_id != null && _id != 0L) {
                String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
                bgBalances = this.iBgControlCaller.queryBalance(entityNumber, String.valueOf(_id));
            } else {
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                if (parentView == null) {
                    return;
                }
                DynamicObject dataEntity = parentView.getModel().getDataEntity(true);
                DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dataEntity, (boolean)true, (boolean)false);
                bgBalances = this.iBgControlCaller.queryBalance(clone);
            }
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        if (bgBalances == null || bgBalances.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u65e0\u53ef\u7528\u9884\u7b97\u4f59\u989d\u6216\u8005\u79d1\u76ee\u5728\u767d\u540d\u5355\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgAvailBalanceListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder balLog = new StringBuilder();
        balLog.append("budget-control-log : ").append(bizId).append("\r\n");
        for (IBudgetBalance bal : bgBalances) {
            balLog.append(JSONUtils.toString((Object)bal.toMap())).append("\r\n");
        }
        log.info(balLog.toString());
        HashSet keys = Sets.newHashSetWithExpectedSize((int)bgBalances.size());
        ArrayList removes = Lists.newArrayListWithCapacity((int)bgBalances.size());
        HashSet<Long> groupIds = new HashSet<Long>(10);
        Long groupId = 0L;
        for (IBudgetBalance bgBalance : bgBalances) {
            groupId = 0L;
            if (bgBalance.getControlScheme() != null && bgBalance.getControlScheme().getGroupId() != null) {
                groupIds.add(bgBalance.getControlScheme().getGroupId());
                groupId = bgBalance.getControlScheme().getGroupId();
            }
            String key = bgBalance.getMemberKey(true, (Collection)bgBalance.getBizModel().getDimensions());
            key = key + "_" + bgBalance.getSetting().getId();
            key = key + "_" + groupId;
            if (!this.isBudget(bgBalance)) {
                key = key + bgBalance.getMemberKey(false, (Collection)bgBalance.getBizModel().getDimensions());
            }
            if (keys.add(key)) continue;
            removes.add(bgBalance);
        }
        if (!removes.isEmpty()) {
            bgBalances.removeAll(removes);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(upperentity);
        int i = 0;
        HashMap<Integer, Map> totalExtAcData = new HashMap<Integer, Map>(bgBalances.size());
        HashMap<Integer, Map> totalUserDimMember = new HashMap<Integer, Map>(bgBalances.size());
        HashMap<Integer, Map<String, kd.epm.eb.common.model.Member>> notLeafMember = new HashMap<Integer, Map<String, kd.epm.eb.common.model.Member>>(bgBalances.size());
        Collection userDefineDims = null;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acturechanges"});
        HashMap<Long, Map> memberCheckMap = new HashMap<Long, Map>(bgBalances.size());
        Map subMemberCheck = null;
        Set subDimSet = null;
        HashMap<Long, Map> hasPermMap = new HashMap<Long, Map>(bgBalances.size());
        Map submemberPerm = null;
        Map subBussPerm = null;
        boolean isCheckMemberPerm = true;
        if (isCheckMemberPerm) {
            for (IBudgetBalance iBudgetBalance : bgBalances) {
                if (iBudgetBalance.getBizModel() == null || !iBudgetBalance.isCheckPermission()) continue;
                subMemberCheck = memberCheckMap.computeIfAbsent(iBudgetBalance.getBizModel().getId(), f -> new HashMap(10));
                subDimSet = subMemberCheck.computeIfAbsent(iBudgetBalance.getBizModel().getControlBusModelId() == null ? Long.valueOf(0L) : iBudgetBalance.getBizModel().getControlBusModelId(), f -> new HashSet(10));
                subDimSet.add(SysDimensionEnum.Entity.getNumber());
                subDimSet.add(SysDimensionEnum.Account.getNumber());
                userDefineDims = iBudgetBalance.getBizModel().getUserDefinedDimensions();
                if (userDefineDims == null) continue;
                for (kd.epm.eb.common.model.Dimension d : userDefineDims) {
                    subDimSet.add(d.getNumber());
                }
            }
            for (Map.Entry entry : memberCheckMap.entrySet()) {
                _modelId = (Long)entry.getKey();
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)_modelId);
                submemberPerm = hasPermMap.computeIfAbsent(_modelId, f -> new HashMap(10));
                for (Map.Entry bussModelEntry : ((Map)entry.getValue()).entrySet()) {
                    subBussPerm = submemberPerm.computeIfAbsent(bussModelEntry.getKey(), f -> new HashMap(10));
                    if (!CommonUtils.hasBusinessModel((Long)_modelId).booleanValue()) {
                        for (String dimensionNumber : (Set)bussModelEntry.getValue()) {
                            subBussPerm.put(dimensionNumber, DimMembPermHelper.getReadPermMembIds((String)dimensionNumber, (Long)_modelId, (Long)((Long)bussModelEntry.getKey()), null, (boolean)true));
                        }
                        continue;
                    }
                    for (String dimensionNumber : (Set)bussModelEntry.getValue()) {
                        Long businessModelId = (Long)bussModelEntry.getKey();
                        List viewIds = modelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(businessModelId, "Entity");
                        for (Long viewId : viewIds) {
                            Set hasPermMemberIdList = DimMembPermHelper.getReadPermMembIds((String)dimensionNumber, (Long)_modelId, (Long)((Long)bussModelEntry.getKey()), (Long)viewId, (boolean)true);
                            if (hasPermMemberIdList == null) continue;
                            subBussPerm.computeIfAbsent(dimensionNumber, f -> new HashSet(10)).addAll(hasPermMemberIdList);
                        }
                    }
                }
            }
        }
        LinkedHashMap<String, Map<String, Map<String, String>>> noPerm = new LinkedHashMap<String, Map<String, Map<String, String>>>(10);
        ArrayList arrayList = new ArrayList(bgBalances);
        Iterator it = arrayList.iterator();
        while (it.hasNext()) {
            IBudgetBalance bgBalance = (IBudgetBalance)it.next();
            isCheckMemberPerm = bgBalance.isCheckPermission();
            boolean hasPerm = true;
            if (bgBalance.getBizModel() != null && isCheckMemberPerm) {
                subBussPerm = (Map)((Map)hasPermMap.get(bgBalance.getBizModel().getId())).get(bgBalance.getBizModel().getControlBusModelId() == null ? Long.valueOf(0L) : bgBalance.getBizModel().getControlBusModelId());
                if (userDefineDims == null) {
                    userDefineDims = bgBalance.getBizModel().getUserDefinedDimensions();
                }
                if (!this.checkPermission(bgBalance, bgBalance.getOrgUnit(true), subBussPerm, noPerm)) {
                    hasPerm = false;
                }
                if (!this.checkPermission(bgBalance, bgBalance.getAccount(true), subBussPerm, noPerm)) {
                    hasPerm = false;
                }
                if (userDefineDims != null) {
                    for (kd.epm.eb.common.model.Dimension d : userDefineDims) {
                        if (this.checkPermission(bgBalance, bgBalance.getMember(true, d.getNumber()), subBussPerm, noPerm)) continue;
                        hasPerm = false;
                    }
                }
            }
            if (hasPerm) continue;
            it.remove();
        }
        if (arrayList.size() > 0) {
            model.batchCreateNewEntryRow(upperentity, arrayList.size());
        }
        Map groupNames = ControlException.queryGroupName(groupIds);
        HashMap<Long, Collection> userDefDimMaps = new HashMap<Long, Collection>(10);
        for (Object bgBalance : arrayList) {
            DynamicObject entity = model.getEntryRowEntity(upperentity, i);
            entity.set("modelname", (Object)bgBalance.getBizModel().getName());
            int controlType = bgBalance.getSetting().getSettingType().getIndex();
            this.setNotLeafMember(notLeafMember, (IBudgetBalance)bgBalance, i);
            _modelId = bgBalance.getBizModel().getId();
            modelIds.add(_modelId);
            userDefineDims = userDefDimMaps.computeIfAbsent(bgBalance.getBizModel().getKey(), arg_0 -> BgAvailBalanceListPlugin.lambda$createUpperEntity$5((IBudgetBalance)bgBalance, arg_0));
            String memberString = BgControlUtils.getMemberString((IBudgetBalance)bgBalance, (boolean)true, (Collection)userDefineDims);
            Map extAcData = bgBalance.getExtAcData();
            if (extAcData != null && !extAcData.isEmpty()) {
                totalExtAcData.put(i, extAcData);
            } else {
                Map memberMap = BgControlUtils.getMemberMap((IBudgetBalance)bgBalance, (boolean)true, (Collection)userDefineDims);
                totalUserDimMember.put(i, memberMap);
            }
            log.info("budget-control-log :  BgAvailBalanceListPlugin " + JSONUtils.toString((Object)bgBalance.toMap()));
            if (bgBalance.getControlScheme() != null && bgBalance.getControlScheme().getGroupId() != null) {
                String gName = (String)groupNames.get(String.valueOf(bgBalance.getControlScheme().getGroupId()));
                if (gName == null) {
                    gName = bgBalance.getControlScheme().getGroupNumber();
                }
                entity.set("groupname", (Object)gName);
            }
            entity.set("allmember", (Object)memberString);
            entity.set("rorgunit", (Object)this.showMember(bgBalance.getOrgUnit(true)));
            entity.set("account", (Object)this.showMember(bgBalance.getAccount(true)));
            entity.set("version", (Object)bgBalance.getVersion(true).getName());
            entity.set("currency", (Object)bgBalance.getCurrency(true).getName());
            entity.set("period", (Object)bgBalance.getPeriod(true).getName());
            entity.set("changetype", (Object)bgBalance.getMember(true, SysDimensionEnum.ChangeType.getNumber()).getName());
            entity.set("audittrailid", (Object)bgBalance.getMember(true, SysDimensionEnum.AuditTrail.getNumber()).getId());
            entity.set("audittrail", (Object)bgBalance.getAuditTrail(true).getName());
            entity.set("modelid", (Object)bgBalance.getBizModel().getId());
            entity.set("orgunitid", (Object)bgBalance.getOrgUnit(true).getId());
            entity.set("accountid", (Object)bgBalance.getAccount(true).getId());
            entity.set("versionid", (Object)bgBalance.getVersion(true).getId());
            entity.set("currencyid", (Object)bgBalance.getCurrency(true).getId());
            if (bgBalance.getBizModel().isEBByModel()) {
                entity.set("yearid", (Object)bgBalance.getYear(true).getId());
                entity.set("periodid", (Object)bgBalance.getPeriod(true).getId());
            } else {
                entity.set("yearid", (Object)0L);
                entity.set("periodid", (Object)bgBalance.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getId());
            }
            entity.set("controltype", (Object)this.showCtrlSet(bgBalance.getSetting()));
            entity.set("controltypeindex", (Object)controlType);
            entity.set("isbeyond", (Object)bgBalance.getSetting().isBeyond());
            entity.set("groupid", (Object)bgBalance.getSetting().getGroupId());
            if (bgBalance.getSetting().getGroupName() == null) {
                entity.set("isgroup", (Object)ResManager.loadKDString((String)"\u672a\u5206\u7ec4", (String)"BgAvailBalanceListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                entity.set("isgroup", (Object)(bgBalance.getSetting().getGroupName() + "(" + bgBalance.getSetting().getGroupNo() + ")"));
            }
            entity.set("coefficient", (Object)bgBalance.getSetting().getCoefficient());
            entity.set("budget", (Object)bgBalance.getBudget());
            entity.set("realbudget", (Object)bgBalance.getRealBudget());
            entity.set("actual", (Object)bgBalance.getActual());
            entity.set("bussmodel", (Object)bgBalance.getBizModel().getControlBusModelId());
            BigDecimal budgetOccupation = bgBalance.getBudgetOccupation() == null ? BigDecimal.ZERO : bgBalance.getBudgetOccupation().abs();
            entity.set("budgetoccupation", (Object)budgetOccupation);
            if (bgBalance.getActualChanges() != null && BigDecimal.ZERO.compareTo(bgBalance.getActualChanges()) != 0) {
                entity.set("acturechanges", (Object)bgBalance.getActualChanges());
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acturechanges"});
            }
            entity.set("occupation", (Object)bgBalance.getOccupation());
            entity.set("execute", (Object)bgBalance.getExecute());
            entity.set("balane", (Object)bgBalance.getBalance());
            Map toMaps = bgBalance.toMap();
            toMaps.put("definedDimMem", memberString);
            this.getPageCache().put("budgetEntry" + i, SerializationUtils.serializeToBase64((Object)toMaps));
            ++i;
        }
        this.getPageCache().put("setNotLeafMember", SerializationUtils.serializeToBase64(notLeafMember));
        this.getPageCache().put("totalExtAcData", SerializationUtils.serializeToBase64(totalExtAcData));
        this.getPageCache().put("totalUserDimMemb", SerializationUtils.serializeToBase64(totalUserDimMember));
        boolean isOpenReduceBill = ControlParamsSettingUtil.isOpenReduceBill((Long)_modelId);
        for (Long modelId : modelIds) {
            if (isOpenReduceBill) break;
            isOpenReduceBill = ControlParamsSettingUtil.isOpenReduceBill((Long)modelId);
        }
        if (!isOpenReduceBill) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"budgetoccupation"});
        }
        this.getView().updateView(upperentity);
        String split = ResManager.loadKDString((String)"\u3001", (String)"BgAvailBalanceListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (!noPerm.isEmpty()) {
            ArrayList<String> msgs = new ArrayList<String>(10);
            for (Map.Entry<String, Map<String, Map<String, String>>> entryModel : noPerm.entrySet()) {
                int index = 1;
                String msg = ResManager.loadResFormat((String)"\u7528\u6237\u6ca1\u6709\u9884\u7b97\u4f53\u7cfb\uff08%1\uff09\u4ee5\u4e0b\u7ef4\u5ea6\u6210\u5458\u8bfb\u53d6\u6743\u9650\uff0c\u65e0\u6cd5\u663e\u793a\u5bf9\u5e94\u5206\u5f55\u7684\u53ef\u7528\u4f59\u989d\uff1a", (String)"BgAvailBalanceListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{entryModel.getKey()});
                msgs.add(msg);
                for (Map.Entry<String, Map<String, String>> entry : entryModel.getValue().entrySet()) {
                    msgs.add(ResManager.loadResFormat((String)"%1\u3001%2\uff1a%3", (String)"BgAvailBalanceListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{index, entry.getKey().substring(entry.getKey().indexOf(95) + 1), StringUtils.join(entry.getValue().values(), (String)split)}));
                    ++index;
                }
            }
            this.getView().showTipNotification(StringUtils.join(msgs, (String)"\r\n"));
        }
    }

    private boolean checkPermission(IBudgetBalance bgBalance, kd.epm.eb.common.model.Member member, Map<String, Set<Long>> subBussPerm, LinkedHashMap<String, Map<String, Map<String, String>>> noPerm) {
        if (subBussPerm == null || bgBalance == null || member == null || noPerm == null || bgBalance.getBizModel() == null) {
            return true;
        }
        Set<Long> hasPerm = subBussPerm.get(member.getDimension().getNumber());
        if (hasPerm == null) {
            return true;
        }
        if (hasPerm.contains(member.getId())) {
            return true;
        }
        String modelkey = bgBalance.getBizModel().getNumber() + " - " + bgBalance.getBizModel().getName();
        String key = (member.getDimension().getSeq() >= 10 ? "" : "0") + member.getDimension().getSeq() + '_' + member.getDimension().getName();
        noPerm.computeIfAbsent(modelkey, g -> new HashMap(10)).computeIfAbsent(key, f -> new TreeMap()).put(member.getNumber(), member.getNumber() + " - " + member.getName());
        return false;
    }

    private String showMember(kd.epm.eb.common.model.Member member) {
        if (member == null) {
            return "";
        }
        return member.getName() + "(" + member.getNumber() + ")";
    }

    private String showCtrlSet(BgControlSetting setting) {
        if (setting == null) {
            return "";
        }
        if (setting.getGroupNo() > 0) {
            return setting.getSettingType().getName();
        }
        return setting.getSettingType().getName();
    }

    private boolean isBudget(IBudgetBalance bgBalance) {
        kd.epm.eb.common.model.Member bgEntity = bgBalance.getMember(true, SysDimensionEnum.Entity.getNumber());
        kd.epm.eb.common.model.Member acEntity = bgBalance.getMember(false, SysDimensionEnum.Entity.getNumber());
        kd.epm.eb.common.model.Member bgAccount = bgBalance.getMember(true, SysDimensionEnum.Account.getNumber());
        kd.epm.eb.common.model.Member acAccount = bgBalance.getMember(false, SysDimensionEnum.Account.getNumber());
        return acEntity.getLongNumber().contains(bgEntity.getLongNumber()) && acAccount.getLongNumber().contains(bgAccount.getLongNumber());
    }

    private void setNotLeafMember(Map<Integer, Map<String, kd.epm.eb.common.model.Member>> notLeafMember, IBudgetBalance bgBalance, int i) {
        List dimensions = bgBalance.getBizModel().getDimensions();
        HashMap<String, kd.epm.eb.common.model.Member> map = new HashMap<String, kd.epm.eb.common.model.Member>(dimensions.size());
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            map.put(dimension.getNumber(), bgBalance.getMember(this.isBudget(bgBalance), dimension.getNumber()));
        }
        notLeafMember.put(i, map);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObject entity = this.getModel().getEntryRowEntity(upperentity, row);
        if (entity == null) {
            return;
        }
        Long modelid = entity.getLong("modelid");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelid);
        Map allMember = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("setNotLeafMember"));
        DetailQuery query = new DetailQuery(modelCacheHelper, entity, (Map)allMember.get(row));
        this.getModel().deleteEntryData(netherentity);
        List<BgControlRecord> records = query.query();
        if (records != null) {
            query.fillDetailRecord(this.getModel(), this.getView(), records);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "refresh": {
                this.createUpperEntity();
                break;
            }
            case "exit": {
                this.getView().close();
                break;
            }
            case "caldetail": {
                HashMap<String, String> params = new HashMap<String, String>(16);
                EntryGrid entryGrid = (EntryGrid)this.getControl(upperentity);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0 || selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BgAvailBalanceListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map allMember = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("setNotLeafMember"));
                int rowIndex = selectRows[0];
                Map stringMemberMap = (Map)allMember.get(selectRows[0]);
                String serMemberData = SerializationUtils.serializeToBase64((Object)stringMemberMap);
                params.put("memberData", serMemberData);
                params.put("budgetBalance", this.getPageCache().get("budgetEntry" + rowIndex));
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("eb_balancecaldetail");
                parameter.setCustomParams(params);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            }
        }
    }

    public void destory() {
        super.destory();
        ModelCacheContext.remove();
        MemberPropCacheService.remove();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        EntryGrid entryGrid = (EntryGrid)cellClickEvent.getSource();
        String fieldKey = cellClickEvent.getFieldKey();
        int rowIndex = cellClickEvent.getRow();
        if (rowIndex < 0) {
            return;
        }
        if ("biznumber".equals(fieldKey)) {
            String billNumber = (String)entryGrid.getModel().getValue("billnumber", rowIndex);
            Long bizId = (Long)entryGrid.getModel().getValue("bizid", rowIndex);
            String appId = BillPreOpenCheckUtil.getInstance().checkViewPerm(billNumber, (Object)bizId, this.getView());
            HashMap<String, String> openParameter = new HashMap<String, String>(16);
            openParameter.put("formId", billNumber);
            openParameter.put("pkId", String.valueOf(bizId));
            openParameter.put("checkRightAppId", appId);
            log.info("checkRightAppId:" + appId);
            BillShowParameter showParameter = (BillShowParameter)FormShowParameter.createFormShowParameter(openParameter);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private static /* synthetic */ Collection lambda$createUpperEntity$5(IBudgetBalance bgBalance, Long f) {
        return bgBalance.getBizModel().getUserDefinedDimensions();
    }

    static class DetailQuery {
        private IModelCacheHelper modelCacheHelper;
        private DynamicObject balance;
        private Map<String, kd.epm.eb.common.model.Member> memberMap;
        private Map<String, String> billInfoMap = new HashMap<String, String>();
        private Map<Long, String> orgMap = new HashMap<Long, String>();
        private Map<Long, String> accountMap = new HashMap<Long, String>();
        private Map<String, Map<Long, String>> reqObjInfo = new HashMap<String, Map<Long, String>>();
        private Map<String, String> operationMap = new HashMap<String, String>();
        private Map<String, Map<String, DynamicObject>> bizMap = new HashMap<String, Map<String, DynamicObject>>();
        private static final String CREATOR1 = "applier";
        private static final String CREATOR2 = "creator";

        public DetailQuery(IModelCacheHelper modelCacheHelper, DynamicObject balance, Map<String, kd.epm.eb.common.model.Member> memberMap) {
            this.modelCacheHelper = modelCacheHelper;
            this.balance = balance;
            this.memberMap = memberMap;
        }

        public List<BgControlRecord> query() {
            DynamicObject group;
            if (this.modelCacheHelper == null || this.balance == null) {
                return null;
            }
            this.billInfoMap.clear();
            this.orgMap.clear();
            this.accountMap.clear();
            this.operationMap.clear();
            this.bizMap.clear();
            boolean isEb = this.modelCacheHelper.getModelobj().isModelByEB();
            String _field = null;
            kd.epm.eb.common.model.Member member = null;
            List dimensions = this.modelCacheHelper.getDimensionList();
            Long modelId = this.balance.getLong("modelid");
            int controlType = this.balance.getInt("controltypeindex");
            HashMap memberIds = Maps.newHashMapWithExpectedSize((int)dimensions.size());
            if (this.memberMap != null) {
                for (Dimension dimension : dimensions) {
                    if (SysDimensionEnum.Version.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.DataType.getNumber().equals(dimension.getNumber()) || (member = this.memberMap.get(dimension.getNumber())) == null) continue;
                    memberIds.put(dimension.getNumber(), member.getId());
                }
            } else {
                memberIds.put(SysDimensionEnum.Entity.getNumber(), this.balance.getLong("orgunitid"));
                memberIds.put(SysDimensionEnum.Account.getNumber(), this.balance.getLong("accountid"));
                memberIds.put(SysDimensionEnum.BudgetPeriod.getNumber(), this.balance.getLong("periodid"));
                memberIds.put(SysDimensionEnum.Currency.getNumber(), this.balance.getLong("currencyid"));
            }
            DynamicObject ctrlDim = null;
            Long busModeId = null;
            Long viewId = null;
            String crTable = null;
            Set dimIds = null;
            Map viewIds = null;
            if (isEb) {
                crTable = "t_eb_bgcontrolrecord";
            } else {
                ctrlDim = BgControlUtils.queryControlDimension((Long)modelId, (Long)this.balance.getLong("bussmodel"));
                if (ctrlDim == null) {
                    return null;
                }
                busModeId = BgControlUtils.getControlDimensionBusModelId((DynamicObject)ctrlDim);
                if ((ctrlDim = BgControlUtils.queryControlDimension((Long)modelId, (Long)busModeId)) == null) {
                    return null;
                }
                dimIds = BgControlUtils.getControlDimension((DynamicObject)ctrlDim);
                if (busModeId == null || dimIds == null || dimIds.isEmpty()) {
                    return null;
                }
                viewIds = BusinessModelServiceHelper.getViewIds((Long)busModeId, (boolean)false);
                crTable = BgControlUtils.getBgControlRecordTable((Long)modelId, (Long)busModeId);
            }
            if (!SqlBatchUtils.hasTable((String)crTable)) {
                return null;
            }
            BizModel bizModel = new BizModel(ModelUtils.getModel((Long)modelId));
            List _dimensions = BgDimensionServiceHelper.getDimensionByModel((BizModel)bizModel, (boolean)false);
            if (!isEb) {
                bizModel.setControlManagerId(Long.valueOf(ctrlDim.getLong("id")));
                bizModel.setControlBusModelId(busModeId);
                bizModel.setControlDims(dimIds);
                _dimensions = bizModel.filterControlDims(_dimensions);
            }
            bizModel.setDimension(_dimensions);
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid, fmodelid, fentitynumber, fbizid, fbiznumber, frefbizid, foperation, fcreatetime,fcreatorid, famount, freqorgunitid, freqaccountid, fserialtextjson", new Object[0]);
            for (Dimension dimension : dimensions) {
                if (dimIds != null && !dimIds.contains(dimension.getId())) continue;
                _field = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? BgControlUtils.getUserDefinedIdField((Dimension)dimension) : (isEb ? (String)BgControlRecordUtils.getRecordFields().get(dimension.getNumber()) : (String)BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber()));
                sql.append(",", new Object[0]).append(_field, new Object[0]);
            }
            sql.append("from ", new Object[0]).append(crTable, new Object[0]);
            sql.append(" where fmodelid = ?", new Object[]{modelId});
            HashMap<String, Set<Long>> groupMap = null;
            Long groupId = this.balance.getLong("groupid");
            List<Object> groupDimIds = new ArrayList(16);
            ArrayList<Map<String, Long>> condition = new ArrayList<Map<String, Long>>();
            if (groupId != null && groupId != 0L && (group = this.getGroup(this.balance.getLong("groupid"))) != null) {
                String[] arrs = "userdefined1,userdefined2,userdefined3,userdefined4,userdefined5,userdefined6,userdefined7".split(",");
                DynamicObjectCollection accounts = group.getDynamicObjectCollection("accounts");
                groupMap = new HashMap<String, Set<Long>>();
                groupMap.put("account", new HashSet());
                for (Object account : accounts) {
                    String tempAccountId = account.getString("account.id") == null ? account.getString("account") : account.getString("account.id");
                    if (!StringUtils.isNotEmpty((String)tempAccountId)) continue;
                    ((Set)groupMap.get("account")).add(Long.parseLong(tempAccountId));
                }
                DynamicObjectCollection dimentions = group.getDynamicObjectCollection("dimentions");
                for (DynamicObject dim : dimentions) {
                    HashMap<String, Long> cond = new HashMap<String, Long>();
                    for (String field : arrs) {
                        if (!(dim.get(field) instanceof DynamicObject)) continue;
                        String dimIdField = field.replace("userdefined", "userdefineddimid");
                        Long id = dim.getLong(dimIdField);
                        String dimId = String.valueOf(id);
                        if (IDUtils.isNotNull((Long)id)) {
                            groupMap.computeIfAbsent(dimId, f -> new HashSet(10)).add(dim.getLong(field + ".id"));
                            cond.put(BgControlUtils.getUserDefinedIdField((Dimension)this.modelCacheHelper.getDimension(id)), dim.getLong(field + ".id"));
                            continue;
                        }
                        if (!groupMap.containsKey(field)) {
                            groupMap.put(field, new HashSet());
                        }
                        ((Set)groupMap.get(field)).add(dim.getLong(field + ".id"));
                    }
                    if (cond.isEmpty()) continue;
                    cond.put("faccountid", dim.getLong("groupaccount.id"));
                    condition.add(cond);
                }
                groupDimIds = ControlRuleHelper.getGroupRuleGroupDimIdList(group.getLong("id"));
            }
            for (Dimension dimension : dimensions) {
                Long l = viewId = viewIds != null ? (Long)viewIds.get(dimension.getNumber()) : null;
                if (dimIds != null && !dimIds.contains(dimension.getId()) || !memberIds.containsKey(dimension.getNumber())) continue;
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                    _field = (String)BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber());
                    this.appendBgPeriodCondition(sql, _field, dimension, viewId, (Long)memberIds.get(dimension.getNumber()), controlType);
                    continue;
                }
                if (SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) {
                    _field = (String)BgControlRecordUtils.getRecordFields().get(dimension.getNumber());
                    this.appendPeriodCondition(sql, _field, dimension, viewId, (Long)memberIds.get(dimension.getNumber()), controlType);
                    continue;
                }
                _field = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? BgControlUtils.getUserDefinedIdField((Dimension)dimension) : (isEb ? (String)BgControlRecordUtils.getRecordFields().get(dimension.getNumber()) : (String)BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber()));
                if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                    this.appendAccountCondition(sql, _field, dimension, viewId, (Long)memberIds.get(dimension.getNumber()), groupMap, this.balance.getLong("bussmodel"));
                    continue;
                }
                if (IDUtils.isNotEmptyLong((Long)groupId).booleanValue() && !dimension.isPreset() && !groupDimIds.contains(dimension.getId())) {
                    Member rootMember = this.modelCacheHelper.getRootMember(dimension.getNumber(), viewId);
                    this.appendCondition(sql, _field, dimension, viewId, rootMember.getId(), groupMap, isEb, this.balance.getLong("bussmodel"));
                    continue;
                }
                this.appendCondition(sql, _field, dimension, viewId, (Long)memberIds.get(dimension.getNumber()), groupMap, isEb, this.balance.getLong("bussmodel"));
            }
            sql.append(" order by fcreatetime desc", new Object[0]);
            LinkedList<BgControlRecord> records = new LinkedList<BgControlRecord>();
            BgControlRecord record = null;
            DataSet ds = DB.queryDataSet((String)"queryDetailRecord", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Object object = null;
            try {
                HashSet fields = Sets.newHashSetWithExpectedSize((int)ds.getRowMeta().getFieldCount());
                for (Field field : ds.getRowMeta().getFields()) {
                    fields.add(field.getName().toLowerCase());
                }
                for (Row row : ds) {
                    record = this.transRow(fields, row, dimensions, condition);
                    if (record == null) continue;
                    record.setBizModel(bizModel);
                    records.add(record);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            return records;
        }

        public DynamicObject getGroup(Long groupId) {
            QFilter qFilter = new QFilter("group", "=", (Object)groupId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_bgcontrolrulemain", (QFilter[])qFilter.toArray());
            return dynamicObject;
        }

        private void appendCondition(SqlBuilder sql, String field, Dimension dimension, Long viewId, Long memberId, boolean isEb, Long businessModelId) {
            this.appendCondition(sql, field, dimension, viewId, memberId, null, isEb, businessModelId);
        }

        private void appendCondition(SqlBuilder sql, String field, Dimension dimension, Long viewId, Long memberId, Map<String, Set<Long>> groupMap, boolean isEb, Long businessModelId) {
            if (sql == null || dimension == null || memberId == null) {
                return;
            }
            String userDef = null;
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                userDef = BgControlUtils.getEBUserDefined((Dimension)dimension);
            }
            ArrayList<Long> _memberIds = new ArrayList<Long>();
            ArrayList<Long> memberIds = new ArrayList<Long>();
            if (groupMap != null && groupMap.containsKey(String.valueOf(dimension.getId()))) {
                _memberIds.addAll((Collection)groupMap.get(String.valueOf(dimension.getId())));
            } else if (userDef != null && groupMap != null && groupMap.containsKey(userDef)) {
                _memberIds.addAll((Collection)groupMap.get(userDef));
            } else {
                _memberIds.add(memberId);
            }
            List viewIds = this.modelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(businessModelId, dimension.getNumber());
            for (Long _memberId : _memberIds) {
                Member member = dimension.getMember(viewId, _memberId);
                if (member == null && viewIds != null) {
                    for (Long vId : viewIds) {
                        Member m = dimension.getMember(vId, _memberId);
                        if (m == null) continue;
                        member = m;
                        break;
                    }
                }
                if (member == null) continue;
                if (!(member.getParentId() != null && member.getParentId() != 0L || !isEb && viewIds != null && viewIds.size() > 1)) {
                    return;
                }
                if (member.isLeaf()) {
                    if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) && isEb && member.getNumber().equals(dimension.getNoneNumber())) {
                        memberIds.add(0L);
                    }
                    memberIds.add(_memberId);
                    continue;
                }
                List children = this.modelCacheHelper.getDetailChildren(member);
                List cmemberIds = children.stream().map(BaseCache::getId).collect(Collectors.toList());
                memberIds.addAll(cmemberIds);
            }
            sql.append(" and ", new Object[0]);
            if (memberIds.isEmpty()) {
                sql.append(field + " = ?", new Object[]{memberId});
            } else if (memberIds.size() == 1) {
                sql.append(field + " = ?", new Object[]{memberIds.get(0)});
            } else {
                sql.appendIn(field, memberIds);
            }
        }

        private void appendAccountCondition(SqlBuilder sql, String field, Dimension dimension, Long viewId, Long memberId, Map<String, Set<Long>> groupMap, Long businessModelId) {
            if (sql == null) {
                return;
            }
            if (groupMap == null || groupMap.isEmpty() || !groupMap.containsKey("account")) {
                this.appendCondition(sql, field, dimension, viewId, memberId, false, businessModelId);
            } else {
                ArrayList memberIds = new ArrayList(groupMap.get("account"));
                sql.append(" and ", new Object[0]);
                sql.appendIn(field, memberIds);
            }
        }

        private void appendPeriodCondition(SqlBuilder sql, String field, Dimension dimension, Long viewId, Long memberId, int controlType) {
            if (sql == null || dimension == null || memberId == null) {
                return;
            }
            boolean ignPeriod = false;
            LinkedHashSet periodIds = Sets.newLinkedHashSet();
            LinkedHashSet periodNums = Sets.newLinkedHashSet();
            Member member = dimension.getMember(viewId, memberId);
            if (BgControlSettingTypeEnum.MONTH.getIndex() == controlType) {
                if (member.isLeaf()) {
                    periodIds.add(memberId);
                } else {
                    List children = this.modelCacheHelper.getDetailChildren(member);
                    periodIds.addAll(children.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                }
            } else if (BgControlSettingTypeEnum.QUARTER.getIndex() == controlType) {
                int end;
                int begin;
                int month = Integer.parseInt(member.getNumber().substring(3));
                if (month <= 3) {
                    begin = 1;
                    end = 3;
                } else if (month <= 6) {
                    begin = 4;
                    end = 6;
                } else if (month <= 9) {
                    begin = 7;
                    end = 9;
                } else {
                    begin = 9;
                    end = 12;
                }
                for (int i = begin; i <= end; ++i) {
                    periodNums.add(BgPeriodUtils.getPeriodMonth((int)i));
                }
            } else if (BgControlSettingTypeEnum.HALFYEAR.getIndex() == controlType) {
                int end;
                int begin;
                int month = Integer.parseInt(member.getNumber().substring(3));
                if (month <= 6) {
                    begin = 1;
                    end = 6;
                } else {
                    begin = 7;
                    end = 12;
                }
                for (int i = begin; i <= end; ++i) {
                    periodNums.add(BgPeriodUtils.getPeriodMonth((int)i));
                }
            } else {
                ignPeriod = true;
            }
            if (!ignPeriod) {
                sql.append(" and ", new Object[0]);
                if (!periodNums.isEmpty()) {
                    periodIds.addAll(this.queryPeriodIds(periodNums, true));
                }
                if (periodIds.isEmpty()) {
                    periodIds.add(member.getId());
                }
                sql.appendIn(field, periodIds.toArray(new Object[periodIds.size()]));
            }
        }

        private void appendBgPeriodCondition(SqlBuilder sql, String field, Dimension dimension, Long viewId, Long memberId, int controlType) {
            String[] periods;
            if (sql == null || dimension == null || memberId == null) {
                return;
            }
            boolean ignPeriod = false;
            HashSet<Long> periodIds = new HashSet<Long>();
            Member member = dimension.getMember(viewId, memberId);
            if (member == null) {
                return;
            }
            if (BgControlSettingTypeEnum.MONTH.getIndex() == controlType) {
                if (member.isLeaf()) {
                    periodIds.add(memberId);
                } else {
                    List children = this.modelCacheHelper.getDetailChildren(member);
                    periodIds.addAll(children.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                }
            } else if (BgControlSettingTypeEnum.YEAR.getIndex() == controlType || BgControlSettingTypeEnum.MONTH_ADDUP.getIndex() == controlType || BgControlSettingTypeEnum.QUARTER_ADDUP.getIndex() == controlType) {
                String[] periods2 = member.getNumber().split("\\.");
                if (periods2 != null && periods2.length > 0) {
                    HashSet<String> periodNums = new HashSet<String>();
                    int cYear = Integer.parseInt(periods2[0].substring(2));
                    if (periods2.length > 1) {
                        if (periods2[1].startsWith("HF")) {
                            for (int i = 1; i <= 2; ++i) {
                                periodNums.add(BgPeriodUtils.getBgPeriodHalfYear((int)cYear, (int)i));
                            }
                        } else if (periods2[1].startsWith("Q")) {
                            for (int i = 1; i <= 4; ++i) {
                                periodNums.add(BgPeriodUtils.getBgPeriodQuarter((int)cYear, (int)i));
                            }
                        } else if (periods2[1].startsWith("M")) {
                            for (int i = 1; i <= 12; ++i) {
                                periodNums.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)i));
                            }
                        }
                    }
                    periodIds.addAll(this.queryPeriodIds(periodNums, false));
                }
            } else if (BgControlSettingTypeEnum.QUARTER.getIndex() == controlType || BgControlSettingTypeEnum.MONTH_QUARTER_ADDUP.getIndex() == controlType) {
                String[] periods3 = member.getNumber().split("\\.");
                if (periods3 != null && periods3.length > 0) {
                    int cYear = Integer.parseInt(periods3[0].substring(2));
                    int cMonth = Integer.parseInt(periods3[1].substring(1));
                    HashSet<String> periodNums = new HashSet<String>();
                    if (cMonth <= 3) {
                        for (int i = 1; i <= 3; ++i) {
                            periodNums.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)i));
                        }
                    } else if (cMonth <= 6) {
                        for (int i = 4; i <= 6; ++i) {
                            periodNums.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)i));
                        }
                    } else if (cMonth <= 9) {
                        for (int i = 7; i <= 9; ++i) {
                            periodNums.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)i));
                        }
                    } else {
                        for (int i = 10; i <= 12; ++i) {
                            periodNums.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)i));
                        }
                    }
                    periodIds.addAll(this.queryPeriodIds(periodNums, false));
                }
            } else if ((BgControlSettingTypeEnum.HALFYEAR.getIndex() == controlType || BgControlSettingTypeEnum.MONTH_HALFYEAR_ADDUP.getIndex() == controlType) && (periods = member.getNumber().split("\\.")) != null && periods.length > 0) {
                int cYear = Integer.parseInt(periods[0].substring(2));
                int cMonth = Integer.parseInt(periods[1].substring(1));
                HashSet<String> periodNums = new HashSet<String>();
                if (cMonth <= 6) {
                    for (int i = 1; i <= 6; ++i) {
                        periodNums.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)i));
                    }
                } else {
                    for (int i = 7; i <= 12; ++i) {
                        periodNums.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)i));
                    }
                }
                periodIds.addAll(this.queryPeriodIds(periodNums, false));
            }
            if (!ignPeriod) {
                if (periodIds.isEmpty()) {
                    periodIds.add(member.getId());
                }
                sql.append(" and ", new Object[0]);
                sql.appendIn(field, periodIds.toArray(new Object[periodIds.size()]));
            }
        }

        private Set<Long> queryPeriodIds(Set<String> periodNumber, boolean isEb) {
            if (periodNumber == null || periodNumber.isEmpty()) {
                return Collections.emptySet();
            }
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)this.modelCacheHelper.getModelobj().getId()));
            builder.add(new QFilter("number", "in", periodNumber));
            Map periodMap = isEb ? BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.Period.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArrays()) : BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArrays());
            if (periodMap != null && !periodMap.isEmpty()) {
                return periodMap.values().stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }

        private BgControlRecord transRow(Set<String> fields, Row row, List<Dimension> dimensions, List<Map<String, Long>> conditions) {
            if (fields == null || row == null || dimensions == null) {
                return null;
            }
            String field = null;
            Long memberId = null;
            Member member = null;
            kd.epm.eb.common.model.Member _member = null;
            if (!conditions.isEmpty()) {
                Boolean flag = Boolean.FALSE;
                block2: for (Map<String, Long> condition : conditions) {
                    if (flag.booleanValue()) break;
                    for (Map.Entry<String, Long> entry : condition.entrySet()) {
                        if (fields.contains(entry.getKey()) && row.get(entry.getKey()) != null && row.getLong(entry.getKey()).equals(entry.getValue())) {
                            flag = Boolean.TRUE;
                            continue;
                        }
                        flag = Boolean.FALSE;
                        continue block2;
                    }
                }
                if (!flag.booleanValue()) {
                    return null;
                }
            }
            BgControlRecord record = new BgControlRecord();
            record.setEntityNumber(row.getString("fentitynumber"));
            record.setBizId(row.getString("fbizid"));
            record.setBizNumber(row.getString("fbiznumber"));
            record.setRefBizId(row.getString("frefbizid"));
            record.setCreateTime(row.getDate("fcreatetime"));
            record.setCreator(row.getLong("fcreatorid"));
            record.setAmount(row.getBigDecimal("famount"));
            record.setOperation(row.getString("foperation"));
            record.setSerialJson(row.getString("fserialtextjson"));
            this.billInfoMap.put(record.getEntityNumber(), null);
            this.operationMap.put(record.getOperation(), null);
            Map map = this.bizMap.getOrDefault(record.getEntityNumber(), new HashMap(16));
            map.put(record.getBizId(), null);
            this.bizMap.put(record.getEntityNumber(), map);
            boolean isEb = this.modelCacheHelper.getModelobj().isModelByEB();
            for (Dimension dimension : dimensions) {
                field = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? BgControlUtils.getUserDefinedIdField((Dimension)dimension) : (isEb ? (String)BgControlRecordUtils.getRecordFields().get(dimension.getNumber()) : (String)BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber()));
                if (fields.contains(field) && (memberId = row.getLong(field)) != null && memberId != 0L && (member = dimension.getStructOfMember(memberId)) != null) {
                    _member = kd.epm.eb.common.model.Member.loadFormCache((Member)member);
                    _member.setDimension(kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)dimension));
                    record.setMember(_member);
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) && (memberId = row.getLong("freqorgunitid")) != null && memberId != 0L) {
                    member = dimension.getStructOfMember(memberId);
                    if (member != null) {
                        _member = kd.epm.eb.common.model.Member.loadFormCache((Member)member);
                        _member.setDimension(kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)dimension));
                        record.setReqOrgUnit(_member);
                    } else {
                        record.setReqOrgUnit(new kd.epm.eb.common.model.Member(row.getLong("freqorgunitid")));
                        this.orgMap.put(row.getLong("freqorgunitid"), null);
                    }
                }
                if (!SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) || (memberId = row.getLong("freqaccountid")) == null || memberId == 0L) continue;
                member = dimension.getStructOfMember(memberId);
                if (member != null) {
                    _member = kd.epm.eb.common.model.Member.loadFormCache((Member)member);
                    _member.setDimension(kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)dimension));
                    record.setReqAccount(_member);
                    continue;
                }
                record.setReqAccount(new kd.epm.eb.common.model.Member(row.getLong("freqaccountid")));
                this.accountMap.put(row.getLong("freqaccountid"), null);
            }
            try {
                if (StringUtils.isNotEmpty((String)record.getSerialJson())) {
                    Map retMap;
                    if (StringUtils.isNotEmpty((String)record.getReqAccBaseData()) && IDUtils.isNotEmptyLong((Long)record.getReqAccId()).booleanValue()) {
                        retMap = this.reqObjInfo.getOrDefault(record.getReqAccBaseData(), new HashMap());
                        retMap.put(record.getReqAccId(), null);
                        this.reqObjInfo.put(record.getReqAccBaseData(), retMap);
                    }
                    if (StringUtils.isNotEmpty((String)record.getReqEntBaseData()) && IDUtils.isNotEmptyLong((Long)record.getReqEntId()).booleanValue()) {
                        retMap = this.reqObjInfo.getOrDefault(record.getReqEntBaseData(), new HashMap());
                        retMap.put(record.getReqEntId(), null);
                        this.reqObjInfo.put(record.getReqEntBaseData(), retMap);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return record;
        }

        private boolean hasClose(BgControlRecord record) {
            if (record == null) {
                return false;
            }
            return record.getAmount().compareTo(BigDecimal.ZERO) < 0 && StringUtils.isEmpty((String)record.getRefBizId()) && "releaseentry".equals(record.getOperation()) && (record.getOperation().contains("close") || record.getOperation().contains("release"));
        }

        private void mergeRecords(List<Dimension> dimensions, List<BgControlRecord> records) {
            HashMap<String, BgControlRecord> recordsMap = new HashMap<String, BgControlRecord>(records.size());
            Iterator<BgControlRecord> iterator = records.iterator();
            StringBuilder info = new StringBuilder();
            while (iterator.hasNext()) {
                BgControlRecord record = iterator.next();
                StringBuilder sb = new StringBuilder();
                sb.append(record.getBizNumber()).append('_').append(record.getReqAccountId()).append('_').append(record.getReqOrgUnitId()).append('_').append(record.get((Object)(SysDimensionEnum.Entity.getNumber() + ".id"))).append('_').append(record.get((Object)(SysDimensionEnum.Account.getNumber() + ".id"))).append('_').append(record.getMember(SysDimensionEnum.ChangeType.getNumber()).getNumber());
                for (Dimension dimension : dimensions) {
                    kd.epm.eb.common.model.Member member;
                    if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) || (member = record.getMember(dimension.getNumber())) == null) continue;
                    sb.append('_').append(member.getNumber());
                }
                String key = sb.toString();
                if (recordsMap.containsKey(key)) {
                    BgControlRecord valueRecord = (BgControlRecord)recordsMap.get(key);
                    valueRecord.setAmount(valueRecord.getAmount().add(record.getAmount()));
                    Date time1 = valueRecord.getCreateTime();
                    Date time2 = record.getCreateTime();
                    if (time1.compareTo(time2) < 0) {
                        valueRecord.setCreateTime(time2);
                        valueRecord.setSerialJson(record.getSerialJson());
                    }
                    iterator.remove();
                    continue;
                }
                recordsMap.put(key, record);
            }
            log.info(info.toString());
        }

        public void fillDetailRecord(IDataModel model, IFormView view, List<BgControlRecord> records) {
            int i;
            BigDecimal value;
            Map reqValueMap;
            Map caValueMap;
            String memberKey;
            kd.epm.eb.common.model.Member member;
            BgControlRecord record2;
            if (model == null || view == null) {
                return;
            }
            if (records == null || records.isEmpty()) {
                return;
            }
            StringBuilder memberStr = new StringBuilder();
            LinkedHashMap occBills = Maps.newLinkedHashMap();
            LinkedHashMap occDetails = Maps.newLinkedHashMap();
            LinkedHashMap exeBills = Maps.newLinkedHashMap();
            LinkedHashMap exeDetails = Maps.newLinkedHashMap();
            LinkedList caOccupations = Lists.newLinkedList();
            for (BgControlRecord record2 : records) {
                Map caDetailMap;
                boolean hasClose = this.hasClose(record2);
                if (!StringUtils.isNotEmpty((String)record2.getRefBizId()) && !hasClose) continue;
                String refBizId = record2.getRefBizId();
                if (hasClose) {
                    refBizId = record2.getBizId();
                }
                if ((member = record2.getMember(SysDimensionEnum.ChangeType.getNumber())) == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u63a7\u5236\u8bb0\u5f55\u7684\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u4e3a\u7a7a", (String)"BgAvailBalanceListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                memberKey = record2.getMemberKey(true);
                if ("Occupation".equals(member.getNumber())) {
                    caValueMap = occBills.computeIfAbsent(refBizId, f -> Maps.newLinkedHashMap());
                    caDetailMap = occDetails.computeIfAbsent(refBizId, f -> Maps.newLinkedHashMap());
                } else {
                    caValueMap = exeBills.computeIfAbsent(refBizId, f -> Maps.newLinkedHashMap());
                    caDetailMap = exeDetails.computeIfAbsent(refBizId, f -> Maps.newLinkedHashMap());
                }
                reqValueMap = caValueMap.computeIfAbsent(memberKey, f -> Maps.newLinkedHashMap());
                value = reqValueMap.computeIfAbsent(record2.getReqKey(), f -> BigDecimal.ZERO);
                value = value.add(record2.getAmount());
                reqValueMap.put(record2.getReqKey(), value);
                List caDetail = caDetailMap.computeIfAbsent(memberKey, f -> Lists.newLinkedList());
                caDetail.add(record2.getAmount());
                if (hasClose) continue;
                caOccupations.add(record2);
            }
            this.queryBillInfo();
            if (!caOccupations.isEmpty()) {
                HashSet noCaOccupationKeys = Sets.newHashSetWithExpectedSize((int)records.size());
                caOccupations.stream().forEach(f -> f.setRemove(true));
                ArrayList<BgControlRecord> noCaOccupations = new ArrayList<BgControlRecord>(records);
                noCaOccupations.removeIf(f -> f.isRemove());
                caOccupations.stream().forEach(f -> f.setRemove(false));
                for (BgControlRecord _record : noCaOccupations) {
                    noCaOccupationKeys.add(_record.getBizId() + "!" + _record.getMemberKey(true));
                }
                Iterator it = caOccupations.iterator();
                while (it.hasNext()) {
                    record2 = (BgControlRecord)it.next();
                    if (!StringUtils.isNotEmpty((String)record2.getRefBizId()) || noCaOccupationKeys.contains(record2.getRefBizId() + "!" + record2.getMemberKey(true))) continue;
                    it.remove();
                }
                caOccupations.stream().forEach(f -> f.setRemove(true));
                records.removeIf(f -> f.isRemove());
            }
            List dimensions = this.modelCacheHelper.getDimensionList();
            log.info("before merge records size:" + records.size());
            log.info("before merge records:" + records);
            this.mergeRecords(dimensions, records);
            log.info("after merge records size:" + records.size());
            log.info("after merge records:" + records);
            Map userName = BgControlRecordUtils.queryApplierName(records);
            model.beginInit();
            model.batchCreateNewEntryRow(BgAvailBalanceListPlugin.netherentity, records.size());
            HashMap<String, kd.epm.eb.common.model.Member> noneMap = new HashMap<String, kd.epm.eb.common.model.Member>(10);
            int in = records.size();
            for (i = 0; i < in; ++i) {
                record2 = records.get(i);
                value = record2.getAmount();
                if (value == null) continue;
                member = record2.getMember(SysDimensionEnum.ChangeType.getNumber());
                if (member != null) {
                    caValueMap = null;
                    if ("Occupation".equals(member.getNumber())) {
                        caValueMap = (Map)occBills.get(record2.getBizId());
                    } else if ("Execute".equals(member.getNumber())) {
                        caValueMap = (Map)exeBills.get(record2.getBizId());
                    }
                    if (caValueMap != null && (reqValueMap = (Map)caValueMap.get(memberKey = record2.getMemberKey(true))) != null && reqValueMap.get(record2.getReqKey()) != null) {
                        if (value.compareTo((BigDecimal)reqValueMap.get(record2.getReqKey())) >= 0) {
                            value = value.add((BigDecimal)reqValueMap.get(record2.getReqKey()));
                            reqValueMap.remove(record2.getReqKey());
                        } else {
                            reqValueMap.put(record2.getReqKey(), ((BigDecimal)reqValueMap.get(record2.getReqKey())).subtract(value));
                            value = BigDecimal.ZERO;
                        }
                    }
                }
                record2.setNewAmount(value);
            }
            in = records.size();
            for (i = 0; i < in; ++i) {
                record2 = records.get(i);
                DynamicObject entity = model.getEntryRowEntity(BgAvailBalanceListPlugin.netherentity, i);
                kd.epm.eb.common.model.Member orgMember = record2.getMember(SysDimensionEnum.Entity.getNumber());
                entity.set("orgunitname", (Object)(orgMember != null ? orgMember.getName() : ""));
                kd.epm.eb.common.model.Member accountMember = record2.getMember(SysDimensionEnum.Account.getNumber());
                entity.set("accountname", (Object)(accountMember != null ? accountMember.getName() : ""));
                entity.set("operation", (Object)this.getOperation(record2));
                entity.set("billname", (Object)this.billInfoMap.get(record2.getEntityNumber()));
                entity.set("billnumber", (Object)record2.getEntityNumber());
                entity.set("biznumber", (Object)record2.getBizNumber());
                entity.set("createtime", (Object)record2.getCreateTime());
                entity.set("updatetime", (Object)record2.getCreateTime());
                entity.set("bizid", (Object)record2.getBizId());
                Long applierId = record2.getApplierId();
                if (IDUtils.isNotNull((Long)applierId)) {
                    if (userName.containsKey(applierId)) {
                        entity.set(CREATOR2, userName.get(applierId));
                    }
                } else {
                    Map<String, DynamicObject> objectMap = this.bizMap.get(record2.getEntityNumber());
                    if (objectMap != null) {
                        try {
                            DynamicObject dynamicObject = objectMap.get(record2.getBizId());
                            if (dynamicObject != null) {
                                DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
                                if (properties.stream().anyMatch(e -> CREATOR1.equals(e.getName()))) {
                                    DynamicObject applier = dynamicObject.getDynamicObject(CREATOR1);
                                    entity.set(CREATOR2, (Object)applier);
                                } else if (properties.stream().anyMatch(e -> CREATOR2.equals(e.getName()))) {
                                    DynamicObject creator = dynamicObject.getDynamicObject(CREATOR2);
                                    entity.set(CREATOR2, (Object)creator);
                                }
                            }
                        }
                        catch (Exception dynamicObject) {
                            // empty catch block
                        }
                    }
                }
                if (StringUtils.isNotEmpty((String)record2.getReqAccBaseData()) && IDUtils.isNotEmptyLong((Long)record2.getReqAccId()).booleanValue()) {
                    entity.set("reqaccountname", (Object)this.reqObjInfo.get(record2.getReqAccBaseData()).get(record2.getReqAccId()));
                } else {
                    entity.set("reqaccountname", (Object)(StringUtils.isNotEmpty((String)record2.getReqAccountName()) ? record2.getReqAccountName() : this.accountMap.get(record2.getReqAccountId())));
                }
                if (StringUtils.isNotEmpty((String)record2.getReqEntBaseData()) && IDUtils.isNotEmptyLong((Long)record2.getReqEntId()).booleanValue()) {
                    entity.set("reqorgunitname", (Object)this.reqObjInfo.get(record2.getReqEntBaseData()).get(record2.getReqEntId()));
                } else {
                    entity.set("reqorgunitname", (Object)(StringUtils.isNotEmpty((String)record2.getReqOrgUnitName()) ? record2.getReqOrgUnitName() : this.orgMap.get(record2.getReqOrgUnitId())));
                }
                memberKey = record2.getMemberKey(true);
                value = record2.getAmount();
                member = record2.getMember(SysDimensionEnum.ChangeType.getNumber());
                if (member != null) {
                    switch (member.getNumber()) {
                        case "Occupation": {
                            this.showOcOccAndExe(member.getNumber(), entity, record2, value, record2.getNewAmount(), memberKey, occBills, occDetails);
                            break;
                        }
                        case "Execute": {
                            this.showOcOccAndExe(member.getNumber(), entity, record2, value, record2.getNewAmount(), memberKey, exeBills, exeDetails);
                        }
                    }
                }
                memberStr.setLength(0);
                for (Dimension dimension : dimensions) {
                    if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) continue;
                    member = record2.getMember(dimension.getNumber());
                    if (member == null && record2.getBizModel() != null && record2.getBizModel().isEBByModel() && (member = (kd.epm.eb.common.model.Member)noneMap.get(dimension.getNumber())) == null) {
                        Member _member = dimension.getStructOfMember(dimension.getNoneNumber());
                        if (_member != null) {
                            member = new kd.epm.eb.common.model.Member(_member.getId(), _member.getName(), _member.getNumber());
                            member.setDimension(new kd.epm.eb.common.model.Dimension(dimension.getId(), dimension.getName(), dimension.getNumber()));
                        }
                        noneMap.put(dimension.getNumber(), member);
                    }
                    if (member == null) continue;
                    memberStr.append(dimension.getName()).append('_').append(member.getName()).append('!');
                }
                if (memberStr.length() <= 0) continue;
                memberStr.setLength(memberStr.length() - 1);
                entity.set("nallmember", (Object)memberStr.toString());
            }
            model.endInit();
            EntryGrid entryGrid = (EntryGrid)view.getControl(BgAvailBalanceListPlugin.netherentity);
            entryGrid.setPageIndex(1);
            view.updateView(BgAvailBalanceListPlugin.netherentity);
        }

        private void showOcOccAndExe(@NotNull String changeType, @NotNull DynamicObject entity, @NotNull BgControlRecord record, BigDecimal value, BigDecimal newValue, @NotNull String memberKey, @NotNull Map<String, Map<String, Map<String, BigDecimal>>> caOccBills, @NotNull Map<String, Map<String, List<BigDecimal>>> caOccDetails) {
            if (newValue == null) {
                return;
            }
            String occuOrExe = "n" + changeType.toLowerCase(Locale.ROOT);
            Map<String, BigDecimal> caOccMap = null;
            entity.set(occuOrExe, (Object)newValue.stripTrailingZeros().toPlainString());
            Map<String, Map<String, BigDecimal>> occValueMap = caOccBills.get(record.getBizId());
            if (occValueMap != null && (caOccMap = occValueMap.get(memberKey)) != null && !caOccMap.isEmpty()) {
                BigDecimal caOccupation = BigDecimal.ZERO;
                Iterator<Map.Entry<String, BigDecimal>> it = caOccMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, BigDecimal> entry = it.next();
                    if (newValue.compareTo(entry.getValue()) >= 0) {
                        caOccupation = caOccupation.add(entry.getValue());
                        it.remove();
                        continue;
                    }
                    caOccupation = caOccupation.add(newValue);
                    entry.setValue(entry.getValue().subtract(newValue));
                }
                if (caOccupation.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal tmpValue = caOccupation.subtract(newValue.abs());
                    if (tmpValue.compareTo(BigDecimal.ZERO) >= 0) {
                        entity.set("nwriteoff", (Object)newValue.stripTrailingZeros().toPlainString());
                        entity.set(occuOrExe, (Object)BigDecimal.ZERO);
                    } else {
                        entity.set("nwriteoff", (Object)caOccupation.stripTrailingZeros().toPlainString());
                        entity.set(occuOrExe, (Object)newValue.abs().subtract(caOccupation).stripTrailingZeros().toPlainString());
                    }
                }
            }
        }

        private void queryBillInfo() {
            QFilter filter;
            if (!this.billInfoMap.isEmpty()) {
                filter = new QFilter("number", "in", this.billInfoMap.keySet());
                Map map = BusinessDataServiceHelper.loadFromCache((String)"eb_structofbill", (String)"name, number", (QFilter[])filter.toArray());
                for (Object obj : map.values()) {
                    this.billInfoMap.put(obj.getString("number"), obj.getString("name"));
                }
            }
            if (!this.operationMap.isEmpty()) {
                filter = new QFilter("number", "in", this.operationMap.keySet());
                Map map = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolbizreg", (String)"name, number", (QFilter[])filter.toArray());
                for (Object obj : map.values()) {
                    this.operationMap.put(obj.getString("number"), obj.getString("name"));
                }
            }
            if (!this.orgMap.isEmpty()) {
                HashSet<Long> orgIds = new HashSet<Long>(this.orgMap.keySet());
                QFilter qFilter = new QFilter("id", "in", orgIds);
                Object objs2 = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, name, number", (QFilter[])qFilter.toArray());
                for (DynamicObject obj : objs2.values()) {
                    this.orgMap.put(obj.getLong("id"), obj.getString("name"));
                    orgIds.remove(obj.getLong("id"));
                }
                if (!orgIds.isEmpty()) {
                    QFilter qFilter2 = new QFilter("id", "in", orgIds);
                    objs2 = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (String)"id, name, number", (QFilter[])qFilter2.toArray());
                    for (DynamicObject obj : objs2.values()) {
                        this.orgMap.put(obj.getLong("id"), obj.getString("name"));
                    }
                }
            }
            if (!this.accountMap.isEmpty()) {
                filter = new QFilter("id", "in", this.accountMap.keySet());
                Map map = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitemedit", (String)"id, name, number", (QFilter[])filter.toArray());
                for (Object obj : map.values()) {
                    this.accountMap.put(obj.getLong("id"), obj.getString("name"));
                }
            }
            if (!this.reqObjInfo.isEmpty()) {
                for (Map.Entry<String, Map<Long, String>> entry : this.reqObjInfo.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    Map<Long, String> KVmap = entry.getValue();
                    QFBuilder qfBuilder = QFBuilder.newQFilter().and("id", "in", KVmap.keySet());
                    String metadata = entry.getKey();
                    if ("bos_adminorg".equals(metadata)) {
                        metadata = "bos_adminorg_structure";
                        qfBuilder.add(new QFilter("org.id", "in", KVmap.keySet()));
                        qfBuilder.add(new QFilter("view.treetype", "=", (Object)"01"));
                    }
                    Map objs3 = BusinessDataServiceHelper.loadFromCache((String)metadata, (String)"id, name, number", (QFilter[])qfBuilder.toArray());
                    for (DynamicObject obj : objs3.values()) {
                        KVmap.put(obj.getLong("id"), obj.getString("name"));
                    }
                }
            }
            if (!this.bizMap.isEmpty()) {
                for (Map.Entry<String, Map<Object, String>> entry : this.bizMap.entrySet()) {
                    try {
                        IDataEntityType dataType = BusinessDataServiceHelper.newDynamicObject((String)entry.getKey()).getDataEntityType();
                        DataEntityPropertyCollection properties = dataType.getProperties();
                        String creatorField = null;
                        if (properties.stream().anyMatch(f -> CREATOR1.equalsIgnoreCase(f.getName()))) {
                            creatorField = CREATOR1;
                        } else if (properties.stream().anyMatch(f -> CREATOR2.equalsIgnoreCase(f.getName()))) {
                            creatorField = CREATOR2;
                        }
                        if (StringUtils.isEmpty((String)creatorField)) continue;
                        Map<Object, String> value = entry.getValue();
                        Map objects = BusinessDataServiceHelper.loadFromCache((String)entry.getKey(), (String)("id," + creatorField), (QFilter[])new QFilter(dataType.getPrimaryKey().getName(), "in", (Object)IDUtils.toLongs(value.keySet())).toArray());
                        if (objects == null) continue;
                        objects.entrySet().forEach(f -> {
                            DynamicObject cfr_ignored_0 = (DynamicObject)value.put(String.valueOf(f.getKey()), (String)f.getValue());
                        });
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
            }
        }

        private String getOperation(BgControlRecord record) {
            if (record == null) {
                return "";
            }
            String operationStr = this.operationMap.get(record.getOperation());
            if (operationStr != null) {
                return operationStr + "(" + record.getOperation() + ")";
            }
            return record.getOperation();
        }
    }
}

