/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.bgavailablebalance;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.exception.KDBizException;
import kd.bos.form.AbstractFormView;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.IBgControlCaller;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.utils.BgControlUtils;

public class BgAvailBalanceMobileListPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(BgAvailBalanceMobileListPlugin.class);
    private IBgControlCaller iBgControlCaller = new BgControlCallerImpl();
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String TIPS = "vectorap";
    private static final String DATA_TAG = "datatag";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TIPS});
        AbstractGrid entryentity = (AbstractGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        IDataModel model = this.getModel();
        if (KEY_ENTRY_ENTITY.equals(source.getEntryKey())) {
            int rowIndex = model.getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
            Object data_vale = model.getValue(DATA_TAG, rowIndex);
            if ("1".equalsIgnoreCase(data_vale.toString())) {
                model.setValue(DATA_TAG, (Object)"0", rowIndex);
            } else {
                model.setValue(DATA_TAG, (Object)"1", rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)TIPS, (CharSequence)key)) {
            String title = ResManager.loadKDString((String)"\u53ef\u7528\u9884\u7b97\u4f59\u989d", (String)"BgAvailBalanceMobileListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String msg = ResManager.loadKDString((String)"\u53ef\u7528\u9884\u7b97\u4f59\u989d=\u9884\u7b97\u6570-\u6267\u884c\u6570-\u5269\u4f59\u5360\u7528\u6570-\u5728\u9014\u8c03\u51cf\u6570-\u5b9e\u9645\u6570\u521d\u59cb\u5316", (String)"BgAvailBalanceMobileListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            BgAvailBalanceMobileListPlugin.showMessage(title, msg, this.getView());
        }
    }

    protected static void showMessage(String title, String msg, IFormView view) {
        AbstractFormView abstractFormView = (AbstractFormView)view;
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("confirmType", ConfirmTypes.Default.getValue());
        map.put("button_type", MessageBoxOptions.None.getValue());
        map.put("msg", msg);
        map.put("title", title);
        abstractFormView.getClientProxy().addAction("showConfirm", map);
    }

    private void loadData() {
        this.loadDataFp();
        String entityNumber = this.getView().getFormShowParameter().getParentFormId();
        Object bizId = this.getView().getFormShowParameter().getCustomParam("bizId");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"acturechanges"});
        Long _id = null;
        if (bizId instanceof Integer) {
            _id = Long.valueOf(((Integer)bizId).toString());
        } else if (bizId instanceof Long) {
            _id = IDUtils.toLong((Object)bizId);
        }
        Collection bgBalances = null;
        try {
            if (_id != null && _id != 0L) {
                entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
                bgBalances = this.iBgControlCaller.queryBalance(entityNumber, String.valueOf(_id));
            } else {
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                DynamicObject dataEntity = parentView.getModel().getDataEntity(true);
                DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)dataEntity, (boolean)true, (boolean)false);
                bgBalances = this.iBgControlCaller.queryBalance(clone);
            }
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            this.loadNoExchangeFp(e.getMessage());
            return;
        }
        if (bgBalances == null || bgBalances.size() < 1) {
            this.loadNoExchangeFp(ResManager.loadKDString((String)"\u672c\u5355\u636e\u65e0\u53ef\u7528\u9884\u7b97\u4f59\u989d\u6216\u8005\u79d1\u76ee\u5728\u767d\u540d\u5355\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgAvailBalanceListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder balLog = new StringBuilder();
        balLog.append("budget-control-log : ").append(bizId).append("\r\n");
        for (IBudgetBalance bal : bgBalances) {
            balLog.append(JSONUtils.toString((Object)bal.toMap())).append("\r\n");
        }
        log.info(balLog.toString());
        HashSet keys = Sets.newHashSetWithExpectedSize((int)bgBalances.size());
        ArrayList removes = Lists.newArrayListWithCapacity((int)bgBalances.size());
        for (IBudgetBalance bgBalance : bgBalances) {
            String key = bgBalance.getMemberKey(true, (Collection)bgBalance.getBizModel().getDimensions());
            if (keys.add(key = key + "_" + bgBalance.getSetting().getId())) continue;
            removes.add(bgBalance);
        }
        if (!removes.isEmpty()) {
            bgBalances.removeAll(removes);
        }
        LinkedHashMap currencySigns = Maps.newLinkedHashMap();
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY_ENTITY);
        model.batchCreateNewEntryRow(KEY_ENTRY_ENTITY, bgBalances.size());
        int i = 0;
        Collection userDefineDims = null;
        for (IBudgetBalance bgBalance : bgBalances) {
            String currencySign = currencySigns.computeIfAbsent(bgBalance.getCurrency(true).getNumber(), f -> {
                DynamicObject _currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id, sign", (QFilter[])new QFilter("number", "=", (Object)bgBalance.getCurrency(true).getNumber()).toArray());
                return _currency.getString("sign");
            });
            DynamicObject entity = model.getEntryRowEntity(KEY_ENTRY_ENTITY, i);
            entity.set("rorgunit", (Object)this.showMember(bgBalance.getOrgUnit(true)));
            entity.set("account", (Object)this.showMember(bgBalance.getAccount(true)));
            BigDecimal budget = bgBalance.getBudget();
            BigDecimal balance = bgBalance.getBalance();
            BigDecimal execute = bgBalance.getExecute();
            BigDecimal occupation = bgBalance.getOccupation();
            BigDecimal budgetOccupation = bgBalance.getBudgetOccupation();
            BigDecimal actualChanges = bgBalance.getActualChanges();
            String colordatatag = "0";
            BigDecimal usedRatio = this.getUsedRatio(balance, budget);
            if (Objects.isNull(usedRatio)) {
                entity.set("usedratio", (Object)"-");
            } else if (usedRatio.compareTo(BigDecimal.ZERO) < 0) {
                entity.set("usedratio", (Object)ResManager.loadKDString((String)"\u5df2\u8d85\u9884\u7b97", (String)"BgAvailBalanceMobileListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                colordatatag = "2";
            } else {
                BigDecimal usedValue = new BigDecimal(100).subtract(usedRatio);
                if (usedValue.compareTo(new BigDecimal(80)) >= 0) {
                    colordatatag = "1";
                }
                entity.set("usedratio", (Object)StrUtils.append((Object[])new Object[]{ResManager.loadKDString((String)"\u5df2\u4f7f\u7528", (String)"BgAvailBalanceMobileListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), usedValue.doubleValue(), "%"}));
            }
            if (Objects.isNull(balance) || balance.compareTo(BigDecimal.ZERO) < 0) {
                colordatatag = "2";
            }
            entity.set("colordatatag", (Object)colordatatag);
            entity.set("balance", (Object)this.changeStr(balance, currencySign));
            entity.set("budget", (Object)this.changeStr(budget, currencySign));
            entity.set("execute", (Object)this.changeStr(execute, currencySign));
            entity.set("occupation", (Object)this.changeStr(occupation, currencySign));
            entity.set("budgetoccupation", (Object)this.changeStr(budgetOccupation == null ? budgetOccupation : budgetOccupation.abs(), currencySign));
            entity.set("acturechanges", (Object)this.changeStr(actualChanges, currencySign));
            entity.set("modelname", (Object)bgBalance.getBizModel().getName());
            entity.set("controltype", (Object)this.showCtrlSet(bgBalance.getSetting()));
            String yesSupport = ResManager.loadKDString((String)"\u662f", (String)"BgAvailBalanceMobileListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String noSupport = ResManager.loadKDString((String)"\u5426", (String)"BgAvailBalanceMobileListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            entity.set("isbeyond", (Object)(bgBalance.getSetting().isBeyond() ? yesSupport : noSupport));
            if (userDefineDims == null) {
                userDefineDims = bgBalance.getBizModel().getUserDefinedDimensions();
            }
            String memberString = BgControlUtils.getMemberString((IBudgetBalance)bgBalance, (boolean)true, (Collection)userDefineDims);
            entity.set("allmember", (Object)memberString);
            entity.set("period", (Object)bgBalance.getPeriod(true).getName());
            entity.set("changetype", (Object)bgBalance.getMember(true, SysDimensionEnum.ChangeType.getNumber()).getName());
            entity.set("version", (Object)bgBalance.getVersion(true).getName());
            entity.set("currency", (Object)bgBalance.getCurrency(true).getName());
            ++i;
        }
        model.endInit();
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private String getCurrencyFormatStr(String sign, int amtPrecision, Object amount) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)userId);
        fobj.getCurrencyFormat().setCurrencySymbols(sign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(amtPrecision);
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
        return format.format(amount);
    }

    private BigDecimal getUsedRatio(BigDecimal balance, BigDecimal budget) {
        BigDecimal usedRatio = null;
        if (!Objects.isNull(budget) && budget.compareTo(BigDecimal.ZERO) != 0 && !Objects.isNull(balance)) {
            usedRatio = balance.multiply(new BigDecimal(100)).divide(budget, 2, 4);
        }
        return usedRatio;
    }

    private String changeStr(BigDecimal value, String currencySign) {
        if (!Objects.isNull(value)) {
            return this.getCurrencyFormatStr(currencySign, 2, value);
        }
        return "-";
    }

    private String showCtrlSet(BgControlSetting setting) {
        if (setting == null) {
            return "";
        }
        if (setting.getGroupNo() > 0) {
            return setting.getSettingType().getName() + "(" + setting.getGroupNo() + ")";
        }
        return setting.getSettingType().getName();
    }

    private String showMember(Member member) {
        if (member == null) {
            return "";
        }
        return member.getName() + "(" + member.getNumber() + ")";
    }

    private void loadDataFp() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"listfp"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"defaultpicfp"});
    }

    private void loadNoExchangeFp(String message) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"defaultpicfp"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"listfp"});
        this.getModel().setValue("data_status", (Object)"0");
        ((Label)this.getControl("defaultlabel")).setText(message);
    }
}

