/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.bgavailablebalance.obj;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.formplugin.control.bgavailablebalance.obj.PanelUtils;

public class CalcBalanceObj {
    private static final Log log = LogFactory.getLog(CalcBalanceObj.class);
    private Map<String, Object> calObj = new HashMap<String, Object>();
    private IModelCacheHelper modelCacheHelper;
    private String modelType;
    private List<String> title;
    private String account;
    private String userDefinedDimStr;
    private List<String> period = new ArrayList<String>();
    private BigDecimal coefficient;
    private String controlType;
    private String currPeriod;
    private Map<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>(16);
    private Map<String, BigDecimal> occupationMap = new HashMap<String, BigDecimal>(16);
    private Map<String, BigDecimal> executeMap = new HashMap<String, BigDecimal>(16);
    private Map<String, BigDecimal> budgetOccupation = new HashMap<String, BigDecimal>(16);
    private Map<String, BigDecimal> actualChanges = new HashMap<String, BigDecimal>(16);
    private Map<String, Map<String, BigDecimal>> extBgMap = new LinkedHashMap<String, Map<String, BigDecimal>>(16);
    private Map<String, Map<String, BigDecimal>> extOccupationMap = new LinkedHashMap<String, Map<String, BigDecimal>>(16);
    private Map<String, Map<String, BigDecimal>> extExecuteMap = new LinkedHashMap<String, Map<String, BigDecimal>>(16);
    private Map<String, Map<String, BigDecimal>> extBudgetOccupation = new LinkedHashMap<String, Map<String, BigDecimal>>(16);
    private Map<String, Map<String, BigDecimal>> extActualChanges = new LinkedHashMap<String, Map<String, BigDecimal>>(16);
    private Set<String> olapPeriods = new HashSet<String>();
    private List<String> hasActualPeriods = new ArrayList<String>();

    public Map<String, Object> getCalObj() {
        return this.calObj;
    }

    public List<String> getTitle() {
        return this.title;
    }

    public String getAccount() {
        return this.account;
    }

    public String getUserDefinedDimStr() {
        return this.userDefinedDimStr;
    }

    public List<String> getPeriod() {
        return this.period;
    }

    public BigDecimal getCoefficient() {
        if (this.coefficient == null) {
            return new BigDecimal("1.0");
        }
        return this.coefficient;
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getCurrPeriod() {
        return this.currPeriod;
    }

    public Map<String, BigDecimal> getBudgetMap() {
        return this.budgetMap;
    }

    public Map<String, BigDecimal> getOccupationMap() {
        return this.occupationMap;
    }

    public Map<String, BigDecimal> getExecuteMap() {
        return this.executeMap;
    }

    public Map<String, Map<String, BigDecimal>> getExtBgMap() {
        return this.extBgMap;
    }

    public Map<String, Map<String, BigDecimal>> getExtOccupationMap() {
        return this.extOccupationMap;
    }

    public Map<String, Map<String, BigDecimal>> getExtExecuteMap() {
        return this.extExecuteMap;
    }

    public Map<String, Map<String, BigDecimal>> getExtBudgetOccupation() {
        return this.extBudgetOccupation;
    }

    public Map<String, Map<String, BigDecimal>> getExtActualChanges() {
        return this.extActualChanges;
    }

    public Map<String, BigDecimal> getBudgetOccupation() {
        return this.budgetOccupation;
    }

    public List<String> getHasActualPeriods() {
        return this.hasActualPeriods;
    }

    public Map<String, BigDecimal> getActualChanges() {
        return this.actualChanges;
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public String getModelType() {
        return this.modelType;
    }

    public final Map<String, Object> getMap(String key) {
        return (Map)this.calObj.get(key);
    }

    public CalcBalanceObj(Map<String, Object> calObj) {
        String periodMember;
        String key;
        String reporttype;
        this.calObj = calObj;
        Map<String, Object> accountMap = this.getMap("Account");
        this.account = this.showAccount(accountMap.get("bgname") != null ? accountMap.get("bgname").toString() : "", accountMap.get("bgnumber").toString());
        Map<String, Object> model = this.getMap("model");
        Long modelId = (Long)model.get("id");
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        DynamicObject model_new = ModelUtils.getModel((Long)modelId);
        this.modelType = reporttype = model_new.getString("reporttype");
        if (ApplicationTypeEnum.EB.getIndex().equals(reporttype)) {
            HashMap yearMap = (HashMap)calObj.get("Year");
            HashMap periodMap = (HashMap)calObj.get("Period");
            this.currPeriod = yearMap.get("number") + "_" + periodMap.get("number");
        } else {
            HashMap budgetPeriodMap = (HashMap)calObj.get("BudgetPeriod");
            this.currPeriod = (String)budgetPeriodMap.get("number");
        }
        if (calObj.containsKey("hasActualPeriods")) {
            this.hasActualPeriods = ((HashSet)calObj.get("hasActualPeriods")).stream().sorted().collect(Collectors.toList());
        }
        Map<String, Object> setting = this.getMap("setting");
        this.coefficient = ((BigDecimal)setting.get("coefficient")).setScale(2, 4);
        this.controlType = (String)setting.get("controltype");
        Map<String, BigDecimal> extBgMap = this.getAmount("extBg");
        Map<String, BigDecimal> extAcMap = this.getAmount("extAc");
        if (extBgMap.isEmpty() && extAcMap.isEmpty()) {
            this.budgetMap = this.getAmount("budget");
            this.occupationMap = this.getAmount("occupation");
            this.executeMap = this.getAmount("execute");
            Boolean openReduceBill = ControlParamsSettingUtil.isOpenReduceBill((Long)modelId);
            this.budgetOccupation = openReduceBill != false ? this.getAmount("budgetOccupation") : new HashMap(16);
            this.actualChanges = this.getAmount("actualChanges");
        }
        log.info("extBgMap:" + JSONUtils.toString(extBgMap));
        for (Map.Entry<String, BigDecimal> extBg : extBgMap.entrySet()) {
            Map map;
            key = extBg.getKey();
            String pdcKey = this.getPDCKey(key);
            periodMember = this.periodMember(key);
            String auditTrailNumber = this.getMemberByDimNumber(key, "AuditTrail");
            if ("BudgetOccupation".equals(auditTrailNumber)) {
                map = this.extBudgetOccupation.getOrDefault(pdcKey, new LinkedHashMap());
                map.put(periodMember, extBg.getValue());
                this.extBudgetOccupation.put(pdcKey, map);
                continue;
            }
            map = this.extBgMap.getOrDefault(pdcKey, new LinkedHashMap());
            map.put(periodMember, extBg.getValue());
            this.extBgMap.put(pdcKey, map);
        }
        log.info("extAcMap:" + JSONUtils.toString(extAcMap));
        for (Map.Entry<String, BigDecimal> extAc : extAcMap.entrySet()) {
            Map map;
            key = extAc.getKey();
            String accountNumber = this.getMemberByDimNumber(key, "Account");
            periodMember = this.periodMember(key);
            String changeTypeNumber = this.getMemberByDimNumber(key, "ChangeType");
            String pdcKey = this.getPDCKey(key);
            if ("Occupation".equals(changeTypeNumber)) {
                map = this.extOccupationMap.getOrDefault(pdcKey, new LinkedHashMap());
                map.put(periodMember, extAc.getValue());
                this.extOccupationMap.put(pdcKey, map);
                continue;
            }
            if ("Execute".equals(changeTypeNumber)) {
                map = this.extExecuteMap.getOrDefault(pdcKey, new LinkedHashMap());
                map.put(periodMember, extAc.getValue());
                this.extExecuteMap.put(pdcKey, map);
                continue;
            }
            if (!"ActualChanges".equals(changeTypeNumber)) continue;
            map = this.extActualChanges.getOrDefault(pdcKey, new LinkedHashMap());
            map.put(periodMember, extAc.getValue());
            this.extActualChanges.put(pdcKey, map);
        }
        log.info("extBudget:" + JSONUtils.toString(this.extBgMap));
        log.info("extoccu:" + JSONUtils.toString(this.extOccupationMap));
        log.info("extExe:" + JSONUtils.toString(this.extExecuteMap));
        log.info("extActualChanges:" + JSONUtils.toString(this.extActualChanges));
        log.info("extBudgetOccupation:" + JSONUtils.toString(this.extBudgetOccupation));
        this.title = Lists.newArrayList((Object[])new String[]{PanelUtils.getTitleAccount(), PanelUtils.getTitleUserdef(), PanelUtils.getTitlePeriod(), PanelUtils.getTitleBudget(), PanelUtils.getTitleCoef(), PanelUtils.getTitleOcc(), PanelUtils.getTitleExe()});
        if (!this.budgetOccupation.isEmpty() || !this.extBudgetOccupation.isEmpty()) {
            this.title.add(PanelUtils.getTitleBo());
        }
        if (!this.actualChanges.isEmpty() || !this.extActualChanges.isEmpty()) {
            this.title.add(PanelUtils.getTitleAc());
        }
        if (BgControlSettingTypeEnum.MONTH.getNumber().equals(this.controlType)) {
            this.period.add(this.currPeriod);
        } else if (BgControlSettingTypeEnum.QUARTER.getNumber().equals(this.controlType)) {
            this.period.addAll(this.getPeriodListByCurPeriod(this.currPeriod, "quarter"));
        } else if (BgControlSettingTypeEnum.HALFYEAR.getNumber().equals(this.controlType)) {
            this.period.addAll(this.getPeriodListByCurPeriod(this.currPeriod, "halfyear"));
        } else if (BgControlSettingTypeEnum.YEAR.getNumber().equals(this.controlType)) {
            this.period.addAll(this.getAllPeriod().stream().sorted().collect(Collectors.toList()));
        } else if (BgControlSettingTypeEnum.isMonthAddUp((String)this.controlType).booleanValue()) {
            HashSet<String> dataPeriod = new HashSet<String>(this.getAllPeriod());
            dataPeriod.add(this.currPeriod);
            List periodList = dataPeriod.stream().sorted().collect(Collectors.toList());
            this.period.addAll(periodList);
        } else if (BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.controlType)) {
            List<String> months = this.getPeriodListByCurPeriod(this.currPeriod, "quarter");
            String maxMonth = months.get(2);
            HashSet<String> allPeriod = new HashSet<String>(this.getAllPeriod());
            allPeriod.addAll(months);
            List periodList = allPeriod.stream().sorted().collect(Collectors.toList());
            for (String p : periodList) {
                if (BgPeriodHelper.compareTo((String)p, (String)maxMonth) > 0 && !this.hasActual(p).booleanValue() || this.period.contains(p)) continue;
                this.period.addAll(this.getPeriodListByCurPeriod(p, "quarter"));
            }
        }
        log.info("periodList:" + StringUtils.join(this.period, (String)","));
        this.userDefinedDimStr = calObj.get("definedDimMem") != null ? (String)calObj.get("definedDimMem") : "";
    }

    private final Map<String, BigDecimal> getAmount(String dataType) {
        String prex = dataType + " : ";
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, Object> entry : this.calObj.entrySet()) {
            BigDecimal bigDecimal;
            String key = entry.getKey();
            if (!key.startsWith(prex) || entry.getValue() == null || BigDecimal.ZERO.compareTo(bigDecimal = (BigDecimal)entry.getValue()) == 0) continue;
            retMap.put(key.replace(prex, ""), bigDecimal);
        }
        return retMap;
    }

    public final Boolean hasActual(List<String> periods) {
        return periods.stream().anyMatch(p -> this.hasActual((String)p));
    }

    public final Boolean hasActual(String period) {
        if (this.occupationMap.containsKey(period) || this.executeMap.containsKey(period) || this.budgetOccupation.containsKey(period) || this.actualChanges.containsKey(period) || this.budgetMap.containsKey(period) && BigDecimal.ZERO.compareTo(this.budgetMap.get(period)) > 0) {
            return true;
        }
        for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extBgMap.entrySet()) {
            for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                if (!period.equals(subEntry.getKey()) || BigDecimal.ZERO.compareTo(subEntry.getValue()) <= 0) continue;
                return true;
            }
        }
        for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extOccupationMap.entrySet()) {
            for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                if (!period.equals(subEntry.getKey())) continue;
                return true;
            }
        }
        for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extExecuteMap.entrySet()) {
            for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                if (!period.equals(subEntry.getKey())) continue;
                return true;
            }
        }
        for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extBudgetOccupation.entrySet()) {
            for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                if (!period.equals(subEntry.getKey())) continue;
                return true;
            }
        }
        for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extActualChanges.entrySet()) {
            for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                if (!period.equals(subEntry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public final Boolean hasGrpData() {
        return !this.extBgMap.isEmpty() || !this.extOccupationMap.isEmpty() || !this.extExecuteMap.isEmpty() || !this.extBudgetOccupation.isEmpty() || !this.extActualChanges.isEmpty();
    }

    public final Set<String> getAllPeriod() {
        if (this.olapPeriods.isEmpty()) {
            this.olapPeriods.addAll(this.budgetMap.keySet());
            this.olapPeriods.addAll(new HashSet<String>(this.occupationMap.keySet()));
            this.olapPeriods.addAll(new HashSet<String>(this.executeMap.keySet()));
            this.olapPeriods.addAll(new HashSet<String>(this.budgetOccupation.keySet()));
            this.olapPeriods.addAll(new HashSet<String>(this.actualChanges.keySet()));
            for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extBgMap.entrySet()) {
                for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                    this.olapPeriods.add(subEntry.getKey());
                }
            }
            for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extOccupationMap.entrySet()) {
                for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                    this.olapPeriods.add(subEntry.getKey());
                }
            }
            for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extExecuteMap.entrySet()) {
                for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                    this.olapPeriods.add(subEntry.getKey());
                }
            }
            for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extBudgetOccupation.entrySet()) {
                for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                    this.olapPeriods.add(subEntry.getKey());
                }
            }
            for (Map.Entry<String, Map<String, BigDecimal>> entry : this.extActualChanges.entrySet()) {
                for (Map.Entry<String, BigDecimal> subEntry : entry.getValue().entrySet()) {
                    this.olapPeriods.add(subEntry.getKey());
                }
            }
        }
        return this.olapPeriods;
    }

    public String userDefinedDim(String pcdKey) {
        ArrayList<Dimension> dimNumbers = new ArrayList<Dimension>();
        List dimensions = this.modelCacheHelper.getDimensionList();
        for (Dimension dimension : dimensions) {
            if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) continue;
            dimNumbers.add(dimension);
        }
        StringBuilder userdefs = new StringBuilder();
        for (Dimension dim : dimNumbers) {
            String memberByDimNumber = this.getMemberByDimNumber(pcdKey, dim.getNumber());
            if (memberByDimNumber == null) continue;
            Member member = this.modelCacheHelper.getMember(dim.getNumber(), null, memberByDimNumber);
            if (member == null) {
                member = this.modelCacheHelper.getMemberByAnyView(dim.getNumber(), memberByDimNumber);
            }
            if (member == null) continue;
            String name = member.getName();
            userdefs.append(dim.getName());
            userdefs.append("_");
            userdefs.append(name);
            userdefs.append("!");
        }
        if (userdefs.length() > 0) {
            userdefs.setLength(userdefs.length() - 1);
        }
        return userdefs.toString();
    }

    public final String showAccount(String accountName, String accountNumber) {
        return accountName + PanelUtils.getTxtBracket(accountNumber);
    }

    public String getPeriodName(String period) {
        if (BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.controlType)) {
            if (ApplicationTypeEnum.EB.getIndex().equals(this.modelType)) {
                String[] split = period.split("_");
                int month = Integer.parseInt(split[2].replace("M", ""));
                int quarter = (int)Math.ceil((double)month / 3.0);
                return ResManager.loadResFormat((String)"%1\u5e74\u7b2c%2\u5b63\u5ea6", (String)"CalcBalanceObj_1", (String)"epm-eb-formplugin", (Object[])new Object[]{split[0].replace("FY", ""), quarter});
            }
            String[] split = period.split("\\.");
            String year = split[0].replace("FY", "");
            int month = Integer.parseInt(split[1].replace("M", ""));
            int quarter = (int)Math.ceil((double)month / 3.0);
            return ResManager.loadResFormat((String)"%1\u5e74\u7b2c%2\u5b63\u5ea6", (String)"CalcBalanceObj_1", (String)"epm-eb-formplugin", (Object[])new Object[]{year, quarter});
        }
        return "";
    }

    public final String getPDCKey(String key) {
        String[] dims = key.split("!");
        StringBuilder sb = new StringBuilder();
        for (String str : dims) {
            if (str.startsWith("BudgetPeriod_") || str.startsWith("AuditTrail_") || str.startsWith("ChangeType_") || str.startsWith("DataType_") || str.startsWith("Version_") || str.startsWith("Year_") || str.startsWith("Period_") || str.startsWith("InternalCompany_")) continue;
            sb.append(str);
            sb.append("!");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public final String periodMember(String key) {
        String[] datakey = key.split("!");
        if (ApplicationTypeEnum.EB.getIndex().equals(this.modelType)) {
            String year = Arrays.stream(datakey).filter(k -> k.startsWith("Year")).findAny().get();
            String yearMember = year.replaceFirst("Year_", "");
            String period = Arrays.stream(datakey).filter(k -> k.startsWith("Period")).findAny().get();
            String periodMember1 = period.replaceFirst("Period_", "");
            return yearMember + "_" + periodMember1;
        }
        String budgetPeriod = Arrays.stream(datakey).filter(k -> k.startsWith("BudgetPeriod")).findAny().get();
        return budgetPeriod.replaceFirst("BudgetPeriod_", "");
    }

    public final String getMemberByDimNumber(String key, String dimnumber) {
        String[] datakey = key.split("!");
        if (Arrays.stream(datakey).noneMatch(k -> k.startsWith(dimnumber))) {
            return null;
        }
        String accountKey = Arrays.stream(datakey).filter(k -> k.startsWith(dimnumber)).findAny().get();
        String repKey = dimnumber + "_";
        return accountKey.replaceFirst(repKey, "");
    }

    public final List<String> getPeriodListByCurPeriod(String preiod, String periodType) {
        ArrayList<String> periodList;
        block6: {
            String monthFlag;
            String prefix;
            block7: {
                int month;
                block5: {
                    String[] split;
                    prefix = "";
                    String monthStr = "";
                    monthFlag = ".M";
                    periodList = new ArrayList<String>();
                    if (ApplicationTypeEnum.EB.getIndex().equals(this.modelType)) {
                        split = preiod.split("_");
                        prefix = split[0] + "_" + split[1];
                        monthStr = split[2];
                        monthFlag = "_M";
                    } else {
                        split = preiod.split("\\.");
                        prefix = split[0];
                        monthStr = split[1];
                        monthFlag = ".M";
                    }
                    month = Integer.parseInt(monthStr.replace("M", ""));
                    if (!"quarter".equals(periodType)) break block5;
                    int quarter = (int)Math.ceil((double)month / 3.0);
                    for (int i = 1; i <= 3; ++i) {
                        String m = prefix + monthFlag + ((quarter - 1) * 3 + i <= 9 ? "0" + ((quarter - 1) * 3 + i) : Integer.valueOf((quarter - 1) * 3 + i));
                        periodList.add(m);
                    }
                    break block6;
                }
                if (!"halfyear".equals(periodType)) break block7;
                int halfYear = (int)Math.ceil((double)month / 6.0);
                for (int i = 1; i <= 6; ++i) {
                    String m = prefix + monthFlag + ((halfYear - 1) * 6 + i <= 9 ? "0" + ((halfYear - 1) * 6 + i) : Integer.valueOf((halfYear - 1) * 6 + i));
                    periodList.add(m);
                }
                break block6;
            }
            if (!"year".equals(periodType)) break block6;
            for (int i = 1; i <= 12; ++i) {
                String m = prefix + monthFlag + (i <= 9 ? "0" + i : Integer.valueOf(i));
                periodList.add(m);
            }
        }
        return periodList;
    }
}

