/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.bgavailablebalance.obj;

import java.util.List;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.Tips;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.StrUtils;

public class FlexPanelBuilder {
    private FlexPanelAp flexPanelAp = new FlexPanelAp();
    private int fontSize = 14;

    public FlexPanelBuilder setFontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public static FlexPanelBuilder build() {
        return new FlexPanelBuilder();
    }

    public static FlexPanelBuilder build(String align, boolean wrap, String width, String height) {
        FlexPanelBuilder fpb = new FlexPanelBuilder();
        fpb.setJustifyContent(align);
        fpb.setWrap(wrap);
        if (StringUtils.isNotEmpty((String)width)) {
            fpb.setWidth(width);
        }
        if (StringUtils.isNotEmpty((String)height)) {
            fpb.setHeight(height);
        }
        return fpb;
    }

    public static FlexPanelBuilder buildMainAp(String key, String direction, String align, String alignItems) {
        FlexPanelBuilder fpb = new FlexPanelBuilder(key, direction, align, alignItems);
        return fpb;
    }

    public FlexPanelBuilder(String key, String direction, String align, String alignItems) {
        this.flexPanelAp.setKey(key);
        this.flexPanelAp.setDirection(direction);
        this.flexPanelAp.setJustifyContent(align);
        this.flexPanelAp.setAlignItems(alignItems);
        this.flexPanelAp.setHideTitle(false);
        this.flexPanelAp.setLazyLoad(true);
    }

    public FlexPanelBuilder() {
        this.flexPanelAp.setKey(StrUtils.getSimpleUuidIdString());
        this.flexPanelAp.setLazyLoad(true);
        this.flexPanelAp.setAlignContent("default");
        this.flexPanelAp.setDirection("row");
        this.flexPanelAp.setAlignItems("center");
    }

    public FlexPanelBuilder setKey(String key) {
        this.flexPanelAp.setKey(key);
        return this;
    }

    public FlexPanelBuilder addBorder(String border) {
        this.addBorder(border, border, border, border);
        return this;
    }

    public FlexPanelBuilder addBorder(String top, String right, String bottom, String left) {
        Border border;
        Style style = this.flexPanelAp.getStyle();
        if (style == null) {
            style = new Style();
        }
        if ((border = style.getBorder()) == null) {
            border = new Border();
        }
        if (StringUtils.isNotEmpty((String)top)) {
            border.setTop(top);
        }
        if (StringUtils.isNotEmpty((String)right)) {
            border.setRight(right);
        }
        if (StringUtils.isNotEmpty((String)bottom)) {
            border.setBottom(bottom);
        }
        if (StringUtils.isNotEmpty((String)left)) {
            border.setLeft(left);
        }
        style.setBorder(border);
        this.flexPanelAp.setStyle(style);
        return this;
    }

    public FlexPanelBuilder addMargin(String top, String right, String bottom, String left) {
        Margin margin;
        Style style = this.flexPanelAp.getStyle();
        if (style == null) {
            style = new Style();
        }
        if ((margin = style.getMargin()) == null) {
            margin = new Margin();
        }
        if (StringUtils.isNotEmpty((String)top)) {
            margin.setTop(top);
        }
        if (StringUtils.isNotEmpty((String)right)) {
            margin.setRight(right);
        }
        if (StringUtils.isNotEmpty((String)bottom)) {
            margin.setBottom(bottom);
        }
        if (StringUtils.isNotEmpty((String)left)) {
            margin.setLeft(left);
        }
        style.setMargin(margin);
        this.flexPanelAp.setStyle(style);
        return this;
    }

    public FlexPanelBuilder addPadding(String top, String right, String bottom, String left) {
        Padding padding;
        Style style = this.flexPanelAp.getStyle();
        if (style == null) {
            style = new Style();
        }
        if ((padding = style.getPadding()) == null) {
            padding = new Padding();
        }
        if (StringUtils.isNotEmpty((String)top)) {
            padding.setTop(top);
        }
        if (StringUtils.isNotEmpty((String)right)) {
            padding.setRight(right);
        }
        if (StringUtils.isNotEmpty((String)bottom)) {
            padding.setBottom(bottom);
        }
        if (StringUtils.isNotEmpty((String)left)) {
            padding.setLeft(left);
        }
        style.setPadding(padding);
        this.flexPanelAp.setStyle(style);
        return this;
    }

    public FlexPanelBuilder setJustifyContent(String align) {
        this.flexPanelAp.setJustifyContent(align);
        return this;
    }

    public FlexPanelBuilder setCustomeStyles(String customeStyles) {
        this.flexPanelAp.setCustomeStyles(customeStyles);
        return this;
    }

    public FlexPanelBuilder setWidth(String width) {
        this.flexPanelAp.setWidth(new LocaleString(width));
        return this;
    }

    public FlexPanelBuilder setHiden(boolean hidden) {
        this.flexPanelAp.setHidden(hidden);
        return this;
    }

    public FlexPanelBuilder setHeight(String height) {
        this.flexPanelAp.setHeight(new LocaleString(height));
        return this;
    }

    public FlexPanelBuilder setWrap(boolean isWrap) {
        this.flexPanelAp.setWrap(isWrap);
        return this;
    }

    public FlexPanelBuilder setShrink(int shrink) {
        this.flexPanelAp.setShrink(shrink);
        return this;
    }

    public FlexPanelBuilder setGrow(int grow) {
        this.flexPanelAp.setGrow(grow);
        return this;
    }

    public FlexPanelBuilder setDirection(String direction) {
        this.flexPanelAp.setDirection(direction);
        return this;
    }

    public FlexPanelBuilder setAlignItems(String alignItems) {
        this.flexPanelAp.setAlignItems(alignItems);
        return this;
    }

    public FlexPanelBuilder setBackColor(String color) {
        this.flexPanelAp.setBackColor(color);
        return this;
    }

    public FlexPanelBuilder setRadius(String radius) {
        this.flexPanelAp.setRadius(radius);
        return this;
    }

    public FlexPanelBuilder setOverflow(String overflow) {
        this.flexPanelAp.setOverflow(overflow);
        return this;
    }

    public FlexPanelBuilder setClickable(boolean clickable) {
        this.flexPanelAp.setClickable(clickable);
        return this;
    }

    public FlexPanelBuilder addItems(ControlAp<?> ap) {
        if (ap != null) {
            this.flexPanelAp.getItems().add(ap);
        }
        return this;
    }

    public FlexPanelBuilder addItems(ControlAp<?> ap, Predicate<Boolean> predicate) {
        if (predicate.test(true)) {
            this.flexPanelAp.getItems().add(ap);
        }
        return this;
    }

    public FlexPanelBuilder setName(String name) {
        this.flexPanelAp.setName(new LocaleString(name));
        return this;
    }

    public FlexPanelBuilder setCtlTips(String tips) {
        Tips t = this.createCtlTips(tips);
        if (t != null) {
            this.flexPanelAp.setCtlTips(t);
        }
        return this;
    }

    private Tips createCtlTips(String tips) {
        if (StringUtils.isNotEmpty((String)tips)) {
            Tips ctlTips = new Tips();
            ctlTips.setContent(new LocaleString(tips));
            ctlTips.setTriggerType("hover");
            ctlTips.setType("text");
            ctlTips.setShowIcon(false);
            return ctlTips;
        }
        return null;
    }

    private final ControlAp addHyperLink(String content, String tips, String key, String foreColor) {
        LabelAp labelAp = new LabelAp();
        if (key == null) {
            labelAp.setKey("label" + StrUtils.getSimpleUuidIdString());
        } else {
            labelAp.setKey(key);
        }
        Tips t = this.createCtlTips(tips);
        if (t != null) {
            labelAp.setCtlTips(t);
        }
        labelAp.setFontSize(this.fontSize);
        labelAp.setClickable(true);
        labelAp.setOperationKey("test");
        labelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJDpob3ZlciB7XG7CoMKgdGV4dC1kZWNvcmF0aW9uOnVuZGVybGluZTtcbsKgfVxuIn0=");
        if (StringUtils.isEmpty((String)foreColor)) {
            labelAp.setForeColor("#5582F3");
        } else {
            labelAp.setForeColor(foreColor);
        }
        labelAp.setName(new LocaleString(content));
        return labelAp;
    }

    private final LabelAp addCell(String content) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("label" + StrUtils.getSimpleUuidIdString());
        labelAp.setFontSize(this.fontSize);
        labelAp.setForeColor("#212121");
        labelAp.setName(new LocaleString(content));
        return labelAp;
    }

    private final LabelAp addCell(String content, String color) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("label" + StrUtils.getSimpleUuidIdString());
        labelAp.setFontSize(this.fontSize);
        labelAp.setForeColor(color);
        labelAp.setName(new LocaleString(content));
        return labelAp;
    }

    public FlexPanelBuilder addHyperLink(String content, String tips, String key, String width, String height) {
        return this.addHyperLink(content, tips, key, width, height, null);
    }

    public FlexPanelBuilder addHyperLink(String content, String tips, String key, String width, String height, String foreColor) {
        return this.addCell(content, tips, key, width, height, true, foreColor);
    }

    public FlexPanelBuilder addCell(String content, String width, String height) {
        return this.addCell(content, null, null, width, height, false, null);
    }

    public FlexPanelBuilder addCell(String content, String tips, String key, String width, String height, boolean isHyperLink, String foreColor) {
        FlexPanelBuilder fpb = new FlexPanelBuilder();
        fpb.setJustifyContent("center");
        fpb.setWrap(false);
        if (StringUtils.isNotEmpty((String)width)) {
            fpb.setWidth(width);
        }
        if (StringUtils.isNotEmpty((String)height)) {
            fpb.setHeight(height);
        }
        if (isHyperLink) {
            fpb.addItems(this.addHyperLink(content, tips, key, foreColor));
        } else {
            LabelAp labelAp = this.addCell(content);
            Tips t = this.createCtlTips(tips);
            if (t != null) {
                labelAp.setCtlTips(t);
            }
            fpb.addItems((ControlAp<?>)labelAp);
        }
        return fpb;
    }

    public FlexPanelBuilder addCell(String content, String width, String height, String color) {
        FlexPanelBuilder fpb = new FlexPanelBuilder();
        fpb.setJustifyContent("center");
        fpb.setWrap(false);
        if (StringUtils.isNotEmpty((String)width)) {
            fpb.setWidth(width);
        }
        if (StringUtils.isNotEmpty((String)height)) {
            fpb.setHeight(height);
        }
        fpb.addItems((ControlAp<?>)this.addCell(content, color));
        return fpb;
    }

    public FlexPanelBuilder addHyperLink(String content, String tips, String key, String width, String height, String top, String right, String bottom, String left) {
        FlexPanelBuilder fpb = this.addHyperLink(content, tips, key, width, height);
        fpb.addBorder(top, right, bottom, left);
        return fpb;
    }

    public FlexPanelBuilder addCell(String content, String width, String height, String top, String right, String bottom, String left) {
        FlexPanelBuilder fpb = this.addCell(content, width, height);
        fpb.addBorder(top, right, bottom, left);
        return fpb;
    }

    public FlexPanelBuilder addCell(String content, String width, String height, String top, String right, String bottom, String left, String color) {
        FlexPanelBuilder fpb = this.addCell(content, width, height, color);
        fpb.addBorder(top, right, bottom, left);
        return fpb;
    }

    public static FlexPanelBuilder addImage(String imageKey, String width, String height, String top, String right, String bottom, String left) {
        FlexPanelBuilder fpb = FlexPanelBuilder.addImage(imageKey, width, height);
        fpb.addBorder(top, right, bottom, left);
        return fpb;
    }

    public static FlexPanelBuilder addImage(String imageKey, String width, String height) {
        FlexPanelBuilder fpb = new FlexPanelBuilder();
        fpb.setJustifyContent("center");
        fpb.setWrap(false);
        if (StringUtils.isNotEmpty((String)width)) {
            fpb.setWidth(width);
        }
        if (StringUtils.isNotEmpty((String)height)) {
            fpb.setHeight(height);
        }
        fpb.addItems((ControlAp<?>)FlexPanelBuilder.addImageCell(imageKey));
        return fpb;
    }

    private static final ImageAp addImageCell(String imageKey) {
        ImageAp imageAp = new ImageAp();
        imageAp.setKey("label" + StrUtils.getSimpleUuidIdString());
        imageAp.setWidth(new LocaleString("18px"));
        imageAp.setHeight(new LocaleString("18px"));
        imageAp.setGrow(0);
        imageAp.setShrink(0);
        imageAp.setImageKey(imageKey);
        imageAp.setRadius("16px");
        return imageAp;
    }

    public FlexPanelBuilder addVector(String key, String fontClass, String width, String height, String top, String right, String bottom, String left, String vcwidth, String vcheight, boolean needoverclass) {
        FlexPanelBuilder fpb = this.addVector(key, fontClass, width, height, null, null, vcwidth, vcheight, needoverclass);
        fpb.addBorder(top, right, bottom, left);
        return fpb;
    }

    public FlexPanelBuilder addVector(String key, String fontClass, String width, String height, String forceColor, String custStyle, String vcwidth, String vcheight, boolean needoverclass) {
        FlexPanelBuilder fpb = new FlexPanelBuilder();
        fpb.setJustifyContent("center");
        fpb.setWrap(false);
        if (custStyle != null) {
            fpb.setCustomeStyles(custStyle);
        }
        if (StringUtils.isNotEmpty((String)width)) {
            fpb.setWidth(width);
        }
        if (StringUtils.isNotEmpty((String)height)) {
            fpb.setHeight(height);
        }
        VectorAp vecotor = this.addVectorCell(key, fontClass, forceColor);
        vecotor.setNeedHoverClass(needoverclass);
        if (StringUtils.isNotEmpty((String)vcwidth)) {
            vecotor.setWidth(new LocaleString(vcwidth));
        }
        if (StringUtils.isNotEmpty((String)vcheight)) {
            vecotor.setHeight(new LocaleString(vcheight));
        }
        fpb.addItems((ControlAp<?>)vecotor);
        return fpb;
    }

    private final VectorAp addVectorCell(String key, String fontClass, String forceColor) {
        VectorAp imageAp = new VectorAp();
        imageAp.setKey(key);
        imageAp.setFontSize(this.fontSize);
        imageAp.setWidth(new LocaleString("16px"));
        imageAp.setHeight(new LocaleString("16px"));
        imageAp.setGrow(0);
        imageAp.setShrink(0);
        imageAp.setfontClass(fontClass);
        imageAp.setRadius("2px");
        if (!StringUtils.isEmpty((String)forceColor)) {
            imageAp.setForeColor(forceColor);
        }
        return imageAp;
    }

    public FlexPanelBuilder addCombox(String content, String tips, String key, String width, String height, boolean isHyperLink, String background, List<ComboItem> items, String defaultValue) {
        FlexPanelBuilder fpb = new FlexPanelBuilder();
        fpb.setJustifyContent("center");
        fpb.setWrap(false);
        if (StringUtils.isNotEmpty((String)width)) {
            fpb.setWidth(width);
        }
        if (StringUtils.isNotEmpty((String)height)) {
            fpb.setHeight(height);
        }
        fpb.addItems((ControlAp<?>)this.addCombox(key, background, height, items, defaultValue));
        return fpb;
    }

    private final FieldAp addCombox(String key, String background, String height, List<ComboItem> items, String defaultValue) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setFieldFontSize(this.fontSize);
        fieldAp.setFontSize(this.fontSize);
        fieldAp.setName(new LocaleString(key));
        fieldAp.setFireUpdEvt(true);
        if (height != null) {
            fieldAp.setHeight(new LocaleString(height));
        }
        fieldAp.setWidth(new LocaleString("100%"));
        fieldAp.setShowTitle(false);
        fieldAp.setComboShowType(0);
        if (background != null) {
            fieldAp.setBackColor(background);
        }
        ComboField ba = new ComboField();
        ba.setId(key);
        ba.setKey(key);
        ba.setShowDropDown(false);
        ba.setMustInput(true);
        if (items != null) {
            ba.setItems(items);
        }
        if (defaultValue != null) {
            ba.setDefValue(defaultValue);
        }
        ba.setEnableNull(false);
        fieldAp.setField((Field)ba);
        return fieldAp;
    }

    public FlexPanelAp get() {
        return this.flexPanelAp;
    }
}

