/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.EarlyWarnMessageInfo;
import kd.bos.entity.earlywarn.warn.YzjPublicNumberInfo;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.StringUtils;

public class ControlWarningMessageHandlerPlugin
implements IEarlyWarnMessageHandler {
    private static final Log log = LogFactory.getLog(ControlWarningMessageHandlerPlugin.class);

    public EarlyWarnMessageInfo singleMessageBuilder(DynamicObject paramDynamicObject, EarlyWarnContext paramEarlyWarnContext) {
        if (paramDynamicObject == null) {
            return new EarlyWarnMessageInfo();
        }
        return this.getMessage(new DynamicObject[]{paramDynamicObject});
    }

    public EarlyWarnMessageInfo mergeMessageBuilder(EarlyWarnContext paramEarlyWarnContext) {
        if (paramEarlyWarnContext.getWarnDataList() == null || paramEarlyWarnContext.getWarnDataList().isEmpty()) {
            return new EarlyWarnMessageInfo();
        }
        return this.getMessage((DynamicObject[])paramEarlyWarnContext.getWarnDataList().toArray((Object[])new DynamicObject[0]));
    }

    public EarlyWarnMessageInfo getMessage(DynamicObject[] objects) {
        EarlyWarnMessageInfo msg = new EarlyWarnMessageInfo();
        if (objects == null || objects.length == 0) {
            return msg;
        }
        Set ids = Arrays.stream(objects).map(o -> o.getLong("id")).collect(Collectors.toSet());
        String idsKey = StringUtils.join(ids, (String)",");
        String domainUrl = UrlService.getDomainContextUrl();
        if (!domainUrl.endsWith("/")) {
            domainUrl = domainUrl + "/";
        }
        String accountId = RequestContext.get().getAccountId();
        String mobUrl = domainUrl + "integration/yzjShareOpen.do?accountId=" + accountId;
        mobUrl = mobUrl + "&appId=bgc&mb_formId=bgc_warning_layout_mb&" + "warningid" + "=" + idsKey;
        msg.setMobContentUrl(mobUrl);
        msg.setContentUrl("appId=bgc&formId=bgc_warning_layout&warningid=" + idsKey);
        return msg;
    }

    public YzjPublicNumberInfo getYZJMessagePublicNumber(List<YzjPublicNumberInfo> publicNumberInfos) {
        if (publicNumberInfos == null) {
            return null;
        }
        String yzjPubNumber = this.getYZJPubNumber();
        for (YzjPublicNumberInfo publicNumberInfo : publicNumberInfos) {
            if (!publicNumberInfo.getPubNumber().equals(yzjPubNumber)) continue;
            return publicNumberInfo;
        }
        return null;
    }

    protected String getYZJPubNumber() {
        String yzjPubNumber = "systempubacc";
        try {
            Set percent = LogSignHelper.getLogSignByGropNum((String)"ControlWaringYZJPubNumber");
            log.info("budget-control-warning-log : ControlWarningMessageHandlerPlugin-ControlWaringYZJPubNumber" + JSONUtils.toString((Object)percent));
            if (percent != null && !percent.isEmpty()) {
                yzjPubNumber = (String)percent.iterator().next();
            }
        }
        catch (Throwable ex) {
            log.info("budget-control-warning-log : ControlWarningMessageHandlerPlugin-ControlWaringYZJPubNumber" + ex);
        }
        if (StringUtils.isEmpty((String)yzjPubNumber)) {
            yzjPubNumber = "systempubacc";
        }
        return yzjPubNumber;
    }
}

