/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.pojo.ControlWarningRecipientMappingPojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.budgetwarnning.ControlWarningRecipientMappingPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class ControlWarningRecipientMappingImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(ControlWarningRecipientMappingImportPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String BTN_DOWNLOAD = "btndownload";

    private static String getEnableCn() {
        return ResManager.loadKDString((String)"\u542f\u7528", (String)"ControlWarningRecipientMappingImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_DOWNLOAD});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
        }
    }

    private void returnExceptionMessage(String message) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)message)) {
            throw new KDBizException(message);
        }
    }

    private void importData() {
        String fileUrl = this.getPageCache().get("file_url");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"ControlWarningRecipientMappingImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List inputStreams = UploadUtil.getFileInputStreams((String)fileUrl);
        List<XSSFWorkbook> uploadBooks = this.getXssfWorkbooks(inputStreams);
        String message = this.checkFileFormat(uploadBooks);
        this.returnExceptionMessage(message);
        ArrayList<List<String>> dataList = new ArrayList<List<String>>(16);
        for (XSSFWorkbook workbook : uploadBooks) {
            BgExcelReader excelReader = BgExcelReader.getInstance().readByWorkbook((Workbook)workbook);
            List datas = excelReader.readString(2, 0, 7);
            dataList.addAll(datas);
        }
        if (CollectionUtils.isNotEmpty(dataList)) {
            dataList.removeIf(e -> {
                for (String str : e) {
                    if (!StringUtils.isNotEmpty((String)str)) continue;
                    return false;
                }
                return true;
            });
        }
        if (CollectionUtils.isEmpty(dataList)) {
            this.returnExceptionMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"ControlWarningRecipientMappingImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.handleExcelDataList(dataList);
    }

    private void handleExcelDataList(List<List<String>> dataList) {
        List<ControlWarningRecipientMappingPojo> successList = this.checkDatas(dataList);
        this.getView().returnDataToParent(successList);
        if (successList.size() < dataList.size()) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u3002", (String)"ControlWarningRecipientMappingImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<ControlWarningRecipientMappingPojo> checkDatas(List<List<String>> dataList) {
        void var19_24;
        DynamicObjectCollection orgs;
        DynamicObjectCollection bosUser;
        Map<Object, Object> persons = new HashMap(dataList.size());
        Map<Object, Object> structOrgs = new HashMap(dataList.size());
        HashMap viewOrg = new HashMap(dataList.size());
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        Long businessModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("businessmodel"));
        HashSet<Object> personNums = new HashSet<Object>(16);
        HashSet<String> structOrgNums = new HashSet<String>(16);
        HashMap<String, Set> viewOrgMapping = new HashMap<String, Set>(dataList.size());
        ArrayList<ControlWarningRecipientMappingPojo> objList = new ArrayList<ControlWarningRecipientMappingPojo>(dataList.size());
        ArrayList<List<String>> errList = new ArrayList<List<String>>(16);
        String orgType = this.getView().getFormShowParameter().getCustomParam("orgtype").toString();
        for (int i = 0; i < dataList.size(); ++i) {
            String[] personNumbers;
            List<String> row = dataList.get(i);
            String entryOrgType = row.get(0);
            if (ControlWarningRecipientMappingImportPlugin.getBudgetOrg().equals(entryOrgType)) {
                String viewNumber = row.get(2);
                Set budgetOrg = viewOrgMapping.getOrDefault(viewNumber, new HashSet());
                budgetOrg.add(row.get(4));
                viewOrgMapping.put(viewNumber, budgetOrg);
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)row.get(4))) {
                structOrgNums.add(row.get(4));
            }
            String personNumber = row.get(6);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)personNumber) || (personNumbers = personNumber.split(",")) == null) continue;
            for (String number : personNumbers) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)number)) continue;
                personNums.add(number);
            }
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)businessModelId, (String)"eb_businessmodel");
        if (!personNums.isEmpty() && (bosUser = QueryServiceHelper.query((String)"bos_user", (String)"id,number,name", (QFilter[])QFBuilder.newQFilter().add("number", "in", personNums).toArray())) != null && !bosUser.isEmpty()) {
            persons = bosUser.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e, (o1, o2) -> o2));
        }
        if (!structOrgNums.isEmpty() && (orgs = QueryServiceHelper.query((String)"bos_adminorg", (String)"id, number", (QFilter[])QFBuilder.newQFilter().add("number", "in", structOrgNums).toArray())) != null && !orgs.isEmpty()) {
            structOrgs = orgs.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e));
        }
        DynamicObjectCollection views = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id, number", (QFilter[])QFBuilder.newQFilter().add("model", "=", (Object)modelId).add("dimension.number", "=", (Object)"Entity").toArray());
        Map<String, Long> viewMap = views.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id")));
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List viewIds = modelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(businessModelId, "Entity");
        for (Map.Entry entry : viewOrgMapping.entrySet()) {
            Long viewId = viewMap.get(entry.getKey());
            if (viewId == null) continue;
            Map memberMap = viewOrg.getOrDefault(entry.getKey(), new HashMap());
            for (String memberNumber : (Set)entry.getValue()) {
                Member member;
                if (memberMap.containsKey(memberNumber) || (member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, memberNumber)) == null || member.isAnalyzeMember()) continue;
                memberMap.put(memberNumber, member);
            }
            viewOrg.put(entry.getKey(), memberMap);
        }
        HashMap<String, Set> permMap = new HashMap<String, Set>(viewIds.size());
        for (Long viewId : viewIds) {
            DynamicObject viewDyn = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview");
            String viewNumber = viewDyn.getString("number");
            Set permMembIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)modelId, (Long)businessModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            permMap.put(viewNumber, permMembIds);
        }
        boolean bl = false;
        while (var19_24 < dataList.size()) {
            String personNumber;
            ArrayList<String> errMsgList = new ArrayList<String>(16);
            ControlWarningRecipientMappingPojo mapObj = new ControlWarningRecipientMappingPojo();
            List<String> row = dataList.get((int)var19_24);
            String orgNumber = row.get(4);
            String entryOrgType = row.get(0);
            if ("0".equals(orgType) && ControlWarningRecipientMappingImportPlugin.getStrutureOrg().equals(entryOrgType) || "1".equals(orgType) && ControlWarningRecipientMappingImportPlugin.getBudgetOrg().equals(entryOrgType)) {
                errMsgList.add(ResManager.loadKDString((String)"\u5206\u5f55\u7ec4\u7ec7\u7c7b\u578b\u4e0e\u5355\u5934\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (String)"ControlWarningRecipientMappingImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ControlWarningRecipientMappingImportPlugin.getBudgetOrg().equals(entryOrgType)) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgNumber)) {
                    errMsgList.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ControlWarningRecipientMappingImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)row.get(2))) {
                    errMsgList.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u9884\u7b97\u7ec4\u7ec7\u201d\u65f6\uff0c\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801\u5fc5\u586b", (String)"ControlWarningRecipientMappingImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (!viewOrg.containsKey(row.get(2))) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u7f16\u5236\u89c6\u56fe\u7f16\u7801\u201c%1\u201d\u4e0d\u5b58\u5728", (String)"ControlWarningRecipientMappingImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{row.get(2)}));
                } else if (!viewIds.contains(viewMap.get(row.get(2)))) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u89c6\u56fe\u201c%1\u201d\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u201c%2\u201d\u5185", (String)"ControlWarningRecipientMappingImportPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[]{row.get(2), dynamicObject.getString("name")}));
                } else if (!((Map)viewOrg.get(row.get(2))).containsKey(orgNumber) || ((Map)viewOrg.get(row.get(2))).get(orgNumber) == null) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u89c6\u56fe\u201c%1\u201d\u4e2d\u4e0d\u5b58\u5728\u201c%2\u201d\u7ec4\u7ec7\u7f16\u7801", (String)"ControlWarningRecipientMappingImportPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{row.get(2), orgNumber}));
                } else {
                    Long orgId = ((Member)((Map)viewOrg.get(row.get(2))).get(orgNumber)).getId();
                    Set permMembIds = (Set)permMap.get(row.get(2));
                    if (permMembIds == null || permMembIds.contains(orgId)) {
                        mapObj.setOrg(orgId);
                        mapObj.setBgOrgView(viewMap.get(row.get(2)));
                        mapObj.setOrgTypeItem("epm_entitymembertree");
                    } else {
                        errMsgList.add(ResManager.loadResFormat((String)"\u65e0\u6210\u5458\u201c%1\u201d\u7684\u4f7f\u7528\u6743\u9650", (String)"ControlWarningRecipientMappingImportPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[]{orgNumber}));
                    }
                }
            } else if (!structOrgs.containsKey(orgNumber)) {
                errMsgList.add(ResManager.loadResFormat((String)"\u7ec4\u7ec7%1\u4e0d\u5b58\u5728", (String)"ControlWarningRecipientMappingImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{orgNumber}));
            } else {
                mapObj.setOrg(Long.valueOf(((DynamicObject)structOrgs.get(orgNumber)).getLong("id")));
                mapObj.setOrgTypeItem("bos_adminorg");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orgNumber)) {
                String[] orgMembers = orgNumber.split(",");
                if (orgMembers != null && orgMembers.length > 1) {
                    errMsgList.add(ResManager.loadKDString((String)"\u540c\u4e00\u884c\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\u7ec4\u7ec7", (String)"ControlWarningRecipientMappingImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    if ("Entity".equals(orgNumber)) {
                        errMsgList.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6839\u8282\u70b9Entity\u4e0d\u80fd\u5bfc\u5165", (String)"ControlWarningRecipientMappingImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    for (int j = 0; j < dataList.size(); ++j) {
                        List<String> strings;
                        boolean disjoint;
                        if (var19_24 == j || (disjoint = Collections.disjoint(row, strings = dataList.get(j))) || !row.get(4).equals(strings.get(4))) continue;
                        errMsgList.add(ResManager.loadKDString((String)"\u5b58\u5728\u7ec4\u7ec7\u91cd\u590d\u7684\u884c", (String)"ControlWarningRecipientMappingImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        mapObj.setOrg(null);
                    }
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(personNumber = row.get(6)))) {
                String[] personNumbers = personNumber.split(",");
                ArrayList<Long> personIds = new ArrayList<Long>(personNumbers.length);
                for (String number : personNumbers) {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)number) && !persons.containsKey(number)) {
                        errMsgList.add(ResManager.loadResFormat((String)"\u4eba\u5458%1\u4e0d\u5b58\u5728", (String)"ControlWarningRecipientMappingImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
                        continue;
                    }
                    if (persons.get(number) == null) continue;
                    personIds.add(((DynamicObject)persons.get(number)).getLong("id"));
                }
                mapObj.setPersons(personIds);
            } else {
                errMsgList.add(ResManager.loadKDString((String)"\u4eba\u5458\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ControlWarningRecipientMappingImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String status = row.get(7);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)status)) {
                mapObj.setStatus(Boolean.valueOf(status.equalsIgnoreCase(ControlWarningRecipientMappingImportPlugin.getEnableCn())));
            }
            if (!errMsgList.isEmpty()) {
                row.add(String.join((CharSequence)",", errMsgList));
                errList.add(row);
            }
            if (mapObj.getOrg() != null && mapObj.getPersons() != null && !mapObj.getPersons().isEmpty()) {
                objList.add(mapObj);
            }
            ++var19_24;
        }
        if (!errList.isEmpty()) {
            this.downloadImportErrorExcel(errList);
        }
        return objList;
    }

    protected List<XSSFWorkbook> getXssfWorkbooks(List<InputStream> inputStreams) {
        ArrayList<XSSFWorkbook> xssfWorkbooks = new ArrayList<XSSFWorkbook>();
        try {
            for (InputStream inputStream : inputStreams) {
                XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
                xssfWorkbooks.add(xssfWorkbook);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u5305\u542b\u683c\u5f0f\u4e0d\u6b63\u786e\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"ControlWarningRecipientMappingImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return xssfWorkbooks;
    }

    private String checkFileFormat(List<XSSFWorkbook> uploadBooks) {
        try {
            for (XSSFWorkbook uploadBook : uploadBooks) {
                XSSFSheet uploadSheet = uploadBook.getSheetAt(0);
                XSSFRow row2 = uploadSheet.getRow(1);
                if (row2 == null) {
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u6ca1\u6709\u83b7\u53d6\u5230\u8868\u5934\u4fe1\u606f\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"ControlWarningRecipientMappingImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                Map<String, Header> sheetHeaderMap = this.getHeaderData();
                for (Map.Entry<String, Header> entry : sheetHeaderMap.entrySet()) {
                    int colNum = Integer.parseInt(entry.getKey());
                    if (row2.getCell(colNum).getStringCellValue().trim().equals(entry.getValue().getHeader())) continue;
                    return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u5305\u542b\u683c\u5f0f\u4e0d\u6b63\u786e\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"ControlWarningRecipientMappingImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u5305\u542b\u683c\u5f0f\u4e0d\u6b63\u786e\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"ControlWarningRecipientMappingImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    protected Map<String, Header> getHeaderData() {
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        headerMap.put("0", new Header(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7c7b\u578b", (String)"ControlWarningRecipientMappingImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        headerMap.put("1", new Header(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u540d\u79f0", (String)"ControlWarningRecipientMappingImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        headerMap.put("2", new Header(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801", (String)"ControlWarningRecipientMappingImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        headerMap.put("3", new Header(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"ControlWarningRecipientMappingImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        headerMap.put("4", new Header(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801*", (String)"ControlWarningRecipientMappingImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        headerMap.put("5", new Header(ResManager.loadKDString((String)"\u4eba\u5458\u540d\u79f0", (String)"ControlWarningRecipientMappingImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        headerMap.put("6", new Header(ResManager.loadKDString((String)"\u4eba\u5458\u5de5\u53f7*\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"ControlWarningRecipientMappingImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        headerMap.put("7", new Header(ResManager.loadKDString((String)"\u72b6\u6001", (String)"ControlWarningRecipientMappingImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), null));
        return headerMap;
    }

    private static String getBudgetOrg() {
        return ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7", (String)"ControlWarningRecipientMappingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getStrutureOrg() {
        return ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"ControlWarningRecipientMappingPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private void downloadImportErrorExcel(List<List<String>> errList) {
        String fileName = ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u6620\u5c04\u5bfc\u5165\u51fa\u9519\u8be6\u60c5.xlsx", (String)"ControlWarningRecipientMappingImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String tempPath = "controlwarning/controlwarningrecipientmapping.xlsx";
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(tempPath);
        excelWriter.setStarPosition(2, 0);
        for (List<String> row : errList) {
            excelWriter.createRow(row);
        }
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void downloadTemplate() {
        String fileName = ResManager.loadResFormat((String)"\u63a5\u6536\u4eba\u6620\u5c04\u6e05\u5355_%1", (String)"ControlWarningRecipientMappingImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        ByteArrayInputStream inStream = null;
        ByteArrayOutputStream outStream = null;
        Workbook workbook = ControlWarningRecipientMappingPlugin.getExportTemp();
        try {
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u7684\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"ControlWarningRecipientMappingImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String fileUrl = this.getPageCache().get("file_url");
        List urls = null;
        urls = fileUrl == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String fileUrl = this.getPageCache().get("file_url");
        if (fileUrl == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }
}

