/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.control.ControlModelFuzzySearchCommon;
import kd.epm.eb.formplugin.control.ModelFilterContainerPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.lang3.StringUtils;

public class ControlWarningRecipientMappingListPlugin
extends ModelFilterContainerPlugin
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static final String OPER_MODIFY = "modify";
    private static final String CACHE_IS_HYPERLINK_CLICK = "isHyperLinkClick";
    private static final String STR_TRUE = "true";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"model", "businessmodel"});
        this.addItemClickListeners(new String[]{"toolbarap", "viewbailorg"});
    }

    private String getDefaultId() {
        String defaultId = this.getPageCache().get("defaultid");
        if (defaultId == null) {
            QFilter filter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bgc_recipientmapping", (String)"id", (QFilter[])filter.toArray());
            defaultId = dynamicObject == null ? "" : String.valueOf(dynamicObject.get("id"));
            this.getPageCache().put("defaultid", defaultId);
        }
        return defaultId;
    }

    public void packageData(PackageDataEvent event) {
        String defid = this.getDefaultId();
        if (defid != null && defid.equals(event.getRowData().getString("id"))) {
            event.getNoLinkKey().add("number");
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if ("eb".equals(formShowParameter.getAppId()) && ModelUtil.isNewEb().booleanValue()) {
            formShowParameter.setCustomParam("newEbForm", (Object)STR_TRUE);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.getPageCache().put(CACHE_IS_HYPERLINK_CLICK, STR_TRUE);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        if ("bar_modify".equals(key) || "bar_delete".equals(key)) {
            this.checkDefault(billList);
        }
        if ("viewbailorg".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_bailorg_modify");
            showParameter.setCustomParam("model", (Object)this.getModelId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        HashMap customParams = new HashMap(){
            {
                this.put("KEY_MODEL_ID", ControlWarningRecipientMappingListPlugin.this.getModelId());
                this.put("KEY_BUSMODEL_ID", ControlWarningRecipientMappingListPlugin.this.getBusinessModelId());
            }
        };
        e.getParameter().setCustomParams((Map)customParams);
        super.beforeShowBill(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("MODEL".equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue("model");
            if (obj == null) {
                this.getPageCache().put("KEY_MODEL_ID", null);
            }
            if (obj instanceof DynamicObject) {
                Long modelId = ((DynamicObject)obj).getLong("id");
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            }
            this.refreshData();
            this.dealModelChanged4Bg(e);
        }
    }

    protected void refreshData() {
        BillList list = (BillList)this.getControl("billlistap");
        if (list != null) {
            list.clearSelection();
            list.refreshData();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if (OPER_MODIFY.equals(opType) && !StringUtils.equals((CharSequence)STR_TRUE, (CharSequence)this.getPageCache().get(CACHE_IS_HYPERLINK_CLICK))) {
            BillList bl = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = bl.getSelectedRows();
            if (selectedRows != null && selectedRows.getPrimaryKeyValues().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"ControlWarningRecipientMappingListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.checkDefault(bl);
        }
        this.getPageCache().remove(CACHE_IS_HYPERLINK_CLICK);
    }

    public void setFilter(SetFilterEvent e) {
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            return;
        }
        try {
            if (this.getPageCache().get("noneModels") != null) {
                e.getQFilters().add(new QFilter("1", "=", (Object)-1));
                return;
            }
            if (this.getPageCache().get("schemeQfilter") != null) {
                Long businessModel;
                if (this.getPageCache().get("KEY_MODEL_ID") != null) {
                    e.getQFilters().add(new QFilter("model.id", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
                }
                if (IDUtils.isNotEmptyLong((Long)(businessModel = this.getBusinessModelId())).booleanValue()) {
                    e.getQFilters().add(new QFilter("businessmodel.id", "=", (Object)businessModel));
                }
            }
            QFilter qFilter = null;
            for (QFilter q : e.getQFilters()) {
                String d;
                if (q.getProperty().startsWith("businessmodel") || q.getProperty().startsWith("model")) continue;
                if ("1".equals(q.getProperty()) && (d = q.getValue().toString()).contains("#")) {
                    String[] c = d.split("#");
                    String[] a = c[0].split(",");
                    q.setProperty(a[0]);
                    q.__setCP("like");
                    q.__setValue((Object)("%" + c[1] + "%"));
                    if (a.length > 1) {
                        q.or(new QFilter(a[1], "like", (Object)("%" + c[1] + "%")));
                    }
                }
                if (qFilter != null) {
                    qFilter.and(q);
                    continue;
                }
                qFilter = q;
            }
            e.setMainOrgQFilter(null);
            e.getQFilters().clear();
            Long modelId = this.getModelId();
            StringBuilder sql = new StringBuilder("(isDefault='1') or ");
            if (!modelId.equals(0L)) {
                sql.append("( model=").append(modelId);
                if (CommonUtils.isBgmdModel((Long)modelId)) {
                    sql.append(" and businessmodel=").append(this.getBusinessModelId());
                }
                if (qFilter != null) {
                    sql.append(" and ").append(qFilter.toString());
                }
                sql.append(")");
            } else {
                sql.append("1=1");
            }
            QFilter qf = QFilter.of((String)sql.toString(), (Object[])new Object[0]);
            for (QFilter.QFilterNest nest : qf.getNests(true)) {
                QFilter filter = nest.getFilter();
                new Date();
                if (("createdate".equals(filter.getProperty()) || "modifydate".equals(filter.getProperty())) && !(filter.getValue() instanceof Date)) {
                    filter.__setValue((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)filter.getValue()));
                }
                if (filter.getNests(true) == null) continue;
                for (QFilter.QFilterNest filterNest : filter.getNests(true)) {
                    QFilter filter1 = filterNest.getFilter();
                    if (!"createdate".equals(filter1.getProperty()) && !"modifydate".equals(filter1.getProperty()) || filter1.getValue() instanceof Date) continue;
                    filter1.__setValue((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)filter1.getValue()));
                }
            }
            e.getQFilters().add(qf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if ("model".equals(key)) {
            BasedataEdit b = ControlModelFuzzySearchCommon.getInstance().reBuildBasedataEdit(key);
            b.setView(this.getView());
            b.setModel(this.getModel());
            b.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            b.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
            e.setControl((Control)b);
        }
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        ControlModelFuzzySearchCommon.getInstance().reWriteData(searchEvent);
    }

    private void checkDefault(BillList billList) {
        for (Object primaryKeyValue : billList.getSelectedRows().getPrimaryKeyValues()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bgc_recipientmapping");
            if (dynamicObject == null || !dynamicObject.getBoolean("isdefault")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ControlWarningRecipientMappingListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

