/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.pojo.ControlWarningRecipientMappingPojo;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ControlWarningRecipientMappingPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener,
RowClickEventListener {
    private static final String ORG_TYPE = "orgtype";
    private static final String ORG_TYPE_ITEM = "orgtypeitem";
    private static final String BG_ORG_VIEW = "bgorgview";
    private static final String ORG = "org";
    private static final String PERSON = "person";
    private static final String STATUS = "status";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String BOS_ADMIN_ORG = "bos_adminorg";
    private static final String EPM_ENTITY_MEMBER_TREE = "epm_entitymembertree";
    private static final String CACHE_BG_ORG_VIEW = "cache_bgorgview";
    private static final String[] titles = new String[]{ControlWarningRecipientMappingPlugin.orgType(), ControlWarningRecipientMappingPlugin.orgViewName(), ControlWarningRecipientMappingPlugin.orgViewNumber(), ControlWarningRecipientMappingPlugin.orgName(), ControlWarningRecipientMappingPlugin.orgNumber(), ControlWarningRecipientMappingPlugin.personName(), ControlWarningRecipientMappingPlugin.personNumber(), ControlWarningRecipientMappingPlugin.status()};

    private static String orgType() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u7c7b\u578b", (String)"ControlWarningRecipientMappingPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String orgViewName() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u540d\u79f0", (String)"ControlWarningRecipientMappingPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String orgViewNumber() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801", (String)"ControlWarningRecipientMappingPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String orgName() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0", (String)"ControlWarningRecipientMappingPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String orgNumber() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801*", (String)"ControlWarningRecipientMappingPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String personName() {
        return ResManager.loadKDString((String)"\u4eba\u5458\u540d\u79f0", (String)"ControlWarningRecipientMappingPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String personNumber() {
        return ResManager.loadKDString((String)"\u4eba\u5458\u5de5\u53f7*\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"ControlWarningRecipientMappingPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String status() {
        return ResManager.loadKDString((String)"\u72b6\u6001", (String)"ControlWarningRecipientMappingPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"model"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{ORG, BG_ORG_VIEW});
        this.addClickListeners(new String[]{IMPORT, EXPORT, "viewbailorg"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        this.addItemClickListeners(new String[]{"toolbarap", "viewbailorg"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBgOrgViewCache();
        if ("2".equals(this.getModel().getValue(ORG_TYPE))) {
            this.enableOrgItem(true);
        } else {
            this.enableOrgItem(false);
        }
    }

    private void setBgOrgViewCache() {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (CommonUtils.isBgmdModel((Long)this.getModelId())) {
            Long businessmodel = this.getPageF7Id("businessmodel");
            Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(businessmodel, SysDimensionEnum.Entity.getNumber());
            this.getPageCache().put(CACHE_BG_ORG_VIEW, String.valueOf(viewId));
        } else {
            Long defaultViewIdOnDim = modelCacheHelper.getDefaultViewIdOnDim(SysDimensionEnum.Entity.getNumber());
            this.getPageCache().put(CACHE_BG_ORG_VIEW, IDUtils.toString((Object)defaultViewIdOnDim));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (IDUtils.isNotNull((Long)modelId) && QueryServiceHelper.exists((String)"epm_model", (Object)modelId)) {
            this.getModel().setValue("model", (Object)modelId);
            if (CommonUtils.isBgmdModel((Long)modelId)) {
                Object businessModelId = this.getView().getFormShowParameter().getCustomParam("KEY_BUSMODEL_ID");
                this.getModel().setValue("businessmodel", (Object)IDUtils.toLong((Object)businessModelId));
            } else if (CommonUtils.isBgModel((Long)modelId)) {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id", (QFilter[])QFBuilder.newQFilter().add("model.id", "=", (Object)modelId).toArray());
                this.getModel().setValue("businessmodel", (Object)dynamicObject.getLong("id"));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ControlWarningRecipientMappingPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        if (ORG_TYPE.equals(name)) {
            if (this.getModel().getEntryRowCount("entryentity") > 0 && !"1".equals(this.getPageCache().get("noCheckOrgType"))) {
                String callId = "switchOrgType&" + e.getChangeSet()[0].getOldValue();
                this.getPageCache().remove("noCheckOrgType");
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7\u7c7b\u578b\u4f1a\u6e05\u9664\u7ec4\u7ec7\u4e0e\u4eba\u5458\u6620\u5c04\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ControlWarningRecipientMappingPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callId, (IFormPlugin)this));
            } else {
                this.getPageCache().put("noCheckOrgType", "2");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "orgtype": {
                if (this.getPageCache().get("noCheckOrgType") != null && !"2".equals(this.getPageCache().get("noCheckOrgType"))) break;
                Object newValue = e.getChangeSet()[0].getNewValue();
                if ("0".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{BG_ORG_VIEW});
                } else if ("1".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{BG_ORG_VIEW});
                } else if ("2".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{BG_ORG_VIEW});
                }
                this.getPageCache().remove("noCheckOrgType");
                break;
            }
            case "orgtypeitem": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.getView().setEnable(Boolean.valueOf(EPM_ENTITY_MEMBER_TREE.equals(e.getChangeSet()[0].getNewValue())), rowIndex, new String[]{BG_ORG_VIEW});
                if (!BOS_ADMIN_ORG.equals(e.getChangeSet()[0].getNewValue())) break;
                this.getModel().setValue(BG_ORG_VIEW, null, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "bgorgview": {
                this.getModel().setValue(ORG, null, e.getChangeSet()[0].getRowIndex());
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "import": {
                List mapObjList = (List)e.getReturnData();
                if (mapObjList == null) break;
                this.refreshDataEntity(mapObjList);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().startsWith("switchOrgType")) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity");
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
                String oldType = messageBoxClosedEvent.getCallBackId().split("&")[1];
                this.getPageCache().put("noCheckOrgType", "1");
                this.getModel().setValue(ORG_TYPE, (Object)oldType);
            }
        }
    }

    private void enableOrgItem(Boolean enbale) {
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            this.getView().setEnable(enbale, i, new String[]{ORG_TYPE_ITEM});
            this.getView().setEnable(Boolean.valueOf(EPM_ENTITY_MEMBER_TREE.equals(this.getModel().getEntryRowEntity("entryentity", i).getString(ORG_TYPE_ITEM))), i, new String[]{BG_ORG_VIEW});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel() {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u6620\u5c04\u65e0\u6570\u636e\u53ef\u5bfc\u51fa", (String)"ControlWarningRecipientMappingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        try {
            Workbook workbook = ControlWarningRecipientMappingPlugin.getExportTemp();
            CellStyle cellStyle = POIUtils.get().getTextCellStyle(workbook);
            Sheet sheet = workbook.getSheetAt(0);
            if (selectRows != null && selectRows.length > 0) {
                this.createRows(selectRows, sheet, cellStyle);
            } else {
                this.createRows(rowCount, sheet, cellStyle);
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String fileName = ResManager.loadResFormat((String)"\u63a5\u6536\u4eba\u6620\u5c04\u6e05\u5355_%1", (String)"ControlWarningRecipientMappingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0b\u8f7d\u53d1\u751f\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CentralizedFileServiceImpl_57", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        catch (Exception e2) {
            log.error((Throwable)e2);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[%1]\u3002", (String)"DataModelImportDetail_01", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private void createRows(int[] selectRows, Sheet sheet, CellStyle cellStyle) {
        int startRow = 2;
        for (int selectRow : selectRows) {
            Row row = sheet.createRow(startRow++);
            this.createRow(row, selectRow, cellStyle);
        }
    }

    private void createRow(Row row, int selectRow, CellStyle cellStyle) {
        boolean status;
        DynamicObject entryData = this.getModel().getEntryRowEntity("entryentity", selectRow);
        String orgName = "";
        String orgNumber = "";
        String orgType = EPM_ENTITY_MEMBER_TREE.equals(entryData.getString(ORG_TYPE_ITEM)) ? ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7", (String)"ControlWarningRecipientMappingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"ControlWarningRecipientMappingPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        DynamicObject org = entryData.getDynamicObject(ORG);
        if (org != null) {
            orgName = org.getString("name");
            orgNumber = org.getString("number");
        }
        ArrayList<String> personNames = new ArrayList<String>(16);
        ArrayList<String> personNumbers = new ArrayList<String>(16);
        DynamicObjectCollection person = entryData.getDynamicObjectCollection(PERSON);
        if (person != null && !person.isEmpty()) {
            for (DynamicObject dynamicObject : person) {
                DynamicObject object = dynamicObject.getDynamicObject("fbasedataid");
                if (object == null) continue;
                personNames.add(object.getString("name"));
                personNumbers.add(object.getString("number"));
            }
        }
        String statusStr = (status = entryData.getBoolean(STATUS)) ? ResManager.loadKDString((String)"\u542f\u7528", (String)"ControlWarningRecipientMappingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"ControlWarningRecipientMappingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String personNamesStr = StringUtils.join(personNames, (String)",");
        String personNumberStr = StringUtils.join(personNumbers, (String)",");
        int maxTextLength = SpreadsheetVersion.EXCEL2007.getMaxTextLength();
        personNamesStr = BgControlUtils.subCellString((String)personNamesStr, (int)maxTextLength);
        personNumberStr = BgControlUtils.subCellString((String)personNumberStr, (int)maxTextLength);
        this.createRow(row, cellStyle, orgType, entryData.getString("bgorgview.name"), entryData.getString("bgorgview.number"), orgName, orgNumber, personNamesStr, personNumberStr, statusStr);
    }

    private void createRow(Row row, CellStyle style, String ... cellValues) {
        int curColIndex = 0;
        for (String value : cellValues) {
            Cell c = row.createCell(curColIndex++);
            c.setCellStyle(style);
            c.setCellValue(value);
        }
    }

    private void createRows(int rowCount, Sheet sheet, CellStyle cellStyle) {
        for (int i = 0; i < rowCount; ++i) {
            Row row = sheet.createRow(i + 2);
            this.createRow(row, i, cellStyle);
        }
    }

    private void refreshDataEntity(List<ControlWarningRecipientMappingPojo> mapObjList) {
        this.getModel().beginInit();
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            block0: for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                DynamicObject org = row.getDynamicObject(ORG);
                if (org == null) continue;
                Iterator<ControlWarningRecipientMappingPojo> ite = mapObjList.iterator();
                while (ite.hasNext()) {
                    ControlWarningRecipientMappingPojo obj = ite.next();
                    if (!obj.getOrg().equals(org.getLong("id"))) continue;
                    if (CollectionUtils.isNotEmpty((Collection)obj.getPersons())) {
                        Long[] personIds = obj.getPersons().toArray(new Long[0]);
                        dataModel.setValue(PERSON, (Object)personIds, i);
                    }
                    dataModel.setValue(STATUS, (Object)obj.getStatus(), i);
                    ite.remove();
                    continue block0;
                }
            }
        }
        for (ControlWarningRecipientMappingPojo obj : mapObjList) {
            int newRowIndex = this.getModel().createNewEntryRow("entryentity");
            dataModel.setValue(ORG_TYPE_ITEM, (Object)obj.getOrgTypeItem(), newRowIndex);
            dataModel.setValue(BG_ORG_VIEW, (Object)obj.getBgOrgView(), newRowIndex);
            dataModel.setValue(ORG, (Object)obj.getOrg(), newRowIndex);
            if (CollectionUtils.isNotEmpty((Collection)obj.getPersons())) {
                Long[] personIds = obj.getPersons().toArray(new Long[0]);
                dataModel.setValue(PERSON, (Object)personIds, newRowIndex);
            }
            dataModel.setValue(STATUS, (Object)obj.getStatus(), newRowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        if ("2".equals(this.getModel().getValue(ORG_TYPE))) {
            this.enableOrgItem(true);
        } else {
            this.enableOrgItem(false);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (e.getSource() instanceof BasedataEdit) {
            BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
            String key = basedataEdit.getKey();
            String formId = this.getModel().getValue(ORG_TYPE_ITEM).toString();
            if (ORG.equals(key) && EPM_ENTITY_MEMBER_TREE.equals(formId)) {
                Long modelId = this.getModelId();
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
                if (CommonUtils.isBgmdModel((Long)this.getModelId())) {
                    f7Param.setBusModelId(this.getPageF7Id("businessmodel"));
                }
                HashSet<Long> selectIds = new HashSet<Long>(16);
                EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = entryEntity.getSelectRows();
                if (this.getModel().getValue(BG_ORG_VIEW, selectRows[0]) != null) {
                    DynamicObject view = (DynamicObject)this.getModel().getValue(BG_ORG_VIEW);
                    if (view != null) {
                        f7Param.setViewId(Long.valueOf(view.getLong("id")));
                    }
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c6\u56fe", (String)"ControlWarningRecipientMappingPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                DynamicObject org = (DynamicObject)this.getModel().getValue(ORG, selectRows[0]);
                if (org != null) {
                    selectIds.add(org.getLong("id"));
                }
                f7Param.setVerifyPermission(true);
                f7Param.setPermType(DimMembPermType.READ);
                f7Param.setSelectIds(selectIds);
                NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
            } else if (BG_ORG_VIEW.equals(key)) {
                if (CommonUtils.isBgmdModel((Long)this.getModelId())) {
                    Long businessmodel;
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                    Map viewGroupViewsByBusModel = modelCacheHelper.getViewGroupViewsByBusModel(businessmodel = this.getPageF7Id("businessmodel"));
                    if (viewGroupViewsByBusModel.containsKey("Entity") && !((List)viewGroupViewsByBusModel.get("Entity")).isEmpty()) {
                        e.getCustomQFilters().add(new QFilter("id", "in", viewGroupViewsByBusModel.get("Entity")));
                    }
                } else {
                    e.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("dimension.number", "=", (Object)"Entity")).and("usage", "=", (Object)"0"));
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "import": {
                this.openImportPage();
                break;
            }
            case "export": {
                this.exportExcel();
                break;
            }
            case "viewbailorg": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("eb_bailorg_modify");
                showParameter.setCustomParam("model", (Object)this.getModelId());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    private void openImportPage() {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "epm_import");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("businessmodel", (Object)this.getPageF7Id("businessmodel"));
        showParameter.setCustomParam(ORG_TYPE, this.getModel().getValue(ORG_TYPE));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.control.budgetwarnning.ControlWarningRecipientMappingImportPlugin");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
        showParameter.setCaption(ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u6620\u5c04\u5bfc\u5165", (String)"ControlWarningRecipientMappingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private Long getBgOrgViewCache() {
        Long bgOrgView = 0L;
        String cache = this.getPageCache().get(CACHE_BG_ORG_VIEW);
        if (StringUtils.isNotEmpty((String)cache)) {
            bgOrgView = IDUtils.toLong((Object)cache);
        }
        return bgOrgView;
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = this.getSelModel();
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    protected DynamicObject getSelModel() {
        return (DynamicObject)this.getModel().getValue("model");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            String tips;
            if (!this.validate()) {
                args.setCancel(true);
            }
            if (StringUtils.isNotEmpty((String)(tips = NumberCheckUtils.checkNumberRule((String)this.getModel().getValue("number").toString())))) {
                throw new KDBizException(tips);
            }
        }
    }

    private boolean validate() {
        boolean result = true;
        IDataModel model = this.getModel();
        Object value = model.getValue("number");
        Object name = model.getValue("name");
        if (Objects.nonNull(value)) {
            if (value.toString().matches("[\u4e00-\u9fa5]+")) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u8f93\u5165\u4e2d\u6587", (String)"ControlWarningRecipientMappingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((String)value.toString().trim()) || StringUtils.isEmpty((String)name.toString())) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4ec5\u8f93\u5165\u7a7a\u683c", (String)"ControlWarningRecipientMappingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if (result) {
            DynamicObject org = null;
            String orgNumber = null;
            DynamicObjectCollection person = null;
            DynamicObjectCollection entrys = model.getEntryEntity("entryentity");
            HashMap<String, Integer> orgNumberMap = new HashMap<String, Integer>(entrys.size());
            boolean rowAllSel = false;
            if (entrys.size() > 0) {
                int in = entrys.size();
                for (int i = 0; i < in; ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (EPM_ENTITY_MEMBER_TREE.equals(entry.getString(ORG_TYPE_ITEM)) && entry.get(BG_ORG_VIEW) == null) {
                        result = false;
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u7b2c%1\u884c\u7684\u7ec4\u7ec7\u89c6\u56fe", (String)"ControlWarningRecipientMappingPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                        break;
                    }
                    org = entry.getDynamicObject(ORG);
                    person = entry.getDynamicObjectCollection(PERSON);
                    boolean bl = rowAllSel = org != null && person != null && !person.isEmpty();
                    if (!rowAllSel) {
                        result = false;
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u540c\u65f6\u9009\u62e9\u7b2c%1\u884c\u7684\u7ec4\u7ec7\u548c\u4eba\u5458", (String)"ControlWarningRecipientMappingPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                        break;
                    }
                    if (org == null) continue;
                    orgNumber = org.getString("number");
                    if (orgNumberMap.containsKey(orgNumber)) {
                        int rowIndex = (Integer)orgNumberMap.get(orgNumber);
                        result = false;
                        String msg = ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u7684\u7ec4\u7ec7\u91cd\u590d", (String)"ControlWarningRecipientMappingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, rowIndex + 1});
                        this.getView().showTipNotification(msg);
                        break;
                    }
                    orgNumberMap.put(orgNumber, i);
                }
            }
        }
        return result;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int row = e.getRowDataEntities()[0].getRowIndex();
        if (row == 0) {
            this.getModel().setValue(BG_ORG_VIEW, (Object)this.getBgOrgViewCache(), row);
            if ("0".equals(this.getModel().getValue(ORG_TYPE)) || "2".equals(this.getModel().getValue(ORG_TYPE))) {
                this.getModel().setValue(ORG_TYPE_ITEM, (Object)EPM_ENTITY_MEMBER_TREE, row);
            } else {
                this.getModel().setValue(ORG_TYPE_ITEM, (Object)BOS_ADMIN_ORG, row);
            }
        } else {
            if (this.getModel().getEntryRowEntity("entryentity", row - 1).get(ORG_TYPE_ITEM) != null) {
                this.getModel().setValue(ORG_TYPE_ITEM, (Object)this.getModel().getEntryRowEntity("entryentity", row - 1).getString(ORG_TYPE_ITEM), row);
            }
            if (this.getModel().getEntryRowEntity("entryentity", row - 1).get(BG_ORG_VIEW) != null) {
                this.getModel().setValue(BG_ORG_VIEW, (Object)this.getModel().getEntryRowEntity("entryentity", row - 1).getDynamicObject(BG_ORG_VIEW), row);
            }
        }
        this.getView().setEnable(Boolean.valueOf("2".equals(this.getModel().getValue(ORG_TYPE))), row, new String[]{ORG_TYPE_ITEM});
    }

    public boolean triggerPropChange() {
        return true;
    }

    protected static Workbook getExportTemp() {
        XSSFWorkbook workbook = new XSSFWorkbook();
        workbook.createSheet("Sheet1");
        XSSFSheet sheet = workbook.getSheetAt(0);
        CellStyle cellStyle = POIUtils.get().getTextCellStyle((Workbook)workbook);
        Row rowHead = sheet.createRow(0);
        Cell cell = rowHead.createCell(0);
        CellRangeAddress region = new CellRangeAddress(0, 0, 0, titles.length - 1);
        sheet.addMergedRegion(region);
        cell.setCellValue(ResManager.loadKDString((String)"\u63a5\u6536\u4eba\u6620\u5c04", (String)"ControlWarningRecipientMappingPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        XSSFCellStyle title1 = workbook.createCellStyle();
        title1.setAlignment(HorizontalAlignment.CENTER);
        title1.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)20);
        title1.setFont((Font)font);
        cell.setCellStyle((CellStyle)title1);
        Row row = sheet.createRow(1);
        for (int i = 0; i < titles.length; ++i) {
            sheet.setColumnWidth(i, 5000);
            String title = titles[i];
            Cell titleCell = row.createCell(i, CellType.STRING);
            titleCell.setCellStyle(cellStyle);
            if (ControlWarningRecipientMappingPlugin.orgType().equals(title)) {
                FileImportUtils fileImportUtils = FileImportUtils.getInstance();
                fileImportUtils.setCellTips(titleCell, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7c7b\u578b\u5fc5\u586b", (String)"ControlWarningRecipientMappingPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                DataValidationHelper validationHelper = sheet.getDataValidationHelper();
                DataValidationConstraint contraint = validationHelper.createExplicitListConstraint(new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7", (String)"ControlWarningRecipientMappingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"ControlWarningRecipientMappingPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])});
                CellRangeAddressList addressList = new CellRangeAddressList(2, 100000, 0, 0);
                DataValidation validation = validationHelper.createValidation(contraint, addressList);
                sheet.addValidationData(validation);
            } else if (ControlWarningRecipientMappingPlugin.orgViewName().equals(title)) {
                FileImportUtils.getInstance().setCellTips(titleCell, ResManager.loadKDString((String)"\u5982\u679c\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u9884\u7b97\u7ec4\u7ec7\u65f6\uff0c\u7ec4\u7ec7\u89c6\u56fe\u540d\u79f0\u5fc5\u586b", (String)"ControlWarningRecipientMappingPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ControlWarningRecipientMappingPlugin.orgViewNumber().equals(title)) {
                FileImportUtils.getInstance().setCellTips(titleCell, ResManager.loadKDString((String)"\u5982\u679c\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u9884\u7b97\u7ec4\u7ec7\u65f6\uff0c\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801\u5fc5\u586b", (String)"ControlWarningRecipientMappingPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ControlWarningRecipientMappingPlugin.orgName().equals(title)) {
                FileImportUtils.getInstance().setCellTips(titleCell, ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u5355\u9009", (String)"ControlWarningRecipientMappingPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ControlWarningRecipientMappingPlugin.orgNumber().equals(title)) {
                FileImportUtils.getInstance().setCellTips(titleCell, ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u7ec4\u7ec7\u7f16\u7801\u5355\u9009", (String)"ControlWarningRecipientMappingPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ControlWarningRecipientMappingPlugin.personName().equals(title)) {
                FileImportUtils.getInstance().setCellTips(titleCell, ResManager.loadKDString((String)"\u4eba\u5458\u540d\u79f0\u591a\u9009\uff0c\u4ee5\u82f1\u6587\u9017\u53f7,\u5206\u9694", (String)"ControlWarningRecipientMappingPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ControlWarningRecipientMappingPlugin.personNumber().equals(title)) {
                FileImportUtils.getInstance().setCellTips(titleCell, ResManager.loadKDString((String)"\u5fc5\u586b\u9879\uff0c\u4eba\u5458\u5de5\u53f7\u591a\u9009\uff0c\u4ee5\u82f1\u6587\u9017\u53f7,\u5206\u9694", (String)"ControlWarningRecipientMappingPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (ControlWarningRecipientMappingPlugin.status().equals(title)) {
                DataValidationHelper validationHelper = sheet.getDataValidationHelper();
                DataValidationConstraint contraint = validationHelper.createExplicitListConstraint(new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"ControlWarningRecipientMappingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7981\u7528", (String)"ControlWarningRecipientMappingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0])});
                CellRangeAddressList addressList = new CellRangeAddressList(2, 100000, 7, 7);
                DataValidation validation = validationHelper.createValidation(contraint, addressList);
                sheet.addValidationData(validation);
            }
            titleCell.setCellValue(title);
        }
        return workbook;
    }
}

