/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgPeriodUserDefinedUtils;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.calc.eums.CalculatorTypeEnum;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;
import kd.epm.eb.control.warning.ControlWarningHelper;
import kd.epm.eb.spread.utils.ReportHelper;

public class ControlWarningReportPlugin
extends AbstractFormPlugin {
    private static final ExecuteAnalyseUtil executeAnalyseUtil = ExecuteAnalyseUtil.getInstance();
    private static final Log log = LogFactory.getLog(ControlWarningReportPlugin.class);
    private static final String[] valueTypes = new String[]{CalculatorTypeEnum.RATE.getNumber().toLowerCase(), CalculatorTypeEnum.BALANCE.getNumber().toLowerCase(), CalculatorTypeEnum.ACTUAL.getNumber().toLowerCase(), CalculatorTypeEnum.BUDGET.getNumber().toLowerCase()};
    private List<Map<String, Object>> warnDatas = null;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject warn = this.getWarningReport();
        if (warn == null) {
            log.info("fillWarnDatas-empty-warn");
            return;
        }
        String unit = warn.getString("unit");
        if (StringUtils.isEmpty((String)unit)) {
            unit = "0";
        }
        this.setUnit(unit);
        ReportHelper.refreshBtnUnitStyle((int)this.getUnit(), (IFormView)this.getView(), (String)"btn_unit");
        List warnDatas = ControlWarningHelper.queryWarnDatas(this.getWarningId(), (boolean)true, (boolean)false);
        this.setWarnDatas(warnDatas);
        this.fillWarnDatas(warnDatas, warn);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void fillWarnDatas(List<Map<String, Object>> warnDatas, DynamicObject warn) {
        if (warnDatas == null || warnDatas.isEmpty()) {
            return;
        }
        if (warn == null) {
            warn = this.getWarningReport();
        }
        if (warn == null) {
            log.info("fillWarnDatas-empty-warn");
            return;
        }
        CalendarHelper helper = new CalendarHelper();
        helper.setTime(warn.getDate("createdate"));
        long modelId = warn.getLong("model");
        IModelCacheHelper cache = ModelCacheContext.getOrCreate((Long)modelId);
        BgPeriodUserDefinedUtils utils = new BgPeriodUserDefinedUtils(Long.valueOf(modelId));
        String periodName = ResManager.loadResFormat((String)"%1\u5e74%2\u6708", (String)"ControlWarningReportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{helper.getCurrentlyYear(), helper.getCurrentlyMonth()});
        String yearName = ResManager.loadResFormat((String)"%1\u5e74", (String)"ControlWarningReportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{helper.getCurrentlyYear()});
        Member member = null;
        if (!cache.getModelobj().isModelByEB()) {
            String pnumber = null;
            String yearnumber = null;
            if (utils.isPeriodUserDefine()) {
                pnumber = utils.getPeriodNumber(BgControlPeriodTypeEnum.MONTH.getIndex(), warn.getDate("createdate"));
                yearnumber = utils.getPeriodNumber(BgControlPeriodTypeEnum.YEAR.getIndex(), warn.getDate("createdate"));
            } else {
                pnumber = BgPeriodUtils.getBgPeriodMonth((int)helper.getCurrentlyYear(), (int)helper.getCurrentlyMonth());
                yearnumber = BgPeriodUtils.getPeriodYear((int)helper.getCurrentlyYear());
            }
            if (pnumber != null && (member = cache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, pnumber)) != null) {
                periodName = member.getName();
            }
            if (yearnumber != null && (member = cache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, yearnumber)) != null) {
                yearName = member.getName();
            }
        }
        LinkedHashMap<String, Integer> userdefineds = new LinkedHashMap<String, Integer>(7);
        List dimnames = null;
        String[] itemNumbers = null;
        Object itemNames = null;
        String ISHIDEN = "isHiden";
        int hideRow = 0;
        boolean isnullrow = true;
        boolean isShowEmpty = this.isShowEmpty();
        HashSet hasNames = new HashSet(10);
        for (Map<String, Object> rowData : warnDatas) {
            dimnames = (List)rowData.get("dimname");
            itemNumbers = (String[])rowData.get("itemnumber");
            for (int i = 2; i < dimnames.size(); ++i) {
                if (!StringUtils.isNotEmpty((String)itemNumbers[i])) continue;
                hasNames.add(dimnames.get(i));
            }
        }
        for (Map<String, Object> rowData : warnDatas) {
            dimnames = (List)rowData.get("dimname");
            itemNumbers = (String[])rowData.get("itemnumber");
            for (int i = 2; i < dimnames.size(); ++i) {
                if (!hasNames.contains(dimnames.get(i)) || userdefineds.containsKey(dimnames.get(i))) continue;
                userdefineds.put((String)dimnames.get(i), userdefineds.size() + 1);
            }
            isnullrow = true;
            for (String valuetype : valueTypes) {
                if (rowData.get(valuetype) == null && rowData.get(valuetype + "total") == null) continue;
                isnullrow = false;
                break;
            }
            if (isnullrow) {
                rowData.put("isHiden", Boolean.TRUE);
            }
            if (isShowEmpty || !isnullrow) continue;
            ++hideRow;
        }
        this.setUserDefineds(userdefineds);
        BigDecimal unitValue = this.getUnitValue();
        int precision = warn.getInt("precision");
        if (precision < 0) {
            precision = 2;
        }
        Format format = BgControlUtils.setDecimalFormatPrecision((Format)BgControlUtils.getDecimalFormatByInternetSet(), (int)precision);
        Format formatRate = BgControlUtils.setDecimalFormatPrecision((Format)new DecimalFormat("#,##0.00%"), (int)precision);
        MemberShowType showtype = this.getShowType();
        this.getModel().beginInit();
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        ArrayList userDefinedList = new ArrayList(userdefineds.keySet());
        List fields = grid.getControls();
        grid.setColumnProperty("currentperiod", "header", (Object)periodName);
        grid.setColumnProperty("year", "header", (Object)yearName);
        for (Control field : fields) {
            if (StringUtils.isEmpty((String)field.getKey()) || !field.getKey().startsWith("userdefineds")) continue;
            int userindex = Integer.parseInt(field.getKey().substring("userdefineds".length()));
            if (userDefinedList.size() < userindex) {
                grid.setColumnProperty(field.getKey(), "vi", (Object)false);
                continue;
            }
            grid.setColumnProperty(field.getKey(), "header", userDefinedList.get(userindex - 1));
        }
        this.getModel().deleteEntryData("entryentity");
        grid.setPageIndex(0);
        if (warnDatas.size() != hideRow) {
            this.getModel().batchCreateNewEntryRow("entryentity", warnDatas.size() - hideRow);
            DynamicObject entry = null;
            int rowindex = 0;
            for (int i = 0; i < warnDatas.size(); ++i) {
                Map<String, Object> rowData = warnDatas.get(i);
                if (!isShowEmpty && Boolean.TRUE.equals(rowData.get("isHiden"))) continue;
                entry = this.getModel().getEntryRowEntity("entryentity", rowindex++);
                entry.set("rowindex", (Object)i);
                this.fillMember(entry, rowData, userdefineds, showtype);
                this.fillValue(entry, rowData, unitValue, format, formatRate);
            }
        }
        this.getModel().beginInit();
    }

    private DynamicObject getWarningReport() {
        QFilter filter = new QFilter("id", "in", this.getWarningId());
        DynamicObject warn = QueryServiceHelper.queryOne((String)"bgc_warningreport", (String)"createdate,model,unit,precision", (QFilter[])filter.toArray());
        return warn;
    }

    private BigDecimal getUnitValue() {
        int unitvalue = this.getUnit();
        return this.getUnitValue(unitvalue);
    }

    private BigDecimal getUnitValue(int unitvalue) {
        DataUnitEnum unit = DataUnitEnum.YUAN;
        for (DataUnitEnum du : DataUnitEnum.values()) {
            if (du.getIndex() != unitvalue) continue;
            unit = du;
        }
        BigDecimal unitValue = new BigDecimal(unit.getValue());
        return unitValue;
    }

    private void setUserDefineds(Map<String, Integer> userdefineds) {
        this.getPageCache().put("userdefineds", JSONUtils.toString(userdefineds));
    }

    private Map<String, Integer> getUserDefineds() {
        String jsonStr = this.getPageCache().get("userdefineds");
        if (StringUtils.isEmpty((String)jsonStr)) {
            return new HashMap<String, Integer>(1);
        }
        MapType javaType = JSONUtils.getMapper().getTypeFactory().constructMapType(LinkedHashMap.class, String.class, Integer.class);
        return (Map)JSONUtils.parse((String)jsonStr, (JavaType)javaType);
    }

    private void fillValue(DynamicObject entry, Map<String, Object> warnData, BigDecimal unitValue, Format format, Format formatRate) {
        for (String valuetype : valueTypes) {
            String valuetypetotal = valuetype + "total";
            BigDecimal value = (BigDecimal)warnData.get(valuetype);
            BigDecimal valuetotal = (BigDecimal)warnData.get(valuetypetotal);
            if (CalculatorTypeEnum.RATE.getNumber().equalsIgnoreCase(valuetype) || CalculatorTypeEnum.RATE_OLD.getNumber().equalsIgnoreCase(valuetype)) {
                entry.set(valuetype, (Object)this.getFormatValue(formatRate, value));
                entry.set(valuetypetotal, (Object)this.getFormatValue(formatRate, valuetotal));
                continue;
            }
            if (Boolean.TRUE.equals(warnData.get("need_unit"))) {
                if (value != null) {
                    value = value.divide(unitValue, 4);
                }
                if (valuetotal != null) {
                    valuetotal = valuetotal.divide(unitValue, 4);
                }
            }
            entry.set(valuetype, (Object)this.getFormatValue(format, value));
            entry.set(valuetypetotal, (Object)this.getFormatValue(format, valuetotal));
        }
    }

    private String getFormatValue(Format format, BigDecimal value) {
        if (value == null) {
            return "";
        }
        return format.format(value);
    }

    private void fillMember(DynamicObject entry, Map<String, Object> rowData, Map<String, Integer> userdefineds, MemberShowType showtype) {
        List dimnames = (List)rowData.get("dimname");
        String[] itemNumbers = (String[])rowData.get("itemnumber");
        String[] itemNames = (String[])rowData.get("itemname");
        for (int c = 0; c < itemNames.length; ++c) {
            String field = null;
            if (StringUtils.isEmpty((String)itemNames[c])) continue;
            field = c == 0 ? "entity" : (c == 1 ? "account" : "userdefineds" + userdefineds.get(dimnames.get(c)));
            entry.set(field, (Object)this.getMemberShowValue(itemNumbers[c], itemNames[c], showtype));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    protected Set<Long> getWarningId() {
        HashSet ids = Sets.newHashSet();
        String idStr = (String)this.getView().getFormShowParameter().getCustomParam("warningid");
        if (StringUtils.isNotEmpty((String)idStr)) {
            String[] idArray;
            for (String id : idArray = idStr.split(",")) {
                ids.add(IDUtils.toLong((Object)id));
            }
        }
        return ids;
    }

    private List<Map<String, Object>> getWarnDatas() {
        String warnDatasStr;
        if (this.warnDatas == null && StringUtils.isNotEmpty((String)(warnDatasStr = this.getPageCache().get("warnDatas")))) {
            this.warnDatas = (List)SerializationUtils.deSerializeFromBase64((String)warnDatasStr);
        }
        return this.warnDatas;
    }

    private void setWarnDatas(List<Map<String, Object>> datas) {
        this.warnDatas = datas;
        this.getPageCache().put("warnDatas", datas == null ? null : SerializationUtils.serializeToBase64(datas));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_shownumber0": 
            case "btn_shownumber1": 
            case "btn_shownumber2": {
                String showTypeNumber = itemKey.replace("btn_shownumber", "");
                Boolean success = this.updateCurEntryEntityMembers(MemberShowType.getEnumByValue((String)showTypeNumber));
                if (!success.booleanValue()) break;
                this.setShowType(showTypeNumber);
                String show = executeAnalyseUtil.getMemberShowTypeShow(showTypeNumber);
                if (show != null) {
                    this.updateBtnShow("btn_shownumber", show);
                }
                this.updateGridColumns();
                break;
            }
            case "btn_showemptyrow": {
                if (this.isShowEmpty()) break;
                this.setShowEmpty(true);
                this.showEmptyRowStatusChange();
                this.updateBtnShow("btn_changeshowepmty", executeAnalyseUtil.getEmptyTypeShow(true));
                break;
            }
            case "btn_notshowemptyrow": {
                if (!this.isShowEmpty()) break;
                this.setShowEmpty(false);
                this.showEmptyRowStatusChange();
                this.updateBtnShow("btn_changeshowepmty", executeAnalyseUtil.getEmptyTypeShow(false));
                break;
            }
            case "btn_unit0": 
            case "btn_unit2": 
            case "btn_unit3": 
            case "btn_unit4": 
            case "btn_unit6": 
            case "btn_unit8": {
                String unit = itemKey.replace("btn_unit", "");
                this.updateCurEntryEntityData(unit);
                this.setUnit(unit);
                break;
            }
            case "refresh": {
                this.fillWarnDatas(this.getWarnDatas(), null);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private Boolean updateCurEntryEntityMembers(MemberShowType showType) {
        if (showType == null) {
            return false;
        }
        MemberShowType curShowType = this.getShowType();
        if (showType == curShowType) {
            return false;
        }
        this.updateRow(true, false, showType, this.getUnitValue());
        return true;
    }

    private void updateRow(boolean isUpdateMember, boolean isUpdateValue, MemberShowType showtype, BigDecimal unitValue) {
        int rowindex;
        List<Map<String, Object>> warnDatas = this.getWarnDatas();
        if (warnDatas == null || warnDatas.isEmpty()) {
            return;
        }
        this.getModel().beginInit();
        int rowcount = this.getModel().getEntryRowCount("entryentity");
        DynamicObject entry = null;
        Map<String, Integer> userdefineds = this.getUserDefineds();
        if (showtype == null) {
            showtype = MemberShowType.NAME;
        }
        if (unitValue == null) {
            unitValue = BigDecimal.ONE;
        }
        DynamicObject warn = this.getWarningReport();
        int precision = 2;
        if (warn != null) {
            precision = warn.getInt("precision");
        }
        Format format = BgControlUtils.setDecimalFormatPrecision((Format)BgControlUtils.getDecimalFormatByInternetSet(), (int)precision);
        Format formatRate = BgControlUtils.setDecimalFormatPrecision((Format)new DecimalFormat("#,##0.00%"), (int)precision);
        Map<String, Object> rowData = null;
        for (int r = 0; r < rowcount && (rowindex = (entry = this.getModel().getEntryRowEntity("entryentity", r)).getInt("rowindex")) < warnDatas.size(); ++r) {
            rowData = warnDatas.get(rowindex);
            if (isUpdateMember) {
                this.fillMember(entry, rowData, userdefineds, showtype);
            }
            if (!isUpdateValue) continue;
            this.fillValue(entry, rowData, unitValue, format, formatRate);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void setShowType(String type) {
        this.getPageCache().put("showType", type);
    }

    private MemberShowType getShowType() {
        String showtype = this.getPageCache().get("showType");
        if (StringUtils.isNotEmpty((String)showtype)) {
            return MemberShowType.getEnumByValue((String)showtype);
        }
        return MemberShowType.NAME;
    }

    public String getMemberShowValue(String number, String name, MemberShowType showType) {
        String value = null;
        switch (showType) {
            case NAME: {
                value = name;
                break;
            }
            case NUMBER: {
                value = number;
                break;
            }
            case NAME_NUMBER: {
                value = number + "#" + name;
                break;
            }
        }
        return value;
    }

    private void setShowEmpty(boolean showEmpty) {
        this.getPageCache().put("showEmpty", String.valueOf(showEmpty));
    }

    private boolean isShowEmpty() {
        String showEmptyJson = this.getPageCache().get("showEmpty");
        if (showEmptyJson == null) {
            return false;
        }
        return Convert.toBool((Object)showEmptyJson);
    }

    private void setUnit(String unit) {
        this.getPageCache().put("unit", unit);
    }

    private int getUnit() {
        String unit = this.getPageCache().get("unit");
        if (unit == null) {
            return 0;
        }
        return Integer.parseInt(unit);
    }

    private void updateBtnShow(String btnKey, String emptyTypeShow) {
        HashMap<String, String> language = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
        language.put(LanguageUtils.getLang((Lang)Lang.zh_CN).toString(), emptyTypeShow);
        param.put("text", language);
        this.getView().updateControlMetadata(btnKey, param);
    }

    private void updateGridColumns() {
    }

    private void showEmptyRowStatusChange() {
        this.fillWarnDatas(this.getWarnDatas(), null);
        this.getView().updateView("entryentity");
    }

    private void updateCurEntryEntityData(String unit) {
        int curUnit;
        if (unit == null) {
            return;
        }
        int toUnit = Integer.parseInt(unit);
        if (toUnit == (curUnit = this.getUnit())) {
            return;
        }
        this.updateRow(false, true, this.getShowType(), this.getUnitValue(toUnit));
        ReportHelper.refreshBtnUnitStyle((int)toUnit, (IFormView)this.getView(), (String)"btn_unit");
    }
}

