/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.control.calc.eums.CalculatorTypeEnum;
import kd.epm.eb.control.warning.ControlWarningConstant;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.validator.routines.BigDecimalValidator;

public class ControlWarningRulePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String WARNING_SEND_TYPE = "warningsendtype";
    private static final String CONDITION = "condition";
    private static final String FILTER_GRIDAP = "filtergridap";
    private static final List<String> compareType = Arrays.asList("67", "83", "21", "36", "19", "65", "37", "9");
    private static final int CONDITION_MAX_LENGTH = 2000;
    private static final String OPER_SAVE = "save";
    private static final String CACHE_CHRONOLOGICAL_PROGRESS = "cache_chronologicalProgress";

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        filterGrid.setEntityNumber("bgc_warningrulecondition");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        List filterColumns = filterGrid.getFilterColumns();
        for (Map map : filterColumns) {
            String fieldName = (String)map.get("fieldName");
            if ("rate.time_plan".equals(fieldName)) {
                LocaleString name = new LocaleString(CalculatorTypeEnum.RATE.getAlias());
                map.put("fieldCaption", name.getLocaleValue());
            }
            ArrayList arrayList = (ArrayList)map.get("compareTypes");
            arrayList.removeIf(k -> {
                boolean result = false;
                if (k instanceof CompareTypeDto) {
                    result = !compareType.contains(((CompareTypeDto)k).getId());
                } else if (k instanceof LinkedHashMap) {
                    result = !compareType.contains(((LinkedHashMap)k).get("id"));
                }
                return result;
            });
        }
        String filterObj = this.getModel().getValue(CONDITION) == null ? "" : this.getModel().getValue(CONDITION).toString();
        FilterCondition filterCondition = null;
        if (StringUtils.isNotEmpty((String)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj, FilterCondition.class);
        } else if (filterGrid.getFilterGridState() != null && filterGrid.getFilterGridState().getFilterCondition() != null && CollectionUtils.isNotEmpty((Collection)filterGrid.getFilterGridState().getFilterCondition().getFilterRow())) {
            filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            filterCondition.getFilterRow().clear();
        }
        filterGrid.SetValue(filterCondition);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (OPER_SAVE.equals(operate.getOperateKey())) {
            String tips;
            if (!this.validate()) {
                args.setCancel(true);
            }
            if (StringUtils.isNotEmpty((String)(tips = NumberCheckUtils.checkNumberRule((String)this.getModel().getValue("number").toString())))) {
                throw new KDBizException(tips);
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            String condition = null;
            if (filterCondition != null) {
                FilterBuilder filterBuilder = ConditionUtils.get().getFilterBuilder("bgc_warningrulecondition", filterCondition);
                if (filterBuilder == null || CollectionUtils.isEmpty((Collection)filterBuilder.getQFilters())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8b66\u89c4\u5219\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"ControlWarningRulePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List<String> errorRateMessages = this.checkFilterCondition(filterCondition);
                if (CollectionUtils.isNotEmpty(errorRateMessages)) {
                    throw new KDBizException(StringUtils.join(errorRateMessages, (String)"\r\n"));
                }
                condition = SerializationUtils.toJsonString((Object)filterCondition);
                if (condition.length() > 2000) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8b66\u89c4\u5219\u6761\u4ef6\u8d85\u51fa\u9650\u5236\u957f\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"ControlWarningRulePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            this.getModel().setValue(CONDITION, condition);
        }
    }

    private List<String> checkFilterCondition(FilterCondition filterCondition) {
        ArrayList<String> errorRateMessages = new ArrayList<String>(16);
        if (filterCondition == null || CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
            return errorRateMessages;
        }
        for (int i = 0; i < filterCondition.getFilterRow().size(); ++i) {
            String timePlanValue;
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterCondition.getFilterRow().get(i);
            if (simpleFilterRow == null) continue;
            List values = simpleFilterRow.getValue();
            String filterName = this.getConditionFilterName(simpleFilterRow);
            List baseDataIds = simpleFilterRow.getBaseDataIds();
            boolean isChronologicalProgress = false;
            if (CollectionUtils.isNotEmpty((Collection)baseDataIds)) {
                for (FilterValue baseDataId : baseDataIds) {
                    if (!String.valueOf(baseDataId.getValue()).equals(String.valueOf(ControlWarningConstant.TIME_PLAN_ID))) continue;
                    isChronologicalProgress = true;
                    break;
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)values)) continue;
            if (values.size() > 1) {
                errorRateMessages.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c%2\u5f55\u5165\u7684\u503c\u4e0d\u5141\u8bb8\u5305\u542b\u82f1\u6587\u9017\u53f7", (String)"ControlWarningRulePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, filterName}));
                continue;
            }
            if (((FilterValue)values.get(0)).getValue() == null || !StringUtils.isNotEmpty((String)(timePlanValue = ((FilterValue)values.get(0)).getValue().toString())) || isChronologicalProgress || BigDecimalValidator.getInstance().isValid(timePlanValue)) continue;
            errorRateMessages.add(ResManager.loadResFormat((String)"\u7b2c%1\u884c%2\u7684\u503c\u53ea\u5141\u8bb8\u5f55\u5165\u6570\u503c", (String)"ControlWarningRulePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, filterName}));
        }
        return errorRateMessages;
    }

    private String getConditionFilterName(SimpleFilterRow simpleFilterRow) {
        String fieldName;
        if (simpleFilterRow == null) {
            return "";
        }
        switch (fieldName = simpleFilterRow.getFieldName()) {
            case "balance": {
                fieldName = CalculatorTypeEnum.BALANCE.getAlias();
                break;
            }
            case "actual": {
                fieldName = CalculatorTypeEnum.ACTUAL.getAlias();
                break;
            }
            case "occupation": {
                fieldName = CalculatorTypeEnum.OCCUPATION.getAlias();
                break;
            }
            case "execute": {
                fieldName = CalculatorTypeEnum.EXECUTE.getAlias();
                break;
            }
            case "rate.time_plan": {
                fieldName = CalculatorTypeEnum.RATE.getAlias();
                break;
            }
        }
        return fieldName;
    }

    private boolean validate() {
        boolean result = true;
        IDataModel model = this.getModel();
        Object value = model.getValue("number");
        Object name = model.getValue("name");
        if (Objects.nonNull(value)) {
            if (value.toString().matches("[\u4e00-\u9fa5]+")) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u8f93\u5165\u4e2d\u6587", (String)"ControlWarningRulePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((String)value.toString().trim()) || StringUtils.isEmpty((String)name.toString())) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4ec5\u8f93\u5165\u7a7a\u683c", (String)"ControlWarningRulePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }

    public boolean triggerPropChange() {
        return true;
    }
}

