/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.mcontrol.mobtable.MobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTableRowBuilder;
import kd.bos.form.mcontrol.mobtable.MobTableRowData;
import kd.bos.form.mcontrol.mobtable.events.BeforeCreateMobTableColumnsEvent;
import kd.bos.form.mcontrol.mobtable.events.IBeforeCreateMobTableColumnsListener;
import kd.bos.form.mcontrol.mobtable.events.MobTableHandleResult;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerArgs;
import kd.bos.form.mcontrol.mobtable.tablecolumn.MobTableColumn;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.calc.eums.CalculatorTypeEnum;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.warning.ControlWarningHelper;

public class MobControlWarningReportPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener,
IBeforeCreateMobTableColumnsListener {
    private static final Log log = LogFactory.getLog(MobControlWarningReportPlugin.class);
    private List<Map<String, Object>> warnDatas = null;

    public void initialize() {
        super.initialize();
        MobTable mobtable = (MobTable)this.getControl("mobtableap");
        if (mobtable != null) {
            mobtable.addMobTablePackageDataHandlerListener(event -> event.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new MobTableDataHandler(this.getWarnDatas())));
        }
        this.getModel().addDataModelChangeListener((IDataModelChangeListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.intUnitCombox();
        DynamicObject warn = this.getWarningReport();
        if (warn == null) {
            return;
        }
        int unitindex = Convert.toInt((Object)warn.get("unit"), (Integer)0);
        DataUnitEnum unit = DataUnitEnum.getEnumByIndex((int)unitindex);
        if (unit == null) {
            unit = DataUnitEnum.YUAN;
        }
        this.getView().getModel().setValue("comboxunit", (Object)unit.getNumber());
        this.getPageCache().put("precision", String.valueOf(warn.getInt("precision")));
        this.setWarnDatas(ControlWarningHelper.queryWarnDatas(this.getWarningId(), (boolean)false, (boolean)true));
    }

    private DynamicObject getWarningReport() {
        QFilter filter = new QFilter("id", "in", this.getWarningId());
        DynamicObject warn = QueryServiceHelper.queryOne((String)"bgc_warningreport", (String)"createdate,model,unit,precision", (QFilter[])filter.toArray());
        return warn;
    }

    private void intUnitCombox() {
        ComboEdit cbxunit = (ComboEdit)this.getControl("comboxunit");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        comboItems.add(new ComboItem(new LocaleString(DataUnitEnum.YUAN.getName()), DataUnitEnum.YUAN.getNumber()));
        comboItems.add(new ComboItem(new LocaleString(DataUnitEnum.THOUSAND.getName()), DataUnitEnum.THOUSAND.getNumber()));
        comboItems.add(new ComboItem(new LocaleString(DataUnitEnum.TENTHOUSAND.getName()), DataUnitEnum.TENTHOUSAND.getNumber()));
        comboItems.add(new ComboItem(new LocaleString(DataUnitEnum.MILLIONS.getName()), DataUnitEnum.MILLIONS.getNumber()));
        comboItems.add(new ComboItem(new LocaleString(DataUnitEnum.BILLIONS.getName()), DataUnitEnum.BILLIONS.getNumber()));
        cbxunit.setComboItems(comboItems);
        this.getView().getModel().setValue("comboxunit", (Object)DataUnitEnum.YUAN.getNumber());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getView().updateView();
    }

    protected Set<Long> getWarningId() {
        HashSet ids = Sets.newHashSet();
        String idStr = (String)this.getView().getFormShowParameter().getCustomParam("warningid");
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)idStr)) {
            String[] idArray;
            for (String id : idArray = idStr.split(",")) {
                ids.add(IDUtils.toLong((Object)id));
            }
        }
        return ids;
    }

    private List<Map<String, Object>> getWarnDatas() {
        String warnDatasStr;
        if (this.warnDatas == null && StringUtils.isNotEmpty((CharSequence)(warnDatasStr = this.getPageCache().get("warnDatas")))) {
            this.warnDatas = (List)SerializationUtils.deSerializeFromBase64((String)warnDatasStr);
        }
        return this.warnDatas;
    }

    private void setWarnDatas(List<Map<String, Object>> datas) {
        this.warnDatas = datas;
        this.getPageCache().put("warnDatas", datas == null ? null : SerializationUtils.serializeToBase64(datas));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void beforeCreateMobTableColumns(BeforeCreateMobTableColumnsEvent event) {
    }

    private class MobTableDataHandler
    extends MobTablePackageDataHandler {
        private List<Map<String, Object>> warnDatas;

        public MobTableDataHandler(List<Map<String, Object>> warnDatas) {
            this.warnDatas = warnDatas;
        }

        public MobTableHandleResult handleData(MobTablePackageDataHandlerArgs args) {
            MobTableHandleResult mobTableHandleResult = new MobTableHandleResult();
            mobTableHandleResult.setMobTableRowDataList(this.createMobTableRowDatas(args.getMobTableColumns(), this.warnDatas));
            return mobTableHandleResult;
        }

        public List<MobTableRowData> createMobTableRowDatas(List<MobTableColumn> mobTableColumns, List<Map<String, Object>> warnDatas) {
            if (warnDatas == null || warnDatas.isEmpty() || mobTableColumns == null || mobTableColumns.isEmpty()) {
                return Lists.newArrayList();
            }
            log.info("budget-control-warning-log : createMobTableRowDatas = " + JSONUtils.toString(warnDatas));
            String unitString = String.valueOf(MobControlWarningReportPlugin.this.getModel().getValue("comboxunit"));
            DataUnitEnum unit = DataUnitEnum.YUAN;
            for (DataUnitEnum du : DataUnitEnum.values()) {
                if (!du.getNumber().equals(unitString)) continue;
                unit = du;
            }
            BigDecimal unitValue = new BigDecimal(unit.getValue());
            ArrayList rowDatas = Lists.newArrayListWithCapacity((int)warnDatas.size());
            MobTableRowData row = null;
            int rowIndex = 0;
            int precision = 2;
            String pstr = MobControlWarningReportPlugin.this.getPageCache().get("precision");
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)pstr)) {
                precision = Integer.parseInt(pstr);
            }
            Format format = BgControlUtils.setDecimalFormatPrecision((Format)BgControlUtils.getDecimalFormatByInternetSet(), (int)precision);
            Format formatRate = BgControlUtils.setDecimalFormatPrecision((Format)new DecimalFormat("#,##0.00%"), (int)precision);
            for (Map<String, Object> warnData : warnDatas) {
                row = MobTableRowBuilder.buildTemplateRowData((int)rowIndex, mobTableColumns);
                rowDatas.add(row);
                for (MobTableColumn col : mobTableColumns) {
                    if (warnData.get(col.getFieldKey()) == null) continue;
                    if (warnData.get(col.getFieldKey()) instanceof BigDecimal) {
                        BigDecimal value = (BigDecimal)warnData.get(col.getFieldKey());
                        if (CalculatorTypeEnum.RATE.getNumber().equalsIgnoreCase(col.getFieldKey()) || CalculatorTypeEnum.RATE_OLD.getNumber().equalsIgnoreCase(col.getFieldKey())) {
                            row.setValue(col.getFieldKey(), (Object)formatRate.format(value));
                            continue;
                        }
                        if (Boolean.TRUE.equals(warnData.get("need_unit"))) {
                            value = value.divide(unitValue, 4);
                        }
                        row.setValue(col.getFieldKey(), (Object)format.format(value));
                        continue;
                    }
                    row.setValue(col.getFieldKey(), warnData.get(col.getFieldKey()));
                }
                ++rowIndex;
            }
            return rowDatas;
        }
    }
}

