/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.DimensionMember.DimensionMemberTreeHandle;
import kd.epm.eb.common.lazytree.DimensionMember.MemberTreeNode;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeContainer;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class ViewOrgAndRecipientPlugin
extends AbstractBasePlugin
implements TreeNodeClickListener,
TreeNodeQueryListener {
    public static final String TREEVIEW = "lefttree";
    public static final String TREENTRYENTITY = "treeentryentity";
    private static final String TREE_SEARCH_AP = "treesearchap";
    private static final String TREE_SEARCH_FRONT = "treesearchfront";
    private static final String TREE_SEARCH_AFTER = "treesearchafter";
    private static final String ENTITY_SEARCH_AP = "entitysearchap";
    private static final String ENTITY_SEARCH_FRONT = "entitysearchbefore";
    private static final String ENTITY_SEARCH_AFTER = "entitysearchafter";
    private static final String CACHE_LEFT_TREE_KEY = "CACHE_F7_TREE_MEMBER_NODE_DATA_lefttree";
    private static final String CACHE_ROOT_TREE_KEY = "cacheRoot";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{TREE_SEARCH_FRONT, TREE_SEARCH_AFTER, ENTITY_SEARCH_FRONT, ENTITY_SEARCH_AFTER});
        Search treeSearch = (Search)this.getView().getControl(TREE_SEARCH_AP);
        treeSearch.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TREEVIEW, CACHE_LEFT_TREE_KEY), true));
        Search entitySearch = (Search)this.getView().getControl(ENTITY_SEARCH_AP);
        entitySearch.addEnterListener(event -> this.newLayzTreeInstane().search(event));
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREENTRYENTITY);
        treeEntry.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4f53\u7cfb\u5931\u8d25", (String)"ViewOrgAndRecipientPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long viewId = modelCache.getDefaultViewIdOnDim(SysDimensionEnum.Entity.getNumber());
        if (this.getView().getFormShowParameter().getCustomParam("view") != null) {
            viewId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("view"));
        }
        Long businessModel = 0L;
        Object businessModelObj = this.getView().getFormShowParameter().getCustomParam("businessModel");
        if (businessModelObj != null && !"0".equals(businessModelObj)) {
            businessModel = IDUtils.toLong((Object)businessModelObj);
        }
        this.getModel().setValue("view", (Object)viewId);
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        MemberF7Parameter f7Param = new MemberF7Parameter();
        f7Param.setModelId(modelId);
        f7Param.setDimensionId(dimension.getId());
        f7Param.setDimensionNumber(dimension.getNumber());
        f7Param.setDimensionName(dimension.getName());
        f7Param.setBusModelId(businessModel);
        f7Param.setViewId(viewId);
        f7Param.setEntityNumber(SysDimensionEnum.Entity.getMemberTreemodel());
        f7Param.setCutTree(true);
        f7Param.setShowLeaf(true);
        String qfilterStr = (String)this.getView().getFormShowParameter().getCustomParam("qfilterStr");
        if (qfilterStr != null) {
            f7Param.setCustomFilters(qfilterStr);
        }
        f7Param.setCutParentNode(true);
        MemberTreeBuilder.get((MemberF7Parameter)f7Param).setTreeKey(TREEVIEW).buildTree((TreeView)this.getControl(TREEVIEW), this.getPageCache());
        try {
            this.treeNodeClick((String)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "treesearchfront": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREEVIEW, CACHE_LEFT_TREE_KEY, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "treesearchafter": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREEVIEW, CACHE_LEFT_TREE_KEY, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "entitysearchbefore": {
                this.newLayzTreeInstane().searchBefore();
                break;
            }
            case "entitysearchafter": {
                this.newLayzTreeInstane().searchNext();
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        try {
            this.treeNodeClick(nodeId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void treeNodeClick(String nodeId) {
        TreeNode currentNode;
        String cache = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_LEFT_TREE_KEY))));
        TreeNode node = (TreeNode)JSON.parseObject((String)cache, TreeNode.class);
        TreeNode treeNode = currentNode = nodeId == null ? node : node.getTreeNode(nodeId);
        if (node.getText() == null) {
            return;
        }
        if (currentNode != null && "root".equals(currentNode.getId()) && currentNode.getChildren() != null && !currentNode.getChildren().isEmpty()) {
            currentNode = (TreeNode)currentNode.getChildren().get(0);
        }
        if (currentNode == null || currentNode.getText() == null) {
            return;
        }
        String number = currentNode.getText().split(" ")[0];
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long viewId = 0L;
        if (this.getModel().getValue("view") != null) {
            viewId = ((DynamicObject)this.getModel().getValue("view")).getLong("id");
        }
        Member member = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, number);
        List members = cacheHelper.getAllChildrenSort(member, true);
        Map<String, Tuple<String, String, String>> mappingParam = this.orgPersonMapping(members);
        MemberTreeNode treeNode2 = new MemberTreeNode(currentNode, null, mappingParam);
        this.getPageCache().put(CACHE_ROOT_TREE_KEY, SerializationUtils.serializeToBase64((Object)treeNode2));
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DimensionMemberTreeHandle(), (ITreeNode)treeNode2).initTree();
    }

    private Map<String, Tuple<String, String, String>> orgPersonMapping(List<Member> members) {
        HashMap<String, Tuple<String, String, String>> retMap = new HashMap<String, Tuple<String, String, String>>();
        String receptMappingId = (String)this.getView().getFormShowParameter().getCustomParam("receptMapping");
        if (StringUtils.isNotEmpty((String)receptMappingId)) {
            DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((Object[])IDUtils.toLongs((Object[])receptMappingId.split(",")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bgc_recipientmapping"));
            Map<String, String> mappingName = Arrays.stream(dynamicObject).collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("name")));
            List entryentity = Arrays.stream(dynamicObject).map(k -> k.getDynamicObjectCollection("entryentity")).flatMap(k -> k.stream()).collect(Collectors.toList());
            Map<String, Tuple> budgetPersons = entryentity.stream().filter(k -> k.getBoolean("status") && "epm_entitymembertree".equals(k.getString("orgtypeitem"))).collect(Collectors.toMap(k -> k.getString("org.id"), v -> Tuple.create((Object)v.getDynamicObjectCollection("person").stream().map(k -> k.getString("fbasedataid.name")).collect(Collectors.joining(",")), (Object)this.receMappingTips((String)mappingName.get(((DynamicObject)v.getParent()).getString("id"))), null), (v1, v2) -> Tuple.create((Object)((String)v1.p1 + "," + (String)v2.p1), (Object)((String)v1.p2 + "," + (String)v2.p2), (Object)v1.p3)));
            Map<String, Tuple> structurePersons = entryentity.stream().filter(k -> k.getBoolean("status") && "bos_adminorg".equals(k.getString("orgtypeitem"))).collect(Collectors.toMap(k -> k.getString("org.id"), v -> Tuple.create((Object)v.getDynamicObjectCollection("person").stream().map(k -> k.getString("fbasedataid.name")).collect(Collectors.joining(",")), (Object)this.budgetOrgAndMappingTips((String)mappingName.get(((DynamicObject)v.getParent()).getString("id"))), null), (v1, v2) -> Tuple.create((Object)((String)v1.p1 + "," + (String)v2.p1), (Object)((String)v1.p2 + "," + (String)v2.p2), (Object)v1.p3)));
            retMap.putAll(budgetPersons);
            Set entitys = members.stream().map(BaseCache::getId).collect(Collectors.toSet());
            if (entitys.stream().allMatch(k -> retMap.containsKey(k))) {
                return retMap;
            }
            DynamicObjectCollection structures = QueryServiceHelper.query((String)"eb_bailorg_entity", (String)"orgview,entity.id,entryentity,entryentity.bailorg,entryentity.bailorg.id,entryentity.default", (QFilter[])QFBuilder.newQFilter().add("entity.id", "in", entitys).add("entryentity.default", "=", (Object)Boolean.TRUE).toArray(), (String)"entryentity.bailorg.id,entryentity.default desc");
            DynamicObjectCollection personChargeOrgs = QueryServiceHelper.query((String)"bos_user", (String)"entryentity,entryentity.dpt.id,name", (QFilter[])QFBuilder.newQFilter().add("entryentity.dpt.id", "in", structures.stream().map(k -> k.getLong("entryentity.bailorg.id")).collect(Collectors.toSet())).add("entryentity.isincharge", "=", (Object)Boolean.TRUE).toArray());
            Map<String, String> personNames = personChargeOrgs.stream().collect(Collectors.groupingBy(k -> k.getString("entryentity.dpt.id"), Collectors.mapping(v -> v.getString("name"), Collectors.joining(","))));
            for (DynamicObject structure : structures) {
                if (retMap.containsKey(structure.getString("entity.id"))) continue;
                if (structurePersons.containsKey(structure.getString("entryentity.bailorg.id"))) {
                    if (retMap.containsKey(structure.getString("entity.id")) && retMap.get(structure.getString("entity.id")) != null) {
                        Tuple tuple = (Tuple)retMap.get(structure.getString("entity.id"));
                        retMap.put(structure.getString("entity.id"), (Tuple<String, String, String>)Tuple.create((Object)((String)tuple.p1 + "," + (String)structurePersons.get((Object)structure.getString((String)"entryentity.bailorg.id")).p1), (Object)tuple.p2, null));
                        continue;
                    }
                    retMap.put(structure.getString("entity.id"), (Tuple<String, String, String>)structurePersons.get(structure.getString("entryentity.bailorg.id")));
                    continue;
                }
                if (!Arrays.stream(dynamicObject).anyMatch(k -> k.getBoolean("isdefault")) || !personNames.containsKey(structure.getString("entryentity.bailorg.id"))) continue;
                retMap.put(structure.getString("entity.id"), (Tuple<String, String, String>)Tuple.create((Object)personNames.get(structure.getString("entryentity.bailorg.id")), (Object)this.budgetOrgBailerTips(), null));
            }
        }
        return retMap;
    }

    private LazyTreeContainer newLayzTreeInstane() {
        MemberTreeNode memberTreeNode = (MemberTreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_ROOT_TREE_KEY));
        return new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new DimensionMemberTreeHandle(), (ITreeNode)memberTreeNode);
    }

    private String receMappingTips(String recipmapping) {
        return ResManager.loadKDString((String)"%s\u4e2d\u6309\u9884\u7b97\u7ec4\u7ec7\u6620\u5c04\u7684\u4eba\u5458", (String)"ViewOrgAndRecipientPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{recipmapping});
    }

    private String budgetOrgAndMappingTips(String recipmapping) {
        return ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7+%s\u4e2d\u6309\u884c\u653f\u7ec4\u7ec7\u6620\u5c04\u7684\u4eba\u5458", (String)"ViewOrgAndRecipientPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{recipmapping});
    }

    private String budgetOrgBailerTips() {
        return ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\u7684\u8d1f\u8d23\u4eba", (String)"ViewOrgAndRecipientPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        this.newLayzTreeInstane().queryTreeNodeChildren(treeNodeEvent);
    }
}

