/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.control.ModelFilterContainerPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class WarnningSchemeListPlugin
extends ModelFilterContainerPlugin {
    private static final String MODEL_CACHE = "MODEL_CACHE";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        if ("modify".equals(evt.getItemKey()) && billList.getSelectedRows().size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u7f16\u8f91\u3002", (String)"WarnningSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if ("eb".equals(formShowParameter.getAppId()) && ModelUtil.isNewEb().booleanValue()) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (Arrays.asList("enable", "disable").contains(formOperate.getOperateKey())) {
            DynamicObject[] schemes;
            List<Long> ids = args.getListSelectedData().stream().map(k -> k.getPrimaryKeyValue()).collect(Collectors.toList());
            for (DynamicObject scheme : schemes = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bgc_controlwarnningscheme"))) {
                scheme.set("status", (Object)"enable".equals(formOperate.getOperateKey()));
            }
            SaveServiceHelper.save((DynamicObject[])schemes);
            String numberString = Arrays.stream(schemes).map(k -> k.getString("number")).collect(Collectors.joining(","));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539", "OperationLogUtil_1101", "epm-eb-common");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fee\u6539\u6210\u529f\u3002", "OperationLogUtil_1104", "epm-eb-common");
            this.writeLog(null, formOperate.getOperateKey(), opName, opDescription, new String[]{numberString});
        } else if ("delete".equals(formOperate.getOperateKey())) {
            List<Long> ids = args.getListSelectedData().stream().map(k -> k.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bgc_controlwarnningscheme"));
            ArrayList<String> errInfos = new ArrayList<String>(schemes.length);
            ArrayList<Long> sucessObj = new ArrayList<Long>(schemes.length);
            for (DynamicObject scheme : schemes) {
                if (scheme.getBoolean("status")) {
                    errInfos.add(ResManager.loadResFormat((String)"%1\u65b9\u6848\u5220\u9664\u5931\u8d25\uff0c\u542f\u7528\u7684\u65b9\u6848\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WarnningSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{scheme.getString("number")}));
                    continue;
                }
                sucessObj.add(scheme.getLong("id"));
            }
            if (sucessObj.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bgc_controlwarnningscheme"), (Object[])sucessObj.toArray());
                this.refreshData();
            }
            if (errInfos.size() > 0) {
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5171%1$s\u5f20\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761", "DimensionMateRuleListPlugin_24", "epm-eb-formplugin");
                String title = ResManager.loadResFormat((String)"\u5171%1$s\u5f20\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761", (String)"DimensionMateRuleListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{args.getListSelectedData().size(), args.getListSelectedData().size() - errInfos.size(), errInfos.size()});
                CommonServiceHelper.showErrorInfoFormWithTitle((IFormView)this.getView(), errInfos, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ed3\u679c", (String)"DimensionMateRuleListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)title);
                this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "DimensionMateRuleListPlugin_15", "epm-eb-formplugin"), opDesc, new String[]{args.getListSelectedData().size() + "", args.getListSelectedData().size() - errInfos.size() + "", errInfos.size() + ""});
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"WarnningSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "OperationLogUtil_1201", "epm-eb-common");
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "OperationLogUtil_1202", "epm-eb-common");
                this.writeLog(null, formOperate.getOperateKey(), opName, opDescription, null);
            }
            args.setCancel(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                Set ids = allRows.stream().map(k -> k.getLong("id")).collect(Collectors.toSet());
                Map cacheDatas = BusinessDataServiceHelper.loadFromCache((String)"bgc_controlwarnningscheme", (String)"id,warnningentity,warnningentity.entity,warnningentity.entity.name,warnningentity.range", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                Map<Long, String> warnningEntityNms = cacheDatas.values().stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDynamicObjectCollection("warnningentity").stream().map(k -> k.getString("entity.name") + "_" + RangeEnum.getRangeByVal((int)Integer.parseInt(k.getString("range"))).getName()).collect(Collectors.joining(","))));
                for (DynamicObject row : allRows) {
                    if (!row.getDataEntityType().getProperties().containsKey((Object)"showwarnningentity")) {
                        TextProp showEntity = new TextProp();
                        showEntity.setName("showwarnningentity");
                        row.getDataEntityType().getProperties().add((Object)showEntity);
                    }
                    row.set("showwarnningentity", (Object)warnningEntityNms.get(row.getLong("id")));
                }
                return allRows;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getPageCache().get("schemeQfilter") != null) {
            Long businessModel;
            if (this.getPageCache().get("KEY_MODEL_ID") != null) {
                e.getQFilters().add(new QFilter("model.id", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
            }
            if (IDUtils.isNotEmptyLong((Long)(businessModel = IDUtils.toLong((Object)this.getPageCache().get("KEY_BUSMODEL_ID")))).booleanValue()) {
                e.getQFilters().add(new QFilter("businessmodel.id", "=", (Object)businessModel));
            }
        }
        if (this.getPageCache().get("noneModels") != null) {
            e.getQFilters().add(new QFilter("1", "=", (Object)-1));
        }
    }

    protected void refreshData() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public String getBizEntityNumber() {
        return "bgc_controlwarnningscheme";
    }
}

