/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SaveCheckTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SaveCheck;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.calc.eums.CalculatorTypeEnum;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class WarnningSchemePlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
SaveCheck {
    private static String SHOWWARNNINGENTITY = "showwarnningentity";
    private static String WARNNINGENTITY = "warnningentity";
    private static String TARGETENTITY = "targetentity";
    private static String TARGETSUBENTITY = "targetsubentity";
    private static String TARGET_PREX = "target_defined";
    private static String MSG = "warnningmsg";
    private static String MSGLANG = "warnningmsglang";
    private static String RECEIVEDMAPPING = "receivermapping";
    private static String TARGET_ACCOUNT_KEY = "target_account";
    private static String DIMKEYMAP = "userdefinedMap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SHOWWARNNINGENTITY, MSG, TARGET_ACCOUNT_KEY, "viewmore"});
        this.addF7SelectListener(this, new String[]{RECEIVEDMAPPING, "warnningrule"});
        for (int i = 1; i <= 7; ++i) {
            this.addClickListeners(new String[]{TARGET_PREX + i});
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PageCache parentPacheCache = new PageCache(e.getFormShowParameter().getParentPageId());
        if (StringUtils.isEmpty((String)parentPacheCache.get("KEY_MODEL_ID"))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"WarnningSchemePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (CommonUtils.hasBusinessModel((Long)IDUtils.toLong((Object)parentPacheCache.get("KEY_MODEL_ID"))).booleanValue() && StringUtils.isEmpty((String)parentPacheCache.get("KEY_BUSMODEL_ID"))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6a21\u578b", (String)"WarnningSchemePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        String userdefinedStr = this.getPageCache().get(DIMKEYMAP);
        Map customDimKeyNums = new HashMap(16);
        if (userdefinedStr != null) {
            customDimKeyNums = (Map)ObjectSerialUtil.deSerializedBytes((String)userdefinedStr);
            if (customDimKeyNums.containsValue(controlKey)) {
                for (Map.Entry keyNum : customDimKeyNums.entrySet()) {
                    if (!((String)keyNum.getValue()).equals(controlKey)) continue;
                    return (String)keyNum.getKey();
                }
            }
            return (String)customDimKeyNums.get(controlKey);
        }
        return "Account";
    }

    @Override
    public void beforeBindData(EventObject e) {
        int i;
        Long modelId;
        super.beforeBindData(e);
        IPageCache parentPageCache = ((BaseView)e.getSource()).getParentView().getPageCache();
        if (parentPageCache.get("KEY_MODEL_ID") != null) {
            this.getModel().setValue("model", (Object)IDUtils.toLong((Object)parentPageCache.get("KEY_MODEL_ID")));
        }
        if (parentPageCache.get("KEY_BUSMODEL_ID") != null) {
            this.getModel().setValue("businessmodel", (Object)IDUtils.toLong((Object)parentPageCache.get("KEY_BUSMODEL_ID")));
        }
        if (CommonUtils.isBgModel((Long)(modelId = this.getModelId()))) {
            DynamicObject businessModel = BusinessModelServiceHelper.getInstance().getDefaultBusModel(modelId, "id,number,name");
            this.getModel().setValue("businessmodel", (Object)businessModel.getLong("id"));
        }
        HashMap<String, String> defineDim2F7key = new HashMap<String, String>(16);
        List<Dimension> dimensionList = this.getDimension();
        EntryGrid grid = (EntryGrid)this.getControl(TARGETENTITY);
        for (i = 1; i <= 7; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_PREX + i});
        }
        for (i = 0; i < dimensionList.size(); ++i) {
            if (i == 0) {
                defineDim2F7key.put(SysDimensionEnum.Account.getNumber(), TARGET_ACCOUNT_KEY);
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGET_PREX + i});
            grid.setColumnProperty(TARGET_PREX + i, "header", (Object)new LocaleString(dimensionList.get(i).getName()));
            defineDim2F7key.put(dimensionList.get(i).getNumber(), TARGET_PREX + i);
        }
        this.getPageCache().put(DIMKEYMAP, ObjectSerialUtil.toByteSerialized(defineDim2F7key));
        DynamicObjectCollection entitys = this.getModel().getEntryEntity(WARNNINGENTITY);
        if (entitys != null && !entitys.isEmpty()) {
            String showEntity = entitys.stream().map(k -> k.getString("entity.name") + "_" + RangeEnum.getRangeByVal((int)k.getInt("range")).getName() + (k.getBoolean("isexclude") ? ResManager.loadKDString((String)"\uff08\u79fb\u9664\uff09", (String)"WarnningSchemePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]) : "")).collect(Collectors.joining(","));
            this.getModel().setValue(SHOWWARNNINGENTITY, (Object)showEntity);
        }
        DynamicObjectCollection targetCollection = this.getModel().getEntryEntity(TARGETENTITY);
        for (DynamicObject targetEntity : targetCollection) {
            DynamicObjectCollection targetEntityCollection = targetEntity.getDynamicObjectCollection(TARGETSUBENTITY);
            for (IDataEntityProperty property : targetEntity.getDynamicObjectType().getProperties()) {
                if (!this.isTargetKey(property.getName()).booleanValue()) continue;
                String targetAcc = this.getCurrentDimNumber(property.getName());
                List members = targetEntityCollection.stream().filter(k -> k.getString("dimension.number").equals(targetAcc)).collect(Collectors.toList());
                targetEntity.set(property.getName(), (Object)members.stream().map(k -> k.getString("member.name")).collect(Collectors.joining(",")));
            }
        }
    }

    private List<Dimension> getDimension() {
        if (this.getPageCache().get("cache_dimension") != null) {
            return (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("cache_dimension"));
        }
        QFilter[] qFilters = this.dimensionQf(this.getModelId(), this.getBusinessModelId());
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)"epm_dimension", (String)"id,number,name,issysdimension", (QFilter[])qFilters, (String)"dseq");
        List<Dimension> dimensionList = Arrays.stream(doc).map(k -> {
            Dimension dimension = new Dimension();
            dimension.setId(Long.valueOf(k.getLong("id")));
            dimension.setName(k.getString("name"));
            dimension.setNumber(k.getString("number"));
            dimension.setPreset(k.getBoolean("issysdimension"));
            return dimension;
        }).collect(Collectors.toList());
        this.getPageCache().put("cache_dimension", SerializationUtils.serializeToBase64(dimensionList));
        return dimensionList;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ILocaleString localeString = (ILocaleString)this.getModel().getValue("warnningmsglang");
        String showMsg = localeString.getLocaleValue();
        if (StringUtils.isEmpty((String)showMsg) && localeString.get((Object)"GLang") != null) {
            showMsg = (String)localeString.get((Object)"GLang");
        }
        if (showMsg == null) {
            showMsg = localeString.getLocaleValue_zh_CN();
        }
        this.getModel().setValue(MSG, (Object)showMsg);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (RECEIVEDMAPPING.equals(key)) {
            FormShowParameter formShowParameter = event.getFormShowParameter();
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            if (CommonUtils.isBgmdModel((Long)this.getModelId())) {
                qFilter.and("businessmodel", "=", (Object)this.getBusinessModelId());
            }
            qFilter.or("isDefault", "=", (Object)Boolean.TRUE);
            this.addF7Filter(event, qFilter);
            DynamicObjectCollection cols = (DynamicObjectCollection)this.getModel().getValue("receivermapping");
            if (cols != null && !cols.isEmpty()) {
                Object[] array = (String[])cols.stream().map(k -> k.getString("fbasedataid.id")).toArray(String[]::new);
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.setSelectedRows(array);
            }
        } else if ("warnningrule".equals(key) && this.getModel().getValue("warnningrule") != null) {
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject warrningRule = (DynamicObject)this.getModel().getValue("warnningrule");
            formShowParameter.setSelectedRow((Object)warrningRule.getLong("id"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.isTargetKey(key).booleanValue()) {
            String currentDimNumber = this.getCurrentDimNumber(key);
            Long modelId = this.getModelId();
            Long busModelId = this.getBusinessModelId();
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)currentDimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setSwitchViewBySelMem(false);
            f7Param.setBusModelId(busModelId);
            f7Param.setMultiSelect(true);
            f7Param.setOnlySelLeaf(false);
            if (SysDimensionEnum.Account.getNumber().equals(currentDimNumber)) {
                f7Param.setDatasetIds(BusinessModelServiceHelper.getInstance().queryDataSetIds(f7Param.getBusModelId()));
                f7Param.setCanSelectRoot(false);
            }
            if (CommonUtils.isBgmdModel((Long)modelId) && busModelId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6a21\u578b", (String)"WarnningSchemePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            int focusRow = ((EntryGrid)this.getControl(TARGETENTITY)).getEntryState().getFocusRow();
            DynamicObject grid = this.getModel().getEntryRowEntity(TARGETENTITY, focusRow);
            Set subEntrys = grid.getDynamicObjectCollection(TARGETSUBENTITY).stream().filter(k -> k.getString("dimension.number").equals(currentDimNumber)).map(k -> k.getLong("member.id")).collect(Collectors.toSet());
            if (!subEntrys.isEmpty()) {
                f7Param.setSelectIds(subEntrys);
            }
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key + "#" + focusRow));
        } else if (SHOWWARNNINGENTITY.equals(key)) {
            RangeF7Param param = new RangeF7Param();
            param.setEnableView(false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "entityback");
            param.setCloseCallBack(closeCallBack);
            param.setNeedPermCheck(true);
            param.setBizModelId(this.getBusinessModelId());
            param.setRangeType(F7RangeTypeEnum.MINI);
            param.setDefaultRange(RangeEnum.ALL);
            param.setMustSelected(true);
            param.setShowExclude(true);
            param.setSwitchViewBySelMem(false);
            Set excludes = this.getModel().getEntryEntity(WARNNINGENTITY).stream().filter(k -> k.getBoolean("isexclude")).map(k -> k.getLong("entity.id")).collect(Collectors.toSet());
            param.setExcludeMemberIds(excludes);
            List members = this.getModel().getEntryEntity(WARNNINGENTITY).stream().map(k -> new MemberCondition(Long.valueOf(k.getLong("entity.id")), k.getString("entity.number"), k.getString("entity.name"), null, k.getString("range"))).collect(Collectors.toList());
            param.setCon_list(members);
            CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)SysDimensionEnum.Entity.getNumber(), null, (IFormView)this.getView(), (RangeF7Param)param);
        } else if (MSG.equals(key)) {
            this.cacheMsgTree();
            FormShowParameter messageForm = new FormShowParameter();
            messageForm.setFormId("bgc_warnningmessage");
            messageForm.getOpenStyle().setShowType(ShowType.Modal);
            messageForm.setCustomParam(MSG, this.getModel().getValue(MSGLANG));
            messageForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "msgback"));
            this.getView().showForm(messageForm);
        } else if ("viewmore".equals(key)) {
            Long viewId = null;
            DynamicObjectCollection entitys = this.getModel().getEntryEntity(WARNNINGENTITY);
            if (!entitys.isEmpty() && ((DynamicObject)entitys.get(0)).get("view") != null) {
                viewId = ((DynamicObject)entitys.get(0)).getLong("view.id");
            }
            Set<Long> inIds = this.orgIds(entitys.stream().filter(k -> !k.getBoolean("isexclude")), viewId);
            Set<Long> notInIds = this.orgIds(entitys.stream().filter(k -> k.getBoolean("isexclude")), viewId);
            inIds.removeIf(k -> notInIds.contains(k));
            QFilter entityQfilter = new QFilter("memberid", "in", inIds);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bgc_vieworgreceiver");
            showParameter.setCustomParam("model", (Object)this.getModelId());
            showParameter.setCustomParam("qfilterStr", (Object)entityQfilter.toSerializedString());
            if (this.getModel().getValue("receivermapping") != null) {
                DynamicObjectCollection receiverMapping = (DynamicObjectCollection)this.getModel().getValue("receivermapping");
                showParameter.setCustomParam("receptMapping", (Object)receiverMapping.stream().map(k -> k.getString("fbasedataid.id")).collect(Collectors.joining(",")));
            }
            if (viewId != null) {
                showParameter.setCustomParam("view", (Object)String.valueOf(viewId));
            }
            showParameter.setCustomParam("businessModel", (Object)this.getBusinessModelId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private Set<Long> orgIds(Stream<DynamicObject> stream, Long viewId) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        stream.forEach(entity -> {
            if (RangeEnum.ONLY.getIndStr().equals(entity.getString("range"))) {
                entityIds.add(entity.getLong("entity.id"));
            } else if (RangeEnum.ALL_EXCLUDE.getIndStr().equals(entity.getString("range"))) {
                entityIds.addAll(this.allMembers(modelCache, viewId, entity.getLong("entity.id"), 0));
            } else if (RangeEnum.ALL.getIndStr().equals(entity.getString("range"))) {
                entityIds.add(entity.getLong("entity.id"));
                entityIds.addAll(this.allMembers(modelCache, viewId, entity.getLong("entity.id"), 0));
            } else if (RangeEnum.ALL_DETAIL.getIndStr().equals(entity.getString("range"))) {
                entityIds.addAll(this.allMembers(modelCache, viewId, entity.getLong("entity.id"), 1));
            } else if (RangeEnum.ALL_NOTDETAIL.getIndStr().equals(entity.getString("range"))) {
                entityIds.addAll(this.allMembers(modelCache, viewId, entity.getLong("entity.id"), 2));
            }
        });
        return entityIds;
    }

    private Set<Long> allMembers(IModelCacheHelper modelCache, Long viewId, Long memberId, int tp) {
        HashSet<Long> memberIds = new HashSet<Long>();
        List childrens = null;
        if (tp == 0) {
            childrens = modelCache.getChildren(modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewId, memberId), false);
        } else if (tp == 1) {
            childrens = modelCache.getDetailChildren(modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewId, memberId));
        } else if (tp == 2) {
            childrens = modelCache.getNotDetailChildren(modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewId, memberId));
        }
        if (childrens == null || childrens.isEmpty()) {
            return memberIds;
        }
        for (Member children : childrens) {
            if (children == null) continue;
            memberIds.add(children.getId());
            memberIds.addAll(this.allMembers(modelCache, viewId, children.getId(), tp));
        }
        return memberIds;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            if (!this.checkBeforeSave().booleanValue()) {
                args.setCancel(true);
            }
        } else if ("importentry".equals(opType)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_rulecontrolimport");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("model", (Object)this.getModelId());
            showParameter.setCustomParam("bussmodel", (Object)this.getBusinessModelId());
            showParameter.setCaption(ResManager.loadKDString((String)"\u9884\u8b66\u6307\u6807\u5bfc\u5165", (String)"WarnningSchemePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)"eb_rulecontrolimport");
            formConfig.getPlugins().clear();
            showParameter.setFormConfig(formConfig);
            showParameter.addCustPlugin("kd.epm.eb.formplugin.control.budgetwarnning.WarnningTargetImportPlugin");
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importback");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
            args.setCancel(true);
        } else if ("donothing".equals(opType)) {
            List<Dimension> dimensions = this.getDimension();
            String[] excelTitle = new String[dimensions.size() * 2];
            int index = 0;
            DynamicObjectCollection targetEntitys = this.getModel().getEntryEntity(TARGETENTITY);
            for (Dimension dimension : dimensions) {
                excelTitle[index++] = ResManager.loadResFormat((String)"%1.\u540d\u79f0", (String)"WarnningSchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()});
                excelTitle[index++] = ResManager.loadResFormat((String)"%1.\u5185\u7801", (String)"WarnningSchemePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()});
            }
            List datas = targetEntitys.stream().map(k -> this.trandimMember((DynamicObject)k)).collect(Collectors.toList());
            String url = ImportAndExportUtil.export((String)ResManager.loadKDString((String)"\u9884\u8b66\u6307\u6807\u5bfc\u51fa", (String)"WarnningSchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), (ThreeTuple[])new ThreeTuple[]{new ThreeTuple((Object)ResManager.loadKDString((String)"\u9884\u8b66\u6307\u6807\u5bfc\u51fa", (String)"WarnningSchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)excelTitle, datas)});
            if (StringUtils.isNotEmpty((String)url)) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
            args.setCancel(true);
        }
    }

    private String[] trandimMember(DynamicObject dynamicObject) {
        List<Dimension> dimensions = this.getDimension();
        String[] memberStr = new String[dimensions.size() * 2];
        int index = 0;
        for (Dimension dimension : dimensions) {
            List members = dynamicObject.getDynamicObjectCollection(TARGETSUBENTITY).stream().filter(k -> dimension.getNumber().equals(k.getString("dimension.number"))).map(k -> k.getDynamicObject("member")).collect(Collectors.toList());
            memberStr[index++] = members.stream().map(k -> k.getString("name")).collect(Collectors.joining(","));
            memberStr[index++] = members.stream().map(k -> k.getString("number")).collect(Collectors.joining(","));
        }
        return memberStr;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean issuccess;
        super.afterDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("save") && (issuccess = e.getOperationResult().getValidateResult().isSuccess())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            String number = (String)this.getModel().getValue("number");
            MultiLangEnumBridge opName = this.getOpName();
            if (opName != null) {
                this.writeLog(number, "save", this.getOpName(), this.getOpDesc(), new String[]{number});
            }
        }
    }

    private MultiLangEnumBridge getOpName() {
        if (this.isCopy().booleanValue()) {
            return new MultiLangEnumBridge("\u590d\u5236", "WarnningSchemePlugin_17", "epm-eb-formplugin");
        }
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            return new MultiLangEnumBridge("\u65b0\u589e", "WarnningSchemePlugin_18", "epm-eb-formplugin");
        }
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            return new MultiLangEnumBridge("\u4fee\u6539", "WarnningSchemePlugin_19", "epm-eb-formplugin");
        }
        return null;
    }

    private MultiLangEnumBridge getOpDesc() {
        if (this.isCopy().booleanValue()) {
            return new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u590d\u5236\u6210\u529f\u3002", "AbstractBasePlugin_17", "epm-eb-formplugin");
        }
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            return new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u65b0\u589e\u6210\u529f\u3002", "AbstractBasePlugin_21", "epm-eb-formplugin");
        }
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            return new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fee\u6539\u6210\u529f\u3002", "AbstractBasePlugin_19", "epm-eb-formplugin");
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.isTargetKey(key).booleanValue() && "".equals(e.getChangeSet()[0].getNewValue())) {
            String dimNumber = this.getCurrentDimNumber(key);
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryRowEntity(TARGETENTITY, rowIndex).getDynamicObjectCollection(TARGETSUBENTITY);
            dynamicObjectCollection.removeIf(k -> dimNumber.equals(k.getString("dimension.number")));
        } else if (MSG.equals(key) && "".equals(e.getChangeSet()[0].getNewValue())) {
            this.getModel().setValue(MSGLANG, null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!Arrays.asList("model", "businessmodel", "showwarnningentity").contains(property.getName())) continue;
            dataEntity.getDataEntityState().setBizChanged(property.getOrdinal(), false);
            IDataEntityProperty baseDataIdProp = (IDataEntityProperty)properties.get((Object)(property.getName() + "_id"));
            if (baseDataIdProp == null) continue;
            dataEntity.getDataEntityState().setBizChanged(baseDataIdProp.getOrdinal(), false);
        }
        for (ICollectionProperty entryProperty : dataEntity.getDynamicObjectType().getProperties().getCollectionProperties(false)) {
            if (!TARGETENTITY.equals(entryProperty.getName())) continue;
            DynamicObjectCollection entryField = dataEntity.getDynamicObjectCollection(entryProperty.getName());
            for (IDataEntityProperty property : entryField.getDynamicObjectType().getProperties()) {
                entryField.forEach(k -> k.getDataEntityState().setBizChanged(property.getOrdinal(), false));
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (actionId) {
            case "entityback": {
                returnData = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                String showEntity = returnData.stream().map(k -> k.getString("name") + "_" + RangeEnum.getRangeByVal((int)k.getInt("scope")).getName() + (k.getBoolean("exclude") ? ResManager.loadKDString((String)"\uff08\u79fb\u9664\uff09", (String)"WarnningSchemePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]) : "")).collect(Collectors.joining(","));
                this.getModel().setValue(SHOWWARNNINGENTITY, (Object)showEntity);
                this.getModel().deleteEntryData(WARNNINGENTITY);
                this.getModel().batchCreateNewEntryRow(WARNNINGENTITY, returnData.size());
                for (int i = 0; i < returnData.size(); ++i) {
                    this.getModel().setValue("entity", (Object)((DynamicObject)returnData.get(i)).getLong("id"), i);
                    this.getModel().setValue("range", (Object)((DynamicObject)returnData.get(i)).getLong("scope"), i);
                    this.getModel().setValue("isexclude", (Object)((DynamicObject)returnData.get(i)).getBoolean("exclude"), i);
                    if (((DynamicObject)returnData.get(i)).get("viewId") == null) continue;
                    this.getModel().setValue("view", (Object)((DynamicObject)returnData.get(i)).getLong("viewId"), i);
                }
                break;
            }
            case "msgback": {
                ILocaleString localeString = (ILocaleString)closedCallBackEvent.getReturnData();
                this.getModel().setValue(MSGLANG, (Object)localeString);
                this.getModel().setValue(MSG, (Object)localeString.getLocaleValue());
                break;
            }
            case "importback": {
                Pair tuple = (Pair)closedCallBackEvent.getReturnData();
                if (!((Boolean)tuple.p1).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u6587\u6863\u3002", (String)"WarnningSchemePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List renturnLists = (List)tuple.p2;
                int cnt = this.getModel().getEntryRowCount(TARGETENTITY);
                Map dimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(DIMKEYMAP));
                for (Map map : renturnLists) {
                    int i = this.getModel().insertEntryRow(TARGETENTITY, cnt++);
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TARGETENTITY, i);
                    for (Map.Entry m : map.entrySet()) {
                        if (m.getValue() == null) continue;
                        String ctrlKey = (String)dimMap.get(m.getKey());
                        this.getModel().setValue(ctrlKey, (Object)((List)m.getValue()).stream().map(Member::getName).collect(Collectors.joining(",")), i);
                        DynamicObjectCollection targetSubEntry = entryRowEntity.getDynamicObjectCollection(TARGETSUBENTITY);
                        for (Member member : (List)m.getValue()) {
                            DynamicObject addNewObj = targetSubEntry.addNew();
                            String treeModel = SysDimensionEnum.Account.getNumber().equals(m.getKey()) ? "epm_accountmembertree" : "epm_userdefinedmembertree";
                            addNewObj.set("dimensiontreemodel", (Object)treeModel);
                            addNewObj.set("member", (Object)BusinessDataServiceHelper.loadSingle((Object)member.getId(), (String)treeModel));
                            addNewObj.set("dimension", (Object)NewF7Utils.getDimension((Long)this.getModelId(), (String)((String)m.getKey())));
                            addNewObj.set("isleaf", (Object)true);
                            addNewObj.set("scope", (Object)"10");
                        }
                    }
                }
                break;
            }
        }
        if (this.isTargetKey(actionId).booleanValue()) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            String[] split = actionId.split("#");
            String currentDimNumber = this.getCurrentDimNumber(split[0]);
            returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String showName = returnData.stream().map(k -> k.getName()).collect(Collectors.joining(","));
            this.getModel().setValue(split[0], (Object)showName, Integer.parseInt(split[1]));
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TARGETENTITY, Integer.parseInt(split[1]));
            DynamicObjectCollection targetSubEntry = entryRowEntity.getDynamicObjectCollection(TARGETSUBENTITY);
            DynamicObject dimObj = NewF7Utils.getDimension((Long)this.getModelId(), (String)currentDimNumber);
            targetSubEntry.removeIf(k -> k.getLong("dimension.id") == dimObj.getLong("id"));
            String treeModel = SysDimensionEnum.Account.getNumber().equals(currentDimNumber) ? "epm_accountmembertree" : "epm_userdefinedmembertree";
            for (ListSelectedRow returnDatum : returnData) {
                DynamicObject addNewObj = targetSubEntry.addNew();
                addNewObj.set("dimensiontreemodel", (Object)treeModel);
                addNewObj.set("member", (Object)BusinessDataServiceHelper.loadSingle((Object)returnDatum.getPrimaryKeyValue(), (String)treeModel));
                addNewObj.set("dimension", (Object)dimObj);
                Map dataMap = returnDatum.getDataMap();
                addNewObj.set("isleaf", dataMap.get("isleaf"));
                addNewObj.set("scope", dataMap.get("scope"));
            }
        }
    }

    private ILocaleString processGLang(ILocaleString localeString, boolean hasL) {
        if (hasL) {
            return localeString;
        }
        if (localeString != null && localeString.keySet().contains("GLang")) {
            String msg = (String)localeString.get((Object)"GLang");
            for (Map.Entry local : localeString.entrySet()) {
                localeString.put(local.getKey(), (Object)msg);
            }
        }
        return localeString;
    }

    private void cacheMsgTree() {
        List<Dimension> dimensions = this.getDimension();
        final ArrayList dims = new ArrayList(dimensions.size());
        dimensions.forEach(k -> {
            dims.add(new TreeNode("1", k.getId() + "_1", ResManager.loadResFormat((String)"%1.\u5185\u7801", (String)"WarnningSchemePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{k.getName()}), (Object)(k.getNumber() + ".number")));
            dims.add(new TreeNode("1", k.getId() + "_2", ResManager.loadResFormat((String)"%1.\u540d\u79f0", (String)"WarnningSchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{k.getName()}), (Object)(k.getNumber() + ".name")));
        });
        final ArrayList<TreeNode> entitys = new ArrayList<TreeNode>(dimensions.size());
        entitys.add(new TreeNode("2", "entityid_1", ResManager.loadKDString((String)"\u7ec4\u7ec7.\u5185\u7801", (String)"WarnningSchemePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"Entity.number"));
        entitys.add(new TreeNode("2", "entityid_2", ResManager.loadKDString((String)"\u7ec4\u7ec7.\u540d\u79f0", (String)"WarnningSchemePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Object)"Entity.name"));
        TreeNode root = new TreeNode(null, "0", ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u9884\u8b66", (String)"WarnningSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.addChildren((List)new LinkedList(){
            {
                this.add(new TreeNode("0", "1", ResManager.loadKDString((String)"\u9884\u8b66\u7ef4\u5ea6", (String)"WarnningSchemePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0])).addChildren(dims));
                this.add(new TreeNode("0", "2", ResManager.loadKDString((String)"\u9884\u8b66\u7ec4\u7ec7", (String)"WarnningSchemePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])).addChildren(entitys));
                this.add(new TreeNode("0", "3", ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u503c", (String)"WarnningSchemePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0])).addChildren(CalculatorTypeEnum.getWaringTypes().stream().map(k -> new TreeNode("3", String.valueOf(k.getIndex()), k.getName(), (Object)k.getNumber())).collect(Collectors.toList())));
            }
        });
        this.getPageCache().put("cache_msgsetting_tree", SerializationUtils.serializeToBase64((Object)root));
    }

    private QFilter[] dimensionQf(Long modelId, Long businessModelId) {
        HashSet<Long> dimensionIdSet = new HashSet<Long>(16);
        boolean hasBusinessModel = CommonUtils.hasBusinessModel((Long)modelId);
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        if (hasBusinessModel) {
            if (CommonUtils.isBgmdModel((Long)modelId)) {
                builder.add(new QFilter("businessmodel.id", "=", (Object)businessModelId));
            }
            String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
            DynamicObjectCollection ctrlDims = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
            for (DynamicObject ctrlDim : ctrlDims) {
                if (!IDUtils.isNotEmptyLong((Long)ctrlDim.getLong("entryentity.dimensionid")).booleanValue()) continue;
                dimensionIdSet.add(ctrlDim.getLong("entryentity.dimensionid"));
            }
            builder.clear();
            if (dimensionIdSet.isEmpty()) {
                builder.add(new QFilter("model", "=", (Object)modelId)).add(new QFilter("number", "=", (Object)SysDimensionEnum.Account.getNumber()));
            } else {
                builder.add(new QFilter("id", "in", dimensionIdSet)).add(new QFilter("issysdimension", "=", (Object)Boolean.FALSE).or("number", "=", (Object)SysDimensionEnum.Account.getNumber()));
            }
        } else {
            builder.add(new QFilter("issysdimension", "=", (Object)Boolean.FALSE).or("number", "=", (Object)SysDimensionEnum.Account.getNumber()));
        }
        return builder.toArray();
    }

    private Boolean checkBeforeSave() {
        String checkMessage = this.saveValidate();
        if (StringUtils.isNotEmpty((String)checkMessage) || (checkMessage = this.checkRepeate()) != null || (checkMessage = this.checkTargetAccountNull()) != null) {
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s", (String)"WarnningSchemePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{checkMessage}));
            MultiLangEnumBridge opName = this.getOpName();
            if (opName != null) {
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\uff0c%s", "WarnningSchemePlugin_0", "epm-eb-formplugin");
                this.writeLog(null, "save", this.getOpName(), opDesc, new String[]{checkMessage}, false);
            }
            return false;
        }
        return true;
    }

    private String checkRepeate() {
        DynamicObject entity = this.getModel().getDataEntity(true);
        DynamicObjectCollection targetEntitys = entity.getDynamicObjectCollection(TARGETENTITY);
        List<Dimension> dimensionList = this.getDimension();
        for (int i = 0; i < targetEntitys.size(); ++i) {
            block1: for (int j = i + 1; j < targetEntitys.size(); ++j) {
                Boolean isRepeate = false;
                DynamicObjectCollection c1 = ((DynamicObject)targetEntitys.get(i)).getDynamicObjectCollection(TARGETSUBENTITY);
                DynamicObjectCollection c2 = ((DynamicObject)targetEntitys.get(j)).getDynamicObjectCollection(TARGETSUBENTITY);
                for (Dimension dimension : dimensionList) {
                    List i1 = c1.stream().filter(k -> dimension.getNumber().equals(k.getString("dimension.number"))).map(k -> k.getLong("member.id")).collect(Collectors.toList());
                    List i2 = c2.stream().filter(k -> dimension.getNumber().equals(k.getString("dimension.number"))).map(k -> k.getLong("member.id")).collect(Collectors.toList());
                    if (i1.isEmpty() && i2.isEmpty()) continue;
                    i1.retainAll(i2);
                    if (i1.isEmpty()) continue block1;
                    isRepeate = true;
                }
                if (!isRepeate.booleanValue()) continue;
                return ResManager.loadResFormat((String)"\u9884\u8b66\u6307\u6807\u5206\u5f55\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WarnningSchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, j + 1});
            }
        }
        return null;
    }

    private String checkTargetAccountNull() {
        if (this.getModel().getEntryEntity(TARGETENTITY).stream().anyMatch(k -> k.getDynamicObjectCollection(TARGETSUBENTITY).stream().noneMatch(p -> SysDimensionEnum.Account.getNumber().equals(p.getString("dimension.number"))))) {
            return ResManager.loadKDString((String)"\u9884\u8b66\u6307\u6807-\u9884\u8b66\u79d1\u76ee\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WarnningSchemePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private Boolean isTargetKey(String key) {
        return key.startsWith("target_");
    }

    public Long getPkId() {
        if (this.isCopy().booleanValue()) {
            return 0L;
        }
        Object pkId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        return IDUtils.toLong((Object)pkId);
    }

    private Boolean isCopy() {
        return this.getView().getFormShowParameter().getCustomParam("iscopy") != null;
    }

    @Override
    public Long getModelId() {
        return this.getPageF7Id("model");
    }

    private Long getBusinessModelId() {
        return this.getPageF7Id("businessmodel");
    }

    public List<String> getAllCheckTypes() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            return Collections.singletonList(SaveCheckTypeEnum.EMPTY_CHECK.getCheckKey());
        }
        return super.getAllCheckTypes();
    }
}

