/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.budgetwarnning;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WarnningTargetImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_DOWNLOAD = "btndownload";
    private static final String BTN_OK = "btnok";
    private static final Log log = LogFactory.getLog(WarnningTargetImportPlugin.class);

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_DOWNLOAD, BTN_OK});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downImportTemplate();
                break;
            }
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        List urls = null;
        urls = this.getPageCache().get("file_url") == null ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("file_url"), List.class);
        for (Object url : evt.getUrls()) {
            Map fileInfo = (Map)url;
            urls.add(fileInfo.get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        List urls = null;
        if (this.getPageCache().get("file_url") != null) {
            urls = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("file_url"), List.class);
            for (Object url : evt.getUrls()) {
                String urles = (String)((Map)url).get("url");
                if (!urls.contains(urles)) continue;
                urls.remove(urles);
            }
            this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
        }
    }

    private void importData() {
        String fileUrl = this.getPageCache().get("file_url");
        if (StringUtils.isBlank((String)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"WarnningTargetImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List inputStreams = UploadUtil.getFileInputStreams((String)fileUrl);
        List<Dimension> dimensions = this.queryDimensions();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model")));
        Long bussModel = (Long)this.getView().getFormShowParameter().getCustomParam("bussmodel");
        ArrayList returnDatas = new ArrayList(16);
        try {
            Pair pair;
            XSSFWorkbook errorBook = null;
            for (InputStream inputStream : inputStreams) {
                BgExcelReader excelReader = BgExcelReader.getInstance().readByInputstream(inputStream);
                List datas = excelReader.readString(0, 0, dimensions.size() * 2 - 1);
                if (excelReader.getSheet().getRow(0) == null || excelReader.getSheet().getRow(0).getLastCellNum() != dimensions.size() * 2 || datas.size() < 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786eEXCEL\u6a21\u677f", (String)"WarnningTargetImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                int titleIndex = 0;
                if (datas.size() < 2) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (String)"WarnningTargetImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                for (int i = 0; i < dimensions.size(); ++i) {
                    if (((String)((List)datas.get(0)).get(titleIndex++)).replace("*", "").equals(this.getDimNameTile(dimensions.get(i))) && ((String)((List)datas.get(0)).get(titleIndex++)).replace("*", "").equals(this.getDimNumberTile(dimensions.get(i)))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786eEXCEL\u6a21\u677f", (String)"WarnningTargetImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                HashMap<String, Set> permMaps = new HashMap<String, Set>(dimensions.size());
                for (Dimension dimension : dimensions) {
                    Set permMembIds = DimMembPermHelper.getPermMembIds((String)dimension.getNumber(), (Long)modelCache.getModelobj().getId(), (Long)IDUtils.toLong((Object)bussModel), null, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                    permMaps.put(dimension.getNumber(), permMembIds);
                }
                Map defaultViewId = modelCache.getViewsByBusModel(bussModel);
                for (int i = 1; i < datas.size(); ++i) {
                    List rowData = (List)datas.get(i);
                    HashMap returnData = new HashMap(dimensions.size());
                    for (int j = 1; j < rowData.size(); j += 2) {
                        String dimNumber = (String)rowData.get(j);
                        Dimension dimension = dimensions.get(j / 2);
                        if (StringUtils.isEmpty((String)dimNumber)) {
                            returnData.put(dimension.getNumber(), new ArrayList());
                            continue;
                        }
                        String[] memberArr = dimNumber.split(",");
                        if ((datas.size() - 1) * dimensions.size() * memberArr.length > 100000) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u8fc7\u5927\uff0c\u5efa\u8bae\u6570\u636e\u884c\u6570*\u7ef4\u5ea6\u6570*\u6700\u5927\u5355\u5143\u683c\u6210\u5458\u6570\u5c0f\u4e8e100000", (String)"WarnningTargetImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        ArrayList<Member> memberList = new ArrayList<Member>(memberArr.length);
                        HashSet<String> memberSet = new HashSet<String>(Arrays.asList(memberArr));
                        Set hasPermMembers = (Set)permMaps.get(dimension.getNumber());
                        for (String memberStr : memberSet) {
                            Long ViewId = (Long)defaultViewId.get(dimension.getNumber());
                            Member member = modelCache.getMember(dimension.getNumber(), ViewId, memberStr);
                            if (member == null || hasPermMembers != null && !hasPermMembers.contains(member.getId())) {
                                if (errorBook == null) {
                                    errorBook = new XSSFWorkbook();
                                    POIUtils.POIConfig config = new POIUtils.POIConfig();
                                    config.getSheetConfig((int)0).COPY_ColBeginIndex = 1;
                                    POIUtils.get().copyBook(excelReader.getSheet().getWorkbook(), (Workbook)errorBook, config);
                                    Sheet sheet = errorBook.getSheetAt(0);
                                    Row firstRow = sheet.getRow(0);
                                    firstRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"WarnningTargetImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                }
                                String errMsg = "";
                                errMsg = member != null && hasPermMembers != null && !hasPermMembers.contains(member.getId()) ? ResManager.loadResFormat((String)"\u65e0\u6210\u5458\u201c%1\u201d\u7684\u4f7f\u7528\u6743\u9650", (String)"ControlWarningRecipientMappingImportPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[]{member.getNumber()}) : ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728%2\u6210\u5458", (String)"WarnningTargetImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getNumber(), memberStr});
                                Cell cell = POIUtils.getCell((Sheet)errorBook.getSheetAt(0), (int)i, (int)0);
                                if (StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                                    String value = cell.getStringCellValue() + ";";
                                    value = value + errMsg;
                                    cell.setCellValue(value);
                                } else {
                                    cell.setCellValue(errMsg);
                                }
                                POIUtils.setCellStyleOfRed((Cell)cell);
                                continue;
                            }
                            memberList.add(member);
                        }
                        returnData.put(dimension.getNumber(), memberList);
                    }
                    returnDatas.add(returnData);
                }
            }
            if (errorBook != null) {
                pair = Pair.onePair((Object)false, returnDatas);
                POIUtils.downloadFile((IFormView)this.getView(), errorBook);
            } else {
                pair = Pair.onePair((Object)true, returnDatas);
            }
            this.getView().returnDataToParent((Object)pair);
            this.getView().close();
        }
        catch (KDBizException ke) {
            throw ke;
        }
        catch (Exception e) {
            log.error("import-error,{}", (Object)e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"WarnningTargetImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void downImportTemplate() {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFCellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFSheet xssfSheet = workBook.createSheet();
        xssfSheet.setColumnWidth(0, 10000);
        List<Dimension> dimensions = this.queryDimensions();
        int colindex = 0;
        XSSFRow row = xssfSheet.createRow(0);
        FileImportUtils fileImportUtils = FileImportUtils.getInstance();
        for (int i = 0; i < dimensions.size(); ++i) {
            xssfSheet.setColumnWidth(colindex, 5000);
            XSSFCell cellnm = row.createCell(colindex++, CellType.STRING);
            String dimName = this.getDimNameTile(dimensions.get(i));
            if (i == 0) {
                dimName = dimName + "*";
            }
            cellnm.setCellValue(dimName);
            cellnm.setCellStyle((CellStyle)style);
            xssfSheet.setColumnWidth(colindex, 5000);
            XSSFCell cellnumber = row.createCell(colindex++, CellType.STRING);
            String dimNumber = this.getDimNumberTile(dimensions.get(i));
            if (i == 0) {
                dimNumber = dimNumber + "*";
            }
            cellnumber.setCellValue(dimNumber);
            cellnumber.setCellStyle((CellStyle)style);
        }
        try {
            ImportAndExportUtil.writeFile((Workbook)workBook, (String)ResManager.loadKDString((String)"\u9884\u8b66\u6307\u6807\u5bfc\u5165\u6a21\u677f", (String)"WarnningTargetImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        try {
            String fileUrl = ImportAndExportUtil.writeFile((Workbook)workBook, (String)ResManager.loadKDString((String)"\u9884\u8b66\u6307\u6807\u5bfc\u5165\u6a21\u677f", (String)"WarnningTargetImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)fileUrl);
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6a21\u677f\u51fa\u9519", (String)"WarnningTargetImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Dimension> queryDimensions() {
        ArrayList<Dimension> dimensions = new ArrayList(16);
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        if (parentPageCache.get("cache_dimension") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25\u3002", (String)"WarnningTargetImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        dimensions = (List)SerializationUtils.deSerializeFromBase64((String)parentPageCache.get("cache_dimension"));
        return dimensions;
    }

    private String getDimNameTile(Dimension dim) {
        String dimName = ResManager.loadResFormat((String)"%1.\u540d\u79f0", (String)"WarnningTargetImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{dim.getName()});
        return dimName;
    }

    private String getDimNumberTile(Dimension dim) {
        String dimNumber = ResManager.loadResFormat((String)"%1.\u5185\u7801", (String)"WarnningTargetImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{dim.getName()});
        return dimNumber;
    }
}

