/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.controlprocess.replace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.controlprocess.ControlProcessParasUtil;
import kd.epm.eb.business.controlprocess.ParaInfo;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.OpBizRuleUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessInfo;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessRowInfo;
import kd.epm.eb.formplugin.control.controlprocess.replace.SimpleObject;
import org.apache.commons.beanutils.BeanUtils;

public class ControlProcessAddPlugin
extends AbstractBasePlugin
implements ClickListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SELECTFORMREFRESH = "selectformrefresh";
    private static final List<String> operations = Lists.newArrayList((Object[])new String[]{"takeoperation", "runoperation", "returnoperation", "clearoperation"});
    private static final List<String> values = Lists.newArrayList((Object[])new String[]{"takevalue", "runvalue", "writeoffsfield"});
    private ControlProcessInfo info;
    private static final List<String> needCacheKeys = Lists.newArrayList((Object[])new String[]{"takevalue", "runvalue", "writeoffsfield", "takeoperation", "runoperation", "returnoperation", "clearoperation"});
    private static final Log log = LogFactory.getLog(ControlProcessAddPlugin.class);
    private static final String WRITEOFFSCHEME = "writeoffschemecn";
    private static final String CONDITION = "condition";

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"save", "saveandnew"});
        this.addClickListeners(new String[]{"takeoperation", "runoperation", "returnoperation", "takevalue", "runvalue", "clearoperation", "writeoffsfield", WRITEOFFSCHEME, CONDITION});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"barcontinue"});
    }

    public void afterCreateNewData(EventObject e) {
        this.createAndCacheInfo();
        this.lockWriteoffs();
        this.getModel().setDataChanged(false);
        if (this.getView().getParentView() == null || !"eb_bgcontrolporcesslist".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"save", "saveandnew"});
        }
    }

    private void createAndCacheInfo() {
        Long settingid = Convert.toLong((Object)this.getView().getFormShowParameter().getCustomParam("settingid"), (Long)0L);
        DynamicObject parasettings = null;
        if (IDUtils.isNotEmptyLong((Long)settingid).booleanValue()) {
            String selectProperties = "id, name,number,entryentity.bill,entryentity.application,entryentity.takeoperation,entryentity.takevalue,entryentity.runoperation,entryentity.runvalue,entryentity.returnoperation,entryentity.clearoperation,entryentity.writeoffs,entryentity.writeoffsfield,entryentity.writeoffsfieldcn,entryentity.isfromouter,entryentity.writeoffscheme,entryentity.writeoffschemecn,serqfilter,condition,priority";
            parasettings = BusinessDataServiceHelper.loadSingle((Object)settingid, (String)"eb_bgcontrolprocess", (String)selectProperties);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
        this.info = ControlProcessInfo.convertTo(parasettings);
        this.info.putInModel(this.getModel(), this.getView());
        this.cacheInfo();
    }

    public ControlProcessInfo getInfo() {
        if (this.info == null) {
            String s = this.getPageCache().get("controlprocessinfo");
            this.info = (ControlProcessInfo)SerializationUtils.deSerializeFromBase64((String)s);
        }
        return this.info;
    }

    public void cacheInfo() {
        this.getPageCache().put("controlprocessinfo", SerializationUtils.serializeToBase64((Object)this.info));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (operations.contains(key) || values.contains(key)) {
            this.openOperationSelectForm(key);
        } else if ("save".equals(key)) {
            boolean save = this.barSave();
            if (save) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ControlProcessAddPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ControlProcessAddPlugin_16", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "ControlProcessAddPlugin_15", "epm-eb-formplugin");
                this.writeLog(null, "save", opName, opDesc, null);
                this.getView().close();
            }
        } else if ("saveandnew".equals(key)) {
            boolean save = this.barSave();
            if (save) {
                this.getView().returnDataToParent((Object)"saveandnew");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ControlProcessAddPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ControlProcessAddPlugin_16", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "ControlProcessAddPlugin_15", "epm-eb-formplugin");
                this.writeLog(null, "save", opName, opDesc, null);
                this.getView().close();
            }
        } else if (WRITEOFFSCHEME.equals(key)) {
            FormShowParameter form = new FormShowParameter();
            form.getOpenStyle().setShowType(ShowType.Modal);
            form.setFormId("eb_writeoffscheme");
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            form.setCustomParam("clickrow", (Object)entryGrid.getSelectRows()[0]);
            form.setCustomParam("clickkey", (Object)key);
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<String> existids = new HashSet<String>(10);
            for (ControlProcessRowInfo row : this.getInfo().getRowInfos()) {
                Long id = row.getWriteoffscheme();
                if (!IDUtils.isNotNull((Long)id)) continue;
                existids.add(String.valueOf(id));
            }
            form.setCustomParam("hasselectwriteoffschemes", (Object)JSONUtils.toString(existids));
            Long writeoffscheme = this.getInfo().getRowInfo(rows[0]).getWriteoffscheme();
            form.setCustomParam("selectwriteoffscheme", (Object)writeoffscheme);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SELECTFORMREFRESH);
            form.setCloseCallBack(callBack);
            this.getView().showForm(form);
        } else if (CONDITION.equals(key)) {
            FormShowParameter form = new FormShowParameter();
            form.getOpenStyle().setShowType(ShowType.Modal);
            form.setFormId("eb_suitcondition");
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            form.setCustomParam("clickrow", (Object)entryGrid.getSelectRows()[0]);
            form.setCustomParam("clickkey", (Object)key);
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ControlProcessRowInfo rowInfo = this.getInfo().getRowInfo(rows[0]);
            String entityNumber = rowInfo.getBill().getNumber();
            form.setCustomParam("baseformid", (Object)entityNumber);
            if (rowInfo.getSerqfilter() != null) {
                form.setCustomParam("filterjson", (Object)rowInfo.getSerqfilter());
            }
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SELECTFORMREFRESH);
            form.setCloseCallBack(callBack);
            this.getView().showForm(form);
        }
    }

    private void openOperationSelectForm(String key) {
        BillFieldTypeEmum billfieldtype = this.getType(key);
        long entryFocusId = this.getEntryFocusId();
        if (entryFocusId == 0L) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        FormShowParameter form = new FormShowParameter();
        form.setFormId("eb_fieldselect");
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCustomParam("clickrow", (Object)entryGrid.getSelectRows()[0]);
        form.setCustomParam("clickkey", (Object)key);
        if (needCacheKeys.contains(key)) {
            this.extracted(key, entryGrid, form, entryGrid.getSelectRows()[0]);
        }
        if (key.endsWith("operation")) {
            form.setCaption(ResManager.loadKDString((String)"\u63a7\u5236\u5355\u636e\u64cd\u4f5c", (String)"ControlProcessAddPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            form.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u53d6\u503c\u5b57\u6bb5", (String)"ControlProcessAddPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        boolean isOccAgain = false;
        try {
            String[] props = BgRegisterUtils.queryRegisterBizUnit((String)BusinessDataServiceHelper.loadSingleFromCache((Object)entryFocusId, (String)"eb_structofbill", (String)"fieldtable").getString("fieldtable"));
            isOccAgain = BgRegisterUtils.isOccAgain((String[])props);
        }
        catch (Throwable e) {
            log.info("openOperationSelectForm-error:{}", (Object)e);
        }
        if (BillFieldTypeEmum.CONTROLVALUE == billfieldtype || !isOccAgain && BillFieldTypeEmum.RUNOPERATION == billfieldtype || BillFieldTypeEmum.WRITEOFFS == billfieldtype) {
            form.setCustomParam("onlyOne", (Object)"true");
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECTFORMREFRESH);
        form.setCloseCallBack(closeCallBack);
        this.getView().showForm(form);
    }

    private void extracted(String key, EntryGrid entryGrid, FormShowParameter form, int row) {
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        DynamicObject dataEntity = dataEntitys[entryGrid.getSelectRows()[0]];
        Object checkObject = dataEntity.get(key);
        if (checkObject != null && !StringUtils.isEmpty((String)checkObject.toString())) {
            form.setCustomParam(key, checkObject);
            ControlProcessInfo _info = this.getInfo();
            if (row >= 0 && _info != null && _info.getRowInfos().size() > row) {
                String showKey = _info.getRowInfo(row).getShowByKey(key);
                if (checkObject.toString().equals(showKey)) {
                    form.setCustomParam(key + "!number", (Object)_info.getRowInfo(row).getShowByKey(key, true));
                }
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cb) {
        Map returnvalue;
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if (SELECTFORMREFRESH.equals(key) && (returnvalue = (Map)cb.getReturnData()) != null) {
            Integer row = (Integer)returnvalue.get("clickrow");
            String clickkey = (String)returnvalue.get("clickkey");
            this.changeByRowAndKey(row, clickkey);
            this.getView().updateView(ENTRYENTITY);
            this.lockWriteoffs();
        }
    }

    private void changeByRowAndKey(Integer row, String clickkey) {
        List paraInfos;
        Map stringListMap;
        Map regbills;
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(row.intValue());
        this.info = this.getInfo();
        String show = this.info.getRowInfos().get(row).getShowByKey(clickkey);
        dynamicObject.set(clickkey, (Object)show);
        if (("takeoperation".equals(clickkey) || "takevalue".equals(clickkey) || "runoperation".equals(clickkey) || "runvalue".equals(clickkey)) && kd.epm.eb.common.utils.StringUtils.isEmpty((String)((String)dynamicObject.get("clearoperation"))) && !(regbills = ControlProcessParasUtil.getRegBillsFromCache((IPageCache)this.getPageCache())).isEmpty() && dynamicObject.get("bill.id") != null && (stringListMap = (Map)regbills.get(dynamicObject.getLong("bill.id"))) != null && (paraInfos = (List)stringListMap.get("CLEAROPERATION")) != null && !paraInfos.isEmpty()) {
            for (ParaInfo paraInfo : paraInfos) {
                if (!paraInfo.getNumber().equals("delete")) continue;
                SimpleObject simpleObject = new SimpleObject(paraInfo.getFid(), paraInfo.getName(), paraInfo.getNumber());
                this.info.getRowInfos().get(row).getCells().put("clearoperation", Collections.singletonList(simpleObject));
                this.cacheInfo();
                dynamicObject.set("clearoperation", (Object)paraInfo.getName());
                break;
            }
        }
    }

    private boolean barSave() {
        boolean b;
        if (this.getModel().getValue("name") == null || StringUtils.isEmpty((String)String.valueOf(this.getModel().getValue("name")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"ControlProcessAddPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String tips = NumberCheckUtils.checkNumberRule((String)((String)this.getModel().getValue("number")));
        if (StringUtils.isNotEmpty((String)tips)) {
            this.getView().showTipNotification(tips);
            return false;
        }
        String checkpri = this.checkPriority();
        if (checkpri != null) {
            this.getView().showTipNotification(checkpri);
            return false;
        }
        try {
            if (this.getModel().getValue("pkid") == null) {
                if (NumberCheckUtils.checkNumberExist((String)"eb_bgcontrolprocess", (String)((String)this.getModel().getValue("number")), null)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ControlProcessAddPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                DynamicObject setting = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolprocess");
                Long settingid = DBServiceHelper.genGlobalLongId();
                setting.set("id", (Object)settingid);
                setting.set("creator", (Object)UserUtils.getUserId());
                setting.set("modifier", (Object)UserUtils.getUserId());
                setting.set("createtime", (Object)TimeServiceHelper.now());
                setting.set("modifiertime", (Object)TimeServiceHelper.now());
                setting.set("enable", (Object)0);
                b = this.saveSetting(setting);
            } else {
                Long pkid = ((DynamicObject)this.getModel().getValue("pkid")).getLong("id");
                if (NumberCheckUtils.checkNumberExist((String)"eb_bgcontrolprocess", (String)((String)this.getModel().getValue("number")), (String)String.valueOf(pkid))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ControlProcessAddPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                HashSet<String> entityNumbers = new HashSet<String>();
                DynamicObject setting = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"eb_bgcontrolprocess");
                this.getEntityNumbers(setting, entityNumbers);
                setting.set("modifier", (Object)UserUtils.getUserId());
                setting.set("modifiertime", (Object)TimeServiceHelper.now());
                QFilter qFilter = new QFilter("id", "=", (Object)pkid);
                qFilter.and("enable", "=", (Object)true);
                b = this.saveSetting(setting);
                if (setting.getBoolean("enable")) {
                    DynamicObject setting1 = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"eb_bgcontrolprocess");
                    this.getEntityNumbers(setting1, entityNumbers);
                    OpBizRuleUtils.updateOpBizRule(entityNumbers);
                }
            }
        }
        catch (Throwable e) {
            log.error(e);
            b = false;
            this.getView().showTipNotification(e.getMessage());
        }
        this.getModel().setDataChanged(false);
        return b;
    }

    private void getEntityNumbers(DynamicObject setting, Set<String> entityNumbers) {
        Object entryentityObj = setting.get(ENTRYENTITY);
        Object[] entryentitylist = null;
        if (entryentityObj instanceof Collection) {
            entryentitylist = ((Collection)entryentityObj).toArray();
        } else if (entryentityObj instanceof DynamicObjectCollection) {
            entryentitylist = ((DynamicObjectCollection)entryentityObj).toArray();
        }
        if (entryentitylist == null) {
            return;
        }
        for (Object entryObj : entryentitylist) {
            Object obj;
            DynamicObject entry = null;
            if (!(entryObj instanceof DynamicObject) || !((obj = (entry = (DynamicObject)entryObj).get("bill")) instanceof DynamicObject)) continue;
            entityNumbers.add(((DynamicObject)obj).getString("fieldtable"));
        }
    }

    private BillFieldTypeEmum getType(String key) {
        switch (key) {
            case "takeoperation": {
                return BillFieldTypeEmum.TAKEOPERATION;
            }
            case "runoperation": {
                return BillFieldTypeEmum.RUNOPERATION;
            }
            case "returnoperation": {
                return BillFieldTypeEmum.RETURNOPERATION;
            }
            case "clearoperation": {
                return BillFieldTypeEmum.CLEAROPERATION;
            }
        }
        return BillFieldTypeEmum.CONTROLVALUE;
    }

    private long getEntryFocusId() {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = entry.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return 0L;
        }
        DynamicObjectCollection rowobjs = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObject bill = ((DynamicObject)rowobjs.get(rows[0])).getDynamicObject("bill");
        long focusId = bill.getLong("id");
        String focusName = bill.getString("name");
        if (focusId != 0L) {
            this.getPageCache().put("entryfocusname", focusName);
            this.getPageCache().put("entryfocusid", String.valueOf(focusId));
        }
        return focusId;
    }

    private void lockWriteoffs() {
        DynamicObjectCollection entitys;
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entry != null && (entitys = this.getModel().getEntryEntity(ENTRYENTITY)) != null) {
            boolean isEnable = false;
            for (int i = 0; i < entitys.size(); ++i) {
                DynamicObject entity = (DynamicObject)entitys.get(i);
                if (entity == null) continue;
                Object billNumber = entity.get("bill.number");
                if ("er_dailyreimbursebill".equals(billNumber) || "er_publicreimbursebill".equals(billNumber) || "er_tripreimbursebill".equals(billNumber)) {
                    isEnable = true;
                }
                this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"writeoffs"});
                this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"writeoffsfield"});
            }
        }
    }

    private boolean saveSetting(DynamicObject setting) {
        block23: {
            this.info = this.getInfo();
            setting.set("name", this.getModel().getValue("name"));
            setting.set("number", this.getModel().getValue("number"));
            List<DynamicObject> tosaveentry = this.info.createSaveEntry();
            try (TXHandle th = TX.requiresNew();){
                try {
                    if (tosaveentry.size() > 0) {
                        setting.set(ENTRYENTITY, tosaveentry);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setting});
                        if (this.info.getRowInfos() != null) {
                            HashSet<String> entityNumbers = new HashSet<String>(this.info.getRowInfos().size());
                            for (ControlProcessRowInfo row : this.info.getRowInfos()) {
                                if (!row.needSave() || row.getBill() == null) continue;
                                entityNumbers.add(row.getBill().getNumber());
                            }
                            for (String entitynumber : entityNumbers) {
                                CacheServiceHelper.clearFieldsCache((String)entitynumber);
                            }
                        }
                        break block23;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u8868\u5355\u7684\u5185\u5bb9\u3002", (String)"ControlProcessAddPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    th.markRollback();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ControlProcessAddPlugin_16", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25", "ControlProcessAddPlugin_18", "epm-eb-formplugin");
                    this.writeLog(null, "save", opName, opDesc, null, false);
                    this.getView().showTipNotification(e.getMessage());
                    boolean bl = false;
                    if (th != null) {
                        if (var4_4 != null) {
                            try {
                                th.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            th.close();
                        }
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "writeoffs": {
                this.writeOffsChange(e);
                break;
            }
            case "writeoffsfield": {
                this.writeOffsFieldChange(e);
                break;
            }
            case "writeoffschemecn": {
                this.writeOffSchemeChange(e);
                break;
            }
            case "condition": {
                this.conditionChange(e);
                break;
            }
            case "priority": {
                this.priorityChange(e);
                break;
            }
            default: {
                this.otherChange(e, e.getProperty().getName());
            }
        }
    }

    private void otherChange(PropertyChangedArgs e, String clickkey) {
        if (e == null || e.getChangeSet() == null) {
            return;
        }
        if (operations.contains(clickkey) || values.contains(clickkey)) {
            this.info = this.getInfo();
            int in = e.getChangeSet().length;
            for (int i = 0; i < in; ++i) {
                ChangeData changeData = e.getChangeSet()[i];
                int index = changeData.getRowIndex();
                if (changeData.getNewValue() != null && !changeData.getNewValue().toString().isEmpty()) continue;
                this.info.updateRowInfo(index, clickkey, new ArrayList<SimpleObject>());
            }
            this.cacheInfo();
        }
    }

    protected void writeOffsChange(PropertyChangedArgs e) {
        if (e == null || e.getChangeSet() == null) {
            return;
        }
        this.info = this.getInfo();
        int in = e.getChangeSet().length;
        for (int i = 0; i < in; ++i) {
            ChangeData changeData = e.getChangeSet()[i];
            int rowIndex = changeData.getRowIndex();
            if (changeData.getNewValue() instanceof Boolean && ((Boolean)changeData.getNewValue()).booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"writeoffsfield"});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62a5\u9500\u5355\u542f\u7528\u51b2\u9500\u501f\u6b3e\u8bbe\u7f6e\u540e\uff0c\u8fd8\u9700\u8981\u5728\u7ef4\u5ea6\u5339\u914d\u4e2d\u8bbe\u7f6e\u501f\u6b3e\u5355\u7684\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u3002", (String)"ControlProcessAddPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"writeoffsfield"});
            }
            ControlProcessRowInfo rowInfo = this.info.getRowInfo(rowIndex);
            rowInfo.setWriteOffs((Boolean)changeData.getNewValue());
            if (rowInfo.isWriteOffs()) continue;
            rowInfo.setWriteOffsField(null);
        }
        this.cacheInfo();
    }

    protected void writeOffsFieldChange(PropertyChangedArgs e) {
        if (e == null || e.getChangeSet() == null) {
            return;
        }
        this.info = this.getInfo();
        int in = e.getChangeSet().length;
        for (int i = 0; i < in; ++i) {
            ChangeData changeData = e.getChangeSet()[i];
            int rowIndex = changeData.getRowIndex();
            ControlProcessRowInfo rowInfo = this.info.getRowInfo(rowIndex);
            if (changeData.getNewValue() != null) {
                rowInfo.setWriteOffsField((String)changeData.getNewValue());
                continue;
            }
            rowInfo.setWriteOffsField(null);
        }
        this.cacheInfo();
    }

    protected void writeOffSchemeChange(PropertyChangedArgs e) {
        if (e == null || e.getChangeSet() == null) {
            return;
        }
        this.info = this.getInfo();
        int in = e.getChangeSet().length;
        for (int i = 0; i < in; ++i) {
            ChangeData changeData = e.getChangeSet()[i];
            int rowIndex = changeData.getRowIndex();
            ControlProcessRowInfo rowInfo = this.info.getRowInfo(rowIndex);
            if (changeData.getNewValue() != null && !"".equals(changeData.getNewValue())) continue;
            rowInfo.setWriteoffschemecn("");
            rowInfo.setWriteoffscheme(0L);
        }
        this.cacheInfo();
    }

    protected void conditionChange(PropertyChangedArgs e) {
        if (e == null || e.getChangeSet() == null) {
            return;
        }
        this.info = this.getInfo();
        int in = e.getChangeSet().length;
        for (int i = 0; i < in; ++i) {
            ChangeData changeData = e.getChangeSet()[i];
            int rowIndex = changeData.getRowIndex();
            ControlProcessRowInfo rowInfo = this.info.getRowInfo(rowIndex);
            if (changeData.getNewValue() != null && !"".equals(changeData.getNewValue())) continue;
            rowInfo.setCondition("");
            rowInfo.setSerqfilter("");
        }
        this.cacheInfo();
    }

    protected void priorityChange(PropertyChangedArgs e) {
        if (e == null || e.getChangeSet() == null) {
            return;
        }
        this.info = this.getInfo();
        int in = e.getChangeSet().length;
        for (int i = 0; i < in; ++i) {
            ChangeData changeData = e.getChangeSet()[i];
            int rowIndex = changeData.getRowIndex();
            ControlProcessRowInfo rowInfo = this.info.getRowInfo(rowIndex);
            rowInfo.setPriority(changeData.getNewValue().toString());
        }
        this.cacheInfo();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("copyentryrow".equals(opType)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (rows[0] > this.getInfo().getRowInfos().size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u7684\u5206\u5f55\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ControlProcessAddPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            ControlProcessRowInfo rowInfo = this.getInfo().getRowInfo(rows[0]);
            if (!rowInfo.needSave()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5355\u636e\u64cd\u4f5c\u52a8\u4f5c\u6216\u53d6\u503c\u5b57\u6bb5\u7684\u5206\u5f55\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ControlProcessAddPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String currentBillnumber = rowInfo.getBill().getNumber();
            String appnumber = rowInfo.getApplication().getNumber();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (entryEntity.stream().filter(entry -> currentBillnumber.equals(entry.getString("bill.number")) && appnumber != null && appnumber.equals(entry.getString("application.number"))).count() > 3L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u5355\u636e\u6700\u591a\u5b58\u57284\u6761\u5206\u5f55\u3002", (String)"ControlProcessAddPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rows[0]);
            if (!StringUtils.isNotEmpty((String)rowInfo.getPriority()) || " ".equals(rowInfo.getPriority()) || !"1".equals(rowInfo.getPriority())) {
                // empty if block
            }
            this.copyNewEntry(rowInfo);
        } else if ("deleteentry".equals(opType)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (entryEntity.stream().filter(entry -> ((DynamicObject)entryEntity.get(rows[0])).getString("bill.number").equals(entry.getString("bill.number"))).count() < 2L) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u5355\u636e\u6700\u540e\u4e00\u6761\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664", (String)"ControlProcessAddPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{((DynamicObject)entryEntity.get(rows[0])).getString("bill.name")}));
            }
            this.getInfo().getRowInfos().remove(rows[0]);
            this.cacheInfo();
        }
    }

    private void copyNewEntry(ControlProcessRowInfo row) {
        ControlProcessRowInfo rowInfo = new ControlProcessRowInfo();
        try {
            BeanUtils.copyProperties((Object)rowInfo, (Object)row);
            rowInfo.setCondition(null);
            rowInfo.setSerqfilter(null);
            if (StringUtils.isNotEmpty((String)row.getPriority()) && !" ".equals(row.getPriority()) && !"1".equals(row.getPriority())) {
                rowInfo.setPriority(String.valueOf(Integer.parseInt(row.getPriority()) - 1));
            } else {
                rowInfo.setPriority("1");
            }
            HashMap<String, List<SimpleObject>> newCell = new HashMap<String, List<SimpleObject>>(row.getCells().size());
            for (Map.Entry<String, List<SimpleObject>> c : row.getCells().entrySet()) {
                List<SimpleObject> oldSinpleObject = c.getValue();
                ArrayList<SimpleObject> newSinpleObject = new ArrayList<SimpleObject>(oldSinpleObject.size());
                for (SimpleObject simpleObject : oldSinpleObject) {
                    newSinpleObject.add(new SimpleObject(simpleObject.getId(), simpleObject.getName(), simpleObject.getNumber()));
                }
                newCell.put(c.getKey(), newSinpleObject);
            }
            rowInfo.setCells(newCell);
            this.getInfo().getRowInfos().add(rowInfo);
            this.cacheInfo();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u65b0\u589e\u6210\u529f", (String)"ControlProcessAddPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u590d\u5236\u5206\u5f55\u53d1\u751f\u9519\u8bef\u3002", (String)"ControlProcessAddPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String checkPriority() {
        List<ControlProcessRowInfo> rowInfos = this.getInfo().getRowInfos();
        if (rowInfos.stream().anyMatch(row -> row.needSave() && StringUtils.isEmpty((String)row.getPriority()))) {
            return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f18\u5148\u7ea7\u3002", (String)"ControlProcessAddPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        Map<String, List<ControlProcessRowInfo>> collect = rowInfos.stream().collect(Collectors.groupingBy(k -> k.getApplication().getNumber() + "-" + k.getBill().getNumber() + "-" + k.getPriority()));
        for (List<ControlProcessRowInfo> value : collect.values()) {
            if (value.size() <= 1) continue;
            return ResManager.loadResFormat((String)"%1\u7684\u4f18\u5148\u7ea7\u91cd\u590d\u3002", (String)"ControlProcessAddPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{value.get(0).getBill().getName()});
        }
        return null;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("copyentryrow".equals(opType)) {
            try {
                int rowindex = this.getInfo().getRowInfos().size() - 1;
                ControlProcessRowInfo rowInfo = this.getInfo().getRowInfos().get(rowindex);
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowindex);
                if (rowInfo != null) {
                    entryRowEntity.set("priority", (Object)rowInfo.getPriority());
                }
            }
            catch (Exception e) {
                log.info("afterDoOperation-error{}", (Object)e);
            }
            this.getView().updateView(ENTRYENTITY);
        }
        if ("copyentryrow".equals(opType) || "deleteentry".equals(opType)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int size = this.getInfo().getRowInfos().size();
            entryGrid.selectRows(size - 1);
            entryGrid.focusCell(size - 1, "bill");
        }
    }
}

