/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.controlprocess.replace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.epm.eb.business.controlprocess.ControlProcessParasUtil;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.enums.ControlProcessParaEnum;
import kd.epm.eb.formplugin.control.controlprocess.replace.BillObject;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessConstant;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessRowInfo;
import kd.epm.eb.formplugin.control.controlprocess.replace.SimpleObject;

public class ControlProcessInfo
implements Serializable {
    private SimpleObject baseInfo;
    private List<ControlProcessRowInfo> rowInfos;
    private static final long serialVersionUID = -625391775964266910L;

    public SimpleObject getBaseInfo() {
        return this.baseInfo;
    }

    public void setBaseInfo(SimpleObject baseInfo) {
        this.baseInfo = baseInfo;
    }

    public List<ControlProcessRowInfo> getRowInfos() {
        return this.rowInfos;
    }

    public void setRowInfos(List<ControlProcessRowInfo> rowInfos) {
        this.rowInfos = rowInfos;
    }

    public ControlProcessRowInfo getRowInfo(int index) {
        return this.rowInfos.get(index);
    }

    public static ControlProcessInfo convertTo(DynamicObject doj) {
        ControlProcessInfo info = new ControlProcessInfo();
        Map regBills = ControlProcessParasUtil.getAllRegBills();
        DynamicObjectCollection allbills = ControlProcessParasUtil.queryBills();
        ArrayList<ControlProcessRowInfo> rowInfos = new ArrayList<ControlProcessRowInfo>(16);
        ArrayList<Long> existbillid = new ArrayList<Long>(16);
        if (doj != null) {
            info.setBaseInfo(new SimpleObject(doj.getLong("id"), doj.getString("name"), doj.getString("number")));
            DynamicObjectCollection entryentity = doj.getDynamicObjectCollection("entryentity");
            entryentity.sort(Comparator.comparing(o -> o.getDynamicObject("bill").getString("number")));
            for (DynamicObject children : entryentity) {
                ControlProcessRowInfo rowInfo = new ControlProcessRowInfo();
                long billid = children.getLong("bill.id");
                String billName = children.getString("bill.name");
                String billNumber = children.getString("bill.number");
                boolean billisfromouter = children.getBoolean("bill.isfromouter");
                rowInfo.setBill(new BillObject(billid, billName, billNumber, billisfromouter));
                existbillid.add(billid);
                long appId = children.getLong("application.id");
                String appName = children.getString("application.name");
                String appNumber = children.getString("application.number");
                boolean appisfromouter = children.getBoolean("bill.isfromouter");
                rowInfo.setApplication(new BillObject(appId, appName, appNumber, appisfromouter));
                rowInfo.setWriteOffs(children.getBoolean("writeoffs"));
                rowInfo.setWriteOffsField(children.getString("writeoffsfield"));
                rowInfo.setWriteOffsFieldName(children.getString("writeoffsfieldcn"));
                rowInfo.setWriteoffscheme(children.getLong("writeoffscheme.id"));
                rowInfo.setWriteoffschemecn(children.getString("writeoffschemecn"));
                rowInfo.setSerqfilter(children.getString("serqfilter"));
                rowInfo.setCondition(children.getString("condition"));
                rowInfo.setPriority(children.getString("priority"));
                Map maps = (Map)regBills.get(billid);
                if (maps == null) continue;
                for (String col : ControlProcessConstant.cols) {
                    String oppnumber;
                    List paraInfos;
                    String colvalue;
                    BillFieldTypeEmum billfield = ControlProcessParaEnum.getFieldtype((String)col);
                    if (billfield == null || (colvalue = children.getString(col)) == null || colvalue.isEmpty() || (paraInfos = (List)maps.get(oppnumber = billfield.getNumber())) == null) continue;
                    String replace = colvalue.replace("\uff0c", ",");
                    String[] colvalus = replace.split(",");
                    List<String> values = Arrays.asList(colvalus);
                    List<SimpleObject> collect = paraInfos.stream().filter(k -> values.contains(k.getNumber())).map(k -> new SimpleObject(k.getFid(), k.getName(), k.getNumber())).collect(Collectors.toList());
                    if (collect.isEmpty()) continue;
                    rowInfo.setCell(col, collect);
                }
                rowInfos.add(rowInfo);
            }
        }
        for (DynamicObject bill : allbills) {
            if (existbillid.contains(bill.getLong("id"))) continue;
            ControlProcessRowInfo nullrowInfo = new ControlProcessRowInfo();
            long billid = bill.getLong("id");
            String billname = bill.getString("name");
            String billnumber = bill.getString("number");
            boolean billisfromouter = bill.getBoolean("isfromouter");
            long appid = bill.getLong("parent.id");
            String appname = bill.getString("parent.name");
            String appnumber = bill.getString("parent.number");
            boolean appisfromouter = bill.getBoolean("parent.isfromouter");
            nullrowInfo.setBill(new BillObject(billid, billname, billnumber, billisfromouter));
            nullrowInfo.setApplication(new BillObject(appid, appname, appnumber, appisfromouter));
            nullrowInfo.setWriteOffs(false);
            rowInfos.add(nullrowInfo);
        }
        info.setRowInfos(rowInfos);
        return info;
    }

    public void putInModel(IDataModel model, IFormView view) {
        if (this.baseInfo != null) {
            model.setValue("number", (Object)this.baseInfo.getNumber());
            model.setValue("name", (Object)this.baseInfo.getName());
            model.setValue("pkid", (Object)this.baseInfo.getId());
        }
        if (this.rowInfos == null || this.rowInfos.isEmpty()) {
            return;
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", this.rowInfos.size());
        for (int i = 0; i < this.rowInfos.size(); ++i) {
            ControlProcessRowInfo rowInfo = this.rowInfos.get(i);
            DynamicObject entryobj = model.getEntryRowEntity("entryentity", i);
            rowInfo.putInRow(entryobj);
        }
        view.updateView("entryentity");
    }

    public void updateRowInfo(int row, String operation, List<SimpleObject> value) {
        this.rowInfos.get(row).getCells().put(operation, value);
    }

    public List<DynamicObject> createSaveEntry() {
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < this.rowInfos.size(); ++i) {
            DynamicObject saveEntry;
            ControlProcessRowInfo rowInfo = this.rowInfos.get(i);
            if (!rowInfo.needSave() || (saveEntry = rowInfo.createSaveEntry(i + 1)) == null) continue;
            saves.add(saveEntry);
        }
        return saves;
    }
}

