/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.controlprocess.replace;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.utils.OpBizRuleUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.lang3.StringUtils;

public class ControlProcessListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
CreateListDataProviderListener {
    private static String BAR_NEW = "barnew";
    private static String BAR_MODIFY = "barmodify";
    private final String BILLLIST = "billlistap";
    private static final Log log = LogFactory.getLog(ControlProcessListPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barnew": {
                this.openNewPage(BAR_NEW);
                break;
            }
            case "barmodify": {
                this.openNewPage(BAR_MODIFY);
                break;
            }
            case "barenable": {
                if (!this.checkAtListOneSelect()) break;
                this.setStatus(true);
                break;
            }
            case "bardisable": {
                this.bardisable();
                break;
            }
            case "bardelete": {
                this.bardelete();
                break;
            }
            case "barrefresh": {
                this.barrefresh();
                break;
            }
            case "barallocation": {
                this.barallocation();
                break;
            }
            case "controlcondition": {
                this.openControlCondition();
            }
        }
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    private void openNewPage(String type) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("eb_bgcontrolprocess");
        if (BAR_NEW.equals(type)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848", (String)"ControlProcessListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.setStatus(OperationStatus.ADDNEW);
        } else if (BAR_MODIFY.equals(type)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            if (billlist.getSelectedRows().size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ControlProcessListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (billlist.getSelectedRows().getPrimaryKeyValues().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"ControlProcessListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter.setCustomParam("settingid", billlist.getSelectedRows().get(0).getPrimaryKeyValue());
            showParameter.setCaption(ResManager.loadKDString((String)"\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848", (String)"ControlProcessListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.setStatus(OperationStatus.EDIT);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "opennewpage");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cbe) {
        String actionId;
        super.closedCallBack(cbe);
        switch (actionId = cbe.getActionId()) {
            case "opennewpage": {
                String result = (String)cbe.getReturnData();
                if (!StringUtils.equals((CharSequence)result, (CharSequence)"saveandnew")) break;
                this.openNewPage(BAR_NEW);
                break;
            }
        }
        this.barrefresh();
    }

    public void setStatus(boolean status) {
        DynamicObject[] alls;
        BillList billList = (BillList)this.getControl("billlistap");
        DynamicObject rptadjust = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolprocess");
        for (DynamicObject all : alls = (DynamicObject[])BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (IDataEntityType)rptadjust.getDataEntityType())) {
            if (status) {
                all.set("enable", (Object)1);
                continue;
            }
            all.set("enable", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])alls);
        this.writeLog("update", new MultiLangEnumBridge("\u4fee\u6539", "ControlProcessListPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u4fee\u6539\u6210\u529f\u3002", "ControlProcessListPlugin_5", "epm-eb-formplugin"));
        OpBizRuleUtils.updateOpBizRule();
        if (status) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"ControlProcessListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"ControlProcessListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.barrefresh();
    }

    private void barrefresh() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    private void bardisable() {
        if (this.checkAtListOneSelect()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u53ef\u80fd\u4f1a\u5bfc\u81f4\u63a7\u5236\u5f02\u5e38\uff0c\u662f\u5426\u786e\u8ba4\u7981\u7528\uff1f", (String)"ControlProcessListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("bardisable"));
        }
    }

    private void bardelete() {
        if (this.checkAtListOneSelect()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u53ef\u80fd\u5bfc\u81f4\u63a7\u5236\u5f02\u5e38\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ControlProcessListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("doDelete"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (actionId) {
            case "doDelete": {
                this.doDelete();
                break;
            }
            case "bardisable": {
                this.setStatus(false);
                break;
            }
        }
    }

    private void doDelete() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList == null) {
            return;
        }
        Object[] ids = billList.getSelectedRows().getPrimaryKeyValues();
        DynamicObject[] alls = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)billList.getEntityType());
        HashSet<Long> hasDimmateIds = new HashSet<Long>(10);
        QFilter filter = new QFilter("controlprocess.fbasedataid", "in", (Object)Sets.newHashSet((Object[])ids));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryrefprocess", (String)"eb_adddimmaterule", (String)"controlprocess.fbasedataid", (QFilter[])filter.toArray(), null);){
            while (ds != null && ds.hasNext()) {
                hasDimmateIds.add(ds.next().getLong("controlprocess.fbasedataid"));
            }
        }
        Object[] allEntryIds = billList.getSelectedRows().getEntryPrimaryKeyValues();
        ArrayList<String> messages = new ArrayList<String>(10);
        for (DynamicObject all : alls) {
            DynamicObjectCollection entryentity = all.getDynamicObjectCollection("entryentity");
            ListIterator iter = entryentity.listIterator();
            DynamicObjectCollection copy_beforeEntryentity = new DynamicObjectCollection();
            while (iter.hasNext()) {
                DynamicObject next = (DynamicObject)iter.next();
                copy_beforeEntryentity.add((Object)next);
                for (Object allEntryId : allEntryIds) {
                    boolean status = true;
                    if (!allEntryId.equals(next.getLong("id")) || !status) continue;
                    iter.remove();
                    status = false;
                }
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            log.info("\u5f00\u59cb\u5220\u9664\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848");
            try {
                ArrayList<Long> deleteIds = new ArrayList<Long>(16);
                ArrayList<DynamicObject> savez = new ArrayList<DynamicObject>(16);
                for (DynamicObject all : alls) {
                    if (all.getDynamicObjectCollection("entryentity").size() == 0) {
                        if (hasDimmateIds.contains(all.getLong("id"))) {
                            messages.add(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0:\u8be5\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u5df2\u88ab\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u5f15\u7528\u3002", (String)"ControlProcessListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{all.getString("number")}));
                            continue;
                        }
                        deleteIds.add(all.getLong("id"));
                        continue;
                    }
                    savez.add(all);
                }
                SaveServiceHelper.save((DynamicObject[])savez.toArray(new DynamicObject[0]));
                if (deleteIds.size() > 0) {
                    DeleteServiceHelper.delete((IDataEntityType)billList.getEntityType(), (Object[])deleteIds.toArray());
                    DeleteServiceHelper.delete((String)"eb_bgcontrolprocessorg", (QFilter[])new QFilter("controlprocess.id", "in", deleteIds).toArray());
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "ControlProcessListPlugin_6", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664%1$s\u5f20\u5355\u636e\u6210\u529f\u3002", "ControlProcessListPlugin_7", "epm-eb-formplugin"), new String[]{deleteIds.size() + ""});
                }
            }
            catch (Exception e) {
                log.info("\u5220\u9664\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u5931\u8d25");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u5931\u8d25", "DimensionRelationListPlugin_6", "epm-eb-formplugin");
                this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "ControlProcessListPlugin_6", "epm-eb-formplugin"), opDesc);
                tx.markRollback();
            }
        }
        OpBizRuleUtils.updateOpBizRule();
        this.barrefresh();
        if (!messages.isEmpty()) {
            this.getView().showTipNotification(String.join((CharSequence)"\r\n", messages));
        }
    }

    private boolean checkAtListOneSelect() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows().size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ControlProcessListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void barallocation() {
        BillList billlist = (BillList)this.getControl("billlistap");
        if (billlist.getSelectedRows().size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ControlProcessListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (billlist.getSelectedRows().getPrimaryKeyValues().length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"ControlProcessListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_import_bgorg");
        showParameter.setCustomParam("settingid", billlist.getSelectedRows().get(0).getPrimaryKeyValue());
        showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7", (String)"ControlProcessListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String ASSIGNORG = "ASSIGNORG";
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ASSIGNORG);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                if (allRows.size() > 0 && ((DynamicObject)allRows.get(0)).containsProperty("entryentity")) {
                    allRows.sort(Comparator.comparing(o -> o.getString("number")).thenComparing(o -> {
                        DynamicObject dynamicObject = o.getDynamicObject("entryentity.bill");
                        return dynamicObject == null ? "" : dynamicObject.getString("number");
                    }));
                }
                ArrayList rowIds = new ArrayList(16);
                allRows.forEach(row -> rowIds.add(row.getLong("id")));
                QFilter qEntryentityId = new QFilter("controlprocess", "in", rowIds);
                DynamicObjectCollection dy = QueryServiceHelper.query((String)"eb_bgcontrolprocessorg", (String)"org.id as orgId,org.name as orgName,controlprocess.id,id", (QFilter[])new QFilter[]{qEntryentityId});
                HashMap orgRanges = new HashMap(16);
                dy.forEach(allotRecord -> {
                    String entryentityId = allotRecord.getString("controlprocess.id");
                    String orgName = allotRecord.getString("orgName");
                    if (orgRanges.containsKey(entryentityId)) {
                        orgRanges.put(entryentityId, (String)orgRanges.get(entryentityId) + "," + orgName);
                    } else {
                        orgRanges.put(entryentityId, orgName);
                    }
                });
                List<String> operationAndValue = Arrays.asList(BillFieldTypeEmum.TAKEOPERATION.getNumber(), BillFieldTypeEmum.RUNOPERATION.getNumber(), BillFieldTypeEmum.CONTROLVALUE.getNumber(), BillFieldTypeEmum.RETURNOPERATION.getNumber(), BillFieldTypeEmum.CLEAROPERATION.getNumber());
                Map fields = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolbizreg", (String)"id,number,name,fieldtable,type", (QFilter[])new QFilter[]{new QFilter("type", "in", operationAndValue)});
                HashMap<String, Map<String, String>> fieldMaps = new HashMap<String, Map<String, String>>(16);
                try {
                    fieldMaps.putAll(fields.values().stream().filter(k -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{k.getString("fieldtable"), k.getString("type"), k.getString("number")})).collect(Collectors.groupingBy(k -> k.getString("fieldtable"), Collectors.toMap(n -> n.getString("number"), m -> {
                        if (StringUtils.isNotEmpty((CharSequence)m.getString("name"))) {
                            return m.getString("name") != null ? m.getString("name") : "";
                        }
                        return m.getLocaleString("name") != null && m.getLocaleString("name").getLocaleValue_zh_CN() != null ? m.getLocaleString("name").getLocaleValue_zh_CN() : "";
                    }, (x, y) -> y))));
                }
                catch (Exception e) {
                    log.error("processerror", (Throwable)e);
                }
                List<String> fieldList = Arrays.asList("takeoperation", "takevalue", "runoperation", "runvalue", "returnoperation", "clearoperation");
                allRows.forEach(row -> {
                    String settingIds = row.getString("id");
                    String orgRange = (String)orgRanges.get(settingIds);
                    row.set("org", (Object)orgRange);
                    try {
                        String fieldTable;
                        Map filedMap;
                        if (row.getDynamicObject("entryentity.bill") != null && (filedMap = (Map)fieldMaps.get(fieldTable = row.getDynamicObject("entryentity.bill").getString("fieldtable"))) != null) {
                            for (String s : fieldList) {
                                String filedStr;
                                String fieldKey = "entryentity." + s.toLowerCase();
                                String field = row.getString(fieldKey);
                                if (!StringUtils.isNotEmpty((CharSequence)field) || !StringUtils.isNotEmpty((CharSequence)(filedStr = Arrays.stream(field.split(",")).map(k -> (String)filedMap.get(k)).collect(Collectors.joining(","))))) continue;
                                row.set(fieldKey, (Object)filedStr);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("error,", (Throwable)e);
                    }
                });
                return allRows;
            }
        });
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String currentClickRowEntryKey = this.getPageCache().get("currentClickRowEntryKey");
        if (currentClickRowEntryKey != null) {
            this.showOrgRangeInfoForm(currentClickRowEntryKey);
        }
    }

    public void showOrgRangeInfoForm(String settingid) {
        QFilter f1 = new QFilter("controlprocess", "=", (Object)settingid);
        DynamicObjectCollection orgRange = QueryServiceHelper.query((String)"eb_bgcontrolprocessorg", (String)"org.id as orgId,org.name as orgName,controlprocess.id,id", (QFilter[])new QFilter[]{f1});
        ArrayList orgIds = new ArrayList(16);
        orgRange.forEach(org -> {
            String id = org.getString("orgId");
            orgIds.add(id);
        });
        FormShowParameter formShow = new FormShowParameter();
        formShow.setCustomParam("orgIds", orgIds);
        formShow.setFormId("eb_ruleallotorginfo");
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShow);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        ListSelectedRow currentClickRow = evt.getCurrentListSelectedRow();
        String value = currentClickRow == null ? null : String.valueOf(currentClickRow);
        this.getPageCache().put("currentClickRowEntryKey", value);
    }

    private void openControlCondition() {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId("eb_controlcondition");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setShowTitle(Boolean.FALSE.booleanValue());
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

