/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.controlprocess.replace;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterResult;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.gridfilter.CommonFilter;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.controlprocess.replace.BillObject;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessInfo;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessRowInfo;

public class SuitCondPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
CommonFilter {
    private static final String FilterGridAp = "filtergridap";
    private ControlProcessInfo info;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        String filterjson = (String)this.getView().getFormShowParameter().getCustomParam("filterjson");
        FilterGrid filterGrid = (FilterGrid)this.getControl(FilterGridAp);
        if (StringUtils.isNotBlank((CharSequence)filterjson)) {
            FlexBDValueCondition fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)filterjson, FlexBDValueCondition.class);
            List filterColumns = filterGrid.getFilterColumns();
            for (SimpleFilterRow simpleFilterRow : fc.getFilterCondition().getFilterRow()) {
                try {
                    Optional<Map> findAny;
                    if (!filterColumns.stream().noneMatch(k -> k.getOrDefault("fieldName", "").toString().equals(simpleFilterRow.getFieldName())) || !(findAny = filterGrid.getFilterColumns().stream().filter(k -> (k.getOrDefault("entryEntity", "") + "." + simpleFilterRow.getFieldName()).equals(k.getOrDefault("fieldName", ""))).findFirst()).isPresent()) continue;
                    simpleFilterRow.setFieldName(findAny.get().getOrDefault("fieldName", "").toString());
                }
                catch (Exception exception) {}
            }
            filterGrid.SetValue(fc.getFilterCondition());
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        this.createFilterGrid();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!StringUtils.isEmpty((CharSequence)this.getControlProcess().getPriority())) {
            this.getModel().setValue("prioritycn", (Object)this.getControlProcess().getPriority());
        } else {
            this.loadPriotity();
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("btnok".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FilterGridAp);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            if (filterCondition.getFilterRow().isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u63a7\u5236\u6761\u4ef6\u8bbe\u7f6e\u662f\u5426\u89c4\u8303\u3002", (String)"SuitCondPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (filterCondition.getFilterRow().size() > 10) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e10\u4e2a\u63a7\u5236\u6761\u4ef6\u3002", (String)"SuitCondPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("baseformid");
            FilterBuilder filterBuilder = ConditionUtils.get().getFilterBuilder(formId, filterCondition);
            FilterResult filterResult = filterBuilder.getFilterObject().getFilterResult();
            String filter = filterResult.getFilterGroup()[0];
            FlexBDValueCondition flexPropertyCon = new FlexBDValueCondition();
            flexPropertyCon.setDescription(new LocaleString(filter));
            flexPropertyCon.setFilterCondition(filterCondition);
            flexPropertyCon.setExpression((String)this.getModel().getValue("expression"));
            String condition = SerializationUtils.toJsonString((Object)flexPropertyCon);
            ControlProcessRowInfo controlProcess = this.getControlProcess();
            if (filter.length() > 50) {
                controlProcess.setCondition(filter.substring(0, 45) + "...");
            } else {
                controlProcess.setCondition(filter);
            }
            controlProcess.setSerqfilter(condition);
            controlProcess.setPriority(String.valueOf(this.getModel().getValue("prioritycn")));
            this.cacheInfo();
            this.checkPriority();
            HashMap<String, Object> returnvalue = new HashMap<String, Object>(16);
            int index = (Integer)this.getFormCustomParam("clickrow");
            String clickkey = (String)this.getFormCustomParam("clickkey");
            returnvalue.put("clickkey", clickkey);
            returnvalue.put("clickrow", index);
            this.getView().returnDataToParent(returnvalue);
            this.getView().close();
        }
    }

    private void createFilterGrid() {
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String formId = (String)paramter.getCustomParam("baseformid");
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            this.filterGridSetFieldColumns(FilterGridAp, formId);
        }
    }

    private void filterGridSetFieldColumns(String controlKey, String entityNumber) {
        try {
            FilterGrid filterGrid = (FilterGrid)this.getControl(controlKey);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            filterGrid.setEntityNumber(entityType.getName());
            List filterColumns = this.getFilterFields(entityType);
            filterGrid.setFilterColumns(filterColumns);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public ControlProcessInfo getInfo() {
        if (this.info == null) {
            IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            String s = pageCache.get("controlprocessinfo");
            this.info = (ControlProcessInfo)SerializationUtils.deSerializeFromBase64((String)s);
        }
        return this.info;
    }

    public void cacheInfo() {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("controlprocessinfo", SerializationUtils.serializeToBase64((Object)this.info));
    }

    private ControlProcessRowInfo getControlProcess() {
        int index = (Integer)this.getFormCustomParam("clickrow");
        return this.getInfo().getRowInfo(index);
    }

    public Set<String> getRegistField(String entityNumber) {
        String selectFields = "name,id,number";
        QFilter qcf = new QFilter("type", "=", (Object)BillFieldTypeEmum.REGSITFIELD.getNumber()).and("fieldtable", "=", (Object)entityNumber);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)selectFields, (QFilter[])new QFilter[]{qcf});
        Set<String> colSets = query.stream().map(k -> k.getString("number")).collect(Collectors.toSet());
        return colSets;
    }

    private void loadPriotity() {
        BillObject bill = this.getControlProcess().getBill();
        String entityNumber = bill.getNumber();
        List rowInfos = this.getInfo().getRowInfos().stream().filter(row -> entityNumber.equals(row.getBill().getNumber())).collect(Collectors.toList());
        for (int i = 1; i <= 4; ++i) {
            String settingPriotity = String.valueOf(i);
            if (!rowInfos.stream().noneMatch(k -> !StringUtils.isEmpty((CharSequence)k.getPriority()) && settingPriotity.equals(k.getPriority()))) continue;
            this.getModel().setValue("prioritycn", (Object)settingPriotity);
            break;
        }
    }

    private void checkPriority() {
        BillObject bill = this.getControlProcess().getBill();
        String entityNumber = bill.getNumber();
        String appnumber = this.getControlProcess().getApplication().getNumber();
        Object prioritycn = this.getModel().getValue("prioritycn");
        List<ControlProcessRowInfo> rowInfos = this.getInfo().getRowInfos();
        for (int i = 0; i < rowInfos.size(); ++i) {
            int clickrow;
            if (!entityNumber.equals(rowInfos.get(i).getBill().getNumber()) || !appnumber.equals(rowInfos.get(i).getApplication().getNumber()) || i == (clickrow = ((Integer)this.getFormCustomParam("clickrow")).intValue()) || !prioritycn.equals(rowInfos.get(i).getPriority())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8c03\u6574\u4f18\u5148\u7ea7\uff0c\u5b58\u5728\u76f8\u540c\u4f18\u5148\u7ea7\u6392\u5e8f\u3002", (String)"SuitCondPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

