/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.controlprocess.replace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.controlprocess.replace.BillObject;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessInfo;
import kd.epm.eb.formplugin.control.controlprocess.replace.ControlProcessRowInfo;
import kd.epm.eb.formplugin.control.controlprocess.replace.SimpleObject;

public class WriteoffSchemePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ListRowClickListener {
    private static final String ADD_SCHEME = "addscheme";
    private static final String EDIT_SCHEME = "editscheme";
    private static final String DEL_SCHEME = "delscheme";
    private static final String SAVE_ROW = "saverow";
    private static final String ADD_ROW = "addrow";
    private static final String DEL_ROW = "delrow";
    private static final String BILLLIST = "billlistap";
    private static final String ENTRY = "entryentity";
    private static final String billF7 = "writeoffbill";
    private static final String SOURCEBILL = "writeoffsourcebill";
    private static final String DETAIL_ENTITY = "writeoffentry";
    private static final String FROMVALUE = "writeoffvalue";
    private static final String SOURCEBILLENTRY = "writeoffsourcebillentry";
    private static final List<String> VAL_OF_CONTROL = Arrays.asList("writeoffsourcebill", "writeoffentry", "writeoffvalue", "writeoffsourcebillentry");
    private static final String cache_select_scheme = "cache_select_scheme";
    private static final String CANCEL = "cancel";
    private static final String CONFIRM = "confirm";
    private static final String SELECTFIELDS = "id,writeoffinfo,writeoffinfo.writeoffbill,writeoffinfo.writeoffsourcebill,writeoffinfo.writeoffentry,writeoffinfo.writeofftype,writeoffinfo.writeoffvalue,writeoffinfo.writeoffsourcebillentry,writeoffinfo.writeoffsourcebill.name,writeoffinfo.writeoffentry.name,writeoffinfo.writeoffvalue.name,writeoffinfo.writeoffsourcebillentry.name";
    private static final String[] keys = new String[]{"writeoffbill.id", "writeoffsourcebill.id", "writeoffentry.id", "writeofftype", "writeoffvalue.id", "writeoffsourcebillentry.id", "writeoffbill.id", "writeoffsourcebillid", "writeoffentryid", "writeofftype", "writeoffvalueid", "writeoffsourcebillentryid"};
    private ControlProcessInfo info;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_SCHEME, EDIT_SCHEME, DEL_SCHEME, SAVE_ROW, ADD_ROW, DEL_ROW, SOURCEBILL, DETAIL_ENTITY, FROMVALUE, SOURCEBILLENTRY, CANCEL, CONFIRM, "upgrade"});
        this.addF7SelectListener(this, new String[]{billF7});
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent event) {
                QFilter qFilter = new QFilter("bill", "=", (Object)WriteoffSchemePlugin.this.getControlProcess().getBill().getId());
                event.getQFilters().add(qFilter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillList();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long selectwriteoffscheme = IDUtils.toLong(this.getFormCustomParam("selectwriteoffscheme"));
        this.selectSchemeRow(selectwriteoffscheme);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (ADD_SCHEME.equals(key) || EDIT_SCHEME.equals(key)) {
            HashMap<String, Object> openParameter = new HashMap<String, Object>(4);
            openParameter.put("formId", "eb_writeoffscheme_pro");
            Long id = this.getControlProcess().getBill().getId();
            openParameter.put("bill", id);
            if (EDIT_SCHEME.equals(key)) {
                Long selectedScheme = this.getSelectedScheme();
                if (selectedScheme == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"WriteoffSchemePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                openParameter.put("pkId", String.valueOf(selectedScheme));
                openParameter.put("Status", String.valueOf(OperationStatus.EDIT.getValue()));
            }
            FormShowParameter form = BaseShowParameter.createFormShowParameter(openParameter);
            form.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key + "win");
            form.setCloseCallBack(closeCallBack);
            this.getView().showForm(form);
        } else if (DEL_SCHEME.equals(key)) {
            Set ids;
            String parent;
            Long selectedScheme = this.getSelectedScheme();
            if (selectedScheme == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (QueryServiceHelper.exists((String)"eb_bgcontrolprocess", (QFilter[])new QFilter[]{new QFilter("entryentity.writeoffscheme", "=", (Object)selectedScheme)})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u5f15\u7528\u6b64\u51b2\u9500\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WriteoffSchemePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (QueryServiceHelper.exists((String)"eb_adddimmaterule", (QFilter[])new QFilter[]{new QFilter("cardentity.writeoffscheme", "=", (Object)selectedScheme)})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u5f15\u7528\u6b64\u51b2\u9500\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WriteoffSchemePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String json = (String)this.getCustomFormParam("hasselectwriteoffschemes");
            String string = parent = this.getView().getParentView() != null ? this.getView().getParentView().getFormShowParameter().getCaption() : null;
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)json) && kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)parent) && (ids = (Set)JSONUtils.parse((String)json, Set.class)) != null && ids.contains(String.valueOf(selectedScheme))) {
                this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u5df2\u6709%1\u9875\u9762\u5f15\u7528\u6b64\u51b2\u9500\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WriteoffSchemePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{parent}));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u6b64\u65b9\u6848\u5417\uff1f", (String)"WriteoffSchemePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_confirm", (IFormPlugin)this));
        } else if (ADD_ROW.equals(key)) {
            if (this.getSelectedScheme() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().createNewEntryRow(ENTRY);
        } else if (DEL_ROW.equals(key)) {
            if (this.getSelectedScheme() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
            if (entryGrid.getSelectRows().length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"WriteoffSchemePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            int focusRow = entryGrid.getEntryState().getFocusRow();
            this.getModel().deleteEntryRow(ENTRY, focusRow);
        } else if (VAL_OF_CONTROL.contains(key)) {
            if (SOURCEBILLENTRY.equals(key)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
                int focusRow = entryGrid.getEntryState().getFocusRow();
                DynamicObject writeoffbill = Optional.ofNullable(this.getModel().getValue(billF7, focusRow)).map(dyna -> (DynamicObject)dyna).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u5355\u636e\u3002", (String)"WriteoffSchemePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0])));
                this.getPageCache().put("entryfocusid", writeoffbill.getString("id"));
                this.getPageCache().put("entryfocusname", writeoffbill.getString("name"));
            } else {
                Long sourceBillId = this.getControlProcess().getBill().getId();
                this.getPageCache().put("entryfocusid", String.valueOf(sourceBillId));
                this.getPageCache().put("entryfocusname", this.getControlProcess().getBill().getName());
            }
            this.openOperationSelectForm(key);
        } else if (SAVE_ROW.equals(key)) {
            if (this.getSelectedScheme() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveRows();
        } else if (CANCEL.equals(key)) {
            if (this.checkchanged().booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u7f16\u8f91\u65b9\u6848\u7684\u51b2\u9500\u4fe1\u606f\uff1f", (String)"WriteoffSchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save_confirm", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        } else if (CONFIRM.equals(key)) {
            Long selectedScheme = this.getSelectedScheme();
            if (selectedScheme == 0L && !this.isCanEmpty().booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkchanged().booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u7f16\u8f91\u65b9\u6848\u7684\u51b2\u9500\u4fe1\u606f\uff1f", (String)"WriteoffSchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save_confirm2", (IFormPlugin)this));
            } else {
                this.confirmScheme();
                this.getView().close();
            }
        } else if ("upgrade".equals(key)) {
            WriteoffSchemePlugin.saveWriteOffCol(WriteoffSchemePlugin.GETBILLUPDAGRADESCHEME());
            WriteoffSchemePlugin.savePresetScheme();
            this.getView().showTipNotification("upgrade sucess !");
        }
    }

    private void confirmScheme() {
        boolean isnoformprocess = this.isNoFromProcess();
        Long schemeId = this.getSelectedScheme();
        ControlProcessRowInfo controlProcess = this.getControlProcess();
        controlProcess.setWriteoffscheme(schemeId);
        if (IDUtils.isNotNull((Long)schemeId)) {
            DynamicObject schemeDyn = QueryServiceHelper.queryOne((String)"eb_writeoffscheme_pro", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
            String schemeName = Optional.ofNullable(schemeDyn).map(dyn -> dyn.getString("name")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            controlProcess.setWriteoffschemecn(schemeName);
        }
        this.cacheInfo();
        HashMap<String, Object> returnvalue = new HashMap<String, Object>(16);
        if (!isnoformprocess) {
            int index = (Integer)this.getFormCustomParam("clickrow");
            String clickkey = (String)this.getFormCustomParam("clickkey");
            returnvalue.put("clickkey", clickkey);
            returnvalue.put("clickrow", index);
        } else {
            returnvalue.put("selectwriteoffscheme", schemeId);
        }
        this.getView().returnDataToParent(returnvalue);
    }

    private Boolean isNoFromProcess() {
        return Convert.toBool(this.getFormCustomParam("isnofromprocess"), (Boolean)false);
    }

    private Boolean isCanEmpty() {
        return Convert.toBool(this.getFormCustomParam("iscanempty"), (Boolean)false);
    }

    public ControlProcessInfo getInfo() {
        if (this.info == null) {
            IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            String s = pageCache.get("controlprocessinfo");
            this.info = (ControlProcessInfo)SerializationUtils.deSerializeFromBase64((String)s);
        }
        return this.info;
    }

    public void cacheInfo() {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("controlprocessinfo", SerializationUtils.serializeToBase64((Object)this.info));
    }

    private ControlProcessRowInfo getControlProcess() {
        if (this.isNoFromProcess().booleanValue()) {
            ControlProcessRowInfo info = new ControlProcessRowInfo();
            info.setBill(new BillObject((Long)this.getFormCustomParam("billid"), "", "", false));
            return info;
        }
        int index = (Integer)this.getFormCustomParam("clickrow");
        return this.getInfo().getRowInfo(index);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (billF7.equals(key)) {
            Long schemeId = this.getSelectedScheme();
            if (schemeId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qFilter = new QFilter("billtype", "=", (Object)BgBillTreeTypeEnum.BILL.getNumber());
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (billF7.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            if (this.getModel().getValue(SOURCEBILLENTRY, focusRow) != null) {
                this.getModel().setValue(SOURCEBILLENTRY, null, focusRow);
                this.getModel().setValue("writeoffsourcebillentryid", (Object)0L, focusRow);
            }
        } else if (VAL_OF_CONTROL.contains(key) && "".equals(e.getChangeSet()[0].getNewValue())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY, focusRow);
            entryRowEntity.set(key, null);
            entryRowEntity.set(key + "id", (Object)0L);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnvalue;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.endsWith("win")) {
            this.refreshBillList();
            Object rets = null;
            rets = closedCallBackEvent.getReturnData();
            if (rets != null && rets instanceof List) {
                Long pkid = Optional.ofNullable(rets).filter(ret -> ((List)ret).size() > 0).map(pk -> IDUtils.toLong(((List)pk).get(0))).orElse(0L);
                this.selectSchemeRow(pkid);
            }
        } else if (actionId.endsWith("select_field_callback") && (returnvalue = (Map)closedCallBackEvent.getReturnData()) != null) {
            Integer row = (Integer)returnvalue.get("clickrow");
            String clickkey = (String)returnvalue.get("clickkey");
            List shows = (List)returnvalue.get("value");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY, row.intValue());
            if (!CollectionUtils.isEmpty((Collection)shows)) {
                entryRowEntity.set(clickkey, (Object)((SimpleObject)shows.get(0)).getName());
                entryRowEntity.set(clickkey + "id", (Object)((SimpleObject)shows.get(0)).getId());
            } else {
                entryRowEntity.set(clickkey, null);
                entryRowEntity.set(clickkey + "id", (Object)0L);
            }
            this.getView().updateView(ENTRY);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentClickRow = evt.getCurrentListSelectedRow();
        String primaryKeyValue = Optional.ofNullable(currentClickRow).map(ListSelectedRow::getPrimaryKeyValue).map(String::valueOf).orElse(null);
        Long schemeId = this.getSelectedScheme();
        if (!schemeId.equals(IDUtils.toLong((Object)primaryKeyValue)) && this.checkchanged().booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u7f16\u8f91\u65b9\u6848\u7684\u51b2\u9500\u4fe1\u606f\uff1f", (String)"WriteoffSchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("switch_scheme", (IFormPlugin)this));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        this.getPageCache().put(cache_select_scheme, primaryKeyValue);
        this.refreshEntry();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        billList.setFilter(new QFilter("bill", "=", (Object)this.getControlProcess().getBill().getId()));
        billList.clearSelection();
        billList.refresh();
    }

    private void openOperationSelectForm(String key) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY);
        FormShowParameter form = new FormShowParameter();
        form.setFormId("eb_fieldselect");
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCustomParam("clickrow", (Object)entryGrid.getSelectRows()[0]);
        form.setCustomParam("clickkey", (Object)key);
        form.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u53d6\u503c\u5b57\u6bb5", (String)"ControlProcessAddPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        form.setCustomParam("onlyOne", (Object)"true");
        this.extracted(key, entryGrid, form);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "select_field_callback");
        form.setCloseCallBack(closeCallBack);
        this.getView().showForm(form);
    }

    private void saveRows() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY);
        Long schemeId = this.getSelectedScheme();
        if (schemeId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51b2\u9500\u65b9\u6848\u3002", (String)"WriteoffSchemePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_writeoffscheme_pro");
        schemeDyn.set("id", (Object)schemeId);
        DynamicObjectCollection dynamicObjectCollection = schemeDyn.getDynamicObjectCollection("writeoffinfo");
        dynamicObjectCollection.clear();
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY, i);
            if (IDUtils.isNotEmptyLong((Long)entryRowEntity.getLong("id")).booleanValue()) {
                dynamicObject.set("id", (Object)entryRowEntity.getLong("id"));
            }
            Boolean check = Boolean.TRUE;
            if (entryRowEntity.get(billF7) != null) {
                dynamicObject.set(billF7, (Object)entryRowEntity.getDynamicObject(billF7).getLong("id"));
            } else {
                check = Boolean.FALSE;
            }
            if (IDUtils.isNotEmptyLong((Long)entryRowEntity.getLong("writeoffsourcebillid")).booleanValue()) {
                dynamicObject.set(SOURCEBILL, (Object)entryRowEntity.getLong("writeoffsourcebillid"));
            } else {
                check = Boolean.FALSE;
            }
            if (IDUtils.isNotEmptyLong((Long)entryRowEntity.getLong("writeoffentryid")).booleanValue()) {
                dynamicObject.set(DETAIL_ENTITY, (Object)entryRowEntity.getLong("writeoffentryid"));
            }
            if (entryRowEntity.get("writeofftype") != null) {
                dynamicObject.set("writeofftype", entryRowEntity.get("writeofftype"));
            } else {
                check = Boolean.FALSE;
            }
            if (IDUtils.isNotEmptyLong((Long)entryRowEntity.getLong("writeoffvalueid")).booleanValue()) {
                dynamicObject.set(FROMVALUE, (Object)entryRowEntity.getLong("writeoffvalueid"));
            } else {
                check = Boolean.FALSE;
            }
            if (IDUtils.isNotEmptyLong((Long)entryRowEntity.getLong("writeoffsourcebillentryid")).booleanValue()) {
                dynamicObject.set(SOURCEBILLENTRY, (Object)entryRowEntity.getLong("writeoffsourcebillentryid"));
            } else {
                check = Boolean.FALSE;
            }
            if (!check.booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u5fc5\u586b\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"WriteoffSchemePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
            }
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        List collect = dynamicObjectCollection.stream().map(k -> String.join((CharSequence)"-", k.getString(billF7), k.getString(SOURCEBILL), k.getString(DETAIL_ENTITY), k.getString("writeofftype"), k.getString(FROMVALUE), k.getString(SOURCEBILLENTRY))).distinct().collect(Collectors.toList());
        if (collect.size() != dynamicObjectCollection.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u51b2\u9500\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"WriteoffSchemePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDyn});
        if (schemeDyn != null && schemeDyn.getDynamicObject("bill") != null) {
            CacheServiceHelper.clearFieldsCache((String)schemeDyn.getDynamicObject("bill").getString("number"));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WriteoffSchemePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void refreshEntry() {
        this.getModel().deleteEntryData(ENTRY);
        Long schemeId = this.getSelectedScheme();
        if (schemeId != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
            DynamicObject[] writeoffs = BusinessDataServiceHelper.load((String)"eb_writeoffscheme_pro", (String)SELECTFIELDS, (QFilter[])new QFilter[]{qFilter});
            if (writeoffs.length < 1) {
                return;
            }
            DynamicObjectCollection dynamicObjectCol = writeoffs[0].getDynamicObjectCollection("writeoffinfo");
            for (int i = 0; i < dynamicObjectCol.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCol.get(i);
                int row = this.getModel().createNewEntryRow(ENTRY);
                DynamicObject model = this.getModel().getEntryRowEntity(ENTRY, row);
                model.set(billF7, (Object)dynamicObject.getDynamicObject(billF7));
                model.set(SOURCEBILL, (Object)dynamicObject.getString("writeoffsourcebill.name"));
                model.set(DETAIL_ENTITY, (Object)dynamicObject.getString("writeoffentry.name"));
                model.set("writeofftype", (Object)dynamicObject.getString("writeofftype"));
                model.set(FROMVALUE, (Object)dynamicObject.getString("writeoffvalue.name"));
                model.set(SOURCEBILLENTRY, (Object)dynamicObject.getString("writeoffsourcebillentry.name"));
                model.set("writeoffsourcebillid", (Object)dynamicObject.getLong("writeoffsourcebill.id"));
                model.set("writeoffentryid", (Object)dynamicObject.getLong("writeoffentry.id"));
                model.set("writeoffvalueid", (Object)dynamicObject.getLong("writeoffvalue.id"));
                model.set("writeoffsourcebillentryid", (Object)dynamicObject.getLong("writeoffsourcebillentry.id"));
            }
        }
        this.getView().updateView(ENTRY);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if ("delete_confirm".equals(confirmId)) {
            if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                Long schemeId = this.getSelectedScheme();
                DeleteServiceHelper.delete((String)"eb_writeoffscheme_pro", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WriteoffSchemePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.refreshBillList();
                if (this.getView().getParentView() != null) {
                    String deljson = this.getView().getParentView().getPageCache().get("deletewriteoffscheme");
                    Set<String> delids = new HashSet<String>(1);
                    if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)deljson)) {
                        delids = (Set)JSONUtils.parse((String)deljson, Set.class);
                    }
                    delids.add(String.valueOf(schemeId));
                    this.getView().getParentView().getPageCache().put("deletewriteoffscheme", JSONUtils.toString(delids));
                }
                this.getPageCache().remove(cache_select_scheme);
                this.refreshEntry();
            }
        } else if ("save_confirm".equals(confirmId)) {
            if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                this.saveRows();
            } else {
                this.getPageCache().put("close", "true");
            }
            this.getView().close();
        } else if ("save_confirm2".equals(confirmId)) {
            if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                this.saveRows();
            } else {
                this.getPageCache().put("close", "true");
            }
            this.confirmScheme();
            this.getView().close();
        } else if ("switch_scheme".equals(confirmId)) {
            if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                try {
                    this.saveRows();
                }
                catch (KDBizException e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WriteoffSchemePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            BillList billList = (BillList)this.getControl(BILLLIST);
            String pkid = Optional.ofNullable(billList.getSelectedRows()).filter(rows -> rows.size() > 0).map(row -> String.valueOf(row.get(0).getPrimaryKeyValue())).orElse(null);
            this.getPageCache().put(cache_select_scheme, pkid);
            this.refreshEntry();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.checkchanged().booleanValue() && !"true".equals(this.getPageCache().get("close"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u7f16\u8f91\u65b9\u6848\u7684\u51b2\u9500\u4fe1\u606f\uff1f", (String)"WriteoffSchemePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save_confirm", (IFormPlugin)this));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
        this.getPageCache().remove("close");
    }

    private Long getSelectedScheme() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        String cacheSchemeId = this.getPageCache().get(cache_select_scheme);
        return Optional.ofNullable(cacheSchemeId).map(v -> IDUtils.toLong((Object)cacheSchemeId)).orElseGet(() -> Optional.ofNullable(billList.getSelectedRows().size() > 0 ? billList.getSelectedRows().get(0) : null).map(b -> IDUtils.toLong((Object)b.getPrimaryKeyValue())).orElseGet(() -> 0L));
    }

    private Boolean checkchanged() {
        Long schemeId = this.getSelectedScheme();
        if (schemeId == 0L) {
            return Boolean.FALSE;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject[] writeoffs = BusinessDataServiceHelper.load((String)"eb_writeoffscheme_pro", (String)"id,writeoffinfo,writeoffinfo.writeoffbill,writeoffinfo.writeoffsourcebill,writeoffinfo.writeoffentry,writeoffinfo.writeofftype,writeoffinfo.writeoffvalue,writeoffinfo.writeoffsourcebillentry", (QFilter[])new QFilter[]{qFilter});
        if (writeoffs.length < 1) {
            return Boolean.FALSE;
        }
        DynamicObjectCollection dynamicObjectCollection = writeoffs[0].getDynamicObjectCollection("writeoffinfo");
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY);
        if (entryRowCount != dynamicObjectCollection.size()) {
            return Boolean.TRUE;
        }
        return Stream.iterate(0, x -> x + 1).limit(entryRowCount).anyMatch(row -> {
            DynamicObject pageRow = this.getModel().getEntryRowEntity(ENTRY, row.intValue());
            DynamicObject dataRow = (DynamicObject)dynamicObjectCollection.get(row.intValue());
            return Stream.iterate(0, y -> y + 1).limit(keys.length / 2).anyMatch(kid -> {
                String n = dataRow.getString(keys[kid]);
                String o = pageRow.getString(keys[keys.length / 2 + kid]);
                return n != null && !n.equals(o) || n == null && o != null && !"0".equals(o);
            });
        });
    }

    private void extracted(String key, EntryGrid entryGrid, FormShowParameter form) {
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        DynamicObject dataEntity = dataEntitys[entryGrid.getSelectRows()[0]];
        Object checkObject = dataEntity.get(key);
        if (checkObject != null && !StringUtils.isEmpty((String)checkObject.toString())) {
            form.setCustomParam(key, checkObject);
        }
    }

    private void selectSchemeRow(Long pkid) {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (pkid != 0L) {
            Stream.iterate(0, x -> x + 1).limit(rows.size()).forEach(index -> {
                if (pkid.equals(IDUtils.toLong((Object)rows.get(index.intValue()).getPrimaryKeyValue()))) {
                    billList.selectRows(new int[]{index});
                    this.getPageCache().put(cache_select_scheme, String.valueOf(pkid));
                    return;
                }
            });
        } else if (rows.size() > 0) {
            billList.selectRows(new int[]{0});
            this.getPageCache().put(cache_select_scheme, String.valueOf(rows.get(0).getPrimaryKeyValue()));
        }
        this.refreshEntry();
    }

    public static final Map<String, List<Map<String, String>>> GETBILLUPDAGRADESCHEME() {
        LinkedHashMap BILLUPDAGRADESCHEME = new LinkedHashMap(){
            {
                this.put("er_dailyreimbursebill", Lists.newArrayList((Object[])new HashMap[]{new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u51b2\u9500\u91d1\u989d", (String)"WriteoffSchemePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "writeoffmoney.accloanamount");
                    }
                }, new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u501f\u6b3e\u660e\u7ec6\u5206\u5f55ID", (String)"WriteoffSchemePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "writeoffmoney.sourceentryid");
                    }
                }, new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u6e90\u5355id", (String)"WriteoffSchemePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "writeoffmoney.sourcebillid");
                    }
                }}));
                this.put("er_publicreimbursebill", Lists.newArrayList((Object[])new HashMap[]{new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u51b2\u9500\u91d1\u989d", (String)"WriteoffSchemePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "writeoffmoney.accloanamount");
                    }
                }, new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u501f\u6b3e\u660e\u7ec6\u5206\u5f55ID", (String)"WriteoffSchemePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "writeoffmoney.sourceentryid");
                    }
                }, new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u6e90\u5355id", (String)"WriteoffSchemePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "writeoffmoney.sourcebillid");
                    }
                }}));
                this.put("er_tripreimbursebill", Lists.newArrayList((Object[])new HashMap[]{new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u51b2\u9500\u91d1\u989d", (String)"WriteoffSchemePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "clearloanentry.loanclearoriamount");
                    }
                }, new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u501f\u6b3e\u5206\u5f55ID", (String)"WriteoffSchemePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "clearloanentry.reqaccountentryid");
                    }
                }, new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u51b2\u501f\u6b3e.\u501f\u6b3e\u5355id", (String)"WriteoffSchemePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "clearloanentry.loanbillid");
                    }
                }}));
                this.put("er_dailyloanbill", Lists.newArrayList((Object[])new 10[]{new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u501f\u6b3e\u660e\u7ec6", (String)"WriteoffSchemePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "expenseentryentity");
                    }
                }}));
                this.put("er_tripreqbill", Lists.newArrayList((Object[])new 11[]{new HashMap(){
                    {
                        this.put("name", ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f", (String)"WriteoffSchemePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put("number", "tripentry");
                    }
                }}));
            }
        };
        return BILLUPDAGRADESCHEME;
    }

    private static final Map<String, List<Map<String, String>>> GETPRESETBILLSETS() {
        LinkedHashMap PRESETBILLSETS = new LinkedHashMap(){
            {
                this.put("er_dailyreimbursebill", Lists.newArrayList((Object[])new 1[]{new HashMap(){
                    {
                        this.put("number", "BXUP");
                        this.put("name", ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500\u5355\u51b2\u9500\u65b9\u6848\uff08\u5347\u7ea7\uff09", (String)"WriteoffSchemePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put(WriteoffSchemePlugin.billF7, "er_dailyloanbill");
                        this.put(WriteoffSchemePlugin.SOURCEBILLENTRY, "expenseentryentity");
                        this.put(WriteoffSchemePlugin.SOURCEBILL, "writeoffmoney.sourcebillid");
                        this.put(WriteoffSchemePlugin.DETAIL_ENTITY, "writeoffmoney.sourceentryid");
                        this.put("writeofftype", "occupationwriteoff");
                        this.put(WriteoffSchemePlugin.FROMVALUE, "writeoffmoney.accloanamount");
                    }
                }}));
                this.put("er_publicreimbursebill", Lists.newArrayList((Object[])new 2[]{new HashMap(){
                    {
                        this.put("number", "DGBXUP");
                        this.put("name", ResManager.loadKDString((String)"\u5bf9\u516c\u62a5\u9500\u5355\u51b2\u9500\u65b9\u6848\uff08\u5347\u7ea7\uff09", (String)"WriteoffSchemePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put(WriteoffSchemePlugin.billF7, "er_dailyloanbill");
                        this.put(WriteoffSchemePlugin.SOURCEBILLENTRY, "expenseentryentity");
                        this.put(WriteoffSchemePlugin.SOURCEBILL, "writeoffmoney.sourcebillid");
                        this.put(WriteoffSchemePlugin.DETAIL_ENTITY, "writeoffmoney.sourceentryid");
                        this.put("writeofftype", "occupationwriteoff");
                        this.put(WriteoffSchemePlugin.FROMVALUE, "writeoffmoney.accloanamount");
                    }
                }}));
                this.put("er_tripreimbursebill", Lists.newArrayList((Object[])new 3[]{new HashMap(){
                    {
                        this.put("number", "CLBXUP");
                        this.put("name", ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355\u51b2\u9500\u65b9\u6848\uff08\u5347\u7ea7\uff09", (String)"WriteoffSchemePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.put(WriteoffSchemePlugin.billF7, "er_dailyloanbill");
                        this.put(WriteoffSchemePlugin.SOURCEBILLENTRY, "expenseentryentity");
                        this.put(WriteoffSchemePlugin.SOURCEBILL, "clearloanentry.loanbillid");
                        this.put(WriteoffSchemePlugin.DETAIL_ENTITY, "clearloanentry.reqaccountentryid");
                        this.put("writeofftype", "occupationwriteoff");
                        this.put(WriteoffSchemePlugin.FROMVALUE, "clearloanentry.loanclearoriamount");
                    }
                }}));
            }
        };
        return PRESETBILLSETS;
    }

    public static void saveWriteOffCol(Map<String, List<Map<String, String>>> billUpgradescheme) {
        for (Map.Entry<String, List<Map<String, String>>> next : billUpgradescheme.entrySet()) {
            String billNumber = next.getKey();
            DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_structofbill", (String)"id,name,number,parent", (QFilter[])new QFilter("number", "=", (Object)billNumber).toArray());
            Long billId = bill.getLong("id");
            String colType = ResManager.loadKDString((String)"\u51b2\u9500\u5b57\u6bb5", (String)"WriteoffSchemePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            QFilter qFilter = new QFilter("bill", "=", (Object)billId);
            qFilter.and(new QFilter("fielddimension", "=", (Object)colType));
            DynamicObject show = null;
            Long longid = DBServiceHelper.genGlobalLongId();
            if (!QueryServiceHelper.exists((String)"eb_conbizregdata", (QFilter[])new QFilter[]{qFilter})) {
                show = BusinessDataServiceHelper.newDynamicObject((String)"eb_conbizregdata");
                show.set("id", (Object)longid);
                show.set("fielddimension", (Object)colType);
                show.set("bill", (Object)billId);
                show.set("fieldtable", (Object)billNumber);
            } else {
                show = BusinessDataServiceHelper.loadSingle((String)"eb_conbizregdata", (String)"id,entryentity,entryentity.number,entryentity.name,entryentity.isprefab", (QFilter[])new QFilter[]{qFilter});
            }
            DynamicObjectCollection entryentity = show.getDynamicObjectCollection(ENTRY);
            List<Map<String, String>> writeoffSets = next.getValue();
            Long sysId = bill.getLong("parent");
            String sysname = BusinessDataServiceHelper.loadSingle((Object)sysId, (String)"eb_structofbill").getString("name");
            for (Map<String, String> dto : writeoffSets) {
                if (entryentity.stream().anyMatch(ent -> ((String)dto.get("number")).equals(ent.getString("number")))) continue;
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("number", (Object)dto.get("number"));
                dynamicObject.set("name", (Object)dto.get("name"));
                dynamicObject.set("isprefab", (Object)Boolean.TRUE);
                DynamicObject sys = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolbizreg");
                sys.set("id", (Object)DBServiceHelper.genGlobalLongId());
                sys.set("number", (Object)dto.get("number"));
                sys.set("fieldalias", (Object)dto.get("number"));
                sys.set("name", (Object)dto.get("name"));
                sys.set("bizsystemid", (Object)sysId);
                sys.set("bizsystemalias", (Object)sysname);
                sys.set("bizunitid", (Object)billId);
                sys.set("bizunitalias", (Object)bill.getString("name"));
                sys.set("fieldtable", (Object)billNumber);
                sys.set("type", (Object)"WRITEOFFFIELD");
                sys.set("typename", (Object)colType);
                sys.set("isentryfield", (Object)Boolean.FALSE);
                sys.set("isprefab", (Object)Boolean.TRUE);
                sys.set("isdefault", (Object)Boolean.FALSE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sys});
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{show});
        }
    }

    public static void savePresetScheme() {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_structofbill", (String)"id,name,number", (QFilter[])new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"er_dailyreimbursebill", "er_publicreimbursebill", "er_tripreimbursebill"})).toArray());
        Set billIds = bills.stream().map(b -> b.getLong("id")).collect(Collectors.toSet());
        String selectProperties = "id, name,number,entryentity.bill,entryentity.bill.id,entryentity.application,entryentity.takeoperation,entryentity.takevalue,entryentity.runoperation,entryentity.runvalue,entryentity.returnoperation,entryentity.clearoperation,entryentity.writeoffs,entryentity.writeoffsfield,entryentity.writeoffsfieldcn,entryentity.isfromouter,entryentity.writeoffscheme,entryentity.writeoffschemecn";
        QFilter qFilter = new QFilter("entryentity.bill", "in", (Object)billIds.toArray());
        qFilter.and(new QFilter("entryentity.writeoffs", "=", (Object)Boolean.TRUE));
        DynamicObject[] processSch = BusinessDataServiceHelper.load((String)"eb_bgcontrolprocess", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        boolean index = false;
        ArrayList<Object[]> updaeParams = new ArrayList<Object[]>(16);
        for (DynamicObject processdynamicObject : processSch) {
            DynamicObjectCollection dynamicObjectCollection = processdynamicObject.getDynamicObjectCollection(ENTRY);
            for (final DynamicObject dynamicObject : dynamicObjectCollection) {
                if (dynamicObject.getString("writeoffs") == null || !dynamicObject.getBoolean("writeoffs")) continue;
                final String billName = dynamicObject.getString("bill.fieldtable");
                String writeoffsfield = null;
                if (dynamicObject.getString("writeoffsfield") != null && !"".equals(dynamicObject.getString("writeoffsfield"))) {
                    writeoffsfield = dynamicObject.getString("writeoffsfield");
                    LinkedHashMap scp = new LinkedHashMap(){
                        {
                            this.put(billName, Lists.newArrayList((Object[])new 1[]{new HashMap(){
                                {
                                    this.put("name", dynamicObject.getString("writeoffsfieldcn"));
                                    this.put("number", dynamicObject.getString("writeoffsfield"));
                                }
                            }}));
                        }
                    };
                    WriteoffSchemePlugin.saveWriteOffCol(scp);
                }
                Map<String, String> schemeMap = WriteoffSchemePlugin.GETPRESETBILLSETS().get(billName).get(0);
                Long billId = dynamicObject.getLong("bill.id");
                DynamicObject woff = QueryServiceHelper.queryOne((String)"eb_structofbill", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)schemeMap.get(billF7))});
                String schemeName = schemeMap.get("name");
                String scheNumber = schemeMap.get("number");
                Long schemeId = DBServiceHelper.genGlobalLongId();
                if (QueryServiceHelper.exists((String)"eb_writeoffscheme_pro", (QFilter[])new QFilter[]{new QFilter("bill", "!=", (Object)woff.getLong("id")).and(new QFilter("number", "=", (Object)scheNumber))})) {
                    String random = UUID.randomUUID().toString();
                    String prex = "-" + random.substring(random.length() - 6).toUpperCase();
                    schemeName = schemeName + prex;
                    scheNumber = scheNumber + prex;
                }
                DynamicObject schemeDyn = BusinessDataServiceHelper.newDynamicObject((String)"eb_writeoffscheme_pro");
                schemeDyn.set("id", (Object)schemeId);
                schemeDyn.set("number", (Object)scheNumber);
                schemeDyn.set("bill", (Object)billId);
                schemeDyn.set("name", (Object)schemeName);
                schemeDyn.set("remark", (Object)schemeName);
                DynamicObjectCollection writeoffinfos = schemeDyn.getDynamicObjectCollection("writeoffinfo");
                DynamicObject writeoffinfo = writeoffinfos.addNew();
                writeoffinfo.set(billF7, (Object)woff.getLong("id"));
                writeoffinfo.set(SOURCEBILLENTRY, (Object)WriteoffSchemePlugin.getRegistCol(woff.getLong("id"), schemeMap.get(SOURCEBILLENTRY)));
                writeoffinfo.set(SOURCEBILL, (Object)WriteoffSchemePlugin.getRegistCol(billId, schemeMap.get(SOURCEBILL)));
                writeoffinfo.set(DETAIL_ENTITY, (Object)WriteoffSchemePlugin.getRegistCol(billId, schemeMap.get(DETAIL_ENTITY)));
                writeoffinfo.set("writeofftype", (Object)schemeMap.get("writeofftype"));
                writeoffsfield = Optional.ofNullable(writeoffsfield).orElseGet(() -> (String)schemeMap.get(FROMVALUE));
                writeoffinfo.set(FROMVALUE, (Object)WriteoffSchemePlugin.getRegistCol(billId, writeoffsfield));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeDyn});
                updaeParams.add(new Object[]{schemeId, schemeName, billId, processdynamicObject.getLong("id")});
            }
        }
        if (updaeParams.size() > 0) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_bgconprocessentry set fwriteoffscheme = ? ,fwriteoffschemecn = ? where fbill = ? and fid = ?", updaeParams);
        }
    }

    private static Long getRegistCol(Long billId, String number) {
        QFilter qFilter = new QFilter("bizunitid", "=", (Object)billId);
        qFilter.and(new QFilter("type", "=", (Object)"WRITEOFFFIELD"));
        qFilter.and(new QFilter("number", "=", (Object)number));
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_bgcontrolbizreg", (String)"id,name,number,type,typename", (QFilter[])new QFilter[]{qFilter});
        return query.getLong("id");
    }
}

