/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.fieldregister;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.control.utils.BgControlProcessUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class BillFieldDefaultEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"add"});
        this.addBeforeF7Selected(Lists.newArrayList((Object[])new String[]{"application", "bill", "orgfield", "periodfield"}));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"barcontinue"});
    }

    private void addBeforeF7Selected(List<String> bdEdits) {
        for (String bdEdit : bdEdits) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(bdEdit);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("add".equals(key)) {
            this.baradd();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "barcontinue": {
                if (this.getModel().getDataChanged()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u8df3\u8f6c\u81f3\u65b0\u9875\u9762\uff1f", (String)"BillFieldDefaultEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changepage", (IFormPlugin)this));
                    break;
                }
                this.openNewPage(evt.getItemKey());
                break;
            }
            case "barsave": {
                this.baradd();
            }
        }
    }

    private void baradd() {
        Object application = this.getModel().getValue("application");
        Object bill = this.getModel().getValue("bill");
        Object orgfield = this.getModel().getValue("orgfield");
        Object periodfield = this.getModel().getValue("periodfield");
        boolean ismapping = (Boolean)this.getModel().getValue("ismapping");
        Boolean ismulticontrol = (Boolean)this.getModel().getValue("ismulticontrol");
        Boolean simplefield = (Boolean)this.getModel().getValue("simplefield");
        Boolean occupationagain = (Boolean)this.getModel().getValue("occupationagain");
        if (application == null || bill == null || orgfield == null || periodfield == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3a\u7a7a\u6821\u9a8c\u5931\u8d25", (String)"BillFieldDefaultEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!ismulticontrol.booleanValue() && this.checkExistSameDimmateRule().booleanValue()) {
            ArrayList<MessageBoxLink> msgLink = new ArrayList<MessageBoxLink>();
            MessageBoxLink messageBoxLink = new MessageBoxLink();
            messageBoxLink.setIndex(0);
            messageBoxLink.setText(ResManager.loadKDString((String)"\u6253\u5f00\u5339\u914d\u89c4\u5219", (String)"BillFieldDefaultEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            msgLink.add(messageBoxLink);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u751f\u6548\u7684\u5339\u914d\u89c4\u5219\u7ec4\uff0c\u8bf7\u7981\u7528/\u5220\u9664\u90e8\u5206\u89c4\u5219\u7ec4\u540e\u91cd\u8bd5,#{0}", (String)"BillFieldDefaultEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), msgLink, MessageBoxOptions.None, ConfirmTypes.Default, new ConfirmCallBackListener("linkCallBack", (IFormPlugin)this), new HashMap());
            return;
        }
        if (!occupationagain.booleanValue() && this.checkExistMultiExecOperation().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u6709\u591a\u4e2a\u6267\u884c\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5173\u95ed\u201c\u591a\u6b21\u6263\u51cf\u201d\u53c2\u6570\u3002", (String)"BillFieldDefaultEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String billNumber = ((DynamicObject)bill).getString("number");
        try (TXHandle th = TX.required();){
            try {
                QFilter qFilter = new QFilter("application", "=", (Object)((DynamicObject)application).getLong("id"));
                qFilter.and("bill", "=", (Object)((DynamicObject)bill).getLong("id"));
                DynamicObject save = BusinessDataServiceHelper.loadSingle((String)"eb_bgcontroldefault", (String)"orgfield,periodfield,fieldtable,ismapping,ismulticontrol,simplefield,isreturncheck,occupationagain,occbyentry", (QFilter[])qFilter.toArray());
                boolean isSave = false;
                if (save == null) {
                    save = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontroldefault");
                    save.set("application", (Object)((DynamicObject)application).getLong("id"));
                    save.set("bill", (Object)((DynamicObject)bill).getLong("id"));
                    isSave = true;
                }
                save.set("fieldtable", (Object)((DynamicObject)bill).getString("fieldtable"));
                save.set("orgfield", orgfield);
                save.set("periodfield", periodfield);
                save.set("ismapping", (Object)ismapping);
                save.set("ismulticontrol", (Object)ismulticontrol);
                save.set("simplefield", (Object)simplefield);
                save.set("isreturncheck", (Object)((Boolean)this.getModel().getValue("isreturncheck")));
                save.set("occupationagain", (Object)((Boolean)this.getModel().getValue("occupationagain")));
                save.set("occbyentry", (Object)((Boolean)this.getModel().getValue("occbyentry")));
                if (isSave) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{save});
                } else {
                    SaveServiceHelper.update((DynamicObject)save);
                }
                CacheServiceHelper.clearFieldsCache((String)((DynamicObject)bill).getString("fieldtable"));
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BillFieldDefaultEditPlugin_2", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "AbstractBasePlugin_11", "epm-eb-formplugin");
                this.writeLog(billNumber, "save", opName, opDesc, new String[]{billNumber});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BillFieldDefaultEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                th.markRollback();
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BillFieldDefaultEditPlugin_2", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", "AbstractBasePlugin_12", "epm-eb-formplugin");
                this.writeLog(billNumber, "save", opName, opDesc, new String[]{billNumber});
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void openNewPage(String key) {
        if ("barcontinue".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_bgcontroldefault");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(showParameter);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("application") != null) {
            this.getModel().setValue("application", customParams.get("application"));
        }
        if (customParams.get("bill") != null) {
            this.getModel().setValue("bill", customParams.get("bill"));
            this.setFieldValue((String)customParams.get("fieldtable"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("bill".equals(name) && this.getModel().getValue("bill") != null) {
            String fieldtable = ((DynamicObject)this.getModel().getValue("bill")).getString("fieldtable");
            this.setFieldValue(fieldtable);
        }
        if ("application".equals(name)) {
            this.getModel().setValue("bill", null);
            this.getModel().setValue("orgfield", null);
            this.getModel().setValue("periodfield", null);
        }
    }

    private void setFieldValue(String fieldtable) {
        if (fieldtable == null || fieldtable.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("fieldtable", "=", (Object)fieldtable);
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"eb_bgcontroldefault", (String)"orgfield,periodfield,ismapping,ismulticontrol,simplefield,isreturncheck,occupationagain,occbyentry", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && dynamicObject.length > 1) {
            DeleteServiceHelper.delete((String)"eb_bgcontroldefault", (QFilter[])qFilter.toArray());
            this.getModel().setValue("orgfield", null);
            this.getModel().setValue("periodfield", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6e05\u9664\u5783\u573e\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8d22\u5e74\u548c\u671f\u95f4\u3002", (String)"BillFieldDefaultEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (dynamicObject != null && dynamicObject.length > 0) {
            this.getModel().setValue("orgfield", dynamicObject[0].get("orgfield"));
            this.getModel().setValue("periodfield", dynamicObject[0].get("periodfield"));
            this.getModel().setValue("ismapping", dynamicObject[0].get("ismapping"));
            this.getModel().setValue("ismulticontrol", dynamicObject[0].get("ismulticontrol"));
            this.getModel().setValue("simplefield", dynamicObject[0].get("simplefield"));
            this.getModel().setValue("isreturncheck", dynamicObject[0].get("isreturncheck"));
            this.getModel().setValue("occupationagain", dynamicObject[0].get("occupationagain"));
            this.getModel().setValue("occbyentry", dynamicObject[0].get("occbyentry"));
        } else {
            this.getModel().setValue("orgfield", null);
            this.getModel().setValue("periodfield", null);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent bfse) {
        String billId;
        String applicationId;
        DynamicObject bill;
        ArrayList<QFilter> fieldQfilters;
        DynamicObject application;
        ListShowParameter showParameter;
        if (((BasedataEdit)bfse.getSource()).getKey().equals("application")) {
            showParameter = (ListShowParameter)bfse.getFormShowParameter();
            ArrayList<? extends QFilter> qFilters = ((BasedataEdit)this.getControl("application")).getQFilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>(16);
            }
            qFilters.addAll(this.getModelIdQfilter(BgBillTreeTypeEnum.APPLICATION.getNumber()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        }
        if (((BasedataEdit)bfse.getSource()).getKey().equals("bill")) {
            showParameter = (ListShowParameter)bfse.getFormShowParameter();
            ArrayList<QFilter> billQfilters = ((BasedataEdit)this.getControl("bill")).getQFilters();
            application = (DynamicObject)this.getModel().getValue("application");
            if (application == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528", (String)"BillFieldDefaultEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                bfse.setCancel(true);
                return;
            }
            Long parent = application.getLong("id");
            if (billQfilters == null) {
                billQfilters = new ArrayList<QFilter>(16);
            }
            billQfilters.add(new QFilter("parent", "=", (Object)parent));
            billQfilters.addAll(this.getModelIdQfilter(BgBillTreeTypeEnum.BILL.getNumber()));
            showParameter.setListFilterParameter(new ListFilterParameter(billQfilters, null));
        }
        if (((BasedataEdit)bfse.getSource()).getKey().equals("orgfield")) {
            showParameter = (ListShowParameter)bfse.getFormShowParameter();
            fieldQfilters = ((BasedataEdit)this.getControl("orgfield")).getQFilters();
            application = (DynamicObject)this.getModel().getValue("application");
            if (application == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u548c\u5355\u636e\u3002", (String)"BillFieldDefaultEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                bfse.setCancel(true);
                return;
            }
            bill = (DynamicObject)this.getModel().getValue("bill");
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e", (String)"BillFieldDefaultEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                bfse.setCancel(true);
                return;
            }
            applicationId = application.getString("id");
            billId = bill.getString("id");
            if (fieldQfilters == null) {
                fieldQfilters = new ArrayList<QFilter>(16);
            }
            fieldQfilters.add(this.getFieldQfilter(applicationId, billId, "ORG"));
            showParameter.setListFilterParameter(new ListFilterParameter(fieldQfilters, null));
        }
        if (((BasedataEdit)bfse.getSource()).getKey().equals("periodfield")) {
            showParameter = (ListShowParameter)bfse.getFormShowParameter();
            fieldQfilters = ((BasedataEdit)this.getControl("periodfield")).getQFilters();
            application = (DynamicObject)this.getModel().getValue("application");
            if (application == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u548c\u5355\u636e\u3002", (String)"BillFieldDefaultEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                bfse.setCancel(true);
                return;
            }
            bill = (DynamicObject)this.getModel().getValue("bill");
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e", (String)"BillFieldDefaultEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                bfse.setCancel(true);
                return;
            }
            applicationId = application.getString("id");
            billId = bill.getString("id");
            if (fieldQfilters == null) {
                fieldQfilters = new ArrayList(16);
            }
            fieldQfilters.add(this.getFieldQfilter(applicationId, billId, "PERIOD"));
            showParameter.setListFilterParameter(new ListFilterParameter(fieldQfilters, null));
        }
    }

    private QFilter getFieldQfilter(String applicationId, String billId, String type) {
        QFilter qFilter = new QFilter("bizunitid", "=", (Object)IDUtils.toLong((Object)billId));
        qFilter.and("type", "=", (Object)type);
        qFilter.and("isentryfield", "=", (Object)"0");
        return qFilter;
    }

    private Collection<? extends QFilter> getModelIdQfilter(String billTreeType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("billtype", "=", (Object)billTreeType));
        return qFilters;
    }

    @Override
    public Long getModelId() {
        return 0L;
    }

    private Boolean checkExistSameDimmateRule() {
        QFilter[] qFilter = QFBuilder.newQFilter().add("bill.id", "=", (Object)((DynamicObject)this.getModel().getValue("bill")).getLong("id")).add("status", "=", (Object)true).toArray();
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)"eb_adddimmaterule", (String)"id", (QFilter[])qFilter);
        if (billObjs != null && billObjs.size() > 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean checkExistMultiExecOperation() {
        Long billId = ((DynamicObject)this.getModel().getValue("bill")).getLong("id");
        QFilter[] qFilter = QFBuilder.newQFilter().add("entryentity.bill.id", "=", (Object)billId).toArray();
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)"eb_bgcontrolprocess", (String)"id,entryentity.bill.id,entryentity.runoperation", (QFilter[])qFilter);
        if (billObjs != null && billObjs.size() > 1) {
            for (DynamicObject obj : billObjs) {
                String runoperation;
                if (!billId.equals(obj.getLong("entryentity.bill.id")) || BgControlProcessUtils.getOperations((String)(runoperation = obj.getString("entryentity.runoperation"))).size() <= 1) continue;
                return true;
            }
        }
        return Boolean.FALSE;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("linkCallBack".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.CUSTOM) {
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("gotodimmaterule", "1");
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

