/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.messageTpl;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class MessageSettingPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeNode node = this.getRootNode();
        if (node == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.deleteAllNodes();
        treeView.updateNode(node);
        treeView.addNode(node);
        this.expandAll(node);
        JSONObject warnningMsg = (JSONObject)this.getFormCustomParam("warnningmsg");
        OrmLocaleValue value = (OrmLocaleValue)this.getModel().getValue("text");
        if (StringUtils.isEmpty((String)value.getLocaleValue()) && warnningMsg.getString("GLang") != null) {
            value.setLocaleValue(warnningMsg.getString("GLang"));
        }
        if (warnningMsg != null) {
            this.getModel().setValue("text", (Object)value);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(clickKey)) {
            String messageContent = String.valueOf(this.getModel().getValue("text"));
            if (messageContent != null && messageContent.length() > 2000) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8b66\u6d88\u606f\u8d85\u8fc7\u6700\u5927\u957f\u5ea62000\uff0c\u8bf7\u68c0\u67e5", (String)"MessageSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(this.getModel().getValue("text"));
            this.getView().close();
        }
    }

    private void expandAll(TreeNode root) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        List child = root.getChildren();
        if (child != null && !child.isEmpty()) {
            for (TreeNode childNode : child) {
                treeView.expand(childNode.getId());
                this.expandAll(childNode);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String postText;
        String nodeId = (String)evt.getNodeId();
        TreeNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return;
        }
        TreeNode treeNode = rootNode.getTreeNode(nodeId, 16);
        if (treeNode.getData() == null) {
            return;
        }
        String nodeData = (String)treeNode.getData();
        StringBuilder appendSb = new StringBuilder();
        appendSb.append("{").append(nodeData).append("}");
        IDataModel model = this.getModel();
        String messageContent = String.valueOf(model.getValue("text"));
        if (messageContent == null) {
            messageContent = "";
        }
        if (messageContent.length() >= 2000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8b66\u6d88\u606f\u8d85\u8fc7\u6700\u5927\u957f\u5ea62000\uff0c\u8bf7\u68c0\u67e5", (String)"MessageSettingPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int cursorFocusIndex = this.getCursorFocusIndex(this.getView(), "treeview", "text");
        if (cursorFocusIndex > messageContent.length()) {
            cursorFocusIndex = 0;
        }
        if ((postText = messageContent.substring(cursorFocusIndex)).indexOf("{") > postText.indexOf("}") || !postText.contains("{") && postText.contains("}")) {
            cursorFocusIndex += postText.indexOf("}") + 1;
            postText = messageContent.substring(cursorFocusIndex);
        }
        String preText = messageContent.substring(0, cursorFocusIndex);
        StringBuilder showText = new StringBuilder().append(preText).append((CharSequence)appendSb).append(postText);
        ILocaleString ls = (ILocaleString)model.getValue("text");
        if (ls != null) {
            ls.setLocaleValue(showText.toString());
        }
        model.setValue("text", (Object)ls);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(16);
        cursorMap.put("cursorIndex", cursorFocusIndex + appendSb.length());
        cursorMap.put("ctrlKey", "text");
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", cursorMap);
    }

    private int getCursorFocusIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = String.valueOf(view.getModel().getValue(textFieldKey));
        int cursorIndex = StringUtils.isEmpty((String)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get("focus") != null) {
                Map focus = (Map)map.get("focus");
                if (focus.get(textFieldKey) != null && focus.get(textFieldKey) instanceof Integer) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    private TreeNode getRootNode() {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        TreeNode node = null;
        if (parentPageCache.get("cache_msgsetting_tree") != null) {
            TreeNode treeNode;
            node = treeNode = (TreeNode)SerializationUtils.deSerializeFromBase64((String)parentPageCache.get("cache_msgsetting_tree"));
        }
        return node;
    }
}

