/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.controlParamsSetting;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.UserSelectServiceHelperNew;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class ControlParamsSetttingPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String BUSSINESS_MODEL = "bussiness_model";
    private static final String SAVE_BTN = "save_btn";
    private static final String REFRESH_BTN = "refresh_btn";
    private static final String TOOL_BAR = "toolbarap";
    private static final String ADJUST_CHECKBOX = "adjust_checkbox";
    private static final String REDISTRIBUTE_CHECKBOX = "redistribute_checkbox";
    private static final String ADJUST_MODIFIER = "adjust_modifier";
    private static final String ADJUST_MODIFYTIME = "adjust_modifytime";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        BasedataEdit dataEdit = (BasedataEdit)this.getControl(MODEL);
        if (dataEdit != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dataEdit = (BasedataEdit)this.getControl(BUSSINESS_MODEL)) != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(ApplicationTypeEnum.EB.getIndex());
        DynamicObject userSelect = UserSelectServiceHelperNew.getUserSelect((IFormView)this.getView(), appTypes);
        if (userSelect == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ControlVersionListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)userSelect.getString(MODEL));
        this.getModel().setValue(BUSSINESS_MODEL, (Object)userSelect.getString("bizmodel"));
        this.setBizModelVisible(userSelect.getLong(MODEL));
        this.loadAllCards();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BUSSINESS_MODEL});
    }

    private void setBizModelVisible(long modelId) {
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setVisible(Boolean.valueOf(ApplicationTypeEnum.BGMD.getIndex().equals(ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType())), new String[]{BUSSINESS_MODEL});
    }

    private void loadReduceOccupationBudget(long modelId, long bussinessModelId) {
        QFilter qfs = new QFilter(MODEL, "=", (Object)modelId);
        qfs.and(new QFilter("bussinessmodel", "=", (Object)bussinessModelId));
        String selectFields = "id,model,bussinessmodel,modifier,modifytime,reduce_adjust,reduce_redistribute";
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"reduce_occupation_budget", (String)selectFields, (QFilter[])qfs.toArray());
        if (obj != null) {
            Date date;
            Label modifyTime;
            Label modifier = (Label)this.getControl(ADJUST_MODIFIER);
            if (modifier != null) {
                modifier.setText(obj.getString("modifier.name"));
            }
            if ((modifyTime = (Label)this.getControl(ADJUST_MODIFYTIME)) != null && (date = obj.getDate("modifytime")) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                modifyTime.setText(sdf.format(date));
            }
            this.getModel().setValue(ADJUST_CHECKBOX, (Object)obj.getBoolean("reduce_adjust"));
            this.getModel().setValue(REDISTRIBUTE_CHECKBOX, (Object)obj.getBoolean("reduce_redistribute"));
        } else {
            Label modifyTime;
            Label modifier = (Label)this.getControl(ADJUST_MODIFIER);
            if (modifier != null) {
                modifier.setText("");
            }
            if ((modifyTime = (Label)this.getControl(ADJUST_MODIFYTIME)) != null) {
                modifyTime.setText("");
            }
            this.getModel().setValue(ADJUST_CHECKBOX, (Object)false);
            this.getModel().setValue(REDISTRIBUTE_CHECKBOX, (Object)false);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "model": {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.EB.getIndex()));
                PluginUtils.setModelByManager(e, filters, this.getView());
                break;
            }
            case "bussiness_model": {
                this.setBusModelQFilters(e);
                break;
            }
        }
    }

    private void setBusModelQFilters(BeforeF7SelectEvent e) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilterList = showParameter.getListFilterParameter().getQFilters();
        qFilterList.clear();
        qFilterList.add(new QFilter(MODEL, "=", (Object)modelId));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "save_btn": {
                this.saveAllCards();
                this.loadAllCards();
                break;
            }
            case "refresh_btn": {
                this.loadAllCards();
                break;
            }
        }
    }

    private void saveAllCards() {
        long modelId = this.getModelId();
        long bussinessModelId = this.getBussinessModelId();
        this.saveReduceOccupationBudget(modelId, bussinessModelId);
    }

    private void saveReduceOccupationBudget(long modelId, long bussinessModelId) {
        QFilter qfs = new QFilter(MODEL, "=", (Object)modelId);
        qfs.and(new QFilter("bussinessmodel", "=", (Object)bussinessModelId));
        String selectFields = "id,model,bussinessmodel,modifier,modifytime,reduce_adjust,reduce_redistribute";
        DynamicObject toSaveObj = BusinessDataServiceHelper.loadSingle((String)"reduce_occupation_budget", (String)selectFields, (QFilter[])qfs.toArray());
        if (toSaveObj == null) {
            toSaveObj = BusinessDataServiceHelper.newDynamicObject((String)"reduce_occupation_budget");
            toSaveObj.set(MODEL, (Object)modelId);
            toSaveObj.set("bussinessmodel", (Object)bussinessModelId);
        }
        toSaveObj.set("modifier", (Object)UserUtils.getUserId());
        toSaveObj.set("modifytime", (Object)TimeServiceHelper.now());
        toSaveObj.set("reduce_adjust", (Object)((Boolean)this.getModel().getValue(ADJUST_CHECKBOX)));
        toSaveObj.set("reduce_redistribute", (Object)((Boolean)this.getModel().getValue(REDISTRIBUTE_CHECKBOX)));
        Object[] saveCounts = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{toSaveObj});
        if (saveCounts.length > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CentralControlAddVersion2_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "model": {
                this.propChangeModel();
                break;
            }
            case "bussiness_model": {
                this.propChangeBizModel();
                break;
            }
        }
    }

    private void propChangeBizModel() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        UserSelectServiceHelperNew.saveUserSelectBizModel((long)modelId, (long)this.getBussinessModelId(), (String)this.getView().getEntityId(), (String)ModelUtil.queryApp((IFormView)this.getView()).getIndex());
        this.loadAllCards();
    }

    private void propChangeModel() {
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)this.getModelId());
        this.setBizModelVisible(this.getModelId());
        this.loadAllCards();
    }

    private void loadAllCards() {
        long modelId = this.getModelId();
        long bussinessModelId = this.getBussinessModelId();
        this.loadReduceOccupationBudget(modelId, bussinessModelId);
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    private Long getBussinessModelId() {
        Long id = 0L;
        DynamicObject bussinessModel = (DynamicObject)this.getModel().getValue(BUSSINESS_MODEL);
        if (bussinessModel != null) {
            id = bussinessModel.getLong("id");
        }
        return id;
    }
}

