/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.controlParamsSetting;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FieldTip;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.enums.LogParamEnum;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class LogParamSettingPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String SETTING_PAGE_CACHE = "settingPageCache";
    private static final String TREE_NODE_CACHE = "treenodecache";
    private static final String TREE_VIEW = "treeviewap";
    private static final String SETTINGS_PANEL = "settingspanel";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_REFRESH = "btn_refresh";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getControl(TREE_VIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeNode root = this.buildRootNode();
        IPageCache pageCache = this.getPageCache();
        pageCache.put(TREE_NODE_CACHE, SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW);
        tree.addNode(root);
        tree.expand("0");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_REFRESH});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.closeParameterForm();
        String nodeId = (String)evt.getNodeId();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_NODE_CACHE), TreeNode.class);
        if (root.getId().equalsIgnoreCase(nodeId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_REFRESH});
            return;
        }
        TreeNode checkedNode = root.getTreeNode(nodeId, 10);
        TreeView tree = (TreeView)this.getControl(TREE_VIEW);
        tree.focusNode(checkedNode);
        if (checkedNode == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_REFRESH});
            return;
        }
        String formId = (String)checkedNode.getData();
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)formId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_REFRESH});
            return;
        }
        FormShowParameter showParameter = this.getFormShowParameter(nodeId, formId);
        this.getView().showForm(showParameter);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_SAVE, BTN_REFRESH});
        this.getPageCache().put(SETTING_PAGE_CACHE, showParameter.getPageId());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.saveData(evt);
                break;
            }
        }
    }

    private IFormPlugin getFormPlugin(IFormView view, String pluginName) {
        IFormPlugin plugin = null;
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)pluginName)) {
            plugin = pluginProxy.getPlugin(pluginName);
        } else if (pluginProxy != null && pluginProxy.getPlugIns().size() > 0) {
            plugin = (IFormPlugin)pluginProxy.getPlugIns().get(0);
        }
        return plugin;
    }

    private void saveData(ItemClickEvent evt) {
        Object[] params;
        String sql;
        IDataModel parameterModel;
        DynamicObject dataEntity;
        List<FieldTip> fieldKeys;
        IFormPlugin formPlugin;
        IPageCache pageCache = this.getPageCache();
        IFormView parameterView = this.getView().getView(pageCache.get(SETTING_PAGE_CACHE));
        if (parameterView == null) {
            return;
        }
        long nodeId = Convert.toLong((Object)parameterView.getFormShowParameter().getCustomParam("nodeid"));
        LogParamEnum logParamEnum = LogParamEnum.getEnumByNodeId((Long)nodeId);
        if (logParamEnum != null && (formPlugin = this.getFormPlugin(parameterView, logParamEnum.getPlugin())) != null) {
            formPlugin.itemClick(evt);
        }
        if ((fieldKeys = this.getMustInputKey(dataEntity = (parameterModel = (IDataModel)parameterView.getService(IDataModel.class)).getDataEntity())).size() != 0) {
            StringBuilder errorDesc = new StringBuilder().append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"EbParamSettingPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (FieldTip fieldKey : fieldKeys) {
                String paramKey = fieldKey.getFieldKey();
                String paramName = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)paramKey)).getDisplayName().getLocaleValue();
                errorDesc.append("\u201c").append(paramName).append("\u201d,");
            }
            errorDesc.setCharAt(errorDesc.length() - 1, '\u3002');
            this.getView().showTipNotification(errorDesc.toString());
            return;
        }
        Long modelId = dataEntity.getDynamicObject("model").getLong("id");
        boolean isExist = false;
        String querySql = "select fparams from t_eb_param_setting where fnodeid = ? and fmodelid = ?";
        try (DataSet ds = DB.queryDataSet((String)this.getClass().toString(), (DBRoute)BgBaseConstant.epm, (String)querySql, (Object[])new Object[]{nodeId, modelId});){
            if (ds != null && ds.hasNext()) {
                isExist = true;
            }
        }
        String jsonString = SerializationUtils.toJsonString((Object)dataEntity);
        Date date = new Date();
        if (isExist) {
            sql = "update t_eb_param_setting set fparams = ?, fmodifydate = ? where fnodeid = ? and fmodelid = ?";
            params = new Object[]{jsonString, date, nodeId, modelId};
        } else {
            sql = "insert into t_eb_param_setting (fid, fnodeid, fmodelid, fparams, fcreatedate, fmodifydate) values (?,?,?,?,?,?)";
            params = new Object[]{DBServiceHelper.genGlobalLongId(), nodeId, modelId, jsonString, date, date};
        }
        boolean result = DB.execute((DBRoute)BgBaseConstant.epm, (String)sql, (Object[])params);
        if (result) {
            if ("eb_rule_param".equals(parameterView.getFormShowParameter().getFormId())) {
                OlapDataAuditService.getInstance().clearCache(dataEntity.getDynamicObject("model").getString("shownumber"));
            }
            Cache.get().remove("eb_param_cache" + modelId + nodeId);
            FormConfig formConfig = parameterView.getFormShowParameter().getFormConfig();
            if (formConfig != null && formConfig.getCaption() != null) {
                this.writeLog(null, "save", new MultiLangEnumBridge("\u4fdd\u5b58", "BgTaskDispatchPlugin_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58%1$s\u6210\u529f", "EbParamSettingPlugin_38", "epm-eb-formplugin"), new String[]{formConfig.getCaption().getLocaleValue()});
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EbParamSettingPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private FormShowParameter getFormShowParameter(String nodeId, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(SETTINGS_PANEL);
        showParameter.setFormId(formId);
        showParameter.setCustomParam("nodeid", (Object)nodeId);
        return showParameter;
    }

    private void closeParameterForm() {
        String pageId = this.getPageCache().get(SETTING_PAGE_CACHE);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>(16);
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(SETTING_PAGE_CACHE);
        }
    }

    private TreeNode buildRootNode() {
        TreeNode treeNode = new TreeNode();
        treeNode.setParentid("");
        treeNode.setId("0");
        treeNode.setText(ResManager.loadKDString((String)"\u5206\u7c7b", (String)"EbParamSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        for (LogParamEnum value : LogParamEnum.values()) {
            TreeNode entry = new TreeNode();
            entry.setParentid(treeNode.getId());
            entry.setId(value.getNodeId().toString());
            entry.setText(value.getName().loadKDString());
            entry.setData((Object)value.getFormId());
            treeNode.addChild(entry);
        }
        return treeNode;
    }

    private List<FieldTip> getMustInputKey(DynamicObject dataEntity) {
        ArrayList<FieldTip> keys = new ArrayList<FieldTip>();
        IDataEntityType type = dataEntity.getDataEntityType();
        DataEntityPropertyCollection props = type.getProperties();
        for (IDataEntityProperty prop : props) {
            BasedataProp basedataProp;
            if (prop instanceof BooleanProp) continue;
            if (prop instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)prop;
                if (!fieldProp.isMustInput() || !StringUtils.isBlank((Object)dataEntity.get(fieldProp.getName()))) continue;
                keys.add(new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.notNull, fieldProp.getName(), new LocaleString(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"EbParamSettingPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0])).getLocaleValue()));
                continue;
            }
            if (!(prop instanceof BasedataProp) || !(basedataProp = (BasedataProp)prop).isMustInput() || !StringUtils.isBlank((Object)dataEntity.get(basedataProp.getName()))) continue;
            keys.add(new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.notNull, basedataProp.getName(), new LocaleString(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"EbParamSettingPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0])).getLocaleValue()));
        }
        return keys;
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }
}

