/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.controlParamsSetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.shrek.service.ShrekServerHelper;
import kd.epm.eb.common.shrek.util.ShrekParamUtils;
import kd.epm.eb.common.utils.pkgversioncheck.PkgVersionCheckService;
import kd.epm.eb.formplugin.controlParamsSetting.EbParamPlugin;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;

public class ShrekParamBg031
extends EbParamPlugin {
    private static final String STOREANDCALC = "storelevel";

    @Override
    public void afterCreateNewData(EventObject e) {
        this.setStoreLevel(this.getModelId(), null);
        super.afterCreateNewData(e);
    }

    public boolean validateBeforeSave() {
        return this.beforeSaveData() && super.validateBeforeSave();
    }

    public void afterSave() {
        ShrekParamUtils.updateDatasetMeta((Long)this.getModelId());
    }

    private void setStoreLevel(Long modelId, Set<Integer> selLevels) {
        int maxLevel = 1;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select max(flevel) as flevel from t_eb_structofent where fmodelid = ?", new Object[]{modelId});
        try (DataSet ds = DB.queryDataSet((String)"queryEntityMaxLevel", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null && ds.hasNext()) {
                maxLevel = ds.next().getInteger("flevel");
            }
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(maxLevel);
        int in = maxLevel;
        for (int i = 1; i < in; ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(ResManager.loadResFormat((String)"%1\u7ea7", (String)"ShrekParamPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{i})));
            comboItem.setValue(String.valueOf(i));
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(STOREANDCALC);
        comboEdit.setComboItems(comboItems);
    }

    private boolean beforeSaveData() {
        long modelId;
        boolean result = true;
        if (!PkgVersionCheckService.getInstance().checkPkgVersionOverOrDefault("kd.bos.olap.dataSources.MetadataCommandInfo", "2.8.3", false)) {
            result = false;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u591a\u7ef4\u6570\u636e\u5e93\u52a8\u6001\u5b58\u50a8\u548c\u8ba1\u7b97\u9700\u8981\u5ba2\u6237\u7aef\u7248\u672c\u5728\u201c%1\u201d\u4ee5\u4e0a\uff0c\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u7248\u672c\u3002", (String)"EbParamSettingPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{"2.8.3"}));
        }
        if ((modelId = this.getModelId()) != 0L) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            DynamicObject dataset = DataSetServiceHelper.loadDefault((Long)modelId);
            if (!ShrekServerHelper.get().equalsVersion(modelCacheHelper.getModelobj(), Dataset.of((DynamicObject)dataset), 9, 2, 5)) {
                result = false;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u591a\u7ef4\u6570\u636e\u5e93\u52a8\u6001\u5b58\u50a8\u548c\u8ba1\u7b97\u9700\u8981\u5ba2\u6237\u7aef\u7248\u672c\u5728\u201c%1\u201d\u4ee5\u4e0a\uff0c\u8bf7\u5347\u7ea7\u591a\u7ef4\u6570\u636e\u5e93\u7248\u672c\u3002", (String)"EbParamSettingPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{"9.2.5"}));
            }
        }
        return result;
    }
}

