/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.currencyconvert;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.currencyConvert.CurrencyConvertSchemeServiceImpl;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.currencyConvert.CurrencyConvertCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.currencyconvert.CurrencyConvertEntity;
import kd.epm.eb.formplugin.currencyconvert.CurrencyEntity;
import kd.epm.eb.formplugin.currencyconvert.CurrencySchemEntity;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class CurrencyConvertListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String CURRENCYTREE = "currencytree";
    private static final String ENTITY_CACHE = "entityCache";
    private static final String EB_CURRENCYCONVERTSCHEM = "eb_currencyconvertschem";
    private static final CurrencyConvertSchemeServiceImpl schemeService = CurrencyConvertSchemeServiceImpl.getInstance();
    private static final String BUDGETDATE = "budgetdate";
    private static final String MEANPARITIES = "meanparities";
    private static final String ADDMEANPARITIES = "addmeanparities";
    private static final String ENDPARITIES = "endparities";
    private static final String MODIFIER = "modifier";
    private static final String MODIFYTIME = "modifytime";
    private static final String ADD_CURRENCYCONVERT = "add_currencyconvert";
    private static final String ENTITY = "entity";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit modelBaseData = (BasedataEdit)this.getView().getControl("model");
        modelBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_addnew", "btn_modify", "btn_delete"});
        TreeView tview = (TreeView)this.getControl(CURRENCYTREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                CurrencyConvertListPlugin.this.refrushBillList();
            }
        });
    }

    private void refrushBillList() {
        Map<String, Object> focusNode = this.getFocusNode();
        String id = focusNode.get("id").toString();
        this.getPageCache().put("nodeId", id);
        List entityCache = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(ENTITY_CACHE));
        this.refreshDimEntry(entityCache, id);
    }

    public Map<String, Object> getFocusNode() {
        TreeView treeView = (TreeView)this.getControl(CURRENCYTREE);
        return treeView.getTreeState().getFocusNode();
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"CurrencyConvertListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("modelId", modelId.toString());
        this.refreshNodeTree(null);
        List<CurrencyConvertEntity> entities = this.buildEntry();
        if (entities.size() > 0) {
            this.refreshDimEntry(entities, this.getPageCache().get("nodeId"));
        } else {
            this.structureStartDate();
        }
    }

    private void structureStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeServiceHelper.now());
        int year = calendar.get(1);
        Calendar newDate = Calendar.getInstance();
        newDate.clear();
        newDate.set(1, year);
        newDate.set(2, 0);
        this.getModel().setValue("startdate", (Object)newDate.getTime());
        Calendar endDate = Calendar.getInstance();
        endDate.clear();
        endDate.set(1, year + 5);
        endDate.set(2, 11);
        this.getModel().setValue("enddate", (Object)endDate.getTime());
    }

    private void setDefaultDate() {
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl("datescope");
        String key_headdatestart = headFieldEdit.getStartDateFieldKey();
        String key_headdateend = headFieldEdit.getEndDateFieldKey();
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        calendar.setTime(TimeServiceHelper.now());
        calendar.set(2, 0);
        calendar.set(5, 1);
        this.getModel().setValue(key_headdatestart, (Object)calendar.getTime());
        calendar.clear();
        calendar.set(1, year + 5);
        calendar.set(2, 0);
        this.getModel().setValue(key_headdateend, (Object)calendar.getTime());
    }

    private List<CurrencyConvertEntity> buildEntry() {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)EB_CURRENCYCONVERTSCHEM, (String)this.getCurrencyFilter(), (QFilter[])qfBuilder.toArrays());
        LinkedList<CurrencyConvertEntity> convertEntityList = new LinkedList<CurrencyConvertEntity>();
        if (load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                CurrencySchemEntity schemEntity;
                CurrencyConvertEntity convertEntity = new CurrencyConvertEntity();
                convertEntity.setId(dynamicObject.getString("id"));
                DynamicObject currencyraw = (DynamicObject)dynamicObject.get("currencyraw");
                DynamicObject currencyrate = (DynamicObject)dynamicObject.get("currencyrate");
                if (currencyraw == null || currencyrate == null) continue;
                convertEntity.setCurrencyRaw(currencyraw.getLong("id"));
                convertEntity.setCurrencyRate(currencyrate.getLong("id"));
                Object modifier = dynamicObject.get(MODIFIER);
                if (modifier != null) {
                    convertEntity.setCreator(((DynamicObject)dynamicObject.get(MODIFIER)).getString("id"));
                }
                convertEntity.setCreateTime((Date)dynamicObject.get(MODIFYTIME));
                convertEntity.setModel(((DynamicObject)dynamicObject.get("model")).getLong("id"));
                convertEntity.setBeginDate((Date)dynamicObject.get("begindate"));
                convertEntity.setEndDate((Date)dynamicObject.get("enddate"));
                String paritiesprecision = dynamicObject.getString("paritiesprecision");
                if (StringUtils.isEmpty((String)paritiesprecision)) {
                    convertEntity.setParitiesPrecision("6");
                } else {
                    convertEntity.setParitiesPrecision(paritiesprecision);
                }
                convertEntity.setParitiesOverturn((Boolean)dynamicObject.get("paritiesoverturn"));
                if (dynamicObject.get("state") == null) {
                    convertEntity.setState(true);
                } else {
                    convertEntity.setState((Boolean)dynamicObject.get("state"));
                }
                convertEntity.setDescription(dynamicObject.getString("description"));
                String entityrang = dynamicObject.getString("entityrang_tag");
                convertEntity.setEntityrang(entityrang);
                if (StringUtils.isNotEmpty((String)entityrang)) {
                    List entityrangList = SerializationUtils.fromJsonStringToList((String)entityrang, Map.class);
                    convertEntity.setEntityScope(this.getMultiSelectF7ReturnValue(entityrangList));
                }
                LinkedList<CurrencySchemEntity> schemEntityList = new LinkedList<CurrencySchemEntity>();
                if (((DynamicObjectCollection)dynamicObject.get(ENTRYENTITY)).size() > 0) {
                    DynamicObjectCollection entryentity = (DynamicObjectCollection)dynamicObject.get(ENTRYENTITY);
                    entryentity.sort((Comparator)new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            Date budgetdate1 = o1.getDate(CurrencyConvertListPlugin.BUDGETDATE);
                            Date budgetdate2 = o2.getDate(CurrencyConvertListPlugin.BUDGETDATE);
                            return budgetdate1.compareTo(budgetdate2);
                        }
                    });
                    if (convertEntity.getBeginDate() == null && convertEntity.getEndDate() == null) {
                        convertEntity.setBeginDate(((DynamicObject)entryentity.get(0)).getDate(BUDGETDATE));
                        convertEntity.setEndDate(((DynamicObject)entryentity.get(entryentity.size() - 1)).getDate(BUDGETDATE));
                    }
                    for (DynamicObject object : entryentity) {
                        schemEntity = new CurrencySchemEntity();
                        schemEntity.setId(object.getString("id"));
                        schemEntity.setBudgetDate((Date)object.get(BUDGETDATE));
                        schemEntity.setMeanParities((BigDecimal)object.get(MEANPARITIES));
                        schemEntity.setAddMeanParities((BigDecimal)object.get(ADDMEANPARITIES));
                        schemEntity.setEndParities((BigDecimal)object.get(ENDPARITIES));
                        if (object.get("endmodifier") != null) {
                            schemEntity.setEndModifier(((DynamicObject)object.get("endmodifier")).getLong("id"));
                        }
                        schemEntity.setEndModifyTime((Date)object.get("endmodifytime"));
                        schemEntityList.add(schemEntity);
                    }
                } else {
                    int year;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(TimeServiceHelper.now());
                    for (int i = year = calendar.get(1); i <= year + 5; ++i) {
                        for (int i1 = 0; i1 < 12; ++i1) {
                            schemEntity = new CurrencySchemEntity();
                            Calendar newDate = Calendar.getInstance();
                            newDate.clear();
                            newDate.set(1, i);
                            newDate.set(2, i1);
                            schemEntity.setBudgetDate(newDate.getTime());
                            schemEntityList.add(schemEntity);
                        }
                    }
                }
                convertEntity.setCurrencyList(schemEntityList);
                convertEntityList.add(convertEntity);
            }
            this.getPageCache().put(ENTITY_CACHE, SerializationUtils.serializeToBase64(convertEntityList));
        }
        return convertEntityList;
    }

    private String getCurrencyFilter() {
        return "id,creator,createtime,modifier,modifytime,model,state,begindate,enddate,paritiesprecision,entityrang_tag,paritiesoverturn,currencyraw,currencyrate,description,entryentity.id,entryentity.budgetdate,entryentity.meanparities,entryentity.addmeanparities,entryentity.endparities,entryentity.endmodifier,entryentity.endmodifytime";
    }

    private void refreshDimEntry(List<CurrencyConvertEntity> entities, String newId) {
        this.getPageCache().put("refersh", "1");
        if (newId == null) {
            CurrencyConvertEntity currencyConvertEntity = entities.get(0);
            this.getModel().setValue("paritiesprecision", (Object)currencyConvertEntity.getParitiesPrecision());
            this.getModel().setValue("paritiesoverturn", (Object)currencyConvertEntity.isParitiesOverturn());
            boolean state = currencyConvertEntity.isState();
            if (!(!state || this.checkParities(currencyConvertEntity) && this.checkScope(currencyConvertEntity))) {
                DynamicObject[] loads = this.getDynamicCurrency();
                this.setState(loads, false);
                currencyConvertEntity.setState(false);
                state = false;
            }
            this.getModel().setValue("state", (Object)state);
            boolean overturnSave = this.isOverturnSave(currencyConvertEntity);
            this.setEntry(currencyConvertEntity.getEntityScope());
            this.getModel().setValue("entityrang", (Object)currencyConvertEntity.getEntityrang());
            if (currencyConvertEntity.getBeginDate() == null && currencyConvertEntity.getEndDate() == null) {
                this.setDefaultDate();
            } else {
                this.getModel().setValue("startdate", (Object)currencyConvertEntity.getBeginDate());
                this.getModel().setValue("enddate", (Object)currencyConvertEntity.getEndDate());
            }
            List<CurrencySchemEntity> currencyList = currencyConvertEntity.getCurrencyList();
            this.setEntryEntity(currencyList);
            if (overturnSave) {
                this.isParitiesDivide();
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(!state), i, new String[]{MEANPARITIES, ADDMEANPARITIES, ENDPARITIES});
            }
            this.getView().setEnable(Boolean.valueOf(!state), new String[]{"datescope", "paritiesprecision"});
            this.setColEditorProp(currencyConvertEntity.getParitiesPrecision());
        } else {
            for (CurrencyConvertEntity convertEntity : entities) {
                if (!newId.equals(convertEntity.getId())) continue;
                this.getModel().setValue("paritiesprecision", (Object)convertEntity.getParitiesPrecision());
                this.getModel().setValue("paritiesoverturn", (Object)convertEntity.isParitiesOverturn());
                boolean state = convertEntity.isState();
                if (!(!state || this.checkParities(convertEntity) && this.checkScope(convertEntity))) {
                    DynamicObject[] loads = this.getDynamicCurrency();
                    this.setState(loads, false);
                    convertEntity.setState(false);
                    state = false;
                }
                this.getModel().setValue("state", (Object)state);
                boolean overturnSave = this.isOverturnSave(convertEntity);
                this.setEntry(convertEntity.getEntityScope());
                this.getModel().setValue("entityrang", (Object)convertEntity.getEntityrang());
                this.getModel().setValue("startdate", (Object)convertEntity.getBeginDate());
                this.getModel().setValue("enddate", (Object)convertEntity.getEndDate());
                this.setEntryEntity(convertEntity.getCurrencyList());
                if (overturnSave) {
                    this.isParitiesDivide();
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    this.getView().setEnable(Boolean.valueOf(!state), i, new String[]{MEANPARITIES, ADDMEANPARITIES, ENDPARITIES});
                }
                this.getView().setEnable(Boolean.valueOf(!state), new String[]{"datescope", "paritiesprecision"});
                this.setColEditorProp(convertEntity.getParitiesPrecision());
            }
        }
        this.getView().updateView(ENTRYENTITY);
        this.getPageCache().remove("refersh");
        this.getView().updateView("entry");
    }

    private boolean checkScope(CurrencyConvertEntity convertEntity) {
        List<CurrencyEntity> entityScope = convertEntity.getEntityScope();
        return entityScope != null && entityScope.size() > 0;
    }

    private boolean checkParities(CurrencyConvertEntity convertEntity) {
        List<CurrencySchemEntity> currencyList = convertEntity.getCurrencyList();
        for (CurrencySchemEntity schemEntity : currencyList) {
            BigDecimal meanParities = schemEntity.getMeanParities();
            BigDecimal addMeanParities = schemEntity.getAddMeanParities();
            BigDecimal endParities = schemEntity.getEndParities();
            if (meanParities == null || addMeanParities == null || endParities == null || meanParities.compareTo(BigDecimal.ZERO) <= 0 && addMeanParities.compareTo(BigDecimal.ZERO) <= 0 && endParities.compareTo(BigDecimal.ZERO) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isOverturnSave(CurrencyConvertEntity currencyConvertEntity) {
        if (currencyConvertEntity.isParitiesOverturn()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_enable", "btn_disable"});
            return true;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_save", "btn_enable", "btn_disable"});
        return false;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.deleteNotSave();
        this.getModel().setDataChanged(false);
    }

    private void deleteNotSave() {
        String save = this.getPageCache().get("save");
        if (StringUtils.isNotEmpty((String)save)) {
            List saves = (List)SerializationUtils.deSerializeFromBase64((String)save);
            List collect = saves.stream().map(Long::valueOf).collect(Collectors.toList());
            QFilter qfId = new QFilter("id", "in", collect);
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            DeleteServiceHelper.delete((String)EB_CURRENCYCONVERTSCHEM, (QFilter[])new QFilter[]{qfId, qFilter});
        }
    }

    private void setEntryEntity(List<CurrencySchemEntity> currencyList) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getPageCache().put("sign", "1");
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, currencyList.size());
        currencyList.sort(new Comparator<CurrencySchemEntity>(){

            @Override
            public int compare(CurrencySchemEntity o1, CurrencySchemEntity o2) {
                Date budgetDate1 = o1.getBudgetDate();
                Date budgetDate2 = o2.getBudgetDate();
                return budgetDate1.compareTo(budgetDate2);
            }
        });
        int row = 0;
        for (CurrencySchemEntity currency : currencyList) {
            this.getModel().setValue(BUDGETDATE, (Object)currency.getBudgetDate(), row);
            this.getModel().setValue(MEANPARITIES, (Object)currency.getMeanParities(), row);
            this.getModel().setValue(ADDMEANPARITIES, (Object)currency.getAddMeanParities(), row);
            this.getModel().setValue(ENDPARITIES, (Object)currency.getEndParities(), row);
            this.getModel().setValue(MODIFIER, (Object)currency.getEndModifier(), row);
            this.getModel().setValue(MODIFYTIME, (Object)currency.getEndModifyTime(), row);
            ++row;
        }
        this.getPageCache().remove("sign");
    }

    private void refreshNodeTree(String newId) {
        DynamicObjectCollection col = this.getDynamicObjects();
        col.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date createtime1 = o1.getDate("createtime");
                Date createtime2 = o2.getDate("createtime");
                return createtime1.compareTo(createtime2);
            }
        });
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u6298\u7b97\u65b9\u6848", (String)"CurrencyConvertListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ArrayList<TreeNode> children = root.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>(16);
        }
        ArrayList<Long> dirtyData = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : col) {
            this.getModel().setValue("currencyraw", dynamicObject.get("currencyraw"));
            this.getModel().setValue("currencyrate", dynamicObject.get("currencyrate"));
            TreeNode treeNode = new TreeNode();
            treeNode.setId(dynamicObject.getString("id"));
            treeNode.setParentid("0");
            StringBuilder group = new StringBuilder();
            DynamicObject currencyraw = (DynamicObject)this.getModel().getValue("currencyraw");
            DynamicObject currencyrate = (DynamicObject)this.getModel().getValue("currencyrate");
            if (currencyraw == null || currencyrate == null) {
                dirtyData.add(dynamicObject.getLong("id"));
                continue;
            }
            group.append(currencyraw.getString("name")).append(" \u2192 ").append(currencyrate.getString("name"));
            treeNode.setText(group.toString());
            children.add(treeNode);
        }
        root.setChildren(children);
        root.setIsOpened(true);
        TreeView tree = (TreeView)this.getControl(CURRENCYTREE);
        tree.deleteAllNodes();
        tree.addNode(root);
        if (newId != null) {
            TreeNode newNode = root.getTreeNode(newId, 20);
            if (newNode != null) {
                tree.focusNode(newNode);
                this.getPageCache().put("nodeId", newId);
            }
        } else if (children.size() > 0) {
            tree.focusNode((TreeNode)children.get(0));
            this.getPageCache().put("nodeId", ((TreeNode)children.get(0)).getId());
        }
        this.rewCurrency(dirtyData);
    }

    private void rewCurrency(List<Long> dirtyData) {
        if (dirtyData.size() > 0) {
            QFBuilder qfBuilder = new QFBuilder("id", "in", dirtyData);
            DynamicObject[] query = BusinessDataServiceHelper.load((String)EB_CURRENCYCONVERTSCHEM, (String)"id,number,currencyraw,currencyrate", (QFilter[])qfBuilder.toArray());
            QFBuilder qfBuilder1 = new QFBuilder(new QFilter("model", "=", (Object)this.getModelId()));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)SysDimensionEnum.Currency.getMemberTreemodel(), (String)"id,number,name", (QFilter[])qfBuilder1.toArray());
            HashMap currencyMap = new HashMap(dynamicObjects.size());
            dynamicObjects.forEach(e -> currencyMap.put(e.getString("number"), e.getLong("id")));
            for (DynamicObject object : query) {
                String number = object.getString("number");
                for (Map.Entry entry : currencyMap.entrySet()) {
                    if (!number.contains((CharSequence)entry.getKey())) continue;
                    String[] split = number.split((String)entry.getKey());
                    if (number.startsWith((String)entry.getKey())) {
                        object.set("currencyraw", entry.getValue());
                        if (currencyMap.get(split[1]) == null) continue;
                        object.set("currencyrate", currencyMap.get(split[1]));
                        continue;
                    }
                    object.set("currencyrate", entry.getValue());
                    if (currencyMap.get(split[0]) == null) continue;
                    object.set("currencyraw", currencyMap.get(split[0]));
                }
            }
            SaveServiceHelper.save((DynamicObject[])query);
        }
    }

    private DynamicObjectCollection getDynamicObjects() {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        return QueryServiceHelper.query((String)EB_CURRENCYCONVERTSCHEM, (String)"id,number,currencyraw,currencyrate,createtime,state,name", (QFilter[])qfBuilder.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("1".equals(this.getPageCache().get("refersh"))) {
            return;
        }
        String key = e.getProperty().getName();
        ArrayList<CurrencyConvertEntity> entityCache = new ArrayList(16);
        String cache = this.getPageCache().get(ENTITY_CACHE);
        if (StringUtils.isNotEmpty((String)cache)) {
            entityCache = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(ENTITY_CACHE));
        }
        String nodeId = this.getPageCache().get("nodeId");
        Boolean state = (Boolean)this.getModel().getValue("state");
        switch (key) {
            case "model": {
                DynamicObject model = (DynamicObject)this.getModel().getValue("model");
                if (model != null) {
                    Long modelId = model.getLong("id");
                    UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                    this.getPageCache().put("modelId", modelId.toString());
                    this.refreshNodeTree(null);
                    List<CurrencyConvertEntity> entities = this.buildEntry();
                    if (entities.size() > 0) {
                        this.refreshDimEntry(entities, null);
                    } else {
                        this.getPageCache().put("refersh", "1");
                        this.getPageCache().remove(ENTITY_CACHE);
                        this.getPageCache().remove("nodeId");
                        this.structureStartDate();
                        this.getModel().setValue("paritiesprecision", (Object)"6");
                        this.getModel().setValue("paritiesoverturn", (Object)false);
                        this.getModel().setValue("state", (Object)false);
                        this.getModel().deleteEntryData(ENTRYENTITY);
                        this.getModel().deleteEntryData("entry");
                        this.getView().updateView(ENTRYENTITY);
                        this.getView().updateView("entry");
                        this.getPageCache().remove("refersh");
                    }
                }
                this.deleteNotSave();
                break;
            }
            case "meanparities": 
            case "addmeanparities": 
            case "endparities": {
                String parities = this.getPageCache().get("parities");
                if ("1".equals(parities)) {
                    return;
                }
                if (!StringUtils.isEmpty((String)this.getPageCache().get("sign"))) break;
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"paritiesoverturn"});
                if (this.estimateParities(rowIndex)) {
                    this.getModel().setValue(MODIFIER, null, rowIndex);
                    this.getModel().setValue(MODIFYTIME, null, rowIndex);
                } else {
                    this.getModel().setValue(MODIFIER, (Object)UserUtils.getUserId(), rowIndex);
                    this.getModel().setValue(MODIFYTIME, (Object)TimeServiceHelper.now(), rowIndex);
                }
                this.getView().updateView(ENTRYENTITY);
                DynamicObject entryentity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
                for (CurrencyConvertEntity convert : entityCache) {
                    List<CurrencySchemEntity> currencyList;
                    Map<Date, CurrencySchemEntity> currencyEntityMap;
                    if (!nodeId.equals(convert.getId()) || (currencyEntityMap = this.getCurrencyEntityMap(currencyList = convert.getCurrencyList())).get((Date)entryentity.get(BUDGETDATE)) == null) continue;
                    CurrencySchemEntity currencySchemEntity = currencyEntityMap.get((Date)entryentity.get(BUDGETDATE));
                    if (key.equals(MEANPARITIES)) {
                        currencySchemEntity.setMeanParities((BigDecimal)entryentity.get(MEANPARITIES));
                    } else if (key.equals(ADDMEANPARITIES)) {
                        currencySchemEntity.setAddMeanParities((BigDecimal)entryentity.get(ADDMEANPARITIES));
                    } else {
                        currencySchemEntity.setEndParities((BigDecimal)entryentity.get(ENDPARITIES));
                    }
                    if (entryentity.get(MODIFIER) == null) {
                        currencySchemEntity.setEndModifier(null);
                        currencySchemEntity.setEndModifyTime(null);
                        continue;
                    }
                    currencySchemEntity.setEndModifier(((DynamicObject)entryentity.get(MODIFIER)).getLong("id"));
                    currencySchemEntity.setEndModifyTime(entryentity.getDate(MODIFYTIME));
                }
                this.getPageCache().put(ENTITY_CACHE, SerializationUtils.serializeToBase64(entityCache));
                break;
            }
            case "startdate": 
            case "enddate": {
                if (state.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.buildDateRange(entityCache, nodeId);
                break;
            }
            case "paritiesoverturn": {
                Boolean paritiesoverturn = (Boolean)this.getModel().getValue("paritiesoverturn");
                for (CurrencyConvertEntity convertEntity : entityCache) {
                    DynamicObject[] dynamicCurrencys;
                    if (!nodeId.equals(convertEntity.getId())) continue;
                    convertEntity.setParitiesOverturn(paritiesoverturn);
                    this.getPageCache().put(ENTITY_CACHE, SerializationUtils.serializeToBase64(entityCache));
                    if (paritiesoverturn.booleanValue()) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save", "btn_enable", "btn_disable"});
                        this.isParitiesDivide();
                        this.getPageCache().put("parities", "1");
                    } else {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_save", "btn_enable", "btn_disable"});
                        this.refreshDimEntry(entityCache, convertEntity.getId());
                        this.getPageCache().put("parities", "0");
                    }
                    if ((dynamicCurrencys = this.getDynamicCurrency()).length <= 0) continue;
                    DynamicObject dynamicCurrency = dynamicCurrencys[0];
                    String entityrang = (String)dynamicCurrency.get("entityrang_tag");
                    DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)dynamicCurrency.get(ENTRYENTITY);
                    if (!StringUtils.isNotEmpty((String)entityrang) || dynamicObjects.size() <= 0) continue;
                    dynamicCurrency.set("paritiesoverturn", this.getModel().getValue("paritiesoverturn"));
                    SaveServiceHelper.save((DynamicObject[])dynamicCurrencys);
                }
                break;
            }
            case "paritiesprecision": {
                if (state.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                String accuracy = (String)this.getModel().getValue("paritiesprecision");
                if (!StringUtils.isNotEmpty((String)accuracy)) break;
                this.setEntryAccuracy(entityCache, nodeId, accuracy);
                break;
            }
        }
    }

    private void setEntryAccuracy(List<CurrencyConvertEntity> entityCache, String nodeId, String accuracy) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        Boolean paritiesoverturn = (Boolean)this.getModel().getValue("paritiesoverturn");
        if (paritiesoverturn.booleanValue()) {
            for (CurrencyConvertEntity convertEntity : entityCache) {
                if (!nodeId.equals(convertEntity.getId())) continue;
                convertEntity.setParitiesPrecision(accuracy);
                List<CurrencySchemEntity> currencyList = convertEntity.getCurrencyList();
                for (CurrencySchemEntity schemEntity : currencyList) {
                    BigDecimal meanparities = schemEntity.getMeanParities().setScale(Integer.parseInt(accuracy), 4);
                    schemEntity.setMeanParities(meanparities);
                    BigDecimal addmeanparities = schemEntity.getAddMeanParities().setScale(Integer.parseInt(accuracy), 4);
                    schemEntity.setAddMeanParities(addmeanparities);
                    BigDecimal endparities = schemEntity.getEndParities().setScale(Integer.parseInt(accuracy), 4);
                    schemEntity.setEndParities(endparities);
                }
                this.getPageCache().put(ENTITY_CACHE, SerializationUtils.serializeToBase64(entityCache));
                this.refreshDimEntry(entityCache, nodeId);
            }
        } else {
            for (CurrencyConvertEntity convert : entityCache) {
                if (!nodeId.equals(convert.getId())) continue;
                convert.setParitiesPrecision(accuracy);
                List<CurrencySchemEntity> currencyList = convert.getCurrencyList();
                Map<Date, CurrencySchemEntity> currencyEntityMap = this.getCurrencyEntityMap(currencyList);
                for (DynamicObject dynamicObject : entity) {
                    if (currencyEntityMap.get((Date)dynamicObject.get(BUDGETDATE)) == null) continue;
                    CurrencySchemEntity currencySchemEntity = currencyEntityMap.get((Date)dynamicObject.get(BUDGETDATE));
                    BigDecimal meanparities = ((BigDecimal)dynamicObject.get(MEANPARITIES)).setScale(Integer.parseInt(accuracy), 4);
                    dynamicObject.set(MEANPARITIES, (Object)meanparities);
                    currencySchemEntity.setMeanParities(meanparities);
                    BigDecimal addmeanparities = ((BigDecimal)dynamicObject.get(ADDMEANPARITIES)).setScale(Integer.parseInt(accuracy), 4);
                    dynamicObject.set(ADDMEANPARITIES, (Object)addmeanparities);
                    currencySchemEntity.setAddMeanParities(addmeanparities);
                    BigDecimal endparities = ((BigDecimal)dynamicObject.get(ENDPARITIES)).setScale(Integer.parseInt(accuracy), 4);
                    dynamicObject.set(ENDPARITIES, (Object)endparities);
                    currencySchemEntity.setEndParities(endparities);
                }
            }
            this.getPageCache().put(ENTITY_CACHE, SerializationUtils.serializeToBase64(entityCache));
            this.setColEditorProp(accuracy);
        }
    }

    private void buildDateRange(List<CurrencyConvertEntity> entityCache, String nodeId) {
        for (CurrencyConvertEntity convert : entityCache) {
            if (!nodeId.equals(convert.getId())) continue;
            Date startdate = (Date)this.getModel().getValue("startdate");
            Date enddate = (Date)this.getModel().getValue("enddate");
            if (startdate == null || enddate == null) continue;
            convert.setBeginDate(startdate);
            convert.setEndDate(enddate);
            Calendar bugCalendar = Calendar.getInstance();
            bugCalendar.setTime(startdate);
            bugCalendar.set(5, 1);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(enddate);
            endCalendar.set(5, 1);
            List<CurrencySchemEntity> currencyList = convert.getCurrencyList();
            this.setCurrencyParitty(convert, bugCalendar, endCalendar, currencyList);
            this.getPageCache().put(ENTITY_CACHE, SerializationUtils.serializeToBase64(entityCache));
            this.refreshDimEntry(entityCache, convert.getId());
        }
    }

    private void setColEditorProp(String accuracy) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ENTRYENTITY, "setColEditorProp", new Object[]{MEANPARITIES, "sc", Integer.parseInt(accuracy)});
        clientViewProxy.invokeControlMethod(ENTRYENTITY, "setColEditorProp", new Object[]{ADDMEANPARITIES, "sc", Integer.parseInt(accuracy)});
        clientViewProxy.invokeControlMethod(ENTRYENTITY, "setColEditorProp", new Object[]{ENDPARITIES, "sc", Integer.parseInt(accuracy)});
        this.getView().updateView(ENTRYENTITY);
    }

    private void setCurrencyParitty(CurrencyConvertEntity convert, Calendar bugCalendar, Calendar endCalendar, List<CurrencySchemEntity> currencyList) {
        Map<Date, CurrencySchemEntity> currencyEntityMap = this.getCurrencyEntityMap(currencyList);
        ArrayList<CurrencySchemEntity> newCurrencyList = new ArrayList<CurrencySchemEntity>(16);
        while (bugCalendar.compareTo(endCalendar) <= 0) {
            Date time = bugCalendar.getTime();
            CurrencySchemEntity currencySchemEntity = new CurrencySchemEntity();
            currencySchemEntity.setBudgetDate(time);
            if (currencyEntityMap.get(time) != null) {
                CurrencySchemEntity schemEntity = currencyEntityMap.get(time);
                currencySchemEntity.setMeanParities(schemEntity.getMeanParities());
                currencySchemEntity.setEndParities(schemEntity.getEndParities());
                currencySchemEntity.setAddMeanParities(schemEntity.getAddMeanParities());
                currencySchemEntity.setEndModifier(schemEntity.getEndModifier());
                currencySchemEntity.setEndModifyTime(schemEntity.getEndModifyTime());
            }
            newCurrencyList.add(currencySchemEntity);
            bugCalendar.add(2, 1);
        }
        convert.setCurrencyList(newCurrencyList);
    }

    private void isParitiesDivide() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        BigDecimal bigDecimal = new BigDecimal(1);
        for (DynamicObject dynamicObject : entryEntity) {
            BigDecimal endparities;
            BigDecimal addmeanparities;
            BigDecimal meanparities = (BigDecimal)dynamicObject.get(MEANPARITIES);
            if (meanparities.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal bigDecimal1 = bigDecimal.divide(meanparities, 6, 4);
                dynamicObject.set(MEANPARITIES, (Object)bigDecimal1);
            }
            if ((addmeanparities = (BigDecimal)dynamicObject.get(ADDMEANPARITIES)).compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal divide = bigDecimal.divide(addmeanparities, 6, 4);
                dynamicObject.set(ADDMEANPARITIES, (Object)divide);
            }
            if ((endparities = (BigDecimal)dynamicObject.get(ENDPARITIES)).compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal divide = bigDecimal.divide(endparities, 6, 4);
            dynamicObject.set(ENDPARITIES, (Object)divide);
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{MEANPARITIES, ADDMEANPARITIES, ENDPARITIES});
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private Map<Date, CurrencySchemEntity> getCurrencyEntityMap(List<CurrencySchemEntity> currencyList) {
        HashMap<Date, CurrencySchemEntity> schemEntityMap = new HashMap<Date, CurrencySchemEntity>(currencyList.size());
        for (CurrencySchemEntity schemEntity : currencyList) {
            schemEntityMap.put(schemEntity.getBudgetDate(), schemEntity);
        }
        return schemEntityMap;
    }

    private boolean estimateParities(int row) {
        IDataModel iDataModel = this.getModel();
        BigDecimal meanparities = (BigDecimal)iDataModel.getValue(MEANPARITIES, row);
        BigDecimal addmeanparities = (BigDecimal)iDataModel.getValue(ADDMEANPARITIES, row);
        BigDecimal endparities = (BigDecimal)iDataModel.getValue(ENDPARITIES, row);
        return meanparities.compareTo(BigDecimal.ZERO) == 0 && addmeanparities.compareTo(BigDecimal.ZERO) == 0 && endparities.compareTo(BigDecimal.ZERO) == 0;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"CurrencyConvertListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dynamicObjects = this.getDynamicObjects();
        switch (key) {
            case "btn_allot": {
                Boolean state1 = (Boolean)this.getModel().getValue("state");
                if (state1.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.showMutilDimensionF7Form();
                break;
            }
            case "btn_save": {
                if (dynamicObjects.size() > 0) {
                    this.saveCurrent(key);
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58\u5206\u5f55", "EbDimMemberMapListPlugin_50", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "EbDimMemberMapPlugin_28", "epm-eb-formplugin");
                    this.writeLogWithEntityNumber(EB_CURRENCYCONVERTSCHEM, null, "save", opName, opDesc, null);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6298\u7b97\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                if (dynamicObjects.size() > 0) {
                    DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
                    if (this.checkBeforeClick(entity) || "btn_disable".equals(key)) {
                        if (this.checkBeforeEntry() || "btn_disable".equals(key)) {
                            MultiLangEnumBridge opName;
                            if (this.judgeState(key)) {
                                return;
                            }
                            DynamicObject[] loads = this.getDynamicCurrency();
                            DynamicObject load = loads[0];
                            if ("btn_enable".equals(key)) {
                                if (this.checkEnableSameCurrency(dynamicObjects, load)) {
                                    return;
                                }
                                this.saveCurrent(key);
                                this.setState(loads, true);
                                for (int i = 0; i < entity.size(); ++i) {
                                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{MEANPARITIES, ADDMEANPARITIES, ENDPARITIES});
                                }
                                this.updateSchemeUpdateLog(true);
                                opName = new MultiLangEnumBridge("\u542f\u7528", "DimMemberUploadPlugin_6", "epm-eb-formplugin");
                                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u542f\u7528\u6210\u529f", "ControlProcessListPlugin_11", "epm-eb-formplugin");
                                this.writeLogWithEntityNumber(EB_CURRENCYCONVERTSCHEM, null, "enable", opName, opDesc, null);
                                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CurrencyConvertListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            } else {
                                this.setState(loads, false);
                                for (int i = 0; i < entity.size(); ++i) {
                                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{MEANPARITIES, ADDMEANPARITIES, ENDPARITIES});
                                }
                                this.updateSchemeUpdateLog(false);
                                opName = new MultiLangEnumBridge("\u7981\u7528", "DimMemberUploadPlugin_27", "epm-eb-formplugin");
                                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7981\u7528\u6210\u529f", "ControlProcessListPlugin_12", "epm-eb-formplugin");
                                this.writeLogWithEntityNumber(EB_CURRENCYCONVERTSCHEM, null, "disable", opName, opDesc, null);
                                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CurrencyConvertListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            this.refreshNodeTree(load.getString("id"));
                            List<CurrencyConvertEntity> entities = this.buildEntry();
                            if (entities.size() > 0) {
                                this.refreshDimEntry(entities, load.getString("id"));
                            }
                            this.clearCacheScheme();
                            break;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u7b97\u65b9\u6848\u8bbe\u7f6e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u6c47\u7387\u3001\u5e94\u7528\u8303\u56f4\u5206\u914d\u3002", (String)"CurrencyConvertListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u7b97\u65b9\u6848\u8bbe\u7f6e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u6c47\u7387\u3001\u5e94\u7528\u8303\u56f4\u5206\u914d\u3002", (String)"CurrencyConvertListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6298\u7b97\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean checkEnableSameCurrency(DynamicObjectCollection dynamicObjects, DynamicObject load) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects) || load == null) {
            return false;
        }
        List enableDynList = dynamicObjects.stream().filter(e -> e.getBoolean("state")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(enableDynList)) {
            HashMap<String, HashSet> enableDynCurrMap = new HashMap<String, HashSet>(16);
            for (DynamicObject dynamicObject : enableDynList) {
                enableDynCurrMap.put(dynamicObject.getString("name"), Sets.newHashSet((Object[])new Long[]{dynamicObject.getLong("currencyraw"), dynamicObject.getLong("currencyrate")}));
            }
            long currencyRaw = load.getDynamicObject("currencyraw").getLong("id");
            long currencyRate = load.getDynamicObject("currencyrate").getLong("id");
            for (Map.Entry entry : enableDynCurrMap.entrySet()) {
                String name = (String)entry.getKey();
                Set currencySet = (Set)entry.getValue();
                if (!currencySet.contains(currencyRaw) || !currencySet.contains(currencyRate)) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6b64\u6298\u7b97\u65b9\u6848\u4e0e\u65b9\u6848%1\u6709\u76f8\u540c\u7684\u539f\u5e01\u3001\u6298\u7b97\u5e01\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u3002", (String)"CurrencyConvertListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{name}));
                return true;
            }
        }
        return false;
    }

    private boolean judgeState(String key) {
        Boolean state = (Boolean)this.getModel().getValue("state");
        if ("btn_enable".equals(key)) {
            if (state.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\u3002", (String)"CurrencyConvertListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else if (!state.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u7981\u7528\u3002", (String)"CurrencyConvertListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setState(DynamicObject[] load, Boolean flse) {
        if (load.length > 0) {
            DynamicObject dynamicCurrency = load[0];
            dynamicCurrency.set("state", (Object)flse);
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "btn_addnew": 
            case "btn_modify": {
                if ("btn_modify".equals(key)) {
                    Boolean state1 = (Boolean)this.getModel().getValue("state");
                    if (state1.booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.openDimensionList(key);
                    break;
                }
                this.openDimensionList(key);
                break;
            }
            case "btn_delete": {
                if (this.getDynamicObjects().size() > 0) {
                    DynamicObject[] loads = this.getDynamicCurrency();
                    if (loads.length <= 0) break;
                    DynamicObject load = loads[0];
                    if (load.get("state") != null) {
                        Boolean state = (Boolean)load.get("state");
                        if (!state.booleanValue()) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5df2\u9009\u7684\u6298\u7b97\u65b9\u6848\uff1f", (String)"CurrencyConvertListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
                            break;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u7b97\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CurrencyConvertListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u7b97\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CurrencyConvertListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6298\u7b97\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void updateSchemeUpdateLog(boolean enable) {
        String nodeId = this.getPageCache().get("nodeId");
        if (StringUtils.isEmpty((String)nodeId) || "0".equals(nodeId)) {
            return;
        }
        schemeService.createOrUpdateSchemeUpdateLog(this.getModelId().longValue(), enable, Long.valueOf(nodeId));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if ("delete_comfirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deleteCurrency();
        }
    }

    private void deleteCurrency() {
        block17: {
            String nodeId = this.getPageCache().get("nodeId");
            QFilter qfId = new QFilter("id", "=", (Object)IDUtils.toLong((Object)nodeId));
            QFilter afScheme = new QFilter("scheme", "=", (Object)Convert.toLong((Object)nodeId));
            try (TXHandle tx = TX.requiresNew((String)"deleteCurrency");){
                try {
                    DeleteServiceHelper.delete((String)"eb_currconvertupdate", (QFilter[])afScheme.toArray());
                    int delete = DeleteServiceHelper.delete((String)EB_CURRENCYCONVERTSCHEM, (QFilter[])new QFilter[]{qfId});
                    if (delete > 0) {
                        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "EbDimMemberMapListPlugin_15", "epm-eb-formplugin");
                        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "EbDimMemberMapListPlugin_16", "epm-eb-formplugin");
                        this.writeLogWithEntityNumber(EB_CURRENCYCONVERTSCHEM, null, "delete", opName, opDesc, null);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"CurrencyConvertListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        break block17;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"CurrencyConvertListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"CurrencyConvertListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
        this.refreshNodeTree(null);
        List<CurrencyConvertEntity> entities = this.buildEntry();
        if (entities.size() > 0) {
            this.refreshDimEntry(entities, null);
        } else {
            this.getPageCache().put("refersh", "1");
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            this.getModel().setValue("paritiesprecision", (Object)"6");
            this.getModel().setValue("paritiesoverturn", (Object)false);
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().deleteEntryData("entry");
            this.getPageCache().remove("refersh");
            this.getView().updateView(ENTRYENTITY);
            this.getView().updateView("entry");
        }
        this.clearCacheScheme();
    }

    private void clearCacheScheme() {
        CurrencyConvertCache convertCache = CurrencyConvertCache.getInstance();
        convertCache.clearSchemeCacheForModelId(this.getModelId());
    }

    private void saveCurrent(String key) {
        Object[] save;
        DynamicObject[] loads = this.getDynamicCurrency();
        String newId = "";
        if (loads.length > 0) {
            DynamicObject load = loads[0];
            Date headdatestart = (Date)this.getModel().getValue("startdate");
            Date headdateend = (Date)this.getModel().getValue("enddate");
            if (headdatestart == null || headdateend == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"CurrencyConvertListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            newId = load.getString("id");
            load.set("begindate", (Object)headdatestart);
            load.set("enddate", (Object)headdateend);
            load.set("paritiesprecision", this.getModel().getValue("paritiesprecision"));
            load.set("paritiesoverturn", this.getModel().getValue("paritiesoverturn"));
            load.set("state", this.getModel().getValue("state"));
            load.set("entityrang_tag", this.getModel().getValue("entityrang"));
            load.set(MODIFIER, (Object)UserUtils.getUserId());
            load.set(MODIFYTIME, (Object)TimeServiceHelper.now());
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)load.get(ENTRYENTITY);
            dynamicObjects.clear();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject object : entryentity) {
                DynamicObject dynamicObject = dynamicObjects.addNew();
                dynamicObject.set(BUDGETDATE, object.get(BUDGETDATE));
                dynamicObject.set(MEANPARITIES, object.get(MEANPARITIES));
                dynamicObject.set(ADDMEANPARITIES, object.get(ADDMEANPARITIES));
                dynamicObject.set(ENDPARITIES, object.get(ENDPARITIES));
                dynamicObject.set("endmodifier", object.get(MODIFIER));
                dynamicObject.set("endmodifytime", object.get(MODIFYTIME));
            }
        }
        if ((save = SaveServiceHelper.save((DynamicObject[])loads)) != null && save.length > 0) {
            String saveCache = this.getPageCache().get("save");
            List saveCaches = null;
            ArrayList saveCacheList = new ArrayList(16);
            if (StringUtils.isNotEmpty((String)saveCache)) {
                saveCaches = (List)SerializationUtils.deSerializeFromBase64((String)saveCache);
            }
            if (saveCaches != null) {
                String finalNewId = newId;
                saveCaches.forEach(e -> {
                    if (!e.equals(finalNewId)) {
                        saveCacheList.add(e);
                    }
                });
                this.getPageCache().put("save", SerializationUtils.serializeToBase64(saveCacheList));
            }
            if ("btn_save".equals(key)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CurrencyConvertListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"paritiesoverturn"});
        } else if ("btn_save".equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CurrencyConvertListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject[] getDynamicCurrency() {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        String nodeId = this.getPageCache().get("nodeId");
        qfBuilder.add(new QFilter("id", "=", (Object)Long.valueOf(nodeId)));
        return BusinessDataServiceHelper.load((String)EB_CURRENCYCONVERTSCHEM, (String)this.getCurrencyFilter(), (QFilter[])qfBuilder.toArrays());
    }

    private boolean checkBeforeClick(DynamicObjectCollection entryentity) {
        for (DynamicObject dynamicObject : entryentity) {
            BigDecimal meanparities = (BigDecimal)dynamicObject.get(MEANPARITIES);
            BigDecimal addmeanparities = (BigDecimal)dynamicObject.get(ADDMEANPARITIES);
            BigDecimal endparities = (BigDecimal)dynamicObject.get(ENDPARITIES);
            if (meanparities.compareTo(BigDecimal.ZERO) <= 0 && addmeanparities.compareTo(BigDecimal.ZERO) <= 0 && endparities.compareTo(BigDecimal.ZERO) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkBeforeEntry() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entry");
        return entity.size() > 0;
    }

    private void showMutilDimensionF7Form() {
        if (this.getDynamicObjects().size() > 0) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ENTITY);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("isShowDisableVisible", (Object)false);
            String entityrang = (String)this.getModel().getValue("entityrang");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)this.getModelId(), (String)SysDimensionEnum.Entity.getNumber(), (String)DynamicObjectCollection.class.getName());
            Long defaultViewIdOnDim = modelCache.getDefaultViewIdOnDim(SysDimensionEnum.Entity.getNumber());
            f8Param.setViewId(defaultViewIdOnDim);
            f8Param.setEnableView(true);
            f8Param.setLoadDefaultBusModel(false);
            if (StringUtils.isNotEmpty((String)entityrang)) {
                List serialize = SerializationUtils.fromJsonStringToList((String)entityrang, Map.class);
                ArrayList<MemberCondition> membersRange = new ArrayList<MemberCondition>(serialize.size());
                Long viewId = defaultViewIdOnDim;
                for (Map stringMap : serialize) {
                    membersRange.add(new MemberCondition((String)stringMap.get("number"), (String)stringMap.get("name"), "", (String)stringMap.get("scope")));
                    try {
                        viewId = Long.parseLong((String)stringMap.get("viewId"));
                    }
                    catch (Exception exception) {}
                }
                f8Param.setViewId(viewId);
                CustomF7utils.loadSelectedData(membersRange, (MemberF7Parameter)f8Param, (Dimension)modelCache.getDimension(SysDimensionEnum.Entity.getNumber()));
            }
            NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)closeCallBack);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6298\u7b97\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void openDimensionList(String key) {
        if (StringUtils.isEmpty((String)this.getPageCache().get("nodeId")) && "btn_modify".equals(key)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6298\u7b97\u65b9\u6848\u3002", (String)"CurrencyConvertListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(EB_CURRENCYCONVERTSCHEM);
            showParameter.setCustomParam("modelId", (Object)this.getPageCache().get("modelId"));
            if ("btn_modify".equals(key)) {
                showParameter.setCustomParam("isAdd", (Object)"1");
                showParameter.setCustomParam("nodeId", (Object)this.getPageCache().get("nodeId"));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CURRENCYCONVERT);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(true);
            this.getPageCache().put("addOrModify", key);
            this.getView().showForm(showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection rows;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        if (ADD_CURRENCYCONVERT.equals(key) && backData != null) {
            String newId = String.valueOf(backData);
            this.refreshNodeTree(newId);
            List<CurrencyConvertEntity> entities = this.buildEntry();
            if (entities.size() > 0) {
                this.refreshDimEntry(entities, newId);
            }
            String save = this.getPageCache().get("save");
            String addOrModify = this.getPageCache().get("addOrModify");
            if ("btn_addnew".equals(addOrModify)) {
                List<String> stringList = new ArrayList<String>(16);
                if (StringUtils.isNotEmpty((String)save)) {
                    stringList = (List)SerializationUtils.deSerializeFromBase64((String)save);
                    stringList.add(newId);
                } else {
                    stringList.add(newId);
                }
                this.getPageCache().put("save", SerializationUtils.serializeToBase64(stringList));
            }
        }
        if (ENTITY.equals(key) && (rows = (DynamicObjectCollection)closedCallBackEvent.getReturnData()) != null) {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
            for (DynamicObject row : rows) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("id", row.getString("memberid"));
                map.put("scope", row.getString("scope"));
                map.put("number", row.getString("number"));
                map.put("name", row.getString("name"));
                map.put("pid", row.getString("pid"));
                map.put("viewId", row.getString("viewid"));
                list.add(map);
            }
            List<CurrencyEntity> currencyEntities = this.getMultiSelectF7ReturnValue(list);
            this.setEntry(currencyEntities);
            String jsonString = SerializationUtils.toJsonString(list);
            this.setEntityRang(jsonString, currencyEntities);
            this.getModel().setValue(key + "rang", (Object)jsonString);
        }
    }

    private void setEntry(List<CurrencyEntity> currencyEntities) {
        this.getModel().deleteEntryData("entry");
        if (currencyEntities != null && currencyEntities.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entry", currencyEntities.size());
            int entryRow = 0;
            for (CurrencyEntity currencyEntity : currencyEntities) {
                DynamicObject entry = this.getModel().getEntryRowEntity("entry", entryRow);
                entry.set("number", (Object)currencyEntity.getNumber());
                entry.set("name", (Object)currencyEntity.getName());
                entry.set("currency", (Object)currencyEntity.getCurrency());
                ++entryRow;
            }
        }
        this.getView().updateView("entry");
    }

    private void setEntityRang(String jsonString, List<CurrencyEntity> returnValue) {
        List entity = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(ENTITY_CACHE));
        String nodeId = this.getPageCache().get("nodeId");
        for (CurrencyConvertEntity convertEntity : entity) {
            if (!nodeId.equals(convertEntity.getId())) continue;
            convertEntity.setEntityScope(returnValue);
            convertEntity.setEntityrang(jsonString);
        }
        this.getPageCache().put(ENTITY_CACHE, SerializationUtils.serializeToBase64((Object)entity));
    }

    private List<CurrencyEntity> getMultiSelectF7ReturnValue(List<Map<String, String>> list) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        LinkedList<CurrencyEntity> entityScope = new LinkedList<CurrencyEntity>();
        IModelCacheHelper model = ModelCacheContext.getOrCreate((Long)this.getModelId());
        ArrayList memberId = new ArrayList(16);
        ArrayList memberNumber = new ArrayList(16);
        for (Map<String, String> stringMap : list) {
            long viewId = 0L;
            try {
                viewId = Long.parseLong(stringMap.get("viewId"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            List members = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), stringMap.get("number"), Integer.parseInt(stringMap.get("scope")));
            members.forEach(d -> memberId.add(d.getId()));
            members.forEach(e -> memberNumber.add(e.getNumber()));
        }
        QFBuilder qfBuilder = new QFBuilder("number", "in", memberNumber);
        qfBuilder.add(new QFilter("id", "in", memberId));
        DynamicObject[] query = BusinessDataServiceHelper.load((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number,name,currency", (QFilter[])qfBuilder.toArray());
        StringBuilder errorMsg = new StringBuilder();
        for (DynamicObject dynamicObject : query) {
            CurrencyEntity currencyEntity = new CurrencyEntity();
            currencyEntity.setNumber(dynamicObject.getString("number"));
            currencyEntity.setName(dynamicObject.getString("name"));
            if (dynamicObject.get("currency") == null) {
                errorMsg.append(dynamicObject.getString("number")).append(",");
                continue;
            }
            currencyEntity.setCurrency(((DynamicObject)dynamicObject.get("currency")).getString("name"));
            entityScope.add(currencyEntity);
        }
        if (StringUtils.isNotEmpty((String)errorMsg.toString())) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ec4\u7ec7%1\u7f3a\u5c11\u9ed8\u8ba4\u5e01\u79cd\u3002", (String)"CurrencyConvertListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{errorMsg.deleteCharAt(errorMsg.lastIndexOf(","))}));
        }
        return entityScope;
    }

    @Override
    public Long getModelId() {
        Object model = this.getModel().getValue("model");
        if (model instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        return 0L;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source = (EntryGrid)evt.getSource();
        if (ENTRYENTITY.equals(source.getEntryKey())) {
            this.getPageCache().put("entryRow", String.valueOf(evt.getRow()));
        }
    }
}

