/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.currencyconvert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.UserSelectUtil;

public class CurrencyConvertLogPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(CurrencyConvertLogPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent e) {
                e.getQFilters().add(CurrencyConvertLogPlugin.this.getBillListQFilter());
            }
        });
    }

    private QFilter getBillListQFilter() {
        long modelId = this.getModelId();
        return new QFilter("model", "=", (Object)modelId);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit modelBaseData = (BasedataEdit)this.getView().getControl("model");
        modelBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "refresh": {
                this.refreshBilllist();
                break;
            }
            case "download": {
                this.download();
                break;
            }
        }
    }

    private void download() {
        DynamicObject[] load;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows == null || selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"CurrencyConvertLogPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)billlist.getEntityType())) {
            this.downloadLog(dynamicObject);
        }
        this.writeLog("download", new MultiLangEnumBridge("\u4e0b\u8f7d", "CurrencyConvertLogPlugin_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4e0b\u8f7d\u6210\u529f", "CurrencyConvertLogPlugin_2", "epm-eb-formplugin"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNotNull((Long)model)) {
            this.getModel().setValue("model", (Object)model);
            this.getPageCache().put("KEY_MODEL_ID", model.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "model": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue != null) {
                    Long id = ((DynamicObject)newValue).getLong("id");
                    UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)id);
                    this.getPageCache().put("KEY_MODEL_ID", id.toString());
                }
                this.refreshBilllist();
                break;
            }
        }
    }

    private void refreshBilllist() {
        BillList control = (BillList)this.getControl("billlistap");
        control.clearSelection();
        control.refresh();
    }

    @Override
    public Long getModelId() {
        Object model = this.getModel().getValue("model");
        if (model instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        return 0L;
    }

    private void downloadLog(DynamicObject doj) {
        String convertrange = doj.getString("convertrange");
        Date executedate = doj.getDate("executedate");
        SimpleDateFormat format = new SimpleDateFormat("yyyy/mm/dd");
        String date = format.format(executedate);
        convertrange = convertrange + date;
        String fileUrl = this.createFileUrl(doj.getString("convertlog"), convertrange);
        this.getClientViewProxy().addAction("download", (Object)fileUrl);
    }

    private IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private String createFileUrl(String log, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            outStream.write(log.getBytes());
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Throwable ex) {
            CurrencyConvertLogPlugin.log.error(ex);
            throw new KDBizException(ex.getMessage());
        }
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".txt", (InputStream)inStream, 10000);
    }
}

