/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.currencyconvert;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class CurrencyConvertSchemePlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    public static final String EB_CURRENCYCONVERTSCHEM = "eb_currencyconvertschem";
    public static final String MODEL = "model";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(MODEL, (Object)this.getModelId());
        if (this.estimateNodeId()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(TimeServiceHelper.now());
            int year = calendar.get(1);
            Calendar newDate = Calendar.getInstance();
            newDate.clear();
            newDate.set(1, year);
            newDate.set(2, 0);
            this.getModel().setValue("begindate", (Object)newDate.getTime());
            Calendar endDate = Calendar.getInstance();
            endDate.clear();
            endDate.set(1, year + 5);
            endDate.set(2, 11);
            this.getModel().setValue("enddate", (Object)endDate.getTime());
            this.getModel().setValue("paritiesprecision", (Object)"6");
            this.getModel().setValue("paritiesoverturn", (Object)false);
        } else {
            String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
            QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
            qfBuilder.add(new QFilter("id", "=", (Object)Long.valueOf(nodeId)));
            DynamicObjectCollection load = QueryServiceHelper.query((String)EB_CURRENCYCONVERTSCHEM, (String)this.getCurrencyFilter(), (QFilter[])qfBuilder.toArrays());
            if (load != null && load.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)load.get(0);
                this.getModel().setValue("currencyraw", dynamicObject.get("currencyraw"));
                this.getModel().setValue("currencyrate", dynamicObject.get("currencyrate"));
                this.getModel().setValue("description", dynamicObject.get("description"));
                this.getModel().setValue(MODEL, dynamicObject.get(MODEL));
                this.getPageCache().put("currencyraw", dynamicObject.getString("currencyraw"));
                this.getPageCache().put("currencyrate", dynamicObject.getString("currencyrate"));
            }
        }
    }

    private String getCurrencyFilter() {
        return "id,name,number,creator,createtime,modifier,modifytime,model,begindate,enddate,paritiesprecision,entityrang_tag,paritiesoverturn,currencyraw,currencyrate,description,entryentity.id,entryentity.budgetdate,entryentity.meanparities,entryentity.addmeanparities,entryentity.endparities,entryentity.endmodifier,entryentity.endmodifytime";
    }

    private boolean estimateNodeId() {
        return this.getView().getFormShowParameter().getCustomParam("isAdd") == null;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnsave"});
        BasedataEdit currencyraw = (BasedataEdit)this.getControl("currencyraw");
        BasedataEdit currencyrate = (BasedataEdit)this.getControl("currencyrate");
        currencyraw.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        currencyrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnsave".equals(key)) {
            this.verifyDataSole();
            if (this.estimateNodeId()) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)EB_CURRENCYCONVERTSCHEM);
                Long userId = UserUtils.getUserId();
                Date nowDate = TimeServiceHelper.now();
                dynamicObject.set("creator", (Object)userId);
                dynamicObject.set("createtime", (Object)nowDate);
                dynamicObject.set(MODEL, (Object)this.getModelId());
                dynamicObject.set("begindate", this.getModel().getValue("begindate"));
                dynamicObject.set("enddate", this.getModel().getValue("enddate"));
                dynamicObject.set("paritiesprecision", this.getModel().getValue("paritiesprecision"));
                dynamicObject.set("paritiesoverturn", this.getModel().getValue("paritiesoverturn"));
                DynamicObject currencyraw = (DynamicObject)this.getModel().getValue("currencyraw");
                DynamicObject currencyrate = (DynamicObject)this.getModel().getValue("currencyrate");
                dynamicObject.set("currencyraw", (Object)currencyraw);
                dynamicObject.set("state", this.getModel().getValue("state"));
                dynamicObject.set("currencyrate", (Object)currencyrate);
                dynamicObject.set("name", (Object)(currencyraw.getString("name") + " \u2192 " + currencyrate.getString("name")));
                String number = currencyraw.getString("number") + currencyrate.getString("number");
                dynamicObject.set("number", (Object)number);
                dynamicObject.set("description", this.getModel().getValue("description"));
                String rawNumber = currencyraw.getString("number");
                String rateNumber = currencyrate.getString("number");
                if (StringUtils.isNotEmpty((String)rawNumber) && StringUtils.isNotEmpty((String)rateNumber)) {
                    this.getModel().setValue(MODEL, (Object)this.getModelId());
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ControlProcessAddPlugin_16", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "ControlProcessAddPlugin_15", "epm-eb-formplugin");
                this.writeLog(null, "save", opName, opDesc, null);
                long currency = this.selceteCurrency(this.getModelId(), currencyraw, currencyrate);
                this.getView().returnDataToParent((Object)currency);
            } else {
                String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
                QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
                qfBuilder.add(new QFilter("id", "=", (Object)Long.valueOf(nodeId)));
                DynamicObject[] load = BusinessDataServiceHelper.load((String)EB_CURRENCYCONVERTSCHEM, (String)this.getCurrencyFilter(), (QFilter[])qfBuilder.toArrays());
                if (load != null && load.length > 0) {
                    DynamicObject dynamicObject = load[0];
                    dynamicObject.set("modifier", (Object)UserUtils.getUserId());
                    dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                    DynamicObject currencyraw = (DynamicObject)this.getModel().getValue("currencyraw");
                    DynamicObject currencyrate = (DynamicObject)this.getModel().getValue("currencyrate");
                    dynamicObject.set("currencyraw", (Object)currencyraw);
                    dynamicObject.set("currencyrate", (Object)currencyrate);
                    dynamicObject.set("name", (Object)(currencyraw.getString("name") + " \u2192 " + currencyrate.getString("name")));
                    dynamicObject.set("number", (Object)(currencyraw.getString("number") + currencyrate.getString("number")));
                    dynamicObject.set("description", this.getModel().getValue("description"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539", "ControlProcessListPlugin_4", "epm-eb-formplugin");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "RuleControlListPlugin_16", "epm-eb-formplugin");
                    this.writeLog(null, "update", opName, opDesc, null);
                    this.getView().returnDataToParent((Object)dynamicObject.getLong("id"));
                }
            }
            this.getView().close();
        }
    }

    private long selceteCurrency(long modelId, DynamicObject currencyraw, DynamicObject currencyrate) {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)modelId);
        qfBuilder.add(new QFilter("currencyraw", "=", (Object)currencyraw.getLong("id")));
        qfBuilder.add(new QFilter("currencyrate", "=", (Object)currencyrate.getLong("id")));
        DynamicObjectCollection load = QueryServiceHelper.query((String)EB_CURRENCYCONVERTSCHEM, (String)this.getCurrencyFilter(), (QFilter[])qfBuilder.toArrays());
        if (load != null && load.size() > 0) {
            return ((DynamicObject)load.get(0)).getLong("id");
        }
        return 0L;
    }

    private void verifyDataSole() {
        IPageCache pageCache = this.getPageCache();
        Object isAdd = this.getView().getFormShowParameter().getCustomParam("isAdd");
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection col = QueryServiceHelper.query((String)EB_CURRENCYCONVERTSCHEM, (String)"id, currencyraw,currencyrate", (QFilter[])qfBuilder.toArray());
        DynamicObject currencyraw = (DynamicObject)this.getModel().getValue("currencyraw");
        DynamicObject currencyrate = (DynamicObject)this.getModel().getValue("currencyrate");
        StringBuilder groupCurrency = new StringBuilder();
        groupCurrency.append(currencyraw.getString("id")).append(currencyrate.getString("id"));
        int count = 0;
        for (DynamicObject dynamicObject : col) {
            StringBuilder group = new StringBuilder();
            group.append(dynamicObject.getString("currencyraw")).append(dynamicObject.getString("currencyrate"));
            if (!groupCurrency.toString().equals(group.toString())) continue;
            ++count;
        }
        if (pageCache.get("currencyraw") != null && pageCache.get("currencyrate") != null && isAdd != null) {
            String raw = pageCache.get("currencyraw");
            String rate = pageCache.get("currencyrate");
            if (!raw.equals(currencyraw.getString("id")) || !rate.equals(currencyrate.getString("id"))) {
                this.isPeriodDta(count);
            }
        } else {
            this.isPeriodDta(count);
        }
    }

    private void isPeriodDta(int count) {
        if (count == 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u7b97\u65b9\u6848\u5df2\u5b58\u5728\u3002", (String)"CurrencyConvertSchemePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (StringUtils.isNotEmpty((String)modelId)) {
            return Long.valueOf(modelId);
        }
        return 0L;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getFormShowParameter().getCloseCallBack() == null) {
            return;
        }
        String key = beforeF7SelectEvent.getProperty().getName();
        QFilter qFilter = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Currency.getNumber(), "CNone", "PC", "EC"}));
        QFilter qFilter1 = this.getCurrencyFilter(key);
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Currency.getNumber()));
        f7Param.addCustomFilter(Arrays.asList(qFilter, qFilter1));
        f7Param.setReturnClassName(ListSelectedRow.class.getName());
        NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
    }

    private QFilter getCurrencyFilter(String key) {
        QFilter qFilter1 = null;
        if ("currencyraw".equals(key)) {
            DynamicObject currencyrate = (DynamicObject)this.getModel().getValue("currencyrate");
            if (currencyrate != null) {
                qFilter1 = new QFilter("number", "!=", (Object)currencyrate.getString("number"));
            }
        } else {
            DynamicObject currencyraw = (DynamicObject)this.getModel().getValue("currencyraw");
            if (currencyraw != null) {
                qFilter1 = new QFilter("number", "!=", (Object)currencyraw.getString("number"));
            }
        }
        return qFilter1;
    }

    public String getCurrentDimNumber(String controlKey) {
        return SysDimensionEnum.Currency.getNumber();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.filterCurrency();
    }

    private void filterCurrency() {
        BasedataEdit currency = (BasedataEdit)this.getControl("currencyraw");
        ArrayList<QFilter> qFilters = currency.getQFilters();
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(16);
        }
        qFilters.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        qFilters.add(new QFilter("number", "!=", (Object)"Currency"));
        currency.setQFilters(qFilters);
    }
}

