/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.currencyconvert;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.currencyConvert.CurrencyConvertServiceImpl;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class CurrencyConvertUpdateListPlugin
extends AbstractListPlugin {
    private static final CurrencyConvertServiceImpl convertService = CurrencyConvertServiceImpl.getInstance();

    public void initialize() {
        super.initialize();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        if (modelid == null) {
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", null);
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumns.stream().filter(c -> c.getFieldName().equals("model.name")).findFirst().get();
        ArrayList modelQFilters = new ArrayList(16);
        modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
        filterColumn.getComboItems().clear();
        ArrayList comboItems = new ArrayList(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        filterColumn.setComboItems(comboItems);
        if (this.isExistModel(modelid)) {
            filterColumn.setDefaultValue(modelid);
            this.getPageCache().put("KEY_MODEL_ID", modelid);
        }
    }

    private boolean isExistModel(String modelId) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)Long.parseLong(modelId));
        if (orCreate == null) {
            return Boolean.FALSE;
        }
        Model model = orCreate.getModelobj();
        if (model == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap1"});
    }

    public void afterCreateNewData(EventObject e) {
        Long model = null;
        model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (IDUtils.isNotNull((Long)model)) {
            this.getPageCache().put("KEY_MODEL_ID", model.toString());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("model.id".equals(args.getFieldName())) {
            args.setCustomQFilters(ModelUtil.getModelFilter((IFormView)this.getView()));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "barupdate": {
                this.schemeUpdate();
                this.refreshBilllist();
                break;
            }
            case "barrefresh": {
                this.refreshBilllist();
                break;
            }
            case "barexit": {
                this.getView().close();
                break;
            }
        }
    }

    private void schemeUpdate() {
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"CurrencyConvertUpdateListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] objects = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).toArray();
        QFilter qFilter1 = new QFilter("id", "in", (Object)objects);
        DynamicObjectCollection dojCollection = QueryServiceHelper.query((String)"eb_currconvertupdate", (String)"status,scheme.id,model.id", (QFilter[])qFilter1.toArray());
        HashSet schemeIds = new HashSet(16);
        HashSet contains = Sets.newHashSet((Object[])new String[]{"0", "2"});
        Long modelId = null;
        HashMap scheme2ModelId = new HashMap();
        dojCollection.forEach(v -> {
            String status = v.getString("status");
            if (contains.contains(status)) {
                schemeIds.add(v.getLong("scheme.id"));
                scheme2ModelId.put(v.getLong("scheme.id"), v.getLong("model.id"));
            }
        });
        for (Long schemeId : schemeIds) {
            QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
            qFilter.and("status", "in", (Object)contains);
            DynamicObject[] eb_currconvertupdates = BusinessDataServiceHelper.load((String)"eb_currconvertupdate", (String)"id,status,modifier,scheme.name,modifytime", (QFilter[])qFilter.toArray());
            this.setStatusAndUpdate(eb_currconvertupdates, "1");
            try {
                modelId = (Long)scheme2ModelId.get(schemeId);
                convertService.executeConvertByScheme(modelId, schemeId);
            }
            catch (Throwable e2) {
                this.setStatusAndUpdate(eb_currconvertupdates, "2");
                SaveServiceHelper.update((DynamicObject[])eb_currconvertupdates);
                this.getView().showErrorNotification(e2.getMessage());
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u66f4\u65b0", "OperationLogUtil_3201", "epm-eb-common");
                MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u66f4\u65b0\u5931\u8d25\u3002", "OperationLogUtil_3205", "epm-eb-common");
                this.writeLog(null, "update", opName, opDescription, new String[]{eb_currconvertupdates[0].getString("scheme.name")});
                return;
            }
            this.setStatusAndUpdate(eb_currconvertupdates, "3");
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u66f4\u65b0", "OffsetRuleListPlugin_50", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u66f4\u65b0\u6210\u529f\u3002", "OperationLogUtil_3204", "epm-eb-common");
            this.writeLogWithEntityNumber("eb_currencyconvertlist", null, "update", opName, opDesc, new String[]{eb_currconvertupdates[0].getString("scheme.name")});
        }
    }

    private void setStatusAndUpdate(DynamicObject[] eb_currconvertupdates, String status) {
        for (DynamicObject eb_currconvertupdate : eb_currconvertupdates) {
            eb_currconvertupdate.set("modifier", (Object)UserUtils.getUserId());
            eb_currconvertupdate.set("modifytime", (Object)TimeServiceHelper.now());
            eb_currconvertupdate.set("status", (Object)status);
        }
        SaveServiceHelper.update((DynamicObject[])eb_currconvertupdates);
    }

    private void refreshBilllist() {
        BillList control = (BillList)this.getControl("billlistap");
        control.clearSelection();
        control.refresh();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List qFilters = args.getFilterParameter().getQFilters();
        this.getPageCache().put("KEY_MODEL_ID", null);
        if (qFilters != null) {
            for (QFilter e : qFilters) {
                if (!e.getProperty().equals("model.id")) continue;
                if (!e.getValue().equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    this.getPageCache().put("KEY_MODEL_ID", e.getValue().toString());
                    UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)IDUtils.toLong((Object)e.getValue()));
                }
                return;
            }
            SearchClickEvent searchClickEvent = args.getSearchClickEvent();
            if (searchClickEvent.getSelectMainOrgIds() != null && searchClickEvent.getSelectMainOrgIds().size() > 0) {
                Long modelId = (Long)searchClickEvent.getSelectMainOrgIds().get(0);
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            }
        }
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)strModelId)) {
            return Long.valueOf(strModelId);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"CurrencyConvertUpdateListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

