/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.customstatustab;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.analysereport.pojo.formula.InvokeParam;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.formplugin.customstatustab.CustomEventEnum;
import kd.epm.eb.formplugin.customstatustab.CustomStatusTab;
import kd.epm.eb.formplugin.customstatustab.CustomStatusTabAp;
import kd.epm.eb.formplugin.customstatustab.FrontMethodEnum;

public interface ICustomStatusTabAp {
    public static final String CACHE_CUSTOM_TAB_INFO_PRE = "cache_custom_tab_info_";
    public static final String CACHE_INITIALIZED_PRE = "cache_initialize_";
    public static final Log log = LogFactory.getLog(ICustomStatusTabAp.class);

    public Map<String, CustomStatusTabAp> fillInitTabsInfo();

    public IFormView getView();

    default public void initStatusTabAp() {
        Map<String, CustomStatusTabAp> initTabInfo = this.fillInitTabsInfo();
        if (initTabInfo == null || initTabInfo.size() == 0) {
            return;
        }
        for (Map.Entry<String, CustomStatusTabAp> entry : initTabInfo.entrySet()) {
            String controlKey = entry.getKey();
            CustomStatusTabAp info = entry.getValue();
            this.checkCustomStatusTabInfo(info, info.getFocusTabId());
            this.invokeFrontMethod(FrontMethodEnum.INIT_STATUS_TABS, controlKey, initTabInfo, info.getFocusTabId(), "statusTabAfterOperation");
        }
    }

    default public void statusTabCustomEvent(CustomEventArgs e) {
        String controlKey = e.getKey();
        String name = e.getEventName();
        String args = e.getEventArgs();
        CustomEventEnum enumByName = CustomEventEnum.getEnumByName(name);
        if (enumByName != null) {
            switch (enumByName) {
                case STATUS_TAB_SELECTED: {
                    this.cacheCurSelStatusTabId(controlKey, args);
                    this.statusTabSelected(controlKey, args);
                    break;
                }
                case STATUS_TAB_ADD_CLICK: {
                    this.statusTabAddNewClick(controlKey);
                    break;
                }
                case STATUS_TAB_CLOSE_CLICK: {
                    if (!StringUtils.isNotEmpty((CharSequence)args)) break;
                    this.statusTabCloseClick(controlKey, (Set)ObjectSerialUtil.parseObject((String)args, (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0]));
                    break;
                }
                case STATUS_TAB_AFTER_OPERATION: {
                    this.afterOperation(controlKey, args);
                    break;
                }
            }
        }
    }

    default public void statusTabSelected(String cusControlKey, String statusTabId) {
    }

    default public void statusTabCloseClick(String cusControlKey, Set<String> statusTabIds) {
    }

    default public void statusTabAddNewClick(String cusControlKey) {
    }

    default public void afterOperation(String cusControlKey, String args) {
        if (StringUtils.isEmpty((CharSequence)args) || args.split(";").length < 3) {
            log.info("afterOperation callBackData is exist error. " + args);
            return;
        }
        String[] split = args.split(";");
        String customStatusTabInfoJson = split[0];
        String focusId = split[1];
        String operation = split[2];
        this.cacheCustomStatusTabInfo(cusControlKey, customStatusTabInfoJson);
        this.cacheCurSelStatusTabId(cusControlKey, focusId);
        FrontMethodEnum frontMethodEnum = FrontMethodEnum.getEnumByName(operation);
        if (frontMethodEnum == null) {
            return;
        }
        switch (frontMethodEnum) {
            case INIT_STATUS_TABS: {
                this.afterInitStatusTabs(cusControlKey);
                break;
            }
            case RELOAD_STATUS_TABS: {
                this.afterReloadStatusTabs(cusControlKey);
                break;
            }
            case FOCUS_STATUS_TAB: {
                this.afterFocusStatusTab(cusControlKey);
                break;
            }
            case ADD_STATUS_TABS: {
                this.afterAddStatusTabs(cusControlKey);
                break;
            }
            case DEL_STATUS_TABS: {
                this.afterDelStatusTabs(cusControlKey);
                break;
            }
            case UPDATE_STATUS_TABS: {
                this.afterUpdateStatusTabs(cusControlKey);
                break;
            }
        }
    }

    default public void afterInitStatusTabs(String controlKey) {
        this.getView().getPageCache().put(CACHE_INITIALIZED_PRE + controlKey, "true");
    }

    default public void afterReloadStatusTabs(String controlKey) {
    }

    default public void afterFocusStatusTab(String controlKey) {
    }

    default public void afterAddStatusTabs(String controlKey) {
    }

    default public void afterDelStatusTabs(String controlKey) {
    }

    default public void afterUpdateStatusTabs(String controlKey) {
    }

    default public void statusTabReLoad(String cusControlKey, List<CustomStatusTab> tabs, String afterOperateFocusTabId) {
        CustomStatusTabAp tabInfo = this.getCustomStatusTabInfo(cusControlKey);
        tabInfo.setCustomStatusTabs(tabs);
        this.checkCustomStatusTabInfo(tabInfo, afterOperateFocusTabId);
        this.invokeFrontMethod(FrontMethodEnum.RELOAD_STATUS_TABS, cusControlKey, tabs, afterOperateFocusTabId, "statusTabAfterOperation");
    }

    default public void addStatusTabs(String cusControlKey, List<CustomStatusTab> tabs, String afterOperateFocusTabId) {
        CustomStatusTabAp tabInfo = this.getCustomStatusTabInfo(cusControlKey);
        tabInfo.getCustomStatusTabs().addAll(tabs);
        this.checkCustomStatusTabInfo(tabInfo, afterOperateFocusTabId);
        this.invokeFrontMethod(FrontMethodEnum.ADD_STATUS_TABS, cusControlKey, tabs, afterOperateFocusTabId, "statusTabAfterOperation");
    }

    default public void addStatusTabs(String cusControlKey, CustomStatusTab tab, String afterOperateFocusTabId) {
        this.addStatusTabs(cusControlKey, Collections.singletonList(tab), afterOperateFocusTabId);
    }

    default public void closeStatusTabs(String cusControlKey, Set<String> tabIds, String afterOperateFocusTabId) {
        CustomStatusTabAp tabInfo = this.getCustomStatusTabInfo(cusControlKey);
        tabInfo.getCustomStatusTabs().removeIf(e -> tabIds.contains(e.getTabId()));
        this.checkCustomStatusTabInfo(tabInfo, afterOperateFocusTabId);
        this.invokeFrontMethod(FrontMethodEnum.DEL_STATUS_TABS, cusControlKey, tabIds, afterOperateFocusTabId, "statusTabAfterOperation");
    }

    default public void closeStatusTabs(String cusControlKey, String tabId, String afterOperateFocusTabId) {
        this.closeStatusTabs(cusControlKey, Collections.singleton(tabId), afterOperateFocusTabId);
    }

    default public void focusStatusTab(String cusControlKey, String tabId) {
        CustomStatusTab tabItemInfo = this.getCustomStatusTabItemInfo(cusControlKey, tabId);
        if (tabItemInfo == null) {
            return;
        }
        this.cacheCurSelStatusTabId(cusControlKey, tabId);
        this.invokeFrontMethod(FrontMethodEnum.FOCUS_STATUS_TAB, cusControlKey, tabId, null, null);
    }

    default public void updateStatusTabs(String cusControlKey, Set<CustomStatusTab> tabs, String afterOperateFocusTabId) {
        Map<String, CustomStatusTab> updateTabsInfo = tabs.stream().collect(Collectors.toMap(CustomStatusTab::getTabId, e -> e));
        CustomStatusTabAp tabInfo = this.getCustomStatusTabInfo(cusControlKey);
        for (CustomStatusTab tab : tabInfo.getCustomStatusTabs()) {
            CustomStatusTab updateTab = updateTabsInfo.get(tab.getTabId());
            if (updateTab == null) continue;
            tab.setTabName(updateTab.getTabName());
            tab.setTabStatusName(updateTab.getTabStatusName());
            tab.setTabStatusBackColor(updateTab.getTabStatusBackColor());
            tab.setShowClose(updateTab.isShowClose());
        }
        this.checkCustomStatusTabInfo(tabInfo, afterOperateFocusTabId);
        this.invokeFrontMethod(FrontMethodEnum.UPDATE_STATUS_TABS, cusControlKey, tabs, afterOperateFocusTabId, "statusTabAfterOperation");
    }

    default public void updateStatusTabs(String cusControlKey, CustomStatusTab tab, String afterOperateFocusTabId) {
        this.updateStatusTabs(cusControlKey, Collections.singleton(tab), afterOperateFocusTabId);
    }

    default public CustomStatusTabAp getCustomStatusTabInfo(String cusControlKey) {
        String cache = this.getView().getPageCache().get(CACHE_CUSTOM_TAB_INFO_PRE + cusControlKey);
        if (cache != null) {
            return (CustomStatusTabAp)SerializationUtils.fromJsonString((String)cache, CustomStatusTabAp.class);
        }
        return new CustomStatusTabAp();
    }

    default public CustomStatusTab getCustomStatusTabItemInfo(String cusControlKey, String tabId) {
        CustomStatusTabAp customStatusTabInfo = this.getCustomStatusTabInfo(cusControlKey);
        return customStatusTabInfo.getStatusTabByTabId(tabId);
    }

    default public String getCurSelStatusTabId(String cusControlKey) {
        CustomStatusTabAp customStatusTabInfo = this.getCustomStatusTabInfo(cusControlKey);
        return customStatusTabInfo.getFocusTabId();
    }

    default public void cacheCurSelStatusTabId(String cusControlKey, String tabId) {
        CustomStatusTabAp customStatusTabInfo = this.getCustomStatusTabInfo(cusControlKey);
        CustomStatusTab statusTab = customStatusTabInfo.getStatusTabByTabId(tabId);
        if (statusTab != null) {
            customStatusTabInfo.setFocusTabId(tabId);
            this.getView().getPageCache().put(CACHE_CUSTOM_TAB_INFO_PRE + cusControlKey, SerializationUtils.toJsonString((Object)customStatusTabInfo));
        }
    }

    default public void invokeFrontMethod(FrontMethodEnum frontMethodEnum, String cusControlKey, Object dataObject, String afterOperateFocusTabId, String callbackEndMethod) {
        InvokeParam invokeParam = new InvokeParam();
        invokeParam.setUuidString(StrUtils.getUuidIdWithDataString());
        invokeParam.setFrontMethod(frontMethodEnum.getMethodName());
        Object[] data = new Object[]{dataObject, afterOperateFocusTabId};
        invokeParam.setDataObject((Object)data);
        invokeParam.setCallbackEndMethod(callbackEndMethod);
        CustomControl customControl = this.getCusStatusTabControl(cusControlKey);
        customControl.setData((Object)invokeParam);
    }

    default public void checkCustomStatusTabInfo(CustomStatusTabAp customStatusTabAp, String afterOperateFocusTabId) {
        CustomStatusTab customStatusTab;
        List<CustomStatusTab> customStatusTabs = customStatusTabAp.getCustomStatusTabs();
        if (afterOperateFocusTabId != null && (customStatusTab = (CustomStatusTab)customStatusTabs.stream().filter(e -> e.getTabId().equals(afterOperateFocusTabId)).findFirst().orElse(null)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u540e\u9009\u4e2d\u9875\u7b7eid\u5728\u9875\u7b7e\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ICustomStatusTabAp_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty(customStatusTabs)) {
            HashSet<String> tabIds = new HashSet<String>(customStatusTabs.size());
            for (CustomStatusTab tab : customStatusTabs) {
                if (StringUtils.isBlank((CharSequence)tab.getTabId()) || tab.getTabId().contains(";")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7b7e\u9879\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ICustomStatusTabAp_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (!tabIds.add(tab.getTabId())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9875\u7b7e\u9879ID\u5df2\u5b58\u5728\u3002", (String)"ICustomStatusTabAp_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isBlank((CharSequence)tab.getTabName())) {
                    tab.setTabName(ResManager.loadKDString((String)"\u9875\u7b7e", (String)"ICustomStatusTabAp_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (tab.getTabStatusName() == null) {
                    tab.setTabStatusName("");
                }
                if (!StringUtils.isBlank((CharSequence)tab.getTabStatusBackColor())) continue;
                tab.setTabStatusBackColor("blue");
            }
        }
    }

    default public void cacheCustomStatusTabInfo(String cusControlKey, String customStatusTabInfoJson) {
        if (StringUtils.isBlank((CharSequence)customStatusTabInfoJson)) {
            log.info("customStatusTabInfoJson is blank.cusControlKey:" + cusControlKey);
            return;
        }
        CustomStatusTabAp customStatusTabInfo = this.getCustomStatusTabInfo(cusControlKey);
        try {
            List tabList = (List)ObjectSerialUtil.parseObject((String)customStatusTabInfoJson, (TypeReference)new TypeReference<List<CustomStatusTab>>(){}, (Feature[])new Feature[0]);
            customStatusTabInfo.setCustomStatusTabs(tabList);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5e8f\u5217\u5316\u5f02\u5e38\uff0c\u524d\u7aef\u8fd4\u56deJson\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"ICustomStatusTabAp_5", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
            log.info("cacheCustomStatusTabInfo error : " + customStatusTabInfoJson);
            return;
        }
        this.getView().getPageCache().put(CACHE_CUSTOM_TAB_INFO_PRE + cusControlKey, SerializationUtils.toJsonString((Object)customStatusTabInfo));
    }

    default public CustomControl getCusStatusTabControl(String cusStatusTabControlKey) {
        CustomControl customControl = (CustomControl)this.getView().getControl(cusStatusTabControlKey);
        if (customControl == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u65e0\u6b64\u81ea\u5b9a\u4e49\u63a7\u4ef6\u3002", (String)"ICustomStatusTabAp_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return customControl;
    }

    default public boolean curCustomInitialized(String cusStatusTabControlKey) {
        return "true".equals(this.getView().getPageCache().get(CACHE_INITIALIZED_PRE + cusStatusTabControlKey));
    }

    default public int MAX_TAB_ITEM_SIZE() {
        return 2000;
    }

    default public boolean compareTabIdsChange(List<CustomStatusTab> aTabs, List<CustomStatusTab> bTabs) {
        if (CollectionUtils.isEmpty(aTabs) || CollectionUtils.isEmpty(bTabs)) {
            return true;
        }
        Set aTabIds = aTabs.stream().map(CustomStatusTab::getTabId).collect(Collectors.toSet());
        Set bTabIds = bTabs.stream().map(CustomStatusTab::getTabId).collect(Collectors.toSet());
        return aTabIds.size() != bTabIds.size() || !aTabIds.containsAll(bTabIds);
    }
}

