/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.customtree;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kd.epm.eb.formplugin.customtree.CustomTreeConstants;
import kd.epm.eb.formplugin.customtree.model.Node;
import kd.epm.eb.formplugin.customtree.model.NodeOp;
import kd.epm.eb.formplugin.customtree.model.NodeTag;

public class CustomTreeBuilder {
    public static NodeTag createRootNodeTag() {
        NodeTag rootTag = new NodeTag();
        rootTag.setIconType(CustomTreeConstants.IconType.IMG.getType());
        rootTag.setIconPath("folder");
        return rootTag;
    }

    public static NodeTag createGroupNodeTag() {
        NodeTag rootTag = new NodeTag();
        rootTag.setIconType(CustomTreeConstants.IconType.IMG.getType());
        rootTag.setIconPath("folder");
        return rootTag;
    }

    public static NodeTag createLeafNodeTag() {
        NodeTag rootTag = new NodeTag();
        rootTag.setIconType(CustomTreeConstants.IconType.IMG.getType());
        rootTag.setIconPath("report");
        return rootTag;
    }

    public static NodeTag createSimpleTag() {
        return new NodeTag();
    }

    public static Node createRootNode(String id, String pid, String label) {
        return CustomTreeBuilder.createNode(id, pid, label, "root", false);
    }

    public static Node createGroupNode(String id, String pid, String label, boolean isLeaf) {
        return CustomTreeBuilder.createNode(id, pid, label, "group", isLeaf);
    }

    public static Node createDirNode(String id, String pid, String label, boolean isLeaf) {
        return new Node(id, pid, label, "dir", isLeaf);
    }

    public static Node createLeafNode(String id, String pid, String label) {
        return CustomTreeBuilder.createNode(id, pid, label, "leaf", true);
    }

    public static Node createNode(String id, String pid, String label, String tag, boolean leaf) {
        return new Node(id, pid, label, tag, leaf);
    }

    public static Map<String, NodeTag> buildDefaultTagMap(NodeTag rootTag, NodeTag groupTag, NodeTag leafTag) {
        return ImmutableMap.of((Object)"root", (Object)rootTag, (Object)"group", (Object)groupTag, (Object)"leaf", (Object)leafTag);
    }

    public static Map<String, NodeTag> buildDefaultTagMap(NodeTag rootTag, NodeTag groupTag, NodeTag leafTag, NodeTag dirTag) {
        return ImmutableMap.of((Object)"root", (Object)rootTag, (Object)"group", (Object)groupTag, (Object)"leaf", (Object)leafTag, (Object)"dir", (Object)dirTag);
    }

    public static NodeOp groupAddOp(String name, String method) {
        return new NodeOp(name, method, "el-icon-folder-add");
    }

    public static NodeOp leafAddOp(String name, String method) {
        return new NodeOp(name, method, "el-icon-document-add");
    }

    public static NodeOp editOp(String name, String method) {
        return new NodeOp(name, method, "el-icon-edit-outline");
    }

    public static NodeOp delOp(String name, String method) {
        return new NodeOp(name, method, "el-icon-delete");
    }

    public static NodeOp createOp(String name, String method, String icon) {
        return new NodeOp(name, method, icon);
    }
}

