/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.customtree;

import java.util.List;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.formplugin.customtree.CustomTreeBuilder;
import kd.epm.eb.formplugin.customtree.CustomTreeConstants;
import kd.epm.eb.formplugin.customtree.PropsData;
import kd.epm.eb.formplugin.customtree.model.Node;
import kd.epm.eb.formplugin.customtree.model.TreeModel;

public class CustomTreeEvent {
    private static final Log log = LogFactory.getLog(CustomTreeEvent.class);
    private static final String CTRL_CUSTOM_AP = "customtreeap";

    public static CustomTreeEvent getInstance() {
        return InnerClass.instance;
    }

    private CustomTreeEvent() {
    }

    public void sendRebuild(IFormView formView, TreeModel treeModel) {
        PropsData propsData = new PropsData();
        propsData.setDataType(CustomTreeConstants.DataType.REBUILD);
        propsData.setData(treeModel);
        this.sendData(formView, propsData);
    }

    public void sendLazyReload(IFormView formView, List<Node> nodeList) {
        PropsData propsData = new PropsData();
        propsData.setDataType(CustomTreeConstants.DataType.LAZY_LOAD);
        propsData.setData(nodeList);
        this.sendData(formView, propsData);
    }

    public void sendAddNode(IFormView formView, Node node) {
        PropsData propsData = new PropsData();
        propsData.setDataType(CustomTreeConstants.DataType.ADD_NODE);
        propsData.setData(node);
        this.sendData(formView, propsData);
    }

    public void sendDelNode(IFormView formView, Node node) {
        PropsData propsData = new PropsData();
        propsData.setDataType(CustomTreeConstants.DataType.DEL_NODE);
        propsData.setData(node);
        this.sendData(formView, propsData);
    }

    public void sendFindNode(IFormView formView, String nodeId) {
        PropsData propsData = new PropsData();
        propsData.setDataType(CustomTreeConstants.DataType.FIND_NODE);
        propsData.setData(CustomTreeBuilder.createNode(nodeId, "", "", "", true));
        this.sendData(formView, propsData);
    }

    public void sendToggleCheckbox(IFormView formView) {
        PropsData propsData = new PropsData();
        propsData.setDataType(CustomTreeConstants.DataType.SHOW_CHECKBOX);
        this.sendData(formView, propsData);
    }

    private void sendData(IFormView formView, PropsData data) {
        CustomControl customcontrol = (CustomControl)formView.getControl(CTRL_CUSTOM_AP);
        customcontrol.setData((Object)data);
    }

    private static class InnerClass {
        private static final CustomTreeEvent instance = new CustomTreeEvent();

        private InnerClass() {
        }
    }
}

