/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.collection;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class DataCollectionAppList
extends AbstractListPlugin {
    private static final String APP_NUMBER = "FI";
    private static final String APPLY_NUMBER = "gl";
    public static final String ENTRYENTITY = "entryentity";
    public static final String BTN_CONFIRM = "btn_confirm";
    public static final String TOOLBARAP = "toolbarap";

    public void afterCreateNewData(EventObject e) {
        this.refreshEntity();
    }

    private void refreshEntity() {
        DynamicObject entryentity;
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        int entryRow = 0;
        for (DynamicObject cloud : clouds) {
            if (!APP_NUMBER.equals(cloud.getString("number"))) continue;
            entryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            entryentity = this.getModel().getEntryRowEntity(ENTRYENTITY, entryRow);
            entryentity.set("cloudname", (Object)cloud.getString("name"));
            entryentity.set("cloudnumber", (Object)cloud.getString("number"));
            entryentity.set("cloudid", (Object)cloud.getString("id"));
        }
        for (DynamicObject app : apps) {
            if (!APPLY_NUMBER.equals(app.getString("number"))) continue;
            entryentity = this.getModel().getEntryRowEntity(ENTRYENTITY, entryRow);
            entryentity.set("appname", (Object)app.getString("name"));
            entryentity.set("appnumber", (Object)app.getString("number"));
            entryentity.set("appid", (Object)app.getString("id"));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_CONFIRM.equals(itemKey)) {
            EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = control.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DataCollectionAppList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRows[0]);
                HashMap<String, String> appMap = new HashMap<String, String>(16);
                appMap.put("cloudname", entryRowEntity.getString("cloudname"));
                appMap.put("cloudnumber", entryRowEntity.getString("cloudnumber"));
                appMap.put("cloudid", entryRowEntity.getString("cloudid"));
                appMap.put("appname", entryRowEntity.getString("appname"));
                appMap.put("appnumber", entryRowEntity.getString("appnumber"));
                appMap.put("appid", entryRowEntity.getString("appid"));
                this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(appMap));
                this.getView().close();
            }
        }
    }
}

