/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.collection;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataGather.service.DataCollectionService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.UserSelectUtil;

public class DataCollectionListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
HyperLinkClickListener {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DataCollectionListPlugin.class);
    private static final String MODEL = "model";
    private static final String BILLLIST_KEY = "billlistap";
    private static final String MAPCATTREE = "mapcattree";
    private static final int MAXLEVEL = 10;

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("eb_collectionconfig");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNull((Long)model)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataCollectionListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)model);
        this.initTree();
        this.refreshEntry();
    }

    private void refreshEntry() {
        BillList billList = (BillList)this.getControl(BILLLIST_KEY);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        TreeNode focusNode = this.getFocusNode();
        if (focusNode != null) {
            QFilter qFilter = new QFilter("apprecord", "=", (Object)Long.parseLong(focusNode.getId()));
            qFilter.and(new QFilter(MODEL, "=", (Object)this.getModelId()));
            e.getQFilters().add(qFilter);
        } else {
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addcat", "btn_delcat"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tview = (TreeView)this.getControl(MAPCATTREE);
        tview.addTreeNodeClickListener((TreeNodeClickListener)this);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                DataCollectionListPlugin.this.refrushBillList();
            }
        });
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList control = (BillList)this.getControl(BILLLIST_KEY);
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void refrushBillList() {
        BillList billList = (BillList)this.getControl(BILLLIST_KEY);
        billList.clearSelection();
        billList.refresh();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "btn_addcat": {
                this.clickAddCloud();
                break;
            }
            case "btn_delcat": {
                this.clickDeleteCloud();
                break;
            }
        }
    }

    private void clickDeleteCloud() {
        TreeNode focusNode = this.getFocusNode();
        if (focusNode != null) {
            if ("0".equals(focusNode.getId()) || "FI".equals(focusNode.getId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u5e94\u7528\u3002", (String)"DataCollectionListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_collectionconfig", (String)"id", (QFilter[])new QFilter[]{new QFilter("apprecord", "=", (Object)IDUtils.toLong((Object)focusNode.getId()))});
                if (query.size() > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u5e94\u7528\u4e0b\u5b58\u5728\u65e0\u6cd5\u5220\u9664\u7684\u914d\u7f6e\u65b9\u6848\u3002", (String)"DataCollectionListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664?", (String)"DataCollectionListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del_data", (IFormPlugin)this));
            }
        }
    }

    private void deleteDataApply(String focusNodeId) {
        if (!this.isStaterPlanByTreeNodeId(focusNodeId)) {
            try (TXHandle tx = TX.required((String)"dataCollection_delete_app");){
                try {
                    DeleteServiceHelper.delete((String)"eb_collectionrecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)focusNodeId))});
                    DeleteServiceHelper.delete((String)"eb_collectionconfig", (QFilter[])new QFilter[]{new QFilter("apprecord", "=", (Object)IDUtils.toLong((Object)focusNodeId))});
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataCollectionListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    log.error("--dataCollectionDelete--:\n" + ThrowableHelper.toString((Throwable)e));
                    throw e;
                }
            }
            this.initTree();
            this.refreshEntry();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u4e0b\u6709\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataCollectionListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isStaterPlanByTreeNodeId(String focusNodeId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_collectionconfig", (String)"status", (QFilter[])new QFilter[]{new QFilter("apprecord", "=", (Object)IDUtils.toLong((Object)focusNodeId))});
        for (DynamicObject dynamicObject : query) {
            boolean stater = dynamicObject.getBoolean("status");
            if (!stater) continue;
            return true;
        }
        return false;
    }

    private void clickAddCloud() {
        if (this.getModelId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataCollectionListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_collectionnewapply");
        formShowParameter.setShowTitle(Boolean.TRUE.booleanValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("appNumber", (Object)String.valueOf(this.getModelId()));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addCloud"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u96c6\u6210\u5e94\u7528", (String)"DataCollectionListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "refresh".equals(operation = ((FormOperate)args.getSource()).getOperateKey())) {
            this.refreshEntry();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_invoke": 
            case "btn_stop": {
                this.itemClickInvoke(key);
                break;
            }
            case "bar_delete": {
                this.deleteCheckout();
                break;
            }
        }
    }

    private void deleteCheckout() {
        DynamicObject[] load;
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DataCollectionListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long value = (Long)selectedRows.getPrimaryKeyValues()[0];
        QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "=", (Object)value));
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"eb_collectionconfig", (String)"id,status", (QFilter[])qfBuilder.toArray())) {
            boolean status = dynamicObject.getBoolean("status");
            if (!status) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u505c\u7528\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"DataCollectionListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList projects = new ArrayList(16);
        QFBuilder qfBuilder1 = new QFBuilder(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_collectionexecute", (String)"id,name,entryentity.project", (QFilter[])qfBuilder1.toArray());
        query.forEach(e -> projects.add(e.getString("entryentity.project")));
        for (DynamicObject dynamicObject : load) {
            String id = dynamicObject.getString("id");
            if (!projects.contains(id)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u5220\u9664\u5f15\u7528\u540e\u91cd\u8bd5\u3002", (String)"DataCollectionListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664?", (String)"DataCollectionListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("bar_delete", (IFormPlugin)this));
    }

    private DynamicObject[] getDynamicStatus() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        Long id = (Long)billList.getFocusRowPkId();
        QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "=", (Object)id));
        return BusinessDataServiceHelper.load((String)"eb_collectionconfig", (String)"id,status", (QFilter[])qfBuilder.toArray());
    }

    private void itemClickInvoke(String key) {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        List<Long> idList = this.getEntrySelectRows();
        if (idList == null) {
            return;
        }
        StringBuilder message = new StringBuilder();
        if ("btn_invoke".equals(key)) {
            QFBuilder qfBuilder = new QFBuilder(new QFilter(MODEL, "=", (Object)this.getModelId()));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_collectionconfig", (String)"id,status,entityrang", (QFilter[])qfBuilder.toArray());
            ArrayList invokeId = new ArrayList(16);
            ArrayList<DynamicObject> forbidden = new ArrayList<DynamicObject>(16);
            for (DynamicObject dynamicObject : load) {
                boolean sta = dynamicObject.getBoolean("status");
                Long id = dynamicObject.getLong("id");
                if (sta) {
                    List entityrang = DataCollectionService.getEntityRang((String)dynamicObject.getString("entityrang"), (long)this.getModelId());
                    invokeId.addAll(entityrang);
                    idList.remove(id);
                    continue;
                }
                if (!idList.contains(id)) continue;
                forbidden.add(dynamicObject);
            }
            ArrayList<DynamicObject> saveDyn = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> temporary = new ArrayList<DynamicObject>(16);
            for (DynamicObject dynamicObject : forbidden) {
                List entityrang = DataCollectionService.getEntityRang((String)dynamicObject.getString("entityrang"), (long)this.getModelId());
                List collect = invokeId.stream().filter(entityrang::contains).collect(Collectors.toList());
                if (collect.size() == 0) {
                    temporary.add(dynamicObject);
                    continue;
                }
                message.append(ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"DataCollectionListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.recursionProject(temporary, saveDyn);
            if (temporary.size() != saveDyn.size() && StringUtils.isEmpty((String)message.toString())) {
                message.append(ResManager.loadKDString((String)"\u8df3\u8fc7\u9009\u4e2d\u65b9\u6848\u9002\u7528\u7ec4\u7ec7\u4ea7\u751f\u51b2\u7a81\u7684\u3002", (String)"DataCollectionListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (saveDyn.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])saveDyn.toArray(new DynamicObject[0]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"DataCollectionListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isNotEmpty((String)message.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u65b9\u6848\u7684\u9002\u7528\u7ec4\u7ec7\u548c\u5df2\u542f\u7528\u65b9\u6848\u7684\u9002\u7528\u7ec4\u7ec7\u4ea7\u751f\u51b2\u7a81\u3002", (String)"DataCollectionListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\u3002", (String)"DataCollectionListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.writeLog("enable", new MultiLangEnumBridge("\u542f\u7528", "CentralRelRelationExportUtils_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u91c7\u96c6\u914d\u7f6e\u65b9\u6848\u542f\u7528", "AbstractMultiReportPlugin_132", "epm-eb-budget"));
        } else {
            QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "in", idList));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_collectionconfig", (String)"id,number,status,entityrang", (QFilter[])qfBuilder.toArray());
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
            for (DynamicObject dynamicObject : load) {
                if (dynamicObject.getBoolean("status")) {
                    dynamicObject.set("status", (Object)false);
                    dynamicObjects.add(dynamicObject);
                    continue;
                }
                message.append(dynamicObject.getString("number"));
                message.append('\u3001');
            }
            if (message.length() > 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u65b9\u6848%1\u5df2\u7981\u7528\u3002", (String)"DataCollectionListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{message.substring(0, message.length() - 1)}));
            }
            if (dynamicObjects.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])load);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DataCollectionListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528", "OffsetRuleListPlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u91c7\u96c6\u914d\u7f6e\u65b9\u6848\u7981\u7528", "AbstractMultiReportPlugin_133", "epm-eb-budget"));
        }
        billList.clearSelection();
        billList.refresh();
    }

    private List<Long> getEntrySelectRows() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u6570\u636e\u3002", (String)"DataCollectionListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(16);
        for (Object id : selectedRows.getPrimaryKeyValues()) {
            idList.add((Long)id);
        }
        return idList;
    }

    private void recursionProject(List<DynamicObject> forbidden, List<DynamicObject> saveDyn) {
        if (forbidden.size() > 0) {
            ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(16);
            int index = 0;
            List entityrang1 = DataCollectionService.getEntityRang((String)forbidden.get(0).getString("entityrang"), (long)this.getModelId());
            for (int i = 1; i < forbidden.size(); ++i) {
                List entityrang2 = DataCollectionService.getEntityRang((String)forbidden.get(i).getString("entityrang"), (long)this.getModelId());
                List collect = entityrang1.stream().filter(entityrang2::contains).collect(Collectors.toList());
                if (collect.size() == 0) {
                    objectList.add(forbidden.get(i));
                    continue;
                }
                ++index;
            }
            if (index == 0) {
                forbidden.get(0).set("status", (Object)true);
                saveDyn.add(forbidden.get(0));
            }
            this.recursionProject(objectList, saveDyn);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        int statusVal;
        BillShowParameter billShowParameter = e.getParameter();
        if (billShowParameter instanceof BaseShowParameter && (statusVal = billShowParameter.getBillStatusValue().intValue()) == BillOperationStatus.ADDNEW.getValue()) {
            if (this.getModelId() == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataCollectionListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            billShowParameter.setCustomParam("modelId", (Object)this.getModelId());
            TreeNode treeNode = this.getFocusNode();
            if (treeNode != null) {
                String focusNode = treeNode.getId();
                if (!this.isDataSetNode(focusNode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u8282\u70b9\u3002", (String)"DataCollectionListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                billShowParameter.setCustomParam("recordId", (Object)Long.parseLong(focusNode));
            }
        }
    }

    private boolean isDataSetNode(String dataSetId) {
        return QueryServiceHelper.exists((String)"eb_collectionrecord", (Object)dataSetId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject modelId = (DynamicObject)this.getModel().getValue(MODEL);
            if (modelId != null) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId.getLong("id"));
            }
            this.initTree();
            this.refreshEntry();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("addCloud".equals(actionId) && (returnData = e.getReturnData()) instanceof String) {
            Map appMap = (Map)SerializationUtils.deSerializeFromBase64((String)String.valueOf(returnData));
            String applynumber = (String)appMap.get("appnumber");
            if (StringUtils.isEmpty((String)applynumber)) {
                return;
            }
            DynamicObjectCollection queryDataRecord = this.getQueryDataRecord();
            int count = 0;
            if (queryDataRecord.size() > 0) {
                for (DynamicObject dynamicObject : queryDataRecord) {
                    if (!applynumber.equals(dynamicObject.getString("appnumber"))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u5217\u8868\u5df2\u5b58\u5728\u3002", (String)"DataCollectionListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    ++count;
                }
                if (count == 0) {
                    this.refreshTree(appMap, queryDataRecord);
                }
            } else {
                this.refreshTree(appMap, queryDataRecord);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        TreeNode focusNode;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("del_data".equals(callBackId) && MessageBoxResult.Yes.getValue() == event.getResult().getValue() && (focusNode = this.getFocusNode()) != null) {
            this.deleteDataApply(focusNode.getId());
        }
        if ("bar_delete".equals(callBackId) && MessageBoxResult.Yes.getValue() == event.getResult().getValue()) {
            BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Long value = (Long)selectedRows.getPrimaryKeyValues()[0];
            QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "=", (Object)value));
            DeleteServiceHelper.delete((String)"eb_collectionconfig", (QFilter[])qfBuilder.toArray());
            this.refreshEntry();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataCollectionListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            log.error("--Collection_Delete--:" + value);
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "AbstractMultiReportPlugin_60", "epm-eb-budget"), new MultiLangEnumBridge("\u91c7\u96c6\u914d\u7f6e\u65b9\u6848\u5220\u9664", "AbstractMultiReportPlugin_134", "epm-eb-budget"));
        }
    }

    private void refreshTree(Map<String, String> appMap, DynamicObjectCollection queryDataRecord) {
        this.saveApplyRecord(appMap, queryDataRecord);
        this.initTree();
    }

    private void saveApplyRecord(Map<String, String> appMap, DynamicObjectCollection queryDataRecord) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_collectionrecord");
        object.set(MODEL, (Object)String.valueOf(this.getModelId()));
        object.set("creator", (Object)UserUtils.getUserId());
        object.set("createtime", (Object)TimeServiceHelper.now());
        object.set("appname", (Object)appMap.get("appname"));
        object.set("appnumber", (Object)appMap.get("appnumber"));
        object.set("cloudname", (Object)appMap.get("cloudname"));
        object.set("cloudnumber", (Object)appMap.get("cloudnumber"));
        object.set("dseq", (Object)(queryDataRecord.size() + 1));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    private void initTree() {
        DynamicObjectCollection queryDataRecord = this.getQueryDataRecord();
        TreeNode root = new TreeNode();
        root.setIsOpened(true);
        root.setText(ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf", (String)"DataCollectionListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setId("0");
        ArrayList<TreeNode> children = root.getChildren();
        if (queryDataRecord.size() > 0) {
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            for (DynamicObject dynamicObject : queryDataRecord) {
                TreeNode applyTreeNode;
                String cloudnumber = dynamicObject.getString("cloudnumber");
                if (root.getTreeNode(cloudnumber, 10) == null) {
                    TreeNode cloudTreeNode = new TreeNode();
                    cloudTreeNode.setId(cloudnumber);
                    cloudTreeNode.setText(dynamicObject.getString("cloudname"));
                    cloudTreeNode.setParentid("0");
                    cloudTreeNode.setIsOpened(true);
                    ArrayList<TreeNode> children1 = cloudTreeNode.getChildren();
                    if (children1 == null) {
                        children1 = new ArrayList<TreeNode>();
                        cloudTreeNode.setChildren(children1);
                        children.add(cloudTreeNode);
                    }
                    applyTreeNode = new TreeNode();
                    applyTreeNode.setId(dynamicObject.getString("id"));
                    applyTreeNode.setText(dynamicObject.getString("appname"));
                    applyTreeNode.setParentid(cloudnumber);
                    children1.add(applyTreeNode);
                    continue;
                }
                TreeNode treeNode = root.getTreeNode(cloudnumber, 10);
                List nodeChildren = treeNode.getChildren();
                applyTreeNode = new TreeNode();
                applyTreeNode.setId(dynamicObject.getString("id"));
                applyTreeNode.setText(dynamicObject.getString("appname"));
                applyTreeNode.setParentid(treeNode.getId());
                nodeChildren.add(applyTreeNode);
            }
        }
        this.addTreeView(root, (List<TreeNode>)children);
    }

    private void addTreeView(TreeNode root, List<TreeNode> children) {
        TreeView control = (TreeView)this.getControl(MAPCATTREE);
        control.deleteAllNodes();
        control.addNode(root);
        if (children != null && children.size() > 0) {
            TreeNode treeNode = children.get(0);
            List nodeChildren = treeNode.getChildren();
            if (nodeChildren != null && nodeChildren.size() > 0) {
                control.focusNode((TreeNode)nodeChildren.get(0));
                this.putFocusNodeAndRootTree((TreeNode)nodeChildren.get(0), root);
            }
        } else {
            control.focusNode(root);
            this.putFocusNodeAndRootTree(root, root);
        }
    }

    private void putFocusNodeAndRootTree(TreeNode focusNode, TreeNode root) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("focusNode", SerializationUtils.serializeToBase64((Object)focusNode));
        pageCache.put("rootTree", SerializationUtils.serializeToBase64((Object)root));
    }

    private TreeNode getFocusNode() {
        TreeNode treeNode = null;
        String focusNode = this.getPageCache().get("focusNode");
        if (StringUtils.isNotEmpty((String)focusNode)) {
            treeNode = (TreeNode)SerializationUtils.deSerializeFromBase64((String)focusNode);
        }
        return treeNode;
    }

    private DynamicObjectCollection getQueryDataRecord() {
        QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
        return QueryServiceHelper.query((String)"eb_collectionrecord", (String)this.getSelectDataRecord(), (QFilter[])qfBuilder.toArray());
    }

    private String getSelectDataRecord() {
        return "id,model,creator,createtime,appname,appnumber,cloudname,cloudnumber,dseq";
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model == null) {
            return 0L;
        }
        return model.getLong("id");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (key.equals(MODEL)) {
            PluginUtils.setModelFilter(e, this.getView());
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)e);
        }
    }
}

