/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.collection;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.business.dataGather.service.DataCollectionService;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class DataCollectionPlanPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String MODEL_KEY = "model";
    private static final String CURRENCY_KEY = "currency";
    private static final String ACCOUNTFORM_KEY = "accountform";
    private static final String STANDARD_KEY = "standard";
    private static final String BOOKTYPE_KEY = "booktype";
    private static final String PERIODTYPE_KEY = "periodtype";
    private static final String BUSINESSENTRY_KEY = "businessentry";
    private static final String DIMMAP_KEY = "dimmap";
    private static final String DIMASSIGN_KEY = "dimassign";
    private static final String BUDGETPERIOD_KEY = "budgetperiod";
    private static final String BGM_BUDGETPERIOD_KEY = "bgm_budgetperiod";
    private static final String BUDGETYEAR_KEY = "budgetyear";
    private static final String APPRECORD_KEY = "apprecord";
    private static final String DATASET_KEY = "dataset";
    private static final String ENTITYDIMMAP = "entitydimmap";
    private static final String ENTITYYEARMAP = "entityyearmap";
    private static final String ENTITYPERIODMAP = "entityperiodmap";
    private static final String ENTITY = "entity";
    private static final String DIMNUMBER = "dimnumber";
    private static final String DIMNAME = "dimname";
    private static final String FISCALYEAR_KEY = "fiscalyear";
    private static final String YEARMAPPING_KEY = "yearmapping";
    private static final String FIELDTABLE = "fieldtable";
    private static final String FIELDID = "fieldid";
    private static final String FIELDNAME = "fieldname";
    private static final String BD_PERIOD_TYPE = "bd_period_type";
    private static final String BD_PERIODOUTLINE_TREE = "bd_periodoutline_tree";
    private static final String BD_PERIOD = "bd_period";
    private static final String BOS_ORG = "bos_org";
    private static final String BD_ACCOUNTTABLE = "bd_accounttable";
    private static final String BD_ASSTACTTYPE = "bd_asstacttype";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{ENTITY, FIELDNAME});
        this.addF7SelectListener(MODEL_KEY, CURRENCY_KEY, DIMMAP_KEY, DIMASSIGN_KEY, BUDGETPERIOD_KEY, BGM_BUDGETPERIOD_KEY, BUDGETYEAR_KEY, ACCOUNTFORM_KEY, BUSINESSENTRY_KEY, DATASET_KEY);
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("modelId");
        Long dateSetId = (Long)formShowParameter.getCustomParam("recordId");
        this.getModel().setValue(APPRECORD_KEY, (Object)dateSetId);
        this.getModel().setValue(MODEL_KEY, (Object)modelId);
        this.setAppName();
        this.setEntityDimMap();
    }

    private void setAppName() {
        DynamicObjectCollection dynamicObject = this.selectDataCollectionRec();
        if (dynamicObject.size() > 0) {
            this.getModel().setValue("apply", (Object)((DynamicObject)dynamicObject.get(0)).getString("appname"));
        }
    }

    private void setEntityDimMap() {
        this.setDimMapDefault();
        int index = 2;
        Map numAndNameByModel = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((long)this.getModelId(), (boolean)false);
        if (numAndNameByModel.size() > 0) {
            for (Map.Entry entry : numAndNameByModel.entrySet()) {
                this.getModel().createNewEntryRow(ENTITYDIMMAP);
                this.getModel().setValue(DIMNUMBER, entry.getKey(), index);
                this.getModel().setValue(DIMNAME, entry.getValue(), index);
                ++index;
            }
        }
    }

    private void setDimMapDefault() {
        this.getModel().batchCreateNewEntryRow(ENTITYDIMMAP, 2);
        this.getModel().setValue(DIMNUMBER, (Object)SysDimensionEnum.Entity.getNumber(), 0);
        this.getModel().setValue(DIMNAME, (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"DataCollectionPlanPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), 0);
        this.getModel().setValue(DIMNUMBER, (Object)SysDimensionEnum.Account.getNumber(), 1);
        this.getModel().setValue(DIMNAME, (Object)ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DataCollectionPlanPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), 1);
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{DIMASSIGN_KEY});
        this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{DIMASSIGN_KEY});
    }

    public void afterLoadData(EventObject e) {
        this.setAppName();
        this.setViewEnable();
        this.setBudgetPeriod();
    }

    private void setBudgetPeriod() {
        if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView())) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            DynamicObjectCollection periodEntity = this.getModel().getEntryEntity(ENTITYPERIODMAP);
            if (periodEntity == null || periodEntity.size() == 0) {
                return;
            }
            for (DynamicObject dynamicObject : periodEntity) {
                Long periodId = dynamicObject.getLong(String.join((CharSequence)"_", BUDGETPERIOD_KEY, "id"));
                if (IDUtils.isNull((Long)periodId)) continue;
                Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), periodId);
                DynamicObject newBudgetPeriod = BusinessDataServiceHelper.newDynamicObject((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel());
                newBudgetPeriod.set("id", (Object)member.getId());
                newBudgetPeriod.set("number", (Object)member.getNumber());
                newBudgetPeriod.set("name", (Object)member.getName());
                dynamicObject.set(BGM_BUDGETPERIOD_KEY, (Object)newBudgetPeriod);
            }
            this.getView().updateView(ENTITYPERIODMAP);
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView())) {
            this.setFieldUnvisibleForBGM();
        } else {
            this.setFieldUnvisibleForOther();
        }
    }

    private void setFieldUnvisibleForBGM() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FISCALYEAR_KEY});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{YEARMAPPING_KEY});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BUDGETPERIOD_KEY});
    }

    private void setFieldUnvisibleForOther() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DATASET_KEY});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BGM_BUDGETPERIOD_KEY});
    }

    private void setViewEnable() {
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{DIMASSIGN_KEY});
        this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{DIMASSIGN_KEY});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
    }

    private DynamicObjectCollection selectDataCollectionRec() {
        Long dateSetId = (Long)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (dateSetId == null) {
            DynamicObject apprecord = (DynamicObject)this.getModel().getValue(APPRECORD_KEY);
            dateSetId = apprecord.getLong("id");
        }
        return QueryServiceHelper.query((String)"eb_collectionrecord", (String)this.getSelectDataRecord(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dateSetId)});
    }

    private String getSelectDataRecord() {
        return "id,model,creator,createtime,appname,appnumber,cloudname,cloudnumber,dseq";
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "entity": {
                this.openCustomF7();
                break;
            }
            case "fieldname": {
                if (!this.isDataSource()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u6570\u636e\u6e90\u4fe1\u606f\u3002", (String)"DataCollectionPlanPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setFormId("eb_collectionfieldf7");
                fsp.setCaption(ResManager.loadKDString((String)"\u5b57\u6bb5\u9009\u62e9", (String)"DataCollectionPlanPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                DynamicObject accountform = (DynamicObject)this.getModel().getValue(ACCOUNTFORM_KEY);
                fsp.setCustomParam(ACCOUNTFORM_KEY, (Object)SerializationUtils.serializeToBase64((Object)accountform));
                EntryGrid control = (EntryGrid)this.getControl(ENTITYDIMMAP);
                int[] selectRows = control.getSelectRows();
                if (selectRows.length > 0) {
                    String fieldName = (String)this.getModel().getValue(FIELDNAME, selectRows[0]);
                    fsp.setCustomParam("fieldName", (Object)fieldName);
                }
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldF7"));
                this.getView().showForm(fsp);
                break;
            }
        }
    }

    private void openCustomF7() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ENTITY);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
        String entityrang = (String)this.getModel().getValue("entityrang");
        RangeF7Param range = new RangeF7Param();
        range.setShowView(false);
        range.setNeedPermCheck(true);
        range.setqFilters(qFilters);
        range.setCloseCallBack(closeCallBack);
        ArrayList<String> userRange = new ArrayList<String>(16);
        userRange.add("10");
        userRange.add("90");
        range.setUserRange(userRange);
        if (StringUtils.isNotEmpty((String)entityrang)) {
            List serialize = SerializationUtils.fromJsonStringToList((String)entityrang, Map.class);
            ArrayList<MemberCondition> membersRange = new ArrayList<MemberCondition>(serialize.size());
            for (Map stringMap : serialize) {
                membersRange.add(new MemberCondition((String)stringMap.get("number"), (String)stringMap.get("name"), "", (String)stringMap.get("scope")));
            }
            range.setCon_list(membersRange);
            CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)SysDimensionEnum.Entity.getNumber(), (Long)0L, (IFormView)this.getView(), (RangeF7Param)range);
        } else {
            CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)SysDimensionEnum.Entity.getNumber(), (Long)0L, (IFormView)this.getView(), (RangeF7Param)range);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setViewEnable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        String dimAssign = this.getPageCache().get(DIMASSIGN_KEY);
        if (dimAssign != null) {
            return;
        }
        switch (propName) {
            case "apprecord": {
                this.setAppRecord();
                break;
            }
            case "periodtype": {
                DynamicObject periodTpye = (DynamicObject)this.getModel().getValue(PERIODTYPE_KEY);
                if (periodTpye != null) {
                    this.queryBookRunnerPeriod(periodTpye);
                } else {
                    this.getModel().deleteEntryData(ENTITYPERIODMAP);
                    this.getModel().deleteEntryData(ENTITYYEARMAP);
                    this.updateView();
                }
                this.updateView();
                break;
            }
            case "budgetyear": 
            case "bgm_budgetperiod": {
                this.budgetYearProperty(e);
                break;
            }
        }
    }

    private void budgetYearProperty(PropertyChangedArgs e) {
        EntryGrid control = (EntryGrid)this.getControl(ENTITYYEARMAP);
        int focusRow = control.getEntryState().getFocusRow();
        DynamicObject budgetyear = (DynamicObject)this.getModel().getValue(BUDGETYEAR_KEY, focusRow);
        String accyear = (String)this.getModel().getValue("accyear", focusRow);
        DynamicObjectCollection entityPriod = this.getModel().getEntryEntity(ENTITYPERIODMAP);
        entityPriod.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Integer anInt1 = ((DynamicObject)o1.get("accperiod")).getInt("periodyear");
                Integer anInt2 = ((DynamicObject)o2.get("accperiod")).getInt("periodyear");
                return anInt1.compareTo(anInt2);
            }
        });
        LinkedHashMap<String, List<DynamicObject>> periodMapByString = new LinkedHashMap<String, List<DynamicObject>>(16);
        this.entityTransformationMap(entityPriod, periodMapByString);
        if (budgetyear == null) {
            if (periodMapByString.get(accyear) != null) {
                periodMapByString.remove(accyear);
                this.buildEntityPeriod(periodMapByString);
            }
        } else if (periodMapByString.get(accyear) != null) {
            List objectList = (List)periodMapByString.get(accyear);
            for (DynamicObject dynamicObject : objectList) {
                dynamicObject.set(FISCALYEAR_KEY, (Object)budgetyear);
            }
            this.buildEntityPeriod(periodMapByString);
        }
        this.getView().updateView(ENTITYPERIODMAP);
    }

    private void entityTransformationMap(DynamicObjectCollection entityPriod, Map<String, List<DynamicObject>> periodMapByString) {
        for (DynamicObject dynamicObject : entityPriod) {
            DynamicObject accperiod = (DynamicObject)dynamicObject.get("accperiod");
            String periodyear = String.valueOf(accperiod.getInt("periodyear"));
            List<DynamicObject> objectList1 = periodMapByString.get(periodyear);
            if (objectList1 == null) {
                LinkedList<DynamicObject> periods = new LinkedList<DynamicObject>();
                periods.add(dynamicObject);
                periodMapByString.put(periodyear, periods);
                continue;
            }
            objectList1.add(dynamicObject);
        }
    }

    private void buildEntityPeriodCompare(DynamicObject budgetyear, List<DynamicObject> objectList) {
        objectList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Integer periodnumber1 = o1.getInt("periodnumber");
                Integer periodnumber2 = o2.getInt("periodnumber");
                return periodnumber1.compareTo(periodnumber2);
            }
        });
        Map<Integer, DynamicObject> periodMap = this.loadPeriodMap();
        for (DynamicObject dynamicObject : objectList) {
            int entryRow = this.getModel().createNewEntryRow(ENTITYPERIODMAP);
            this.getModel().setValue("accperiod", (Object)dynamicObject.getString("id"), entryRow);
            Date begindate = dynamicObject.getDate("begindate");
            this.getModel().setValue("startdate", (Object)begindate, entryRow);
            this.getModel().setValue("enddate", (Object)dynamicObject.getDate("enddate"), entryRow);
            Calendar accDate = Calendar.getInstance();
            accDate.setTime(begindate);
            int monday = accDate.get(2) + 1;
            if (periodMap.get(monday) != null) {
                if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView())) {
                    this.getModel().setValue(BGM_BUDGETPERIOD_KEY, periodMap.get(monday).get("id"), entryRow);
                }
                this.getModel().setValue(BUDGETPERIOD_KEY, periodMap.get(monday).get("id"), entryRow);
            }
            this.getModel().setValue(FISCALYEAR_KEY, budgetyear.get("id"), entryRow);
        }
    }

    private void buildEntityPeriod(Map<String, List<DynamicObject>> entityPeriodMap) {
        if (entityPeriodMap.size() > 0) {
            this.getModel().deleteEntryData(ENTITYPERIODMAP);
            this.getModel().beginInit();
            for (Map.Entry<String, List<DynamicObject>> map : entityPeriodMap.entrySet()) {
                List<DynamicObject> value = map.getValue();
                for (DynamicObject dynamicObject : value) {
                    int entryRow = this.getModel().createNewEntryRow(ENTITYPERIODMAP);
                    this.getModel().setValue("accperiod", dynamicObject.get("accperiod"), entryRow);
                    this.getModel().setValue("startdate", (Object)dynamicObject.getDate("startdate"), entryRow);
                    this.getModel().setValue("enddate", (Object)dynamicObject.getDate("enddate"), entryRow);
                    this.getModel().setValue(FISCALYEAR_KEY, dynamicObject.get(FISCALYEAR_KEY), entryRow);
                    if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView())) {
                        this.getModel().setValue(BGM_BUDGETPERIOD_KEY, dynamicObject.get(BGM_BUDGETPERIOD_KEY), entryRow);
                    }
                    this.getModel().setValue(BUDGETPERIOD_KEY, dynamicObject.get(BUDGETPERIOD_KEY), entryRow);
                }
            }
            this.getModel().endInit();
        }
    }

    private void updateView() {
        this.getView().updateView(ENTITYYEARMAP);
        this.getView().updateView(ENTITYPERIODMAP);
    }

    private void queryBookRunnerPeriod(DynamicObject periodtype) {
        DynamicObjectCollection query = this.getDynamicPeriodType(periodtype);
        if (query.size() > 0) {
            Long id = ((DynamicObject)query.get(0)).getLong("id");
            DynamicObjectCollection objects = QueryServiceHelper.query((String)BD_PERIODOUTLINE_TREE, (String)this.getSelectPeriodOutline(), (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)id)});
            objects.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    Integer periodyear1 = o1.getInt("periodyear");
                    Integer periodyear2 = o2.getInt("periodyear");
                    return periodyear1.compareTo(periodyear2);
                }
            });
            QFBuilder qfBuilder = new QFBuilder(MODEL_KEY, "=", (Object)this.getModelId());
            qfBuilder.add(new QFilter("level", "=", (Object)3));
            HashMap<String, DynamicObject> yearMap = new HashMap<String, DynamicObject>(16);
            this.loadYearMap(qfBuilder, yearMap, this.getModelId());
            ArrayList periodyears = new ArrayList(16);
            objects.forEach(a -> periodyears.add(a.getLong("periodyear")));
            QFilter qFilter1 = new QFilter(PERIODTYPE_KEY, "=", (Object)id);
            qFilter1.and(new QFilter("periodyear", "in", periodyears));
            DynamicObjectCollection dynamicObjects = this.getDynamicPeriod(qFilter1);
            HashMap<String, String> objectMap = new HashMap<String, String>(16);
            for (DynamicObject object : dynamicObjects) {
                String periodyear = String.valueOf(object.getInt("periodyear"));
                objectMap.putIfAbsent(periodyear, "1");
            }
            this.getModel().deleteEntryData(ENTITYYEARMAP);
            this.getModel().beginInit();
            for (DynamicObject object : objects) {
                if (objectMap.get(object.getString("periodyear")) == null) continue;
                int row = this.getModel().createNewEntryRow(ENTITYYEARMAP);
                String periodyear = object.getString("periodyear");
                this.getModel().setValue("accyear", (Object)periodyear, row);
                this.getModel().setValue("accyearid", (Object)object.getString("id"), row);
                if (yearMap.get(periodyear) == null) continue;
                this.getModel().setValue(BUDGETYEAR_KEY, ((DynamicObject)yearMap.get(periodyear)).get("id"), row);
            }
            this.getModel().endInit();
            if (objects.size() > 0) {
                QFilter qFilter = new QFilter(PERIODTYPE_KEY, "=", (Object)id);
                DynamicObjectCollection bdPeriod = this.getDynamicPeriod(qFilter);
                bdPeriod.sort((Comparator)new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        Integer anInt1 = o1.getInt("periodyear");
                        Integer anInt2 = o2.getInt("periodyear");
                        return anInt1.compareTo(anInt2);
                    }
                });
                LinkedHashMap<String, List<DynamicObject>> periodYearMap = new LinkedHashMap<String, List<DynamicObject>>(16);
                for (DynamicObject dynamicObject : bdPeriod) {
                    List objectList = (List)periodYearMap.get(String.valueOf(dynamicObject.getInt("periodyear")));
                    if (objectList == null) {
                        ArrayList<DynamicObject> periodYearList = new ArrayList<DynamicObject>(16);
                        periodYearList.add(dynamicObject);
                        periodYearMap.put(String.valueOf(dynamicObject.getInt("periodyear")), periodYearList);
                        continue;
                    }
                    objectList.add(dynamicObject);
                }
                Map<Integer, DynamicObject> periodMap = this.loadPeriodMap();
                if (bdPeriod.size() > 0) {
                    this.buildPeriodEnity(yearMap, periodYearMap, periodMap);
                }
            }
        }
    }

    private Map<Integer, DynamicObject> loadPeriodMap() {
        ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp((IFormView)this.getView());
        switch (applicationTypeEnum) {
            case BGM: 
            case BGMD: {
                return this.getDimensionBPeriodMap();
            }
        }
        return this.getDimensionPeriodMap();
    }

    private void loadYearMap(QFBuilder qfBuilder, Map<String, DynamicObject> yearMap, Long modelId) {
        ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp((IFormView)this.getView());
        switch (applicationTypeEnum) {
            case BGM: 
            case BGMD: {
                IModelCacheHelper modelCacheHelper;
                List members;
                if (IDUtils.isNull((Long)modelId) || (members = (modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId)).getMembers(SysDimensionEnum.BudgetPeriod.getNumber(), 2)) == null || members.isEmpty()) break;
                for (Member member : members) {
                    String substring;
                    String number = member.getNumber();
                    if (!number.startsWith("FY") || yearMap.containsKey(substring = number.substring(2))) continue;
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel());
                    dynamicObject.set("id", (Object)member.getId());
                    dynamicObject.set("name", (Object)member.getName());
                    dynamicObject.set("number", (Object)member.getNumber());
                    yearMap.put(substring, dynamicObject);
                }
                break;
            }
            default: {
                DynamicObjectCollection queryYear = QueryServiceHelper.query((String)SysDimensionEnum.Year.getMemberTreemodel(), (String)"id,number,name", (QFilter[])qfBuilder.toArray());
                for (DynamicObject dynamicObject : queryYear) {
                    String number = dynamicObject.getString("number");
                    if (!number.startsWith("FY")) continue;
                    String substring = number.substring(2);
                    yearMap.put(substring, dynamicObject);
                }
            }
        }
    }

    private Map<Integer, DynamicObject> getDimensionPeriodMap() {
        QFBuilder qfBuilder1 = new QFBuilder(MODEL_KEY, "=", (Object)this.getModelId());
        qfBuilder1.add(new QFilter("isleaf", "=", (Object)true));
        DynamicObjectCollection queryPeriod = QueryServiceHelper.query((String)SysDimensionEnum.Period.getMemberTreemodel(), (String)"id,number,name,effmonth,effday,expmonth,expday", (QFilter[])qfBuilder1.toArray());
        HashMap<Integer, DynamicObject> periodMap = new HashMap<Integer, DynamicObject>(16);
        for (DynamicObject dynamicObject : queryPeriod) {
            periodMap.put(dynamicObject.getInt("effmonth"), dynamicObject);
        }
        return periodMap;
    }

    private Map<Integer, DynamicObject> getDimensionBPeriodMap() {
        QFBuilder qfBuilder1 = new QFBuilder(MODEL_KEY, "=", (Object)this.getModelId());
        qfBuilder1.add(new QFilter("isleaf", "=", (Object)true));
        DynamicObjectCollection queryPeriod = QueryServiceHelper.query((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"id,number,name,effmonth,effday,expmonth,expday", (QFilter[])qfBuilder1.toArray());
        HashMap<Integer, DynamicObject> periodMap = new HashMap<Integer, DynamicObject>(16);
        for (DynamicObject dynamicObject : queryPeriod) {
            periodMap.put(dynamicObject.getInt("effmonth"), dynamicObject);
        }
        return periodMap;
    }

    private DynamicObjectCollection getDynamicPeriod(QFilter qFilter) {
        return QueryServiceHelper.query((String)BD_PERIOD, (String)this.getSelectPeriod(), (QFilter[])new QFilter[]{qFilter});
    }

    private DynamicObjectCollection getDynamicPeriodType(DynamicObject periodtype) {
        return QueryServiceHelper.query((String)BD_PERIOD_TYPE, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)periodtype.getString("number"))});
    }

    private void buildPeriodEnity(Map<String, DynamicObject> yearMap, Map<String, List<DynamicObject>> periodYearMap, Map<Integer, DynamicObject> periodMap) {
        this.getModel().deleteEntryData(ENTITYPERIODMAP);
        this.getModel().beginInit();
        for (Map.Entry<String, List<DynamicObject>> map : periodYearMap.entrySet()) {
            if (yearMap.get(map.getKey()) == null) continue;
            List<DynamicObject> value = map.getValue();
            value.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    Integer periodnumber1 = o1.getInt("periodnumber");
                    Integer periodnumber2 = o2.getInt("periodnumber");
                    return periodnumber1.compareTo(periodnumber2);
                }
            });
            for (DynamicObject dynamicObject : value) {
                int entryRow = this.getModel().createNewEntryRow(ENTITYPERIODMAP);
                this.getModel().setValue("accperiod", (Object)dynamicObject.getString("id"), entryRow);
                Date begindate = dynamicObject.getDate("begindate");
                this.getModel().setValue("startdate", (Object)begindate, entryRow);
                this.getModel().setValue("enddate", (Object)dynamicObject.getDate("enddate"), entryRow);
                Calendar accDate = Calendar.getInstance();
                accDate.setTime(begindate);
                int monday = accDate.get(2) + 1;
                if (periodMap.get(monday) != null) {
                    if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView())) {
                        this.getModel().setValue(BGM_BUDGETPERIOD_KEY, periodMap.get(monday).get("id"), entryRow);
                    }
                    this.getModel().setValue(BUDGETPERIOD_KEY, periodMap.get(monday).get("id"), entryRow);
                }
                this.getModel().setValue(FISCALYEAR_KEY, yearMap.get(map.getKey()).get("id"), entryRow);
            }
        }
        this.getModel().endInit();
    }

    private String getSelectPeriod() {
        return "id,periodyear,periodnumber,begindate,enddate,isadjustperiod";
    }

    private String getSelectPeriodOutline() {
        return "id,periodyear,outlinebegindate,outlineenddate,period,periodoutlinequarter";
    }

    private void setAppRecord() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(APPRECORD_KEY);
        this.getModel().setValue("modelname", (Object)value.getString("appname"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operation = ((FormOperate)args.getSource()).getOperateKey())) {
            this.baseValidate();
        }
    }

    private void baseValidate() {
        DynamicObjectCollection periodEntity;
        String entityrang;
        List entit;
        this.getPageCache().put(DIMASSIGN_KEY, "lock");
        String number = (String)this.getModel().getValue("number");
        String checkNumber = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotEmpty((String)checkNumber)) {
            throw new KDBizException(checkNumber);
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (StringUtils.isEmpty((String)name.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u5207\u6362\u5bf9\u5e94\u8bed\u8a00\u540e\uff0c\u8f93\u5165\u540d\u79f0\u4fe1\u606f\u3002\u5f53\u524d\u8bed\u8a00\u73af\u5883\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"DataCollectionPlanPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String status = this.getPageCache().get("status");
        if (StringUtils.isEmpty((String)status) || !StringUtils.equals((String)status, (String)"modify")) {
            QFilter qf = new QFilter("number", "=", (Object)number);
            qf.and(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
            boolean exists = QueryServiceHelper.exists((String)"eb_collectionconfig", (QFilter[])qf.toArray());
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\u3002", (String)"DataCollectionPlanPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("status", "modify");
        }
        if ((entit = DataCollectionService.getEntityRang((String)(entityrang = (String)this.getModel().getValue("entityrang")), (long)this.getModelId())).size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5e26\u660e\u7ec6\u7684\u9002\u7528\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataCollectionPlanPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String entityField = (String)this.getModel().getValue(FIELDNAME, 0);
        if (StringUtils.isEmpty((String)entityField)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5339\u914d\u5173\u7cfb-\u7ec4\u7ec7,\u6e90\u5b57\u6bb5\u540d\u79f0\u672a\u9009\u62e9\u3002", (String)"DataCollectionPlanPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String accountField = (String)this.getModel().getValue(FIELDNAME, 1);
        if (StringUtils.isEmpty((String)accountField)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5339\u914d\u5173\u7cfb-\u79d1\u76ee,\u6e90\u5b57\u6bb5\u540d\u79f0\u672a\u9009\u62e9\u3002", (String)"DataCollectionPlanPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection yearEntity = this.getModel().getEntryEntity(ENTITYYEARMAP);
        boolean yearJudge = true;
        if (ApplicationTypeEnum.BGM != ModelUtil.queryApp((IFormView)this.getView()) && yearEntity.size() > 0) {
            for (DynamicObject dynamicObject : yearEntity) {
                DynamicObject budgetyear = (DynamicObject)dynamicObject.get(BUDGETYEAR_KEY);
                if (budgetyear == null) continue;
                yearJudge = false;
            }
            if (yearJudge) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u6620\u5c04\u5173\u7cfb\u6709\u6570\u636e\u672a\u586b\u5199\u3002", (String)"DataCollectionPlanPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if ((periodEntity = this.getModel().getEntryEntity(ENTITYPERIODMAP)).size() > 0 && (yearJudge = this.checkPeriods(periodEntity))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u6620\u5c04\u5173\u7cfb\u6709\u6570\u636e\u672a\u586b\u5199\u3002", (String)"DataCollectionPlanPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.setUserDefine();
        this.getPageCache().remove(DIMASSIGN_KEY);
    }

    private boolean checkPeriods(DynamicObjectCollection periodEntity) {
        Iterator iterator = periodEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject budgetyear;
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView())) {
                budgetyear = (DynamicObject)dynamicObject.get(BGM_BUDGETPERIOD_KEY);
                if (budgetyear != null) {
                    Long periodId = budgetyear.getLong("id");
                    Long oldPeriodId = dynamicObject.getLong(String.join((CharSequence)"_", BUDGETPERIOD_KEY, "id"));
                    if (IDUtils.isNotNull((Long)oldPeriodId) && oldPeriodId.equals(periodId)) {
                        iterator.remove();
                        continue;
                    }
                    DynamicObject ebPeriod = BusinessDataServiceHelper.newDynamicObject((String)SysDimensionEnum.Period.getMemberTreemodel());
                    ebPeriod.set("id", (Object)periodId);
                    ebPeriod.set("number", (Object)budgetyear.getString("number"));
                    ebPeriod.set("name", (Object)budgetyear.getString("name"));
                    ebPeriod.setParent((Object)System.currentTimeMillis());
                    dynamicObject.set(BUDGETPERIOD_KEY, (Object)ebPeriod);
                    continue;
                }
                return true;
            }
            budgetyear = (DynamicObject)dynamicObject.get(BUDGETPERIOD_KEY);
            if (budgetyear != null) continue;
            return true;
        }
        return false;
    }

    private void setUserDefine() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTITYDIMMAP);
        DynamicObjectCollection dynamicObjects = DimensionServiceHelper.queryAllUserDefineDimension((Long)this.getModelId(), (String)"id,number,shortnumber");
        HashMap<String, String> shortMap = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            shortMap.put(dynamicObject.getString("number"), dynamicObject.getString("shortnumber"));
        }
        for (int i = 2; i < entity.size(); ++i) {
            String userField = (String)this.getModel().getValue(FIELDNAME, i);
            DynamicObject userAssign = (DynamicObject)this.getModel().getValue(DIMASSIGN_KEY, i);
            if (!StringUtils.isEmpty((String)userField) || userAssign != null) continue;
            String value = (String)this.getModel().getValue(DIMNUMBER, i);
            StringBuilder sb = new StringBuilder();
            QFBuilder qfBuilder = new QFBuilder(MODEL_KEY, "=", (Object)this.getModelId());
            qfBuilder.add(new QFilter("number", "=", (Object)sb.append((String)shortMap.get(value)).append("None").toString()));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id", (QFilter[])qfBuilder.toArray());
            if (query.size() <= 0) continue;
            this.getModel().setValue(DIMASSIGN_KEY, (Object)((DynamicObject)query.get(0)).getString("id"), i);
        }
    }

    public void afterBindData(EventObject ent) {
        super.afterBindData(ent);
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isNotEmpty((String)number)) {
            this.getPageCache().put("status", "modify");
            boolean status = (Boolean)this.getModel().getValue("status");
            if (status) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propKey;
        switch (propKey = beforeF7SelectEvent.getProperty().getName()) {
            case "currency": 
            case "budgetyear": 
            case "budgetperiod": 
            case "bgm_budgetperiod": {
                this.getQFiltersByYearPeriod(beforeF7SelectEvent);
                break;
            }
            case "dimmap": {
                this.getQFiltersByMapping(beforeF7SelectEvent);
                break;
            }
            case "businessentry": {
                this.getQFiltersByOrg(beforeF7SelectEvent);
                break;
            }
            case "dimassign": {
                this.getQFiltersByYearAssign(beforeF7SelectEvent);
                break;
            }
            case "dataset": {
                this.getQfiltersByModelId(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void getQFiltersByOrg(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)UserUtils.getUserId());
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            filterParameter.getQFilters().add(new QFilter("id", "in", (Object)hasPermOrgs));
        }
    }

    private void getQfiltersByModelId(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        qFilterList.add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
    }

    private void getQFiltersByYearAssign(BeforeF7SelectEvent beforeF7SelectEvent) {
        ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)true));
        LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
        leftTreeF7Parameter.setKeepTree(true);
        leftTreeF7Parameter.setOnlyLeaf(true);
        this.switchLeftTreeF7(beforeF7SelectEvent, 0L, leftTreeF7Parameter);
    }

    private void getQFiltersByAccount(BeforeF7SelectEvent e) {
        FormShowParameter showParameter;
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)UserUtils.getUserId(), (String)"fibd", (String)BD_ACCOUNTTABLE, (String)"47150e89000000ac");
        if (!permOrgResult.hasAllOrgPerm() && (showParameter = e.getFormShowParameter()) instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            DynamicObjectCollection query = QueryServiceHelper.query((String)BD_ACCOUNTTABLE, (String)"id", (QFilter[])new QFilter("org", "in", (Object)hasPermOrgs).toArray());
            ArrayList ids = new ArrayList(query.size());
            query.forEach(q -> ids.add(q.getLong("id")));
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
        }
    }

    private void getQFiltersByMapping(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        qFilterList.add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTITYDIMMAP);
        qFilterList.add(new QFilter(DIMNUMBER, "=", this.getModel().getValue(DIMNUMBER, rowIndex)));
        if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView()) && this.getModel().getValue(DIMNUMBER, rowIndex).equals(SysDimensionEnum.Account.getNumber())) {
            DynamicObject dataSet = (DynamicObject)this.getModel().getValue(DATASET_KEY);
            if (dataSet != null) {
                qFilterList.add(new QFilter(DATASET_KEY, "=", (Object)dataSet.getLong("id")));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"DataCollectionPlanPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
    }

    private void getQFiltersByYearPeriod(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject row;
        DynamicObject bpDy;
        FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter filterParameter = ((ListShowParameter)formShowParameter).getListFilterParameter();
        filterParameter.getQFilters().add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
        filterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)true));
        if (BUDGETPERIOD_KEY.equals(beforeF7SelectEvent.getProperty().getName()) && (bpDy = (row = this.getModel().getEntryRowEntity(ENTITYPERIODMAP, beforeF7SelectEvent.getRow())).getDynamicObject(BUDGETPERIOD_KEY)) != null) {
            ((ListShowParameter)formShowParameter).setSelectedRow((Object)bpDy.getLong("id"));
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelObj != null) {
            return modelObj.getLong("id");
        }
        return 0L;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        Object[] primaryKeyValues;
        super.closedCallBack(closedCallBackEvent);
        String backKey = closedCallBackEvent.getActionId();
        if (ENTITY.equals(backKey)) {
            DynamicObjectCollection rows = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (rows != null) {
                ArrayList list = new ArrayList(16);
                for (DynamicObject row : rows) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", row.getString("memberid"));
                    map.put("scope", row.getString("scope"));
                    map.put("number", row.getString("number"));
                    map.put("name", row.getString("name"));
                    map.put("pid", row.getString("pid"));
                    list.add(map);
                }
                String jsonString = SerializationUtils.toJsonString(list);
                List<String> entityrang = DataCollectionPlanPlugin.getEntityRang(jsonString);
                StringBuilder sb = new StringBuilder(16);
                for (String str : entityrang) {
                    if (sb.toString().isEmpty()) {
                        sb.append(str);
                        continue;
                    }
                    sb.append(",").append(str);
                }
                this.getModel().setValue(ENTITY, (Object)sb.toString());
                this.getModel().setValue(backKey + "rang", (Object)jsonString);
            }
        } else if ("fieldF7".equals(backKey)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 instanceof Map) {
                Map rows = (Map)closedCallBackEvent.getReturnData();
                int index = this.getModel().getEntryCurrentRowIndex(ENTITYDIMMAP);
                if (index != -1) {
                    this.getModel().setValue(FIELDTABLE, rows.get("table"), index);
                    this.getModel().setValue(FIELDID, rows.get("id"), index);
                    this.getModel().setValue(FIELDNAME, rows.get("name"), index);
                }
            }
        } else if ("userdefF7".equals(backKey) && (primaryKeyValues = (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()).getPrimaryKeyValues()) != null && primaryKeyValues.length > 0) {
            EntryGrid entitydimmap = (EntryGrid)this.getControl(ENTITYDIMMAP);
            int index = entitydimmap.getEntryState().getFocusRow();
            this.getModel().setValue(DIMASSIGN_KEY, primaryKeyValues[0], index);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    public static List<String> getEntityRang(String entity) {
        if (!entity.isEmpty()) {
            ArrayList<String> accountIds = new ArrayList<String>(16);
            List serialize = SerializationUtils.fromJsonStringToList((String)entity, Map.class);
            for (Map stringMap : serialize) {
                String scope = (String)stringMap.get("scope");
                if (StringUtils.equals((String)"90", (String)scope)) {
                    accountIds.add((String)stringMap.get("name") + " " + ResManager.loadKDString((String)"\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458", (String)"DataCollectionPlanPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                accountIds.add((String)stringMap.get("name"));
            }
            return accountIds;
        }
        return new ArrayList<String>(1);
    }

    private boolean isDataSource() {
        Object accountform = this.getModel().getValue(ACCOUNTFORM_KEY);
        Object standard = this.getModel().getValue(STANDARD_KEY);
        Object booktype = this.getModel().getValue(BOOKTYPE_KEY);
        Object periodtype = this.getModel().getValue(PERIODTYPE_KEY);
        Object businessentry = this.getModel().getValue(BUSINESSENTRY_KEY);
        return accountform != null && standard != null && booktype != null && businessentry != null && periodtype != null;
    }

    public String getCurrentDimNumber(String controlKey) {
        EntryGrid entitydimmap = (EntryGrid)this.getControl(ENTITYDIMMAP);
        int focusRow = entitydimmap.getEntryState().getFocusRow();
        return (String)this.getModel().getValue(DIMNUMBER, focusRow);
    }
}

