/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.execute;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.service.DataGatherGLMiddleTableService;
import kd.epm.eb.business.dataGather.service.DataGatherRunService;
import kd.epm.eb.common.applyTemplate.constants.StatusEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.datagather.GlobalVar;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.domain.ExecuteStatusEnum;
import org.apache.commons.lang.StringUtils;

public class BgmExecuteDataCollectionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String EPM_EB_FORMPLUGIN = "epm-eb-formplugin";
    private static final String BTN_EXECUTE = "btn_execute";
    private static final String ENTITY = "entity";
    private static final String BUDGETPERIOD = "budgetperiod";
    private static final String EXECUTE = "collection_execute";
    private static final String FETCH = "fetch";
    private static final String SPLIT_SIZE = "splitsize";
    private static final String COLLECTION_CONFIG = "eb_collectionconfig";
    private Long modelId;
    private IModelCacheHelper modelCacheHelper;
    private Set<Long> entityIds = new HashSet<Long>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_EXECUTE});
        this.addF7SelectListener(ENTITY, BUDGETPERIOD, EXECUTE);
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propKey = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        switch (propKey) {
            case "entity": {
                this.checkCollectionConfigOrg(qFilter);
                filterParameter.getQFilters().add(qFilter);
                break;
            }
            case "budgetperiod": {
                filterParameter.getQFilters().add(qFilter);
                filterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)true));
                break;
            }
            case "collection_execute": {
                filterParameter.getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter == null) {
            return;
        }
        this.setEntityDefaultValue(parameter);
        this.setBudgetPeriodDefaultValue(parameter);
    }

    private void setBudgetPeriodDefaultValue(FormShowParameter parameter) {
        Long defaultId = (Long)parameter.getCustomParam("BUDGETPERIOD_KEY");
        if (IDUtils.isNotNull((Long)defaultId)) {
            this.getModel().setValue(BUDGETPERIOD, (Object)defaultId);
        }
    }

    private void setEntityDefaultValue(FormShowParameter parameter) {
        this.loadCollectionConfigOrg(new QFilter("model", "=", (Object)this.getModelId()));
        List entitys = (List)parameter.getCustomParam("ENTITY_NUMBER_LIST");
        if (entitys == null || entitys.size() == 0) {
            return;
        }
        HashSet<Long> entitySet = new HashSet<Long>(10);
        String entityDimKey = SysDimensionEnum.Entity.getNumber();
        for (String entity : entitys) {
            Long id;
            Member member;
            if (StringUtils.isEmpty((String)entity) || (member = this.modelCacheHelper.getMember(entityDimKey, Long.valueOf(0L), entity)) == null || IDUtils.isNull((Long)(id = member.getId())) || !this.entityIds.contains(id)) continue;
            entitySet.add(id);
        }
        this.getModel().setValue(ENTITY, (Object)entitySet.toArray(new Long[entitySet.size()]));
    }

    private void checkCollectionConfigOrg(QFilter qFilter) {
        qFilter.and(new QFilter("id", "in", new ArrayList<Long>(this.entityIds)));
    }

    private void loadCollectionConfigOrg(QFilter qFilter) {
        QFilter queryFilter = new QFilter("status", "=", (Object)StatusEnum.ENABLE.getCode());
        queryFilter.and(qFilter);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)COLLECTION_CONFIG, (String)"entityrang", (QFilter[])queryFilter.toArray());
        for (DynamicObject dynamicObject : collection) {
            String entity = dynamicObject.getString("entityrang");
            List array = JSON.parseArray((String)entity, JSONObject.class);
            for (JSONObject jsonObject : array) {
                Long id = jsonObject.getLong("id");
                if (!IDUtils.isNotNull((Long)id)) continue;
                this.entityIds.add(id);
            }
        }
    }

    private int getSqlBatch() {
        String sqlBatch;
        String string = sqlBatch = this.getModel().getValue("sqlbatch") == null ? "8000" : this.getModel().getValue("sqlbatch").toString();
        if (StringUtils.isNumeric((String)sqlBatch)) {
            return Integer.parseInt(sqlBatch);
        }
        return 8000;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (BTN_EXECUTE.equals(key)) {
            DynamicObject budgetPeriod = (DynamicObject)this.getModel().getValue(BUDGETPERIOD);
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ENTITY);
            DynamicObjectCollection collectionExecutes = (DynamicObjectCollection)this.getModel().getValue(EXECUTE);
            Integer fetch = (Integer)this.getModel().getValue(FETCH);
            Integer splitSize = (Integer)this.getModel().getValue(SPLIT_SIZE);
            if (splitSize != null && splitSize > 0) {
                GlobalVar.splitSize.set(splitSize);
            }
            GlobalVar.fetch.set(fetch);
            HashSet<String> org = new HashSet<String>(orgs.size());
            orgs.forEach(f -> org.add(((DynamicObject)f.get("fbasedataid")).getString("number")));
            DataGatherHandCallParam param = this.getDataGatherHandCallParam(org, null, null, budgetPeriod);
            ArrayList<Long> executeIds = new ArrayList<Long>(16);
            boolean deleteHistoryDataOnFirstExec = true;
            for (DynamicObject collectionExecute : collectionExecutes) {
                String executeId = collectionExecute.getString("fbasedataid.id");
                ArrayList<Long> executes = new ArrayList<Long>(5);
                executes.add(Long.parseLong(executeId));
                if (deleteHistoryDataOnFirstExec) {
                    deleteHistoryDataOnFirstExec = false;
                    DataGatherGLMiddleTableService.getInstance().deleteDataFromMiddleTable(executes);
                }
                DataGatherRunService.getInstance().doDataGatherRun(this.getModelId(), executes, param);
                executeIds.add(Long.parseLong(executeId));
            }
            QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "in", executeIds));
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"eb_collectionexecute", (String)"remind,supervisors,modifier", (QFilter[])qfBuilder.toArray());
            boolean remind = load.getBoolean("remind");
            if (remind) {
                DynamicObjectCollection supervisors = (DynamicObjectCollection)load.get("supervisors");
                this.messqge(supervisors);
            }
            GlobalVar.fetch.remove();
            this.getView().getParentView().showSuccessNotification(ExecuteStatusEnum.SUCCESS.getName());
            this.getView().returnDataToParent((Object)"1");
            this.getView().close();
        }
    }

    private DataGatherHandCallParam getDataGatherHandCallParam(Set<String> org, DynamicObject year, DynamicObject period, DynamicObject budgetPeriod) {
        DataGatherHandCallParam param = new DataGatherHandCallParam();
        param.setOrgNums(org);
        param.setSqlBatch(this.getSqlBatch());
        ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp((IFormView)this.getView());
        switch (applicationTypeEnum) {
            case BGM: 
            case BGMD: {
                param.setPeriodNum(budgetPeriod.getString("number"));
                param.setAppNum(ApplicationTypeEnum.BGM.getAppnum());
                break;
            }
            default: {
                if (year != null) {
                    param.setYearNum(year.getString("number"));
                }
                if (period != null) {
                    param.setPeriodNum(period.getString("number"));
                }
                param.setAppNum(ApplicationTypeEnum.EB.getAppnum());
            }
        }
        return param;
    }

    private void messqge(DynamicObjectCollection supervisors) {
        ArrayList receiver = new ArrayList(16);
        if (!supervisors.isEmpty()) {
            supervisors.forEach(e -> receiver.add(e.getLong("fbasedataid_id")));
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u91c7\u96c6", (String)"ExecuteCollectionTask_0", (String)EPM_EB_FORMPLUGIN, (Object[])new Object[0]));
        messageInfo.setContent(ResManager.loadKDString((String)"\u6709\u4e00\u4e2a\u6b63\u5728\u6267\u884c\u7684\u6570\u636e\u91c7\u96c6\uff0c\u8bf7\u67e5\u770b\u3002", (String)"ExecuteCollectionTask_1", (String)EPM_EB_FORMPLUGIN, (Object[])new Object[0]));
        messageInfo.setUserIds(receiver);
        messageInfo.setSenderId(UserUtils.getUserId());
        messageInfo.setType("message");
        messageInfo.setEntityNumber("eb_collectionexecute");
        messageInfo.setNotifyType("sms");
        messageInfo.setPubaccNumber("systempubacc");
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    @Override
    public Long getModelId() {
        if (IDUtils.isNull((Long)this.modelId)) {
            String modelIdStr;
            this.modelId = super.getModelId();
            if (IDUtils.isNull((Long)this.modelId) && StringUtils.isNotEmpty((String)(modelIdStr = this.getParamByKey(this.getView(), "model")))) {
                this.modelId = Long.valueOf(modelIdStr);
            }
        }
        if (IDUtils.isNotNull((Long)this.modelId) && this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
        }
        return this.modelId;
    }

    private String getParamByKey(IFormView view, String key) {
        String cnNameStr = null;
        if (view == null) {
            return cnNameStr;
        }
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            cnNameStr = parentView.getPageCache().get(key);
        }
        if (StringUtils.isEmpty(cnNameStr)) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            if (formShowParameter == null) {
                return cnNameStr;
            }
            cnNameStr = (String)formShowParameter.getCustomParam(key);
        }
        return cnNameStr;
    }
}

