/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.execute;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BgmExecuteDataDetailsPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(BgmExecuteDataDetailsPlugin.class);
    private static final String DATA_DATAGATHERDATA_ID = "eb_datagatherdata";
    private static final String BILLLISTAP = "billlistap";
    private Long modelId = 0L;
    private Map<String, String> cnNameMap = new HashMap<String, String>(16);
    private List<Map<String, String>> dimensionlist = new ArrayList<Map<String, String>>(10);
    private List<Integer> hashcodeList = new ArrayList<Integer>(10);
    private Map<String, Queue<String>> queueMap = new HashMap<String, Queue<String>>(10);
    private IModelCacheHelper modelCacheHelper;

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if (billList == null) {
            return;
        }
        billList.addCreateListColumnsListener(this::createColumns);
        billList.setSplitPage(true);
        billList.addSetFilterListener(this::setFilter);
        billList.addPackageDataListener(this::packageData);
    }

    private void packageData(PackageDataEvent packageDataEvent) {
        Object source = packageDataEvent.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc desc = (DynamicTextColumnDesc)source;
            String key = desc.getKey();
            Queue<String> queue = this.queueMap.get(key);
            String poll = queue.poll();
            desc.setFormatExpression(poll);
            packageDataEvent.setFormatValue((Object)poll);
        }
    }

    private void createColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        List<String> rowAndColDims = this.loadRowAndColDims();
        if (rowAndColDims == null || rowAndColDims.size() == 0) {
            return;
        }
        List listColumns = beforeCreateListColumnsArgs.getListColumns();
        beforeCreateListColumnsArgs.setListColumns(new ArrayList());
        for (String dimKey : rowAndColDims) {
            DynamicTextListColumn listColumn = new DynamicTextListColumn();
            String key = dimKey.toLowerCase(Locale.ENGLISH);
            listColumn.setListFieldKey(key);
            listColumn.setKey(key);
            listColumn.setFieldName(key);
            listColumn.setEntityName(DATA_DATAGATHERDATA_ID);
            String chineseName = this.loadCnName(dimKey);
            listColumn.setCaption(new LocaleString(chineseName));
            listColumn.setVisible(11);
            listColumn.setTextAlign("center");
            beforeCreateListColumnsArgs.addListColumn((IListColumn)listColumn);
        }
        for (IListColumn listColumn : listColumns) {
            beforeCreateListColumnsArgs.addListColumn(listColumn);
        }
    }

    private void setFilter(SetFilterEvent setFilterEvent) {
        this.loadDimensionData();
        List<String> rowAndColDims = this.loadRowAndColDims();
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection ebdim = QueryServiceHelper.query((String)DATA_DATAGATHERDATA_ID, (String)"entryentity.id,entryentity.ebdim", (QFilter[])qFilter.toArray());
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (ebdim != null && ebdim.size() > 0) {
            for (DynamicObject dynamicObject : ebdim) {
                int indexOf;
                String ebdimStr = dynamicObject.getString("entryentity.ebdim");
                Map<String, String> map = this.checkJsonFormatAndLoadMap(ebdimStr);
                if (map == null || map.size() == 0 || (indexOf = this.hashcodeList.indexOf(map.hashCode())) <= -1) continue;
                for (Map<String, String> pageDimenData : this.dimensionlist) {
                    if (!this.compareMap(pageDimenData, map)) continue;
                    long id = dynamicObject.getLong("entryentity.id");
                    ids.add(id);
                    this.loadDynamicColumnValueToQueue(map, rowAndColDims);
                }
            }
        }
        qFilter.and(new QFilter("entryentity.id", "in", ids));
        setFilterEvent.getQFilters().addAll(Arrays.asList(qFilter.toArray()));
    }

    private Map<String, String> checkJsonFormatAndLoadMap(String ebdimStr) {
        if (StringUtils.isEmpty((String)ebdimStr)) {
            return null;
        }
        if (!ebdimStr.startsWith("{") || !ebdimStr.endsWith("}")) {
            return null;
        }
        Map map = null;
        try {
            map = (Map)JSON.parseObject((String)ebdimStr, Map.class);
        }
        catch (Exception e) {
            LOG.warn(String.join((CharSequence)"", ebdimStr, " is not json format."), (Throwable)e);
        }
        return map;
    }

    private void loadDynamicColumnValueToQueue(Map<String, String> map, List<String> rowAndColDims) {
        if (rowAndColDims == null || rowAndColDims.size() == 0 || map == null || map.size() == 0) {
            return;
        }
        for (String dimKey : rowAndColDims) {
            Member member;
            String memberNumber = map.get(dimKey);
            Queue<String> queue = this.queueMap.get(dimKey.toLowerCase(Locale.ENGLISH));
            if (queue == null) {
                queue = new LinkedList<String>();
            }
            if ((member = this.modelCacheHelper.getMember(dimKey, Long.valueOf(0L), memberNumber)) == null) {
                queue.offer(memberNumber);
            } else {
                queue.offer(member.getName());
            }
            this.queueMap.put(dimKey.toLowerCase(Locale.ENGLISH), queue);
        }
    }

    private boolean compareMap(Map<String, String> pageDimenData, Map<String, String> map) {
        if (pageDimenData == null || pageDimenData.size() == 0 || map == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : pageDimenData.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                String mapToValue = map.get(key);
                if (value.equalsIgnoreCase(mapToValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public Long getModelId() {
        if (IDUtils.isNull((Long)this.modelId)) {
            String modelIdStr;
            this.modelId = super.getModelId();
            if (IDUtils.isNull((Long)this.modelId) && StringUtils.isNotEmpty((String)(modelIdStr = this.getParamByKey(this.getView(), "model")))) {
                this.modelId = Long.valueOf(modelIdStr);
            }
        }
        if (IDUtils.isNotNull((Long)this.modelId) && this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
        }
        return this.modelId;
    }

    private List<String> loadRowAndColDims() {
        String dims = this.getParamByKey(this.getView(), "eb_datadetails_dim_key");
        List dimKeys = (List)JSON.parseObject((String)dims, List.class);
        if (dimKeys == null) {
            return new ArrayList<String>(0);
        }
        return dimKeys;
    }

    private Map<String, String> loadDimCnName() {
        if (this.cnNameMap.size() > 0) {
            return this.cnNameMap;
        }
        String cnNameStr = this.getParamByKey(this.getView(), "eb_datadetails_cn_key");
        if (StringUtils.isEmpty((String)cnNameStr)) {
            return new HashMap<String, String>(0);
        }
        this.cnNameMap = (Map)JSON.parseObject((String)cnNameStr, Map.class);
        return this.cnNameMap;
    }

    private String loadCnName(String dimKey) {
        return this.loadDimCnName().get(dimKey);
    }

    private void loadDimensionData() {
        String cnNameStr = this.getParamByKey(this.getView(), "eb_datadetails_data_key");
        if (StringUtils.isEmpty((String)cnNameStr)) {
            return;
        }
        Map datas = (Map)JSON.parseObject((String)cnNameStr, Map.class);
        if (datas != null && datas.size() > 0) {
            datas.forEach((k, v) -> {
                this.dimensionlist.add((Map<String, String>)v);
                this.hashcodeList.add(v.hashCode());
            });
        }
    }

    private String getParamByKey(IFormView view, String key) {
        String cnNameStr = null;
        if (view == null) {
            return cnNameStr;
        }
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            cnNameStr = parentView.getPageCache().get(key);
        }
        if (StringUtils.isEmpty(cnNameStr)) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            if (formShowParameter == null) {
                return cnNameStr;
            }
            cnNameStr = (String)formShowParameter.getCustomParam(key);
        }
        return cnNameStr;
    }
}

