/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.execute;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataGather.service.DataCollectionService;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class ExecuteCollectionEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
TreeNodeClickListener {
    private static final String MODEL_KEY = "model";
    private static final String SUPERVISORS_KEY = "supervisors";
    private static final String TREEVIEWAP = "treeviewap";
    private static final int MAXLEVEL = 10;
    private static final String MOVETO = "moveto";
    private static final String MOVEBACK = "moveback";
    private static final String BTNTOP = "btntop";
    private static final String BTNUP = "btnup";
    private static final String BTNBOTTOM = "btnbottom";
    private static final String BTNDOWN = "btndown";
    private static final String ENTRYENTITY = "entryentity";
    private static final String COLSTATUS = "colstatus";
    private static final String FOCUS_NODE = "focusNode";
    private static final String SEARCH_BEFORE = "searchbefore";
    private static final String SEARCH_NEXT = "searchnext";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MOVETO, MOVEBACK, BTNTOP, BTNUP, BTNBOTTOM, BTNDOWN});
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7SelectListener(MODEL_KEY, SUPERVISORS_KEY);
        TreeView tview = (TreeView)this.getControl(TREEVIEWAP);
        tview.addTreeNodeClickListener((TreeNodeClickListener)this);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                ExecuteCollectionEditPlugin.this.refrushBillList();
            }
        });
        this.addClickListeners(new String[]{SEARCH_BEFORE, SEARCH_NEXT});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), ExecuteCollectionEditPlugin.this.getView(), ExecuteCollectionEditPlugin.this.getPageCache(), new TreeSearchUtil.TreeSearchParam(ExecuteCollectionEditPlugin.TREEVIEWAP, ExecuteCollectionEditPlugin.TREEVIEWAP));
                    ExecuteCollectionEditPlugin.this.refrushBillList();
                } else {
                    ExecuteCollectionEditPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"ExecuteCollectionEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private void refrushBillList() {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (focusNode != null) {
            this.getPageCache().put(FOCUS_NODE, focusNode.get("id").toString());
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "moveto": {
                List<String> treeNodeFocusNode = this.getTreeNodeFocusNode();
                String applyList = this.getPageCache().get("applyList");
                if (StringUtils.isEmpty((String)applyList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u65b9\u6848\u3002", (String)"ExecuteCollectionEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection appList = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("applyList"));
                HashMap nodeMap = new HashMap(16);
                appList.forEach(e -> nodeMap.put(e.getString("id"), e));
                if (treeNodeFocusNode.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u65b9\u6848\u3002", (String)"ExecuteCollectionEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
                ArrayList entityIds = new ArrayList(16);
                entity.forEach(e -> entityIds.add(((DynamicObject)e.get("project")).getString("id")));
                List reduce = treeNodeFocusNode.stream().filter(item -> !entityIds.contains(item)).collect(Collectors.toList());
                if (reduce.size() == 0) {
                    return;
                }
                this.getModel().beginInit();
                for (String dyn : reduce) {
                    if (nodeMap.get(dyn) == null) continue;
                    DynamicObject dynamicObject = (DynamicObject)nodeMap.get(dyn);
                    int entryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("proname", (Object)dynamicObject.getString("name"), entryRow);
                    this.getModel().setValue("pronumber", (Object)dynamicObject.getString("number"), entryRow);
                    boolean status = dynamicObject.getBoolean("status");
                    if (status) {
                        this.getModel().setValue(COLSTATUS, (Object)ResManager.loadKDString((String)"\u542f\u7528", (String)"ExecuteCollectionEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), entryRow);
                    } else {
                        this.getModel().setValue(COLSTATUS, (Object)ResManager.loadKDString((String)"\u7981\u7528", (String)"ExecuteCollectionEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), entryRow);
                    }
                    this.getModel().setValue("project", (Object)dynamicObject.getString("id"), entryRow);
                    this.getModel().setValue("order", (Object)(entryRow + 1), entryRow);
                }
                this.getModel().endInit();
                this.getView().updateView(ENTRYENTITY);
                break;
            }
            case "moveback": {
                EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] rows = control.getSelectRows();
                if (rows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u79fb\u9664\u3002", (String)"ExecuteCollectionEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().deleteEntryRows(ENTRYENTITY, rows);
                this.getView().updateView(ENTRYENTITY);
                break;
            }
            case "btntop": {
                this.moveTempRow("1");
                break;
            }
            case "btnup": {
                this.moveTempRow("2");
                break;
            }
            case "btnbottom": {
                this.moveTempRow("3");
                break;
            }
            case "btndown": {
                this.moveTempRow("4");
                break;
            }
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREEVIEWAP, TREEVIEWAP, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREEVIEWAP, TREEVIEWAP, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
        }
    }

    private void moveTempRow(String moveType) {
        EntryGrid tempEntry = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rowIndexs = tempEntry.getSelectRows();
        int rowCount = rowIndexs.length;
        if (rowCount == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u3002", (String)"ExecuteCollectionEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (rowCount > 1 && rowIndexs[0] + rowCount != rowIndexs[rowCount - 1] + 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u6279\u91cf\u79fb\u52a8\u8fde\u7eed\u7684\u884c\u3002", (String)"ExecuteCollectionEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        int allRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        EntryProp prop = (EntryProp)this.getModel().getDataEntityType().getProperty(ENTRYENTITY);
        DynamicObjectCollection inserRow = new DynamicObjectCollection(rows.getDynamicObjectType(), (Object)this.getModel().getDataEntity());
        switch (moveType) {
            case "2": {
                if (rowIndexs[0] != 0) {
                    this.getModel().moveEntryRowsUp(ENTRYENTITY, rowIndexs);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\u3002", (String)"ExecuteCollectionEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "1": {
                if (rowIndexs[0] != 0) {
                    this.getModel().setEntryRowTop(ENTRYENTITY, rowIndexs);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\u3002", (String)"ExecuteCollectionEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                if (rowIndexs[rowCount - 1] != allRowCount - 1) {
                    this.getModel().moveEntryRowsDown(ENTRYENTITY, rowIndexs);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"ExecuteCollectionEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                if (rowIndexs[rowCount - 1] != allRowCount - 1) {
                    this.getModel().setEntryRowBottom(ENTRYENTITY, rowIndexs);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"ExecuteCollectionEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = (Long)formShowParameter.getCustomParam("modelId");
        this.getModel().setValue(MODEL_KEY, (Object)modelId);
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        this.getModel().setValue("modelname", (Object)model.getString("name"));
        this.setExecuteWayVisible();
        this.initTree();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"executeplan"});
    }

    private void initTree() {
        DynamicObjectCollection queryDataRecord = DataCollectionService.getQueryDataRecord((Long)this.getModelId());
        TreeNode root = new TreeNode();
        root.setIsOpened(true);
        root.setText(ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf", (String)"ExecuteCollectionEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setId("0");
        ArrayList<TreeNode> children = root.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>();
            root.setChildren(children);
        }
        if (queryDataRecord.size() > 0) {
            this.initApplyTree(queryDataRecord, root, children);
            DynamicObjectCollection project = DataCollectionService.getQueryCollectionProject((Long)this.getModelId());
            this.getPageCache().put("applyList", SerializationUtils.serializeToBase64((Object)project));
            for (DynamicObject dynamicObject : project) {
                String apprecord = dynamicObject.getString("apprecord");
                TreeNode treeNode = root.getTreeNode(apprecord, 10);
                if (treeNode == null) continue;
                ArrayList<TreeNode> nodeChildren = treeNode.getChildren();
                if (nodeChildren == null) {
                    nodeChildren = new ArrayList<TreeNode>(16);
                    treeNode.setChildren(nodeChildren);
                }
                TreeNode treeNode1 = new TreeNode();
                treeNode1.setId(dynamicObject.getString("id"));
                treeNode1.setText(dynamicObject.getString("name"));
                treeNode1.setParentid(dynamicObject.getString("apprecord"));
                nodeChildren.add(treeNode1);
            }
        }
        EpmTreeUtils.spreadAllNode((TreeNode)root);
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TREEVIEWAP, TREEVIEWAP));
        this.getPageCache().put(TREEVIEWAP, SerializationUtils.toJsonString((Object)root));
        TreeView control = (TreeView)this.getControl(TREEVIEWAP);
        control.deleteAllNodes();
        control.addNode(root);
        control.setRootVisible(false);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
    }

    private void initApplyTree(DynamicObjectCollection queryDataRecord, TreeNode root, List<TreeNode> children) {
        for (DynamicObject dynamicObject : queryDataRecord) {
            TreeNode applyTreeNode;
            String cloudnumber = dynamicObject.getString("cloudnumber");
            if (root.getTreeNode(cloudnumber, 10) == null) {
                TreeNode cloudTreeNode = new TreeNode();
                cloudTreeNode.setId(cloudnumber);
                cloudTreeNode.setText(dynamicObject.getString("cloudname"));
                cloudTreeNode.setParentid("0");
                cloudTreeNode.setIsOpened(true);
                ArrayList<TreeNode> children1 = cloudTreeNode.getChildren();
                if (children1 == null) {
                    children1 = new ArrayList<TreeNode>();
                    cloudTreeNode.setChildren(children1);
                    children.add(cloudTreeNode);
                }
                applyTreeNode = new TreeNode();
                applyTreeNode.setId(dynamicObject.getString("id"));
                applyTreeNode.setText(dynamicObject.getString("appname"));
                applyTreeNode.setParentid(cloudnumber);
                children1.add(applyTreeNode);
                continue;
            }
            TreeNode treeNode = root.getTreeNode(cloudnumber, 10);
            List nodeChildren = treeNode.getChildren();
            applyTreeNode = new TreeNode();
            applyTreeNode.setId(dynamicObject.getString("id"));
            applyTreeNode.setText(dynamicObject.getString("appname"));
            applyTreeNode.setParentid(treeNode.getId());
            nodeChildren.add(applyTreeNode);
        }
    }

    private List<String> getTreeNodeFocusNode() {
        TreeView control = (TreeView)this.getControl(TREEVIEWAP);
        return control.getTreeState().getSelectedNodeId();
    }

    public void afterLoadData(EventObject e) {
        DynamicObject value = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        this.getModel().setValue("modelname", (Object)value.getString("name"));
        this.initTree();
        this.setExecuteWayVisible();
        this.setEntrtyEcho();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        this.getPageCache().put("modify", "1");
    }

    private void setEntrtyEcho() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dynamicObject : entity) {
            DynamicObject project = (DynamicObject)dynamicObject.get("project");
            dynamicObject.set("proname", (Object)project.getString("name"));
            dynamicObject.set("pronumber", (Object)project.getString("number"));
            boolean status = project.getBoolean("status");
            if (status) {
                dynamicObject.set(COLSTATUS, (Object)ResManager.loadKDString((String)"\u542f\u7528", (String)"ExecuteCollectionEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            dynamicObject.set(COLSTATUS, (Object)ResManager.loadKDString((String)"\u7981\u7528", (String)"ExecuteCollectionEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String number;
        DynamicObject executeProject;
        String modify;
        super.afterDoOperation(afterDoOperationEventArgs);
        String executeplan = (String)this.getModel().getValue("executeplan");
        if ("timerexecute".equals(executeplan) && StringUtils.isNotEmpty((String)(modify = this.getPageCache().get("modify"))) && (executeProject = DataCollectionService.getQueryExecuteProject((String)(number = (String)this.getModel().getValue("number")))) != null) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.afterDeleteJob(executeProject.getString("jobid"));
            scheduleManager.afterDeleteSchedule(executeProject.getString("scheduleid"));
            executeProject.set("jobid", null);
            executeProject.set("scheduleid", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{executeProject});
        }
    }

    public void afterBindData(EventObject ent) {
        super.afterBindData(ent);
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isNotEmpty((String)number)) {
            this.getPageCache().put("status", "modify");
            boolean status = (Boolean)this.getModel().getValue("status");
            if (status) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            }
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"executeplan"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operation = ((FormOperate)args.getSource()).getOperateKey())) {
            String number = this.checkNumberRule();
            this.checkNumber(number);
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (StringUtils.isEmpty((String)name.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bed\u8a00\u73af\u5883\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u540d\u79f0\u4fe1\u606f\u3002", (String)"ReportSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.checkEnddate()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u65e9\u4e8e\u6216\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"ExecuteCollectionEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (entity == null || entity.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u65b9\u6848\u3002", (String)"ExecuteCollectionEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String executeplan = (String)this.getModel().getValue("executeplan");
            this.executeplan(executeplan);
        }
    }

    private boolean checkEnddate() {
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        return enddate.before(startdate);
    }

    private void checkNumber(String number) {
        String status = this.getPageCache().get("status");
        if (StringUtils.isEmpty((String)status) || !StringUtils.equals((String)status, (String)"modify")) {
            QFilter qf = new QFilter("number", "=", (Object)number);
            qf.and(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
            boolean exists = QueryServiceHelper.exists((String)"eb_collectionexecute", (QFilter[])qf.toArray());
            if (exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\u3002", (String)"ExecuteCollectionEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("status", "modify");
        }
    }

    private String checkNumberRule() {
        this.getModel().updateCache();
        String number = (String)this.getModel().getValue("number");
        String checkNumber = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotEmpty((String)checkNumber)) {
            throw new KDBizException(checkNumber);
        }
        return number;
    }

    private void executeplan(String executeplan) {
        if ("timerexecute".equals(executeplan)) {
            boolean lastdate = (Boolean)this.getModel().getValue("lastdate");
            boolean settleddate = (Boolean)this.getModel().getValue("settleddate");
            if (lastdate && !settleddate) {
                Integer timefield = (Integer)this.getModel().getValue("timefield");
                if (timefield == -1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u6708\u6700\u540e\u4e00\u5929\u6267\u884c\u65f6\u95f4\u672a\u586b\u5199\u3002", (String)"ExecuteCollectionEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (!lastdate && settleddate) {
                String effday = (String)this.getModel().getValue("effday");
                String expday = (String)this.getModel().getValue("expday");
                Integer datetimefield = (Integer)this.getModel().getValue("datetimefield");
                if (StringUtils.isEmpty((String)effday) || StringUtils.isEmpty((String)expday) || datetimefield == -1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u6708\u56fa\u5b9a\u65f6\u95f4\u6267\u884c\u65f6\u95f4\u672a\u586b\u5199\u3002", (String)"ExecuteCollectionEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (!lastdate) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u65f6\u6267\u884c\u7684\u6267\u884c\u9891\u6b21\u672a\u9009\u62e9\u3002", (String)"ExecuteCollectionEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getModel().setValue("timefield", (Object)0);
            this.getModel().setValue("effday", null);
            this.getModel().setValue("expday", null);
            this.getModel().setValue("datetimefield", (Object)0);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "executeplan": {
                this.setExecuteWayVisible();
                break;
            }
            case "lastdate": 
            case "settleddate": {
                boolean value = (Boolean)this.getModel().getValue(propName);
                if (!value) break;
                this.getModel().setValue("lastdate".equals(propName) ? "settleddate" : "lastdate", (Object)false);
                break;
            }
            case "remind": {
                DynamicObjectCollection sup;
                boolean remind = (Boolean)this.getModel().getValue("remind");
                if (!remind || (sup = (DynamicObjectCollection)this.getModel().getValue(SUPERVISORS_KEY)).size() != 0) break;
                this.getModel().setValue("remind", (Object)false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u7763\u4eba\u3002", (String)"ExecuteCollectionEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "supervisors": {
                DynamicObjectCollection supervisors = (DynamicObjectCollection)this.getModel().getValue(SUPERVISORS_KEY);
                if (supervisors.size() != 0) break;
                this.getModel().setValue("remind", (Object)false);
                this.getModel().setValue(SUPERVISORS_KEY, null);
                break;
            }
        }
    }

    private void setExecuteWayVisible() {
        String executeplan = (String)this.getModel().getValue("executeplan");
        if ("timerexecute".equals(executeplan)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap5"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap5"});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelObj != null) {
            return modelObj.getLong("id");
        }
        return 0L;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }
}

