/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.execute;

import java.lang.constant.Constable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.DispatchService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataGather.service.DataCollectionService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.UserSelectUtil;

public class ExecuteCollectionListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ExecuteCollectionListPlugin.class);
    private static final String MODEL = "model";
    private static final String BILLLIST_KEY = "billlistap";

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("eb_collectionconfig");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long model = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNull((Long)model)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExecuteCollectionListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL, (Object)model);
        this.refrushBillList();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BillList control = (BillList)this.getControl(BILLLIST_KEY);
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void refrushBillList() {
        BillList billList = (BillList)this.getControl(BILLLIST_KEY);
        billList.clearSelection();
        billList.refresh();
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "delete".equals(operation = ((FormOperate)args.getSource()).getOperateKey())) {
            this.deleteCheckout();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_invoke": 
            case "btn_stop": {
                this.itemClickInvoke(key);
                break;
            }
            case "execute": {
                this.itemClickExecute();
                break;
            }
            case "bar_delete": {
                this.deleteCheckout();
                break;
            }
            case "executelog": {
                this.itemClickExecuteLog();
                break;
            }
        }
    }

    private void itemClickExecuteLog() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setPageId(lsp.getBillFormId() + this.getModelId() + "_" + this.getView().getPageId());
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setStatus(OperationStatus.VIEW);
        lsp.setBillFormId("eb_datagatherdata");
        lsp.setCustomParam("modelId", (Object)String.valueOf(this.getModelId()));
        lsp.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter(MODEL, "=", (Object)this.getModelId())));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void itemClickExecute() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u3002", (String)"ExecuteCollectionListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object pk = selectedRows.getPrimaryKeyValues()[0];
        QFBuilder qfBuilder = new QFBuilder("id", "=", pk);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"eb_collectionexecute", (String)"status,startdate,enddate", (QFilter[])qfBuilder.toArray());
        if (queryOne == null) {
            return;
        }
        if (!queryOne.getBoolean("status")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u65b9\u6848\u540e\u6267\u884c\u3002", (String)"ExecuteCollectionListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Date startdate = queryOne.getDate("startdate");
        Date enddate = queryOne.getDate("enddate");
        Date now = TimeServiceHelper.now();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = null;
        try {
            parse = sim.parse(sim.format(now));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        if (parse != null && (DateTimeUtils.dayBefore((Date)parse, (Date)startdate) || DateTimeUtils.dayBefore((Date)enddate, (Date)parse))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u5728\u65b9\u6848\u751f\u6548\u671f\u95f4\u5185\u3002", (String)"ExecuteCollectionListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List executeProjectByEntity = DataCollectionService.getExecuteProjectByEntity((Long)this.getModelId(), (Long)((Long)pk));
        if (executeProjectByEntity.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u6267\u884c\u7684\u914d\u7f6e\u65b9\u6848\uff0c\u8bf7\u542f\u7528\u91c7\u96c6\u914d\u7f6e\u65b9\u6848\u6216\u68c0\u67e5\u76f8\u5173\u6743\u9650\u3002", (String)"ExecuteCollectionListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFormCollection(pk);
    }

    private void openFormCollection(Object pk) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("eb_collectionexecutedata");
        fsp.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u91c7\u96c6", (String)"ExecuteCollectionListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam("executeId", (Object)String.valueOf(pk));
        fsp.setCustomParam("modelId", (Object)String.valueOf(this.getModelId()));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "message"));
        this.getView().showForm(fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("message".equals(actionId) && StringUtils.isNotEmpty((String)(returnData = (String)evt.getReturnData()))) {
            if (StringUtils.equals((String)returnData, (String)"0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"ExecuteCollectionListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ExecuteCollectionListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void deleteCheckout() {
        DynamicObject[] load = this.getDynamicStatus();
        ArrayList<Long> deleteIds = new ArrayList<Long>(16);
        ArrayList<Long> cannotDelete = new ArrayList<Long>(16);
        if (load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                boolean status = dynamicObject.getBoolean("status");
                Long id = dynamicObject.getLong("id");
                if (status) {
                    cannotDelete.add(id);
                    continue;
                }
                deleteIds.add(id);
            }
            if (deleteIds.size() > 0 && cannotDelete.size() > 0) {
                this.getPageCache().put("message", ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff0c\u5df2\u8df3\u8fc7\u5df2\u542f\u7528\u65e0\u6cd5\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"ExecuteCollectionListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getPageCache().put("deleteIds", SerializationUtils.serializeToBase64(deleteIds));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664?", (String)"ExecuteCollectionListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteProject", (IFormPlugin)this));
            } else if (deleteIds.size() == 0 && cannotDelete.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ExecuteCollectionListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (deleteIds.size() > 0) {
                this.getPageCache().put("message", ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExecuteCollectionListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getPageCache().put("deleteIds", SerializationUtils.serializeToBase64(deleteIds));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664?", (String)"ExecuteCollectionListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteProject", (IFormPlugin)this));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u3002", (String)"ExecuteCollectionListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject[] getDynamicStatus() {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        ArrayList<Long> selectId = new ArrayList<Long>(primaryKeyValues.length);
        for (Object value : primaryKeyValues) {
            selectId.add((Long)value);
        }
        QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "in", selectId));
        return BusinessDataServiceHelper.load((String)"eb_collectionexecute", (String)this.getSelectExecuteFilter(), (QFilter[])qfBuilder.toArray());
    }

    private void itemClickInvoke(String key) {
        BillList billList = (BillList)this.getView().getControl(BILLLIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u542f\u7528\u7684\u6570\u636e\u3002", (String)"ExecuteCollectionListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] keyValues = selectedRows.getPrimaryKeyValues();
        ArrayList<Long> objects = new ArrayList<Long>(keyValues.length);
        for (Object keyValue : keyValues) {
            objects.add((Long)keyValue);
        }
        DynamicObject[] load = DataCollectionService.getQueryExecuteProject(objects);
        if (load.length == 0) {
            return;
        }
        ArrayList<Long> success = new ArrayList<Long>(16);
        ArrayList<Long> invokes = new ArrayList<Long>(16);
        ArrayList<Long> expiryDate = new ArrayList<Long>(16);
        if ("btn_invoke".equals(key)) {
            for (DynamicObject dynamicObject : load) {
                long id = dynamicObject.getLong("id");
                boolean status = dynamicObject.getBoolean("status");
                if (status) {
                    invokes.add(id);
                    continue;
                }
                Date startdate = dynamicObject.getDate("startdate");
                Date enddate = dynamicObject.getDate("enddate");
                Date now = TimeServiceHelper.now();
                SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
                Date parse = null;
                try {
                    parse = sim.parse(sim.format(now));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new KDBizException(e.getMessage());
                }
                if (parse == null || !DateTimeUtils.dayBefore((Date)startdate, (Date)parse) && !DateTimeUtils.dayEquals((Date)startdate, (Date)parse)) continue;
                if (DateTimeUtils.dayBefore((Date)parse, (Date)enddate) || DateTimeUtils.dayEquals((Date)parse, (Date)enddate)) {
                    dynamicObject.set("status", (Object)true);
                    String executeplan = dynamicObject.getString("executeplan");
                    if ("timerexecute".equals(executeplan)) {
                        this.createSchedule(id, dynamicObject);
                    }
                    success.add(id);
                    continue;
                }
                expiryDate.add(id);
            }
        } else {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            for (DynamicObject dynamicObject : load) {
                long id = dynamicObject.getLong("id");
                boolean status = dynamicObject.getBoolean("status");
                if (!status) {
                    invokes.add(id);
                    continue;
                }
                dynamicObject.set("status", (Object)false);
                String jobid = dynamicObject.getString("jobid");
                String scheduleid = dynamicObject.getString("scheduleid");
                if (StringUtils.isNotEmpty((String)jobid) && StringUtils.isNotEmpty((String)scheduleid)) {
                    scheduleManager.afterDeleteJob(jobid);
                    scheduleManager.afterDeleteSchedule(scheduleid);
                }
                success.add(id);
            }
        }
        SaveServiceHelper.save((DynamicObject[])load);
        if ("btn_invoke".equals(key)) {
            if ((invokes.size() > 0 || expiryDate.size() > 0) && success.size() > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\uff0c\u8df3\u8fc7\u5df2\u542f\u7528\u6216\u5f53\u524d\u65e5\u671f\u4e0d\u5728\u65b9\u6848\u751f\u6548\u671f\u95f4\u5185\u3002", (String)"ExecuteCollectionListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("enable", new MultiLangEnumBridge("\u542f\u7528", "OffsetRuleListPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u91c7\u96c6\u6267\u884c\u65b9\u6848\u542f\u7528\u6210\u529f", "AbstractMultiReportPlugin_137", "epm-eb-budget"));
            } else if (invokes.size() > 0 && success.size() == 0 && expiryDate.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u542f\u7528\u3002", (String)"ExecuteCollectionListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (expiryDate.size() > 0 && (success.size() == 0 || invokes.size() == 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u5728\u65b9\u6848\u751f\u6548\u671f\u95f4\u5185\u3002", (String)"ExecuteCollectionListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if ((invokes.size() == 0 || expiryDate.size() == 0) && success.size() > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ExecuteCollectionListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("enable", new MultiLangEnumBridge("\u542f\u7528", "OffsetRuleListPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u91c7\u96c6\u6267\u884c\u65b9\u6848\u542f\u7528\u6210\u529f", "AbstractMultiReportPlugin_137", "epm-eb-budget"));
            }
        } else if (invokes.size() > 0 && success.size() > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\uff0c\u8df3\u8fc7\u5df2\u7981\u7528\u65b9\u6848\u3002", (String)"ExecuteCollectionListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528", "OffsetRuleListPlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u91c7\u96c6\u6267\u884c\u65b9\u6848\u7981\u7528\u6210\u529f", "AbstractMultiReportPlugin_144", "epm-eb-budget"));
        } else if (invokes.size() == 0 && success.size() > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ExecuteCollectionListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528", "OffsetRuleListPlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u91c7\u96c6\u6267\u884c\u65b9\u6848\u7981\u7528\u6210\u529f", "AbstractMultiReportPlugin_144", "epm-eb-budget"));
        } else if (invokes.size() > 0 && success.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u7981\u7528\u3002", (String)"ExecuteCollectionListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        invokes.clear();
        success.clear();
        billList.clearSelection();
        billList.refresh();
    }

    private String getSelectExecuteFilter() {
        return "id,status,executeplan,startdate,enddate,supervisors,remind,lastdate,timefield,settleddate,effday,expday,datetimefield,jobid,scheduleid";
    }

    private void createSchedule(Long id, DynamicObject load) {
        String jobId = this.createJob(load, id);
        String plan = this.createPlan(jobId, load);
        load.set("jobid", (Object)jobId);
        load.set("scheduleid", (Object)plan);
    }

    private String createJob(DynamicObject load, Long id) {
        HashMap<String, Constable> params = new HashMap<String, Constable>(16);
        params.put("executeId", id);
        params.put("supervisors", (Constable)((DynamicObjectCollection)load.get("supervisors")));
        params.put("remind", Boolean.valueOf(load.getBoolean("remind")));
        params.put("senderId", UserUtils.getUserId());
        params.put("modelId", this.getModelId());
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(ResManager.loadResFormat((String)"\u6267\u884c\u6570\u636e\u91c7\u96c6_%1", (String)"ExecuteCollectionListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()}));
        jobInfo.setNumber(DBServiceHelper.genStringId());
        String taskClassName = "kd.epm.eb.formplugin.dataAcquisition.task.ExecuteCollectionTask";
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setParams(params);
        jobInfo.setRunByOrgId(0L);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setRunConcurrently(true);
        jobInfo.setAppId("eb");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"eb");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return String.valueOf(obj);
    }

    private String createPlan(String jobId, DynamicObject load) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber(DBServiceHelper.genStringId());
        planInfo.setName(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u91c7\u96c6", (String)"ExecuteCollectionListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(load.getDate("startdate"));
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(load.getDate("enddate"));
        boolean lastdate = load.getBoolean("lastdate");
        boolean settleddate = load.getBoolean("settleddate");
        if (lastdate) {
            Integer timefield = load.getInt("timefield");
            Map time = DataCollectionService.timeTransformDate((Integer)timefield);
            startTimeCalendar.set(10, Integer.parseInt((String)time.get("hour")));
            startTimeCalendar.set(12, Integer.parseInt((String)time.get("minute")));
            startTimeCalendar.set(13, Integer.parseInt((String)time.get("second")));
            planInfo.setCronExpression((String)time.get("second") + " " + (String)time.get("minute") + " " + (String)time.get("hour") + " L * ? *");
        } else if (settleddate) {
            int effday = Integer.parseInt(load.getString("effday"));
            int expday = Integer.parseInt(load.getString("expday"));
            int max = Math.max(effday, expday);
            int min = Math.min(effday, expday);
            StringBuilder str = new StringBuilder();
            for (int i = min; i <= max; ++i) {
                if (StringUtils.isNotEmpty((String)str.toString())) {
                    str.append(",").append(i);
                    continue;
                }
                str.append(i);
            }
            Integer datetimefield = load.getInt("datetimefield");
            Map time = DataCollectionService.timeTransformDate((Integer)datetimefield);
            startTimeCalendar.set(10, Integer.parseInt((String)time.get("hour")));
            startTimeCalendar.set(12, Integer.parseInt((String)time.get("minute")));
            startTimeCalendar.set(13, Integer.parseInt((String)time.get("second")));
            int days = startTimeCalendar.get(5);
            if (days > max) {
                startTimeCalendar.set(2, startTimeCalendar.get(2) + 1);
                startTimeCalendar.set(5, min);
            }
            if (days < min) {
                startTimeCalendar.set(5, min);
            }
            startTimeCalendar.set(5, min);
            String dateStr = str.toString();
            planInfo.setCronExpression((String)time.get("second") + " " + (String)time.get("minute") + " " + (String)time.get("hour") + " " + dateStr + " * ? *");
        }
        planInfo.setStartTime(startTimeCalendar);
        planInfo.setEndTime(endTime);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"eb");
        Object createPlan = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
        return String.valueOf(createPlan);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        int statusVal;
        BillShowParameter billShowParameter = e.getParameter();
        if (billShowParameter instanceof BaseShowParameter && (statusVal = billShowParameter.getBillStatusValue().intValue()) == BillOperationStatus.ADDNEW.getValue()) {
            billShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            DynamicObject modelId = (DynamicObject)this.getModel().getValue(MODEL);
            if (modelId != null) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId.getLong("id"));
            }
            this.refrushBillList();
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter(MODEL, "=", (Object)this.getModelId()));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && "deleteProject".equals(callBackId)) {
            this.delete();
        }
    }

    private void delete() {
        String deleteIds = this.getPageCache().get("deleteIds");
        if (StringUtils.isEmpty((String)deleteIds)) {
            return;
        }
        try {
            List delete = (List)SerializationUtils.deSerializeFromBase64((String)deleteIds);
            if (delete.size() > 0) {
                DeleteServiceHelper.delete((String)"eb_collectionexecute", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)delete)});
                this.getView().showSuccessNotification(this.getPageCache().get("message"));
                log.info("executeCollention_delete" + delete);
            }
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "AbstractMultiReportPlugin_60", "epm-eb-budget"), new MultiLangEnumBridge("\u91c7\u96c6\u6267\u884c\u65b9\u6848\u5220\u9664\u6210\u529f", "AbstractMultiReportPlugin_152", "epm-eb-budget"));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"ExecuteCollectionListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.refrushBillList();
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (key.equals(MODEL)) {
            PluginUtils.setModelFilter(e, this.getView());
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)e);
        }
    }
}

