/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.execute;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.service.DataCollectionService;
import kd.epm.eb.business.dataGather.service.DataGatherRunService;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.datagather.GlobalVar;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.lang.StringUtils;

public class ExecuteDataCollectionPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String BTN_SAVE = "btn_save";
    private static final String ENTITY = "entity";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String BUDGETPERIOD = "budgetperiod";
    private static final String SPLIT_SIZE = "splitsize";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE});
        this.addF7SelectListener(ENTITY, YEAR, PERIOD, BUDGETPERIOD);
    }

    private void addF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List<Long> executeProjectByEntity = this.getExecuteEntryId();
        this.getModel().setValue(ENTITY, (Object)executeProjectByEntity.toArray());
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        qfBuilder.add(new QFilter("isleaf", "=", (Object)true));
        if (ApplicationTypeEnum.BGM != ModelUtil.queryApp((IFormView)this.getView())) {
            this.setYearAndPeriod(qfBuilder);
        } else {
            this.setBudgetPeriod(qfBuilder);
        }
    }

    private void setBudgetPeriod(QFBuilder qfBuilder) {
        Calendar instance = Calendar.getInstance();
        String year = String.valueOf(instance.get(1));
        year = String.join((CharSequence)"", "FY", year);
        String month = String.valueOf(instance.get(2) + 1);
        month = month.length() == 1 ? String.join((CharSequence)"", "M", "0", month) : String.join((CharSequence)"", "M", month);
        String dimenMember = String.join((CharSequence)".", year, month);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"id,number,name", (QFilter[])qfBuilder.toArray());
        for (DynamicObject object : collection) {
            String number = object.getString("number");
            if (!dimenMember.equals(number)) continue;
            this.getModel().setValue(BUDGETPERIOD, (Object)object.getLong("id"));
        }
    }

    private void setYearAndPeriod(QFBuilder qfBuilder) {
        qfBuilder.add(new QFilter("level", "=", (Object)3));
        DynamicObjectCollection query_year = QueryServiceHelper.query((String)"epm_yearmembertree", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
        for (DynamicObject object : query_year) {
            SimpleDateFormat sim;
            String format;
            String substring;
            String number = object.getString("number");
            if (!number.startsWith("FY") || !(substring = number.substring(2, 6)).equals(format = (sim = new SimpleDateFormat("yyyy")).format(new Date()))) continue;
            this.getModel().setValue(YEAR, (Object)object.getLong("id"));
        }
        QFBuilder qfPeriod = new QFBuilder("model", "=", (Object)this.getModelId());
        qfPeriod.add(new QFilter("isleaf", "=", (Object)true));
        DynamicObjectCollection query_period = QueryServiceHelper.query((String)"epm_periodmembertree", (String)"id,number,name,effmonth,effday,expmonth,expday", (QFilter[])qfPeriod.toArray());
        Calendar instance = Calendar.getInstance();
        int month = instance.get(2) + 1;
        for (DynamicObject object : query_period) {
            int effmonth = object.getInt("effmonth");
            if (effmonth != month) continue;
            this.getModel().setValue(PERIOD, (Object)object.getLong("id"));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propKey = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (propKey) {
            case "year": {
                filterParameter.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
                filterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)true));
                filterParameter.getQFilters().add(new QFilter("level", "=", (Object)3));
                break;
            }
            case "budgetperiod": 
            case "period": {
                filterParameter.getQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
                filterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)true));
                break;
            }
            case "entity": {
                List<Long> executeProjectByEntity = this.getExecuteEntryId();
                filterParameter.getQFilters().add(new QFilter("id", "in", executeProjectByEntity));
                break;
            }
        }
    }

    private int getSqlBatch() {
        String sqlBatch;
        String string = sqlBatch = this.getModel().getValue("sqlbatch") == null ? "8000" : this.getModel().getValue("sqlbatch").toString();
        if (StringUtils.isNumeric((String)sqlBatch)) {
            return Integer.parseInt(sqlBatch);
        }
        return 8000;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (BTN_SAVE.equals(key)) {
            String number;
            DynamicObject budgetPeriod;
            DynamicObject period;
            DynamicObject year = (DynamicObject)this.getModel().getValue(YEAR);
            boolean checkParam = this.checkParam(year, period = (DynamicObject)this.getModel().getValue(PERIOD), budgetPeriod = (DynamicObject)this.getModel().getValue(BUDGETPERIOD));
            if (!checkParam) {
                return;
            }
            Integer splitSize = (Integer)this.getModel().getValue(SPLIT_SIZE);
            if (splitSize != null && splitSize > 0) {
                GlobalVar.splitSize.set(splitSize);
            }
            if (ApplicationTypeEnum.BGM != ModelUtil.queryApp((IFormView)this.getView()) && ((number = period.getString("number")).startsWith("Q_") || number.startsWith("HF_"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6267\u884c\uff0c\u8bf7\u9009\u62e9\u671f\u95f4\u7ef4\u5ea6\u7684\u660e\u7ec6\u6210\u5458\u3002", (String)"ExecuteCollectionTask_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return;
            }
            DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue(ENTITY);
            HashSet<String> org = new HashSet<String>(entry.size());
            entry.forEach(f -> org.add(((DynamicObject)f.get("fbasedataid")).getString("number")));
            DataGatherHandCallParam param = this.getDataGatherHandCallParam(org, year, period, budgetPeriod);
            String executeId = (String)this.getView().getFormShowParameter().getCustomParam("executeId");
            ArrayList<Long> executes = new ArrayList<Long>(5);
            executes.add(Long.parseLong(executeId));
            GlobalVar.fetch.remove();
            DataGatherRunService.getInstance().doDataGatherRun(this.getModelId(), executes, param);
            QFBuilder qfBuilder = new QFBuilder(new QFilter("id", "=", (Object)Long.parseLong(executeId)));
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"eb_collectionexecute", (String)"remind,supervisors,modifier", (QFilter[])qfBuilder.toArray());
            boolean remind = load.getBoolean("remind");
            if (remind) {
                DynamicObjectCollection supervisors = (DynamicObjectCollection)load.get("supervisors");
                this.messqge(supervisors);
            }
            this.writeLog("execute", new MultiLangEnumBridge("\u6267\u884c", "EbShareSchemeExecutePlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6267\u884c\u6570\u636e\u91c7\u96c6", "ExecuteCollectionListPlugin_3", "epm-eb-formplugin"));
            this.getView().returnDataToParent((Object)"1");
            this.getView().close();
            this.writeLog("execute", new MultiLangEnumBridge("\u6267\u884c", "EbShareSchemeExecutePlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u91c7\u96c6\u96c6\u6210\u65b9\u6848\u6267\u884c\u6210\u529f", "AbstractMultiReportPlugin_153", "epm-eb-budget"));
        }
    }

    private boolean checkParam(DynamicObject year, DynamicObject period, DynamicObject budgetPeriod) {
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue(ENTITY);
        if (this.checkDynamic(entry == null || entry.size() == 0, ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExecuteDataCollectionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]))) {
            return false;
        }
        ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp((IFormView)this.getView());
        switch (applicationTypeEnum) {
            case BGM: 
            case BGMD: {
                if (!this.checkDynamic(budgetPeriod == null, ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExecuteDataCollectionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]))) break;
                return false;
            }
            default: {
                if (this.checkDynamic(year == null, ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExecuteDataCollectionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]))) {
                    return false;
                }
                if (!this.checkDynamic(period == null, ResManager.loadKDString((String)"\u9884\u7b97\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExecuteDataCollectionPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]))) break;
                return false;
            }
        }
        return true;
    }

    private boolean checkDynamic(boolean flag, String msg) {
        if (flag) {
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    private DataGatherHandCallParam getDataGatherHandCallParam(Set<String> org, DynamicObject year, DynamicObject period, DynamicObject budgetPeriod) {
        DataGatherHandCallParam param = new DataGatherHandCallParam();
        param.setOrgNums(org);
        param.setSqlBatch(this.getSqlBatch());
        ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp((IFormView)this.getView());
        switch (applicationTypeEnum) {
            case BGM: 
            case BGMD: {
                param.setPeriodNum(budgetPeriod.getString("number"));
                param.setAppNum(ApplicationTypeEnum.BGM.getAppnum());
                break;
            }
            default: {
                param.setYearNum(year.getString("number"));
                param.setPeriodNum(period.getString("number"));
                param.setAppNum(ApplicationTypeEnum.EB.getAppnum());
            }
        }
        return param;
    }

    private void messqge(DynamicObjectCollection supervisors) {
        ArrayList receiver = new ArrayList(16);
        if (supervisors.size() > 0) {
            supervisors.forEach(e -> receiver.add(e.getLong("fbasedataid_id")));
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u91c7\u96c6", (String)"ExecuteCollectionTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        messageInfo.setContent(ResManager.loadKDString((String)"\u6709\u4e00\u4e2a\u6b63\u5728\u6267\u884c\u7684\u6570\u636e\u91c7\u96c6\uff0c\u8bf7\u67e5\u770b\u3002", (String)"ExecuteCollectionTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        messageInfo.setUserIds(receiver);
        messageInfo.setSenderId(UserUtils.getUserId());
        messageInfo.setType("message");
        messageInfo.setEntityNumber("eb_collectionexecute");
        messageInfo.setNotifyType("sms");
        messageInfo.setPubaccNumber("systempubacc");
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private List<Long> getExecuteEntryId() {
        String executeId = (String)this.getView().getFormShowParameter().getCustomParam("executeId");
        return DataCollectionService.getExecuteProjectByEntity((Long)this.getModelId(), (Long)Long.parseLong(executeId));
    }

    @Override
    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        return Long.valueOf(modelId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ApplicationTypeEnum.BGM == ModelUtil.queryApp((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUDGETPERIOD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PERIOD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{YEAR});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BUDGETPERIOD});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PERIOD});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{YEAR});
        }
    }
}

