/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.execute;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import kd.epm.eb.formplugin.dataAcquisition.execute.ExecuteDataRecordHead;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ExecuteDataRecordPlugin
extends AbstractListPlugin {
    public void packageData(PackageDataEvent e) {
        BaseDataColumnDesc desc;
        String key;
        Object formatValue = e.getFormatValue();
        if (formatValue != null) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof BaseDataColumnDesc && "excutescheme.name".equals(key = (desc = (BaseDataColumnDesc)source).getKey())) {
            e.setFormatValue((Object)ResManager.loadKDString((String)"\u6267\u884c\u65b9\u6848\u5df2\u5220\u9664\u3002", (String)"ExecuteDataRecordPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
        args.setCancel(Boolean.TRUE.booleanValue());
        BillListHyperLinkClickEvent hy = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long currentRow = (Long)hy.getCurrentRow().getPrimaryKeyValue();
        this.exportExcel(currentRow);
    }

    private void exportExcel(Long currentRow) {
        String selectFields = "model.name,model.shownumber,excutescheme.name,excutescheme.number,collectscheme.name,collectscheme.number,excutedate,excuter.name,glperiod.name,glperiod.number,asstinfo,glaccount.name,glaccount.number,glaccount.dc,debitfor,creditfor,ebdim,glorg.name,glorg.number";
        QFBuilder qb = new QFBuilder("id", "=", (Object)currentRow);
        DynamicObject[] list = BusinessDataServiceHelper.load((String)"eb_datagatherdata", (String)selectFields, (QFilter[])qb.toArrays());
        if (list != null && list.length > 0) {
            ArrayList<String[]> dataList = new ArrayList<String[]>(10);
            DynamicObject dynamicObject = list[0];
            DynamicObjectCollection entryentity = (DynamicObjectCollection)dynamicObject.get("entryentity");
            for (DynamicObject row : entryentity) {
                String modelName = dynamicObject.getString("model.name");
                String modelNumber = dynamicObject.getString("model.shownumber");
                String excuteschemeName = dynamicObject.getString("excutescheme.name");
                String excuteschemeNumber = dynamicObject.getString("excutescheme.number");
                String collectschemeName = row.getString("collectscheme.name");
                String collectschemeNumber = row.getString("collectscheme.number");
                String glperiodName = row.getString("glperiod.name");
                String glperiodNumber = row.getString("glperiod.number");
                String glorgName = row.getString("glorg.name");
                String glorgNumber = row.getString("glorg.number");
                String asstinfo = row.getString("asstinfo");
                String glaccountName = row.getString("glaccount.name");
                String glaccountNumber = row.getString("glaccount.number");
                String yeardebitlocal = row.getBigDecimal("debitfor").setScale(2, 4).toPlainString();
                String yearcreditlocal = row.getBigDecimal("creditfor").setScale(2, 4).toPlainString();
                String ebdim = row.getString("ebdim");
                SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String excutedate = sim.format(dynamicObject.getDate("excutedate"));
                String excuterName = dynamicObject.getString("excuter.name");
                String[] data = new String[]{modelName, modelNumber, excuteschemeName, excuteschemeNumber, collectschemeName, collectschemeNumber, glperiodName, glperiodNumber, glorgName, glorgNumber, asstinfo, glaccountName, glaccountNumber, yeardebitlocal, yearcreditlocal, ebdim, excutedate, excuterName};
                dataList.add(data);
            }
            String tempPath = "datacollection/middletable.xlsx";
            String filename = ResManager.loadResFormat((String)"\u6570\u636e\u91c7\u96c6\u4e2d\u95f4\u8868%1", (String)"ExecuteDataRecordPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 0, 0, 0);
            String url = ExcelImExportUtils.getInstance().writeWithTemplate(tempPath, filename, Collections.singletonList(new ExecuteDataRecordHead().heads), dataList, sheet);
            if (StringUtils.isNotEmpty((String)url)) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"ExecuteDataRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

