/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.memberMap;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;

public class EbDimMemberMapPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener,
BasedataFuzzySearchListener {
    private static final Set<String> exclude = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Process.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber()});
    private static final String DIMENSION = "dimnumber";
    private static final String DIMENSION_CACHE = "dim_cache";
    private static final String BIZBASEDATA = "businessbasedata";
    private static final String ENTRY_DIMMEMBER = "dimmember";
    private static final String ENTRY_BIZMEMBER = "bizmember";
    private static final String ENTRY_BIZMEMBEREXT = "bizmemberext";
    private static final String BTN_TOOLBAR = "advcontoolbarap";
    private static final String BTN_ADDLINE = "addentry";
    private static final String BTN_DELLINE = "deleteentry";
    private static final String BTN_TBMAIN = "tbmain";
    private static final String BTN_REIGST = "reigst";
    private static final String BASEDATAFIELD = "basedatafield";
    private static final String BASENAME = "basename";
    private static final String SHOWBIZMEMBER = "showbizmember";
    private static final String SHOWDIMMEMBER = "showdimmember";
    private static final String BUSINESSBASEDATAEXT = "businessbasedataext";
    private static final String USEASSISTDATA = "useassistdata";
    private static final String SHOWBIZMEMBEREXT = "showbizmemberext";
    private static final String BIZNUMBEREXT = "biznumberext";
    private static final String MOREBUSSDATA = "morebussdata";
    private static final String USEMOREBUSSDATA = "usemorebussdata";
    private static final String DIM_ENTRY_CLEAR = "dim_clear_line";
    private static final String BIZ_ENTRY_CLEAR = "biz_clear_line";
    private static final String BIZ_ENTRYEXT_CLEAR = "biz_clearext_line";
    public static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    public static final String BOS_ADMINORG_STRUCTURE = "bos_adminorg_structure";
    public static final String YES = "Yes";
    private boolean islevel;
    public static final String DATASET = "dataset";
    public static final String ENTRYENTITY_STRING = "entryentity";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"model"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit showbiz = (TextEdit)this.getControl(SHOWBIZMEMBER);
        showbiz.addClickListener((ClickListener)this);
        TextEdit showbizExt = (TextEdit)this.getControl(SHOWBIZMEMBEREXT);
        showbizExt.addClickListener((ClickListener)this);
        TextEdit showdim = (TextEdit)this.getControl(SHOWDIMMEMBER);
        showdim.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{BTN_TOOLBAR, BTN_TBMAIN});
        BasedataEdit dataSet = (BasedataEdit)this.getControl(DATASET);
        if (dataSet != null) {
            dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void transToBosOrg() {
        String businessStr;
        IDataModel dataModel = this.getModel();
        if (dataModel == null) {
            return;
        }
        Object value = dataModel.getValue(BUSINESSBASEDATAEXT);
        if (value instanceof String && "gl_org".equals(businessStr = (String)value)) {
            this.getPageCache().put("modify", "1");
            dataModel.setValue(BUSINESSBASEDATAEXT, (Object)"bos_org");
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.firstAddPreset();
        this.initBusinessbasedata(BIZBASEDATA);
        this.initBusinessbasedata(MOREBUSSDATA);
        this.initBusinessbasedataExt();
        BaseShowParameter param = (BaseShowParameter)this.getView().getFormShowParameter();
        if (param != null && BillOperationStatus.ADDNEW.getValue() != param.getStatus().getValue()) {
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            if (model != null) {
                this.initDimension(model);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
        if (ApplicationTypeEnum.BGM != ModelUtil.queryApp((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DATASET});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
    }

    public void afterBindData(EventObject e) {
        String number;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new"});
        if (this.getModel().getValue("model") != null) {
            this.initDimension(this.getSelModel());
        }
        if (StringUtils.isNotEmpty((String)(number = (String)this.getModel().getValue("number")))) {
            this.getPageCache().put("status", "modify");
        }
        this.showdata();
        this.setEnable();
        this.showMorebussdata();
        this.showBnussData();
        this.modifyMorebussdata();
    }

    private void modifyMorebussdata() {
        String businessbasedataext;
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY_STRING);
        for (DynamicObject dynamicObject : entity) {
            String value = (String)dynamicObject.get(MOREBUSSDATA);
            if (!"gl_org".equals(value)) continue;
            dynamicObject.set(MOREBUSSDATA, (Object)"bos_org");
        }
        String businessbasedata = (String)this.getModel().getValue(BIZBASEDATA);
        if (StringUtils.isNotEmpty((String)businessbasedata) && "gl_org".equals(businessbasedata)) {
            this.getPageCache().put("modify", "1");
            this.getModel().setValue(BIZBASEDATA, (Object)"bos_org");
        }
        if (StringUtils.isNotEmpty((String)(businessbasedataext = (String)this.getModel().getValue(BUSINESSBASEDATAEXT))) && "gl_org".equals(businessbasedataext)) {
            this.getPageCache().put("modify", "1");
            this.getModel().setValue(BUSINESSBASEDATAEXT, (Object)"bos_org");
        }
        this.getView().updateView(ENTRYENTITY_STRING);
        this.getModel().setDataChanged(false);
    }

    private void showBnussData() {
        if (this.getAssistDataValue(USEMOREBUSSDATA)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BIZBASEDATA});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MOREBUSSDATA});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BIZBASEDATA});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MOREBUSSDATA});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BUSINESSBASEDATAEXT, SHOWBIZMEMBEREXT, BIZNUMBEREXT, MOREBUSSDATA});
        Long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "KEY_MODEL_ID");
        if (modelId != null && modelId != 0L) {
            this.getModel().setValue("model", (Object)modelId);
        }
    }

    private void setEnable() {
        if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.VIEW.getValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", BTN_ADDLINE, BTN_DELLINE});
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String businessbasedata = (String)e.getSourceData().get(BIZBASEDATA);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_registmappingbill", (String)BASENAME, (QFilter[])new QFilter[]{new QFilter(BASEDATAFIELD, "=", (Object)IDUtils.toLong((Object)businessbasedata))});
        this.getModel().setValue("businessbasedataname", (Object)dynamicObject.getString(BASENAME));
        JSONArray entryentityArray = (JSONArray)e.getSourceData().get(ENTRYENTITY_STRING);
        for (int i = 0; i < entryentityArray.size(); ++i) {
            this.getModel().createNewEntryRow(ENTRYENTITY_STRING);
            JSONObject entryentityJason = (JSONObject)entryentityArray.get(i);
            DynamicObject entryentity = this.getModel().getEntryRowEntity(ENTRYENTITY_STRING, i);
            entryentity.set(SHOWBIZMEMBER, (Object)entryentityJason.getString("bizName"));
            entryentity.set(SHOWDIMMEMBER, (Object)entryentityJason.getString("dimName"));
            entryentity.set(ENTRY_BIZMEMBER, (Object)entryentityJason.getString("bizid"));
            entryentity.set(ENTRY_DIMMEMBER, (Object)entryentityJason.getString("dimid"));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        CacheServiceHelper.remove((String)"CONTROL_MAPPING_CACHE1");
    }

    private void initBusinessbasedata(String data) {
        ItemClassTypeEdit itemc = (ItemClassTypeEdit)this.getControl(data);
        ArrayList<ComboItem> com = new ArrayList<ComboItem>(16);
        this.queryBaseDataAndSetItem(com, data);
        itemc.setComboItems(com);
    }

    private void initBusinessbasedataExt() {
        ItemClassTypeEdit itemc = (ItemClassTypeEdit)this.getControl(BUSINESSBASEDATAEXT);
        ArrayList<ComboItem> com = new ArrayList<ComboItem>(16);
        this.queryBaseDataAndSetItem(com, BUSINESSBASEDATAEXT);
        itemc.setComboItems(com);
    }

    private void queryBaseDataAndSetItem(List<ComboItem> com, String key) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_registmappingbill", (String)"basedatafield,basename", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        HashMap map = new HashMap(16);
        query.forEach(m -> map.put(m.getString(BASEDATAFIELD), m.getString(BASENAME)));
        Object value = this.getModel().getValue(BIZBASEDATA);
        for (Map.Entry entry : map.entrySet()) {
            ComboItem comboItem = new ComboItem();
            String basedataDefaultName = (String)entry.getValue();
            String baseId = (String)entry.getKey();
            LocaleString name = this.getLocaleString(basedataDefaultName, baseId);
            comboItem.setCaption(name);
            comboItem.setValue("bos_org".equals(baseId) ? "bos_org" : baseId);
            if (key.equals(BUSINESSBASEDATAEXT) && value != null && value.toString().equals(baseId)) continue;
            com.add(comboItem);
        }
    }

    private LocaleString getLocaleString(String basedataDefaultName, String baseId) {
        String idByNumber = MetadataDao.getIdByNumber((String)baseId, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((String)idByNumber) && StringUtils.isEmpty((String)(idByNumber = MetadataDao.getIdByNumber((String)baseId, (MetaCategory)MetaCategory.Entity)))) {
            LocaleString name = new LocaleString(basedataDefaultName);
            return name;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)baseId);
        LocaleString name = entityType != null ? entityType.getDisplayName() : new LocaleString(basedataDefaultName);
        return name;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (BASEDATAFIELD.equals(actionId) && "success".equals(e.getReturnData())) {
            this.initBusinessbasedata(BIZBASEDATA);
        }
        if (SHOWBIZMEMBER.equals(actionId)) {
            this.fillBizmember(e, actionId);
        }
        if (SHOWDIMMEMBER.equals(actionId)) {
            this.fillDimmember(e, actionId);
        }
        if (SHOWBIZMEMBEREXT.equals(actionId)) {
            this.fillBizmember(e, actionId);
        }
        if (BASEDATAFIELD.equals(actionId) && "save".equals(e.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u6210\u529f", (String)"EbDimMemberMapPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillDimmember(ClosedCallBackEvent e, String key) {
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
        if (selectedRowCollection != null && selectedRowCollection.size() != 0) {
            ListSelectedRow returnData = selectedRowCollection.get(0);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY_STRING);
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_STRING);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(selectRows[0]);
            if (SHOWDIMMEMBER.equals(key)) {
                dynamicObject.set(ENTRY_DIMMEMBER, returnData.getPrimaryKeyValue());
                dynamicObject.set("dimmemnumber", (Object)returnData.getNumber());
                dynamicObject.set(SHOWDIMMEMBER, (Object)returnData.getName());
            }
            this.setBudgetAndActualRelation(dynamicObject);
            this.getView().updateView(ENTRYENTITY_STRING);
        }
    }

    private void setBudgetAndActualRelation(DynamicObject dynamicObject) {
        String numberAndlongnumber;
        String dimmer = dynamicObject.getString("dimmemnumber");
        if (dimmer != null && !dimmer.isEmpty() && (numberAndlongnumber = this.getPageCache().get("numberAndlongnumber")) == null) {
            this.setLongumberAndNumberToPageChache(DIMENSION);
        }
    }

    private void fillBizmember(ClosedCallBackEvent e, String action) {
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)e.getReturnData();
        if (selectedRowCollection != null && selectedRowCollection.size() != 0) {
            ListSelectedRow returnData = selectedRowCollection.get(0);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY_STRING);
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_STRING);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(selectRows[0]);
            Long primaryKeyValue = 0L;
            try {
                primaryKeyValue = returnData.getPrimaryKeyValue() instanceof String ? Long.valueOf(Long.parseLong(returnData.getPrimaryKeyValue().toString())) : (Long)returnData.getPrimaryKeyValue();
            }
            catch (Exception ex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7684ID\u9700\u4e3a\u6574\u6570\u3002", (String)"EbDimMemberMapPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String FormId = "";
            Object FormId_new = this.getModel().getValue(BIZBASEDATA);
            if (FormId_new != null) {
                FormId = (String)FormId_new;
            }
            if (this.useMorebussData()) {
                FormId = this.getBussdataNumber();
            }
            FormId = this.getForm(FormId);
            if (action.equals(SHOWBIZMEMBEREXT)) {
                dynamicObject.set(ENTRY_BIZMEMBEREXT, (Object)primaryKeyValue);
                FormId = this.getModel().getValue(BUSINESSBASEDATAEXT).toString();
            } else {
                dynamicObject.set(ENTRY_BIZMEMBER, (Object)primaryKeyValue);
            }
            ArrayList<String> filed = new ArrayList<String>(16);
            FormId = this.changeFormId(FormId);
            this.islevel = this.isLevelData(FormId, filed);
            String selectFiled = this.getSelectFiled(filed);
            DynamicObject doj = null;
            try {
                doj = BusinessDataServiceHelper.loadSingle((String)FormId, (String)selectFiled, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)returnData.getPrimaryKeyValue()))});
                if (BOS_ORG_STRUCTURE.equals(FormId)) {
                    selectFiled = selectFiled + ",org.id";
                    doj = BusinessDataServiceHelper.loadSingle((String)FormId, (String)selectFiled, (QFilter[])new QFilter[]{new QFilter("org.number", "=", (Object)returnData.getNumber()).and("view.number", "=", (Object)"15")});
                }
                if (BOS_ADMINORG_STRUCTURE.equals(FormId)) {
                    selectFiled = selectFiled + ",org.id";
                    doj = BusinessDataServiceHelper.loadSingle((String)FormId, (String)selectFiled, (QFilter[])new QFilter[]{new QFilter("org.number", "=", (Object)returnData.getNumber()).and("view.number", "=", (Object)"01")});
                }
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
            if (returnData.isPkLongType()) {
                if (returnData.getNumber() == null) {
                    try {
                        if (doj.getString("number") == null || doj.getString("number").isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u7f16\u7801\u5b57\u6bb5\u6216\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EbDimMemberMapPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (doj.getString("name") == null || doj.getString("name").isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u540d\u79f0\u5b57\u6bb5\u6216\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EbDimMemberMapPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (action.equals(SHOWBIZMEMBEREXT)) {
                            dynamicObject.set(BIZNUMBEREXT, (Object)doj.getString("number"));
                            dynamicObject.set(SHOWBIZMEMBEREXT, (Object)doj.getString("name"));
                        }
                        dynamicObject.set("biznumber", (Object)doj.getString("number"));
                        dynamicObject.set(SHOWBIZMEMBER, (Object)doj.getString("name"));
                    }
                    catch (Exception ex) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u7f16\u7801\u3001\u540d\u79f0\u5b57\u6bb5\u6216\u7f16\u7801\u3001\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EbDimMemberMapPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else if (action.equals(SHOWBIZMEMBEREXT)) {
                    dynamicObject.set(BIZNUMBEREXT, (Object)returnData.getNumber());
                    dynamicObject.set(SHOWBIZMEMBEREXT, (Object)returnData.getName());
                } else {
                    dynamicObject.set("biznumber", (Object)returnData.getNumber());
                    dynamicObject.set(SHOWBIZMEMBER, (Object)returnData.getName());
                }
            } else {
                try {
                    if (doj.getString("number") == null || doj.getString("number").isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u7f16\u7801\u5b57\u6bb5\u6216\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EbDimMemberMapPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (doj.getString("name") == null || doj.getString("name").isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u540d\u79f0\u5b57\u6bb5\u6216\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EbDimMemberMapPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (action.equals(SHOWBIZMEMBEREXT)) {
                        dynamicObject.set(BIZNUMBEREXT, (Object)doj.getString("number"));
                        dynamicObject.set(SHOWBIZMEMBEREXT, (Object)doj.getString("name"));
                    } else {
                        dynamicObject.set("biznumber", (Object)doj.getString("number"));
                        dynamicObject.set(SHOWBIZMEMBER, (Object)doj.getString("name"));
                    }
                }
                catch (Exception ex) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u7f16\u7801\u3001\u540d\u79f0\u5b57\u6bb5\u6216\u7f16\u7801\u3001\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EbDimMemberMapPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (action.equals(SHOWBIZMEMBER)) {
                boolean leaf = this.isLeaf(doj, FormId, filed);
                this.setMessageData(leaf, dynamicObject);
            }
            this.getView().updateView(ENTRYENTITY_STRING);
        }
    }

    private String changeFormId(String formId) {
        if ("bos_org".equals(formId)) {
            return BOS_ORG_STRUCTURE;
        }
        if ("bos_adminorg".equals(formId)) {
            return BOS_ADMINORG_STRUCTURE;
        }
        return formId;
    }

    private void setMessageData(boolean leaf, DynamicObject dynamicObject) {
        if (leaf) {
            dynamicObject.set("range", (Object)RangeEnum.ONLY.getIndex());
        } else {
            dynamicObject.set("range", (Object)RangeEnum.ALL.getIndex());
            this.getModel().setValue("isexitnoleaf", (Object)true);
        }
    }

    private boolean useMorebussData() {
        Object value = this.getModel().getValue(USEMOREBUSSDATA);
        return value != null && (Boolean)value != false;
    }

    public String getBussdataNumber() {
        Object value;
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY_STRING);
        int[] selectRows = entryentity.getSelectRows();
        int i = 0;
        if (selectRows.length != 0) {
            i = selectRows[0];
        }
        if ((value = this.getModel().getValue(MOREBUSSDATA, i)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u522b\u3002", (String)"DimMemberMappingPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return value + "";
    }

    private String getSelectFiled(List<String> levelData) {
        if (this.islevel) {
            String value = levelData.get(0);
            return "id,name,number," + value;
        }
        return "id,name,number";
    }

    private boolean isLeaf(DynamicObject doj, String formId, List<String> filed) {
        if (this.islevel) {
            String value = filed.get(0);
            QFBuilder qfBuilder = new QFBuilder();
            if (!BOS_ORG_STRUCTURE.equals(formId) && !BOS_ADMINORG_STRUCTURE.equals(formId)) {
                qfBuilder.add(new QFilter(value, "=", (Object)doj.getLong("id")));
            } else {
                qfBuilder.add(new QFilter(value, "=", (Object)doj.getLong("org.id")));
            }
            return !QueryServiceHelper.exists((String)formId, (QFilter[])qfBuilder.toArrays());
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String action = e.getCallBackId();
        if (DIM_ENTRY_CLEAR.equals(action)) {
            if (YES.equals(e.getResultValue())) {
                this.clearLine();
                this.setVisible();
            } else {
                this.setOldData(DIMENSION);
            }
        } else if (BIZ_ENTRY_CLEAR.equals(action)) {
            if (YES.equals(e.getResultValue())) {
                this.clearLine();
                this.clearValue();
            } else {
                this.setOldData(BIZBASEDATA);
            }
        } else if (BIZ_ENTRYEXT_CLEAR.equals(action)) {
            if (YES.equals(e.getResultValue())) {
                this.showdata();
                this.clearValue();
                this.clearLine();
            } else {
                this.setUssistValue(USEASSISTDATA);
            }
        } else if (BUSINESSBASEDATAEXT.equals(action)) {
            if (e.getResultValue().equals(YES)) {
                this.clearLine();
            } else {
                this.setOldData(BUSINESSBASEDATAEXT);
            }
        } else if (USEMOREBUSSDATA.equals(action)) {
            if (YES.equals(e.getResultValue())) {
                this.showMorebussdata();
                this.showBnussData();
                this.clearLine();
            } else {
                this.setUssistValue(USEMOREBUSSDATA);
                this.showBnussData();
            }
        }
    }

    private void setOldData(String businessbasedataext) {
        this.getModel().beginInit();
        String oldData = this.getPageCache().get("oldData");
        if (oldData != null) {
            this.getModel().setValue(businessbasedataext, (Object)oldData);
        }
        this.getView().updateView(businessbasedataext);
        this.getModel().endInit();
    }

    private void setUssistValue(String key) {
        this.getModel().beginInit();
        if (this.getAssistDataValue(key)) {
            this.getModel().setValue(key, (Object)false);
        } else {
            this.getModel().setValue(key, (Object)true);
        }
        this.getView().updateView(key);
        this.getModel().endInit();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit basedataEdit;
        if (e.getSource() instanceof BasedataEdit && "model".equals((basedataEdit = (BasedataEdit)e.getSource()).getKey())) {
            this.beforeF7Select_model(e);
        }
        if (((BasedataEdit)e.getSource()).getKey().equals(DATASET) && StringUtils.isNotEmpty((String)DATASET) && this.getControl(DATASET) != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(DATASET)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
            qFilterList.add(qFilter);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    protected void beforeF7Select_model(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propNmae;
        super.propertyChanged(e);
        switch (propNmae = e.getProperty().getName()) {
            case "model": {
                this.initDimension(this.getSelModel());
                break;
            }
            case "dimnumber": {
                this.setLongumberAndNumberToPageChache(propNmae);
                this.setDataToPageChache(e);
                this.initDimMember();
                break;
            }
            case "businessbasedata": {
                this.setDataToPageChache(e);
                this.initBizMember(BIZBASEDATA);
                this.initBusinessbasedataExt();
                break;
            }
            case "useassistdata": {
                this.initBizMember(USEASSISTDATA);
                break;
            }
            case "businessbasedataext": {
                this.setDataToPageChache(e);
                this.initBizMember(BUSINESSBASEDATAEXT);
                this.showTips();
                break;
            }
            case "usemorebussdata": {
                this.setDataToPageChache(e);
                this.initBizMember(USEMOREBUSSDATA);
                this.showBnussData();
                this.showMorebussdata();
                break;
            }
            case "morebussdata": {
                this.setDataToPageChache(e);
                this.setbussdatavalue();
                break;
            }
            case "showbizmemberext": {
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY_STRING);
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY_STRING);
                int[] selectRows = entryGrid.getSelectRows();
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(selectRows[0]);
                dynamicObject.set(BIZNUMBEREXT, (Object)"");
                this.getView().updateView(ENTRYENTITY_STRING);
                break;
            }
        }
    }

    private void setVisible() {
        String dimnumber = (String)this.getModel().getValue(DIMENSION);
        if (SysDimensionEnum.Entity.getNumber().equals(dimnumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{USEMOREBUSSDATA});
        } else {
            this.getModel().setValue(USEMOREBUSSDATA, (Object)false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{USEMOREBUSSDATA});
        }
    }

    private void setbussdatavalue() {
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY_STRING);
        int[] selectRows = entryentity.getSelectRows();
        this.getModel().setValue(SHOWBIZMEMBER, null, selectRows[0]);
        this.getModel().setValue("biznumber", null, selectRows[0]);
        this.getModel().setValue(ENTRY_BIZMEMBER, null, selectRows[0]);
    }

    private void showMorebussdata() {
        Object value = this.getModel().getValue(USEMOREBUSSDATA);
        if (value != null) {
            if (((Boolean)value).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{MOREBUSSDATA});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BIZBASEDATA});
                this.initBusinessbasedata(MOREBUSSDATA);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MOREBUSSDATA});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BIZBASEDATA});
            }
        }
    }

    private void setLongumberAndNumberToPageChache(String propNmae) {
        Object value = this.getModel().getValue(propNmae);
        if (value != null) {
            String FormId = this.getModel().getValue(DIMENSION).toString();
            String dimNumber = null;
            SysDimensionEnum fixDim = SysDimensionEnum.getEnumByNumber((String)FormId);
            dimNumber = fixDim != null && !fixDim.getNumber().equals(SysDimensionEnum.Project.getNumber()) ? fixDim.getMemberTreemodel() : SysDimensionEnum.Project.getMemberTreemodel();
            QFilter qFilter = new QFilter("model", "=", (Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
            ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
            filters.add(qFilter);
            QFBuilder builder = new QFBuilder();
            if (SysDimensionEnum.Project.getMemberTreemodel().equals(dimNumber)) {
                builder.add(qFilter);
                builder.add(new QFilter("number", "=", this.getModel().getValue(DIMENSION)));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)SysDimensionEnum.Project.getMemberTreemodel(), (String)"dimension", (QFilter[])builder.toArrays());
                if (dynamicObject != null) {
                    filters.add(new QFilter("dimension", "=", (Object)dynamicObject.getLong("dimension")));
                } else {
                    filters.add(new QFilter("dimension", "=", (Object)0));
                }
            }
            builder.clear();
            builder.add(filters);
            DynamicObjectCollection query = QueryServiceHelper.query((String)dimNumber, (String)"id,number,longnumber", (QFilter[])builder.toArrays());
            HashMap<String, String> numberAndLongnumber = new HashMap<String, String>(16);
            for (DynamicObject dynamicObject : query) {
                numberAndLongnumber.put(dynamicObject.getString("number"), dynamicObject.getString("longnumber"));
            }
            this.getPageCache().put("numberAndlongnumber", SerializationUtils.serializeToBase64(numberAndLongnumber));
        }
    }

    private void setDataToPageChache(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet[0].getOldValue() != null) {
            this.getPageCache().put("oldData", changeSet[0].getOldValue().toString());
        }
    }

    private void showTips() {
        Object value = this.getModel().getValue(BIZBASEDATA);
        Object valueExt = this.getModel().getValue(BUSINESSBASEDATAEXT);
        if (value == null && valueExt != null && !this.useMorebussData()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"EbDimMemberMapPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(BUSINESSBASEDATAEXT, null);
        }
        if (valueExt == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SHOWBIZMEMBEREXT, BIZNUMBEREXT});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SHOWBIZMEMBEREXT, BIZNUMBEREXT});
        }
    }

    private void clearValue() {
        this.getModel().setValue(BUSINESSBASEDATAEXT, null);
    }

    private void showdata() {
        if (this.getAssistDataValue(USEASSISTDATA)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUSINESSBASEDATAEXT, SHOWBIZMEMBEREXT, BIZNUMBEREXT});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BUSINESSBASEDATAEXT, SHOWBIZMEMBEREXT, BIZNUMBEREXT});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        switch (evt.getItemKey()) {
            case "addentry": {
                if (!this.checkSelect(true)) break;
                this.initBusinessbasedata(BIZBASEDATA);
                this.addLine();
                break;
            }
            case "deleteentry": {
                this.delLine();
                break;
            }
            case "reigst": {
                this.openReigstBaseDataListPage();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals(SHOWBIZMEMBER) || source.getKey().equals(SHOWBIZMEMBEREXT)) {
            try {
                String FormId = "";
                Object formIdNew = this.getModel().getValue(BIZBASEDATA);
                if (formIdNew != null) {
                    FormId = (String)formIdNew;
                }
                if (this.useMorebussData()) {
                    FormId = this.getBussdataNumber();
                }
                FormId = this.getForm(FormId);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SHOWBIZMEMBER);
                if (source.getKey().equals(SHOWBIZMEMBEREXT)) {
                    FormId = this.getModel().getValue(BUSINESSBASEDATAEXT).toString();
                    closeCallBack = new CloseCallBack((IFormPlugin)this, SHOWBIZMEMBEREXT);
                }
                ListShowParameter showParameter = new ListShowParameter();
                if (!FormId.equals(SysDimensionEnum.Project.getMemberTreemodel())) {
                    showParameter.setBillFormId(FormId);
                    FormConfig formConfig = FormMetadataCache.getListFormConfig((String)FormId);
                    if (formConfig == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u8bbe\u7f6e\u5f53\u524d\u57fa\u7840\u8d44\u6599\u7684\u5217\u8868\u3002", (String)"EbDimMemberMapPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String f7ListFormId = formConfig.getF7ListFormId();
                    showParameter.setFormId(f7ListFormId);
                    showParameter.setLookUp(true);
                    showParameter.setMultiSelect(false);
                    showParameter.setShowApproved(false);
                    showParameter.setShowTitle(false);
                } else {
                    showParameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6", (String)"EbDimMemberMapPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    showParameter.setCustomParam("modelId", ((DynamicObject)this.getModel().getValue("model")).get("id"));
                    showParameter.setFormId("eb_userdefinedtreelist");
                }
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setHeight("570");
                css.setWidth("900");
                showParameter.getOpenStyle().setInlineStyleCss(css);
                this.getView().showForm((FormShowParameter)showParameter);
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        if (source.getKey().equals(SHOWDIMMEMBER)) {
            Member member;
            String dimNumber = this.getModel().getValue(DIMENSION).toString();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, source.getKey());
            Long modelId = this.getModelId();
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            if (source.getKey().equals(SHOWDIMMEMBER)) {
                f7Param.setOnlySelLeaf(true);
            }
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            long bussnessModel = CommonUtils.getBussnessModel((Long)this.getModelId());
            Map viewIds = Collections.emptyMap();
            if (IDUtils.isNotNull((long)bussnessModel)) {
                f7Param.setBusModelId(Long.valueOf(bussnessModel));
                viewIds = modelCacheHelper.getViewsByBusModel(Long.valueOf(bussnessModel));
            }
            EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY_STRING);
            int[] selectRows = control.getSelectRows();
            String dimmemnumber = (String)this.getModel().getValue("dimmemnumber", selectRows[0]);
            if (StringUtils.isNotEmpty((String)dimmemnumber) && (member = modelCacheHelper.getMember(dimNumber, (Long)viewIds.get(dimNumber), dimmemnumber)) != null) {
                f7Param.setSelectId(member.getId());
            }
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
        }
    }

    private String getForm(String formId) {
        if ("gl_org".equals(formId)) {
            formId = "bos_org";
        }
        return formId;
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = this.getSelModel();
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            args.setCancel(true);
            return;
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            if (!this.validate()) {
                args.setCancel(true);
                return;
            }
            this.setbusinessbaseDataNameValue(BIZBASEDATA, "businessbasedataname");
            this.setbusinessbaseDataNameValue(BUSINESSBASEDATAEXT, "businessbasedatanameext");
            this.setDataByEntry();
            this.setExitNoLeafValue();
            this.setMorebusnessData();
            this.clearMappingChache();
            this.updateDimName();
            this.getView().returnDataToParent((Object)"updata");
        }
    }

    private void setDataByEntry() {
        String businessbasedataext;
        boolean useassistdata;
        boolean usemorebussdata = (Boolean)this.getModel().getValue(USEMOREBUSSDATA);
        if (usemorebussdata) {
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY_STRING);
            for (DynamicObject dynamicObject : entity) {
                if (!"bos_org".equals(dynamicObject.getString(MOREBUSSDATA))) continue;
                dynamicObject.set(MOREBUSSDATA, (Object)"gl_org");
            }
        } else {
            String businessbasedata = (String)this.getModel().getValue(BIZBASEDATA);
            if ("bos_org".equals(businessbasedata)) {
                this.getPageCache().put("modify", "1");
                this.getModel().setValue(BIZBASEDATA, (Object)"gl_org");
                this.getModel().setValue("businessbasedataname", (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"EbDimMemberMapPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if ((useassistdata = ((Boolean)this.getModel().getValue(USEASSISTDATA)).booleanValue()) && "bos_org".equals(businessbasedataext = (String)this.getModel().getValue(BUSINESSBASEDATAEXT))) {
            this.getPageCache().put("modify", "1");
            this.getModel().setValue(BUSINESSBASEDATAEXT, (Object)"gl_org");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            String businessbasedata = (String)this.getModel().getValue(BIZBASEDATA);
            if ("gl_org".equals(businessbasedata)) {
                this.getPageCache().put("modify", "1");
                this.getModel().setValue(BIZBASEDATA, (Object)"bos_org");
                this.getModel().setDataChanged(false);
            } else {
                this.transToBosOrg();
            }
            boolean usemorebussdata = (Boolean)this.getModel().getValue(USEMOREBUSSDATA);
            if (usemorebussdata) {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY_STRING);
                for (DynamicObject dynamicObject : entity) {
                    if (!"gl_org".equals(dynamicObject.getString(MOREBUSSDATA))) continue;
                    dynamicObject.set(MOREBUSSDATA, (Object)"bos_org");
                    this.getModel().setDataChanged(false);
                }
            }
        }
    }

    private void setMorebusnessData() {
        this.getModel().beginInit();
        Object value = this.getModel().getValue(USEMOREBUSSDATA);
        if (value != null) {
            int entryentity = this.getModel().getEntryEntity(ENTRYENTITY_STRING).size();
            if (!((Boolean)value).booleanValue()) {
                if (entryentity > 0) {
                    this.getModel().setValue(MOREBUSSDATA, null, 0, entryentity);
                }
            } else {
                this.getModel().setValue(BIZBASEDATA, null);
            }
        }
        this.getModel().endInit();
    }

    private void clearMappingChache() {
        Object pkId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getStatus().getValue() == OperationStatus.EDIT.getValue() && (pkId = ((BaseShowParameter)formShowParameter).getPkId()) != null && !pkId.toString().isEmpty()) {
            BgMemMappingServiceHelper.clearCacheByMapping((Long)Long.parseLong(pkId.toString()));
        }
    }

    private void setExitNoLeafValue() {
        this.getModel().beginInit();
        Boolean value = (Boolean)this.getModel().getValue("isexitnoleaf");
        this.getModel().setValue("isexitnoleaf", (Object)value);
        this.getView().updateView("isexitnoleaf");
        this.getModel().endInit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setbusinessbaseDataNameValue(String key, String setValue) {
        Object s = this.getModel().getValue(key);
        if (s != null && !s.toString().isEmpty()) {
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)BASEDATAFIELD, (String)"eb_registmappingbill", (String)BASENAME, (QFilter[])new QFilter[]{new QFilter(BASEDATAFIELD, "=", this.getModel().getValue(key))}, (String)"", (int)1);){
                if (rows == null) return;
                for (Row memberRow : rows) {
                    String basename = memberRow.getString(BASENAME);
                    this.getModel().setValue(setValue, (Object)basename);
                }
                return;
            }
        } else {
            this.getModel().setValue(setValue, null);
        }
    }

    private void setNotRequired() {
        if (!this.getAssistDataValue(USEASSISTDATA)) {
            ItemClassTypeEdit businessExt = (ItemClassTypeEdit)this.getControl(BUSINESSBASEDATAEXT);
            businessExt.setMustInput(false);
            TextEdit showbizExt = (TextEdit)this.getControl(SHOWBIZMEMBEREXT);
            showbizExt.setMustInput(false);
            DecimalEdit bizmemberExt = (DecimalEdit)this.getControl(ENTRY_BIZMEMBEREXT);
            bizmemberExt.setMustInput(false);
            TextEdit biznumberExt = (TextEdit)this.getControl(BIZNUMBEREXT);
            biznumberExt.setMustInput(false);
            this.getView().updateView();
        }
    }

    private boolean getAssistDataValue(String key) {
        return (Boolean)this.getModel().getValue(key);
    }

    protected DynamicObject getSelModel() {
        return (DynamicObject)this.getModel().getValue("model");
    }

    protected boolean checkModel(boolean showTip) {
        boolean re = true;
        DynamicObject model = this.getSelModel();
        if (model == null) {
            re = false;
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"EbDimMemberMapPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return re;
    }

    protected String getSelDimension() {
        return (String)this.getModel().getValue(DIMENSION);
    }

    protected boolean checkDimension(boolean showTip) {
        boolean re = true;
        String dimension = this.getSelDimension();
        if (StringUtils.isEmpty((String)dimension)) {
            re = false;
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6", (String)"EbDimMemberMapPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return re;
    }

    protected String getSelBizBaseData() {
        return (String)this.getModel().getValue(BIZBASEDATA);
    }

    protected boolean checkBizBaseData(boolean showTip) {
        boolean re = true;
        String bizBaseData = this.getSelBizBaseData();
        if (StringUtils.isEmpty((String)bizBaseData) && !this.useMorebussData()) {
            re = false;
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"EbDimMemberMapPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return re;
    }

    protected boolean checkBizBaseDataExt(boolean showTip) {
        Object businessDataExt;
        boolean re = true;
        if (this.getAssistDataValue(USEASSISTDATA) && showTip && (businessDataExt = this.getModel().getValue(BUSINESSBASEDATAEXT)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"EbDimMemberMapPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            re = false;
        }
        return re;
    }

    protected boolean checkSelect(boolean showTip) {
        return this.checkModel(showTip) && this.checkDimension(showTip) && this.checkBizBaseData(showTip) && this.checkBizBaseDataExt(showTip);
    }

    protected void initDimension(DynamicObject model) {
        if (model == null) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)model.getPkValue()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_dimension", (String)"id, name, number", (QFilter[])filter.toArray(), (String)"dseq");){
            if (ds != null) {
                Row row = null;
                HashMap<String, String> dimensionMap = new HashMap<String, String>(16);
                ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
                ComboItem item = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    if (exclude.contains(row.getString("number"))) continue;
                    item = new ComboItem(new LocaleString(row.getString("name")), row.getString("number"));
                    items.add(item);
                    dimensionMap.put(row.getString("number"), row.getString("name"));
                }
                ComboEdit control = (ComboEdit)this.getControl(DIMENSION);
                control.setComboItems(items);
                this.getPageCache().put(DIMENSION_CACHE, SerializationUtils.serializeToBase64(dimensionMap));
            }
        }
    }

    protected DynamicObject getDimMapping(PropertyChangedArgs e) {
        if (e == null || e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return null;
        }
        return e.getChangeSet()[0].getDataEntity();
    }

    protected void initDimMember() {
        if (this.checkSelect(false)) {
            DynamicObject entry;
            int count = this.getModel().getEntryRowCount(ENTRYENTITY_STRING);
            if (count == 1 && (entry = this.getModel().getEntryRowEntity(ENTRYENTITY_STRING, 0)) != null && entry.get(ENTRY_DIMMEMBER) == null && entry.get(ENTRY_BIZMEMBER) == null) {
                count = 0;
            }
            if (count > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u7ef4\u5ea6\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"EbDimMemberMapPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DIM_ENTRY_CLEAR, (IFormPlugin)this));
            } else {
                this.clearLine();
            }
        } else {
            this.clearLine();
        }
    }

    protected void updateDimName() {
        Map dimensionMap;
        String dimnumber = (String)this.getModel().getValue(DIMENSION);
        String dimCacahe = this.getPageCache().get(DIMENSION_CACHE);
        if (dimCacahe != null && (dimensionMap = (Map)SerializationUtils.deSerializeFromBase64((String)dimCacahe)) != null && dimensionMap.containsKey(dimnumber)) {
            this.getModel().setValue("dimname", dimensionMap.get(dimnumber));
        }
    }

    protected void initBizMember(String key) {
        if (this.checkSelect(false) || key.equals(USEASSISTDATA) || key.equals(USEMOREBUSSDATA)) {
            DynamicObject entry;
            int count = this.getModel().getEntryRowCount(ENTRYENTITY_STRING);
            if (count == 1 && (entry = this.getModel().getEntryRowEntity(ENTRYENTITY_STRING, 0)) != null && entry.get(ENTRY_DIMMEMBER) == null && entry.get(ENTRY_BIZMEMBER) == null) {
                count = 0;
            }
            if (count > 0) {
                String modify;
                if (key.equals(BUSINESSBASEDATAEXT)) {
                    if (this.getModel().getValue(BUSINESSBASEDATAEXT) != null) {
                        modify = this.getPageCache().get("modify");
                        if (StringUtils.isEmpty((String)modify)) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"EbDimMemberMapPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BUSINESSBASEDATAEXT, (IFormPlugin)this));
                        } else {
                            this.getPageCache().remove("modify");
                        }
                    }
                } else if (key.equals(USEASSISTDATA)) {
                    if (((Boolean)this.getModel().getValue(USEASSISTDATA)).booleanValue()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u6253\u5f00\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"EbDimMemberMapPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BIZ_ENTRYEXT_CLEAR, (IFormPlugin)this));
                    } else if (this.getModel().getValue(BUSINESSBASEDATAEXT) != null) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"EbDimMemberMapPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BIZ_ENTRYEXT_CLEAR, (IFormPlugin)this));
                    }
                } else if (key.equals(USEMOREBUSSDATA)) {
                    if (((Boolean)this.getModel().getValue(USEMOREBUSSDATA)).booleanValue()) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u6253\u5f00\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"EbDimMemberMapPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(USEMOREBUSSDATA, (IFormPlugin)this));
                    } else if (this.getModel().getValue(USEMOREBUSSDATA) != null) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"EbDimMemberMapPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(USEMOREBUSSDATA, (IFormPlugin)this));
                    }
                } else {
                    modify = this.getPageCache().get("modify");
                    if (StringUtils.isEmpty((String)modify)) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4f1a\u6e05\u9664\u5f53\u524d\u7684\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5173\u7cfb\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"EbDimMemberMapPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BIZ_ENTRY_CLEAR, (IFormPlugin)this));
                    } else {
                        this.getPageCache().remove("modify");
                    }
                }
            } else {
                if (key.equals(USEASSISTDATA)) {
                    this.showdata();
                    this.clearValue();
                }
                this.clearLine();
            }
        } else {
            this.clearLine();
        }
    }

    protected void clearLine() {
        this.getModel().deleteEntryData(ENTRYENTITY_STRING);
    }

    protected void addLine() {
        String bizType;
        if (this.getModel().getEntryEntity(ENTRYENTITY_STRING).isEmpty() && !this.useMorebussData() && !StringUtils.isNotEmpty((String)(bizType = (String)this.getModel().getValue(BIZBASEDATA)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u3002", (String)"EbDimMemberMapPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().createNewEntryRow(ENTRYENTITY_STRING);
    }

    protected void delLine() {
        int rowIndex = ((EntryGrid)this.getControl(ENTRYENTITY_STRING)).getEntryState().getFocusRow();
        if (rowIndex >= 0) {
            this.getModel().deleteEntryRow(ENTRYENTITY_STRING, rowIndex);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c\u3002", (String)"EbDimMemberMapPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected boolean validate() {
        boolean result = true;
        IDataModel model = this.getModel();
        String value = (String)model.getValue("number");
        Object name = model.getValue("name");
        if (Objects.nonNull(value)) {
            String saveNumber;
            String checkNumber = NumberCheckUtils.checkNumberRule((String)value);
            if (StringUtils.isNotEmpty((String)checkNumber)) {
                throw new KDBizException(checkNumber);
            }
            if (StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)name.toString())) {
                result = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDimMemberMapPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)(saveNumber = this.getPageCache().get("status"))) || !StringUtils.equals((String)saveNumber, (String)"modify")) {
                QFilter qFilter = new QFilter("number", "=", (Object)value);
                qFilter.and(new QFilter("model", "=", (Object)this.getModelId()));
                boolean exists = QueryServiceHelper.exists((String)"eb_ebdimmembermap", (QFilter[])qFilter.toArray());
                if (exists) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\u3002", (String)"EbDimMemberMapPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getPageCache().put("status", "modify");
            }
        }
        if (result) {
            String bizMember = null;
            String dimMember = null;
            Object bizMemberExt = null;
            DynamicObjectCollection entrys = model.getEntryEntity(ENTRYENTITY_STRING);
            HashMap<String, Integer> bizMemberMap = new HashMap<String, Integer>(16);
            HashMap<String, Integer> bizMemberExtMap = new HashMap<String, Integer>(16);
            if (entrys.size() == 0) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u81f3\u5c11\u5b58\u5728\u4e00\u884c\u8bb0\u5f55\u3002", (String)"EbDimMemberMapPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            int in = entrys.size();
            for (int i = 0; i < in; ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                dimMember = entry.getString(SHOWDIMMEMBER);
                bizMember = entry.getString(SHOWBIZMEMBER);
                if (bizMember == null || StringUtils.isEmpty((String)bizMember)) {
                    result = false;
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDimMemberMapPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                    break;
                }
                if (dimMember == null || StringUtils.isEmpty((String)dimMember)) {
                    result = false;
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDimMemberMapPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1}));
                    break;
                }
                if (bizMemberExtMap.containsKey(entry.getString("biznumber") + entry.getString(BIZNUMBEREXT))) {
                    int rowIndex = (Integer)bizMemberExtMap.get(entry.getString("biznumber") + entry.getString(BIZNUMBEREXT));
                    result = false;
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u548c\u8f85\u52a9\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u91cd\u590d\u3002", (String)"EbDimMemberMapPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, rowIndex + 1}));
                    break;
                }
                if (!entry.getString(BIZNUMBEREXT).isEmpty()) {
                    bizMemberExtMap.put(entry.getString("biznumber") + entry.getString(BIZNUMBEREXT), i);
                }
                if (!entry.getString(BIZNUMBEREXT).isEmpty()) continue;
                if (bizMemberMap.containsKey(entry.getString("biznumber"))) {
                    int rowIndex = (Integer)bizMemberMap.get(entry.getString("biznumber"));
                    result = false;
                    String msg = ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u7684\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u7f16\u7801\u91cd\u590d\uff0c\u4e00\u4e2a\u4e1a\u52a1\u57fa\u7840\u8d44\u6599\u4e0d\u5141\u8bb8\u6620\u5c04\u591a\u4e2a\u7ef4\u5ea6\u6210\u5458\u3002", (String)"EbDimMemberMapPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{i + 1, rowIndex + 1});
                    this.getView().showErrorNotification(msg);
                    break;
                }
                bizMemberMap.put(entry.getString("biznumber"), i);
            }
        }
        return result;
    }

    private void openReigstBaseDataListPage() {
        ListShowParameter param = new ListShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setBillFormId("eb_registmappingbill");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BASEDATAFIELD));
        this.getView().showForm((FormShowParameter)param);
    }

    private Map<Object, Object> addInitMap() {
        HashMap<Object, Object> initMap = new HashMap<Object, Object>(16);
        initMap.put("bos_org", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"EbDimMemberMapPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        initMap.put("bd_accountview", ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee", (String)"EbDimMemberMapPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        initMap.put("bd_supplier", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"EbDimMemberMapPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        initMap.put("bd_customer", ResManager.loadKDString((String)"\u5ba2\u6237", (String)"EbDimMemberMapPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        initMap.put("pa_microenterprisedf", ResManager.loadKDString((String)"\u5c0f\u5fae\u5b9a\u4e49", (String)"EbDimMemberMapPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        initMap.put("er_expenseitemedit", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"EbDimMemberMapPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        initMap.put("bos_org_biz", ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e1a\u52a1\u804c\u80fd", (String)"EbDimMemberMapPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        initMap.put("bd_project", ResManager.loadKDString((String)"\u9879\u76ee", (String)"EbDimMemberMapPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return initMap;
    }

    private void firstAddPreset() {
        if (!QueryServiceHelper.exists((String)"eb_registmappingbill", (QFilter[])new QFilter[]{new QFilter("BASEDATAFIELD", "=", (Object)"bos_org")})) {
            Map<Object, Object> objectObjectMap = this.addInitMap();
            int i = 0;
            DynamicObject[] dynamicObjects = new DynamicObject[objectObjectMap.size()];
            for (Map.Entry<Object, Object> entry : objectObjectMap.entrySet()) {
                Object o = entry.getKey();
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_registmappingbill");
                dynamicObject.set(BASEDATAFIELD, o);
                dynamicObject.set(BASENAME, entry.getValue());
                dynamicObjects[i] = dynamicObject;
                ++i;
            }
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                    this.writeLog(new MultiLangEnumBridge("\u4fdd\u5b58", "EbDimMemberMapPlugin_27", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "EbDimMemberMapPlugin_28", "epm-eb-formplugin"));
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.writeLog(new MultiLangEnumBridge("\u4fdd\u5b58", "EbDimMemberMapPlugin_27", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25", "EbDimMemberMapPlugin_29", "epm-eb-formplugin"));
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    public void writeLog(MultiLangEnumBridge opName, MultiLangEnumBridge opDescription) {
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, null, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.equals("model")) {
            BasedataEdit b = new BasedataEdit(){

                protected FuzzySearch buildDefLookUpSetting(BasedataEntityType refBDType) {
                    FuzzySearch setting = new FuzzySearch();
                    String number = refBDType.getNumberProperty();
                    String name = refBDType.getNameProperty();
                    String reportType = "reporttype";
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)number)) {
                        ParameterHelper.addItem((FuzzySearch)setting, (String)number, (String)ResManager.loadKDString((String)"\u7f16\u7801", (String)"EbDimMemberMapPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]), (float)100.0f);
                    }
                    if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)name)) {
                        ParameterHelper.addItem((FuzzySearch)setting, (String)name, (String)ResManager.loadKDString((String)"\u540d\u79f0", (String)"EbDimMemberMapPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), (float)100.0f);
                    }
                    ParameterHelper.addItem((FuzzySearch)setting, (String)reportType, (String)ResManager.loadKDString((String)"\u5e94\u7528\u7c7b\u578b", (String)"EbDimMemberMapPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]), (float)100.0f);
                    return setting;
                }
            };
            b.setFieldKey(key);
            b.setKey(key);
            b.setDisplayProp("name");
            b.setView(this.getView());
            b.setModel(this.getModel());
            b.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            b.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
            e.setControl((Control)b);
        }
    }

    public boolean isLevelData(String form, List<String> filed) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)form);
        IDataEntityProperty parent = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"parent");
        IDataEntityProperty parentid = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"parentid");
        if (parent != null && !parent.getAlias().isEmpty() || parentid != null && !parentid.getAlias().isEmpty()) {
            if (parent != null) {
                filed.add("parent");
            } else {
                filed.add("parentid");
            }
            return true;
        }
        return false;
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        List queryData = searchEvent.getQueryData();
        if (queryData != null && queryData.size() > 0) {
            for (int i = 0; i < queryData.size(); ++i) {
                ArrayList list = (ArrayList)queryData.get(i);
                String reporttype = (String)list.get(3);
                list.remove(3);
                if ("4".equals(reporttype)) {
                    list.add(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97", (String)"EbDimMemberMapPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                list.add(ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb", (String)"EbDimMemberMapPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

