/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataAcquisition.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.service.DataGatherRunService;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class ExecuteCollectionTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long executeId = (Long)map.get("executeId");
        Long modelId = (Long)map.get("modelId");
        DataGatherHandCallParam param = this.createParam(executeId, modelId);
        DataGatherRunService.getInstance().doDataGatherRun(modelId, Collections.singletonList(executeId), param);
        DynamicObjectCollection supervisors = (DynamicObjectCollection)map.get("supervisors");
        ArrayList receiver = new ArrayList(16);
        if (supervisors.size() > 0) {
            supervisors.forEach(e -> receiver.add(e.getLong("fbasedataid_id")));
        }
        boolean remind = (Boolean)map.get("remind");
        Long senderId = (Long)map.get("senderId");
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle(ResManager.loadKDString((String)"\u6267\u884c\u6570\u636e\u91c7\u96c6", (String)"ExecuteCollectionTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        messageInfo.setContent(ResManager.loadKDString((String)"\u6709\u4e00\u4e2a\u6b63\u5728\u6267\u884c\u7684\u6570\u636e\u91c7\u96c6\uff0c\u8bf7\u67e5\u770b\u3002", (String)"ExecuteCollectionTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        messageInfo.setUserIds(receiver);
        messageInfo.setSenderId(senderId);
        messageInfo.setType("message");
        messageInfo.setEntityNumber("eb_collectionexecute");
        if (remind) {
            messageInfo.setNotifyType("sms");
            messageInfo.setPubaccNumber("systempubacc");
        }
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private DataGatherHandCallParam createParam(Long executeId, Long modelId) {
        DataGatherHandCallParam param = new DataGatherHandCallParam();
        Integer year = Calendar.getInstance().get(1);
        String yearNumber = "FY" + year;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)yearNumber);
        if (!QueryServiceHelper.exists((String)SysDimensionEnum.Year.getMemberTreemodel(), (QFilter[])qFilter.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u4efb\u52a1\u6240\u5c5e\u4f53\u7cfb\u7684\u8d22\u5e74\u4e2d\u6ca1\u6709\u672c\u5e74\u3002", (String)"ExecuteCollectionListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        param.setYearNum(yearNumber);
        Integer month = Calendar.getInstance().get(2) + 1;
        param.setPeriodNum("M_M" + (month < 10 ? "0" + month : month));
        qFilter = new QFilter("id", "=", (Object)executeId);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_collectionexecute", (String)"entryentity.project", (QFilter[])qFilter.toArray());
        HashSet configSet = new HashSet(16);
        dynamicObjectCollection.forEach(e -> configSet.add((Long)e.get(0)));
        qFilter = new QFilter("id", "in", configSet);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"eb_collectionconfig", (String)"entityrang", (QFilter[])qFilter.toArray());
        HashSet org = new HashSet(16);
        orgs.forEach(e -> {
            List list = SerializationUtils.fromJsonStringToList((String)((String)e.get(0)), Map.class);
            list.forEach(f -> org.add(f.get("number")));
        });
        param.setOrgNums(org);
        param.setAppNum(ApplicationTypeEnum.EB.getAppnum());
        param.setSqlBatch(6000);
        return param;
    }
}

