/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.sonmodel.BgmdMainSubControlHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataModelTrans.DataModelFormCommon;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.controller.DataModelExportController;
import kd.epm.eb.formplugin.dataModelTrans.dto.DataModelFormClosedResult;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportRequest;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelExportMain;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildTemplate;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DataModelRepairPeriod;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelIsLeafUtil;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DataModelExportBillV2Plugin
extends AbstractFormPlugin {
    private static final String EXPORT_TAB = "radiogroupfield";
    private static final String CACHE_MODEL_TREE = "model_tree";
    private static final String MODEL_TREE_VIEW = "modeltreeap";
    private static final String CACHE_DIM_TREE = "dim_tree";
    private static final String CACHE_SELECT_DIM_TREE = "dim_select_tree";
    private static final String DIM_TREE_VIEW = "dimtreeap";
    private static final String DIM_SELECT_TREE = "dimselecttreeap";
    private static final String CACHE_DIM_DETAIL_TREE = "dim_detail_tree";
    private static final String DIM_DETAIL_TREE_VIEW = "dimdetailtreeap";
    private static final String DIM_SEARCH_CONTROL = "dimsearchap";
    private static final String DIM_SEARCH_CONTROL_1 = "dimsearchap1";
    private static final String DIM_SEARCH_BEFORE = "dimsearchbefore";
    private static final String SELECT_SEARCH_BEFORE = "selectsearchbefore";
    private static final String DIM_SEARCH_NEXT = "dimsearchnext";
    private static final String SELECT_SEARCH_NEXT = "selectsearchnext";
    private static final String FOCUS1 = "focus1";
    private static final String RESULT_LIST1 = "resultList1";
    private static final String FOCUS2 = "focus2";
    private static final String RESULT_LIST2 = "resultList2";
    private static final String OLD_NODE_CACHE_NAME1 = "oldNodeCacheName1";
    private static final String OLD_NODE_CACHE_NAME2 = "oldNodeCacheName2";
    private static final String CURRENT_MODEL_NODE_ID = "current_model_node_id";
    private static final String CURRENT_DIM_NODE_ID = "current_dim_node_id";
    private static final String CLICK_LEFT_NODE_CACHE = "clickLeftNodeCache";
    private static final String CLICK_RIGHT_NODE_CACHE = "clickRightNodeCache";
    private static final String CACHE_MODEL_TREE_NODE = "cachemodeltreenode";
    private static final String CACHE_DIM_TREE_NODE = "cachedimtreenode";
    private static final String CACHE_SELECT_TREE_NODES = "cacheselecttreenode";
    private static final String CACHE_MODEL_CHECK_ALL_NODE = "cachemodelcheckallnode";
    private static final String CACHE_RIGHT_TREE_ROOT_NODE = "getCacheRightTreeRootNode";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BTN_EXPORT = "exportap";
    private static final String BTN_IMPORT = "importap";
    private static final String BTN_TRANSPORT_LOG = "btn_transport_log";
    private static final String BTN_REFRESH = "refreshap";
    private static final String BTN_GO = "go";
    private static final String BTN_BACK = "back";
    private static final int COLLECTION_SIZE = 16;
    private static final int TREE_MAX_SIZE = 10;
    private static final String modelTreeRootNodeId = "100";
    private static final String baseDataTreeRootNodeId = "1000";
    private static final String ACTION_EXPORT_MODEL_RANGE = "exportModelRange";
    private static Log log = LogFactory.getLog(DataModelExportBillV2Plugin.class);

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTreeNodeClickListeners();
        this.addTreeNodeCheckListeners();
        this.addTreeSearchClickListeners();
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
        this.addClickListeners(new String[]{DIM_SEARCH_BEFORE, DIM_SEARCH_NEXT, SELECT_SEARCH_BEFORE, SELECT_SEARCH_NEXT, BTN_GO, BTN_BACK});
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addTabSelectListener();
    }

    private void addTreeSearchClickListeners() {
        Search searchLeft = (Search)this.getControl("searchap");
        searchLeft.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (StringUtils.isNotBlank((String)event.getText())) {
                    List nodes;
                    TreeSearchUtil.TreeSearchParam treeSearchParam = new TreeSearchUtil.TreeSearchParam(DataModelExportBillV2Plugin.MODEL_TREE_VIEW, DataModelExportBillV2Plugin.CACHE_MODEL_TREE);
                    TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), DataModelExportBillV2Plugin.this.getView(), DataModelExportBillV2Plugin.this.getPageCache(), treeSearchParam, true);
                    String resultStr = DataModelExportBillV2Plugin.this.getPageCache().get(treeSearchParam.getResultList());
                    if (StringUtils.isNotBlank((String)resultStr) && (nodes = (List)SerializationUtils.deSerializeFromBase64((String)resultStr)) != null && nodes.size() > 0) {
                        TreeNode node = (TreeNode)nodes.get(0);
                        TreeView tree = (TreeView)DataModelExportBillV2Plugin.this.getView().getControl(treeSearchParam.getTreeKey());
                        tree.treeNodeClick(node.getParentid(), node.getId());
                    }
                } else {
                    DataModelExportBillV2Plugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u6216\u7f16\u7801\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"DataModelExportBillV2Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        Search searchRight = (Search)this.getControl(DIM_SEARCH_CONTROL);
        searchRight.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (StringUtils.isNotBlank((String)event.getText())) {
                    TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), DataModelExportBillV2Plugin.this.getView(), DataModelExportBillV2Plugin.this.getPageCache(), new TreeSearchUtil.TreeSearchParam(DataModelExportBillV2Plugin.DIM_TREE_VIEW, DataModelExportBillV2Plugin.CACHE_DIM_TREE, "_1"));
                } else {
                    DataModelExportBillV2Plugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u6216\u7f16\u7801\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"DataModelExportBillV2Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        Search searchSelected = (Search)this.getControl(DIM_SEARCH_CONTROL_1);
        searchSelected.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (StringUtils.isNotBlank((String)event.getText())) {
                    TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), DataModelExportBillV2Plugin.this.getView(), DataModelExportBillV2Plugin.this.getPageCache(), new TreeSearchUtil.TreeSearchParam(DataModelExportBillV2Plugin.DIM_SELECT_TREE, DataModelExportBillV2Plugin.CACHE_SELECT_DIM_TREE, "_2"));
                } else {
                    DataModelExportBillV2Plugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u6216\u7f16\u7801\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"DataModelExportBillV2Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private void addTabSelectListener() {
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent tabSelectEvent) {
                String key = tabSelectEvent.getTabKey();
                if ("exportall".equalsIgnoreCase(key)) {
                    DataModelExportBillV2Plugin.this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap8"});
                    DataModelExportBillV2Plugin.this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9", "flexpanelap10"});
                } else {
                    DataModelExportBillV2Plugin.this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap8", "flexpanelap9", "flexpanelap10"});
                    if (DataModelExportBillV2Plugin.this.getCacheCurrentLeftNodeID() != null) {
                        DataModelExportBillV2Plugin.this.initSelectedTree();
                    }
                }
                DataModelExportBillV2Plugin.this.getPageCache().put(DataModelExportBillV2Plugin.EXPORT_TAB, key);
                DataModelExportBillV2Plugin.this.setMulti2DimTree();
            }
        });
    }

    private void setMulti2DimTree() {
        TreeView tree = (TreeView)this.getView().getControl(DIM_TREE_VIEW);
        if (StringUtils.equals((String)this.getCacheExportMode(), (String)"exportall")) {
            tree.setMulti(false);
        } else if (StringUtils.equals((String)this.getCacheExportMode(), (String)"exportselect")) {
            tree.setMulti(true);
        } else {
            return;
        }
    }

    private void getRightTreeByLeftTree() {
        if (!StringUtils.isEmpty((String)this.getCacheCurrentLeftNodeID())) {
            this.refreshRightTree();
            this.refreshSelectedTree();
        }
    }

    public void clickTreeNode(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        TreeView source = (TreeView)evt.getSource();
        if (MODEL_TREE_VIEW.equals(source.getKey())) {
            this.cacheModelNode(nodeId);
            if (modelTreeRootNodeId.equals(nodeId)) {
                TreeView treeRight = (TreeView)this.getView().getControl(DIM_TREE_VIEW);
                treeRight.deleteAllNodes();
                TreeView treeSelected = (TreeView)this.getView().getControl(DIM_SELECT_TREE);
                treeSelected.deleteAllNodes();
            } else {
                this.getRightTreeByLeftTree();
            }
        }
    }

    private void putClickNodeToCache(TreeNode clickNode, String caheTreeKey) {
        if (StringUtils.isNotBlank((String)caheTreeKey)) {
            this.getPageCache().put(caheTreeKey, SerializationUtils.toJsonString((Object)clickNode));
        }
    }

    private void refreshRightTree() {
        this.initRightTree();
        Search searchSelected = (Search)this.getControl(DIM_SEARCH_CONTROL);
        searchSelected.setSearchKey("");
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(DIM_TREE_VIEW, CACHE_DIM_TREE, "_1"));
    }

    private void refreshSelectedTree() {
        this.initSelectedTree();
        Search searchSelected = (Search)this.getControl(DIM_SEARCH_CONTROL_1);
        searchSelected.setSearchKey("");
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(DIM_SELECT_TREE, CACHE_SELECT_DIM_TREE, "_2"));
    }

    private void initRightTree() {
        TreeView treeRight = (TreeView)this.getView().getControl(DIM_TREE_VIEW);
        if (StringUtils.equals((String)this.getCacheExportMode(), (String)"exportall")) {
            treeRight.setMulti(false);
        } else {
            treeRight.setMulti(true);
        }
        TreeNode rightNode = this.generateRightTree();
        treeRight.deleteAllNodes();
        treeRight.addNode(rightNode);
        this.spreadAllNode(rightNode);
        this.cacheRootNode(rightNode, CACHE_DIM_TREE);
        this.cacheRightTreeRootNode(rightNode);
        this.getPageCache().put(CACHE_DIM_TREE_NODE, null);
    }

    private void initSelectedTree() {
        TreeView treeRight = (TreeView)this.getView().getControl(DIM_SELECT_TREE);
        treeRight.setMulti(true);
        TreeNode selectNode = this.generateSelectedTree();
        treeRight.deleteAllNodes();
        treeRight.addNode(selectNode);
        this.spreadAllNode(selectNode);
        this.cacheRootNode(selectNode, CACHE_SELECT_DIM_TREE);
    }

    private Map<String, TreeNode> getCacheRightTreeRootNode() {
        HashMap<String, TreeNode> rootMap = null;
        String cache = this.getPageCache().get(CACHE_RIGHT_TREE_ROOT_NODE);
        rootMap = StringUtils.isNotBlank((String)cache) ? (HashMap<String, TreeNode>)ObjectSerialUtil.deSerializedBytes((String)cache) : new HashMap<String, TreeNode>(16);
        return rootMap;
    }

    private void cacheRightTreeRootNode(TreeNode root) {
        Map<String, TreeNode> rootMap = this.getCacheRightTreeRootNode();
        if (rootMap != null) {
            rootMap.put(this.getCacheCurrentLeftNodeID(), root);
        }
        this.getPageCache().put(CACHE_RIGHT_TREE_ROOT_NODE, ObjectSerialUtil.toByteSerialized(rootMap));
    }

    private TreeNode generateRightTree() {
        TreeNode rootRight = new TreeNode();
        rootRight.setId(baseDataTreeRootNodeId);
        rootRight.setText(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"DataModelExportBillV2Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rootRight.setParentid("");
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("name", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"DataModelExportBillV2Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        data.put("level", "1");
        data.put("id", baseDataTreeRootNodeId);
        rootRight.setData(data);
        Long modelId = Long.valueOf(this.getCacheCurrentLeftNodeID());
        List<String> numbers = DataModelTransEnum.getNumberByLevel(0);
        numbers.addAll(DataModelTransEnum.getNumberByLevel(1));
        numbers.remove(DataModelTransEnum.model.getNumber());
        this.filter4NewEbApp(numbers);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        for (String number : numbers) {
            DataModelTransEnum dataModel = DataModelTransEnum.getEnumByNumber(number);
            TreeNode node = new TreeNode();
            node.setId(dataModel.getNumber());
            node.setText(dataModel.getChineseName());
            node.setLongNumber(dataModel.getNumber());
            node.setType(dataModel.getFormID());
            node.setParentid(rootRight.getId());
            HashMap<String, String> data1 = new HashMap<String, String>();
            data1.put("id", String.valueOf(dataModel.getDseq()));
            data1.put("name", dataModel.getChineseName());
            data1.put("number", dataModel.getNumber());
            data1.put("level", "2");
            node.setData(data1);
            treeNodes.add(node);
            if (node.getChildren() != null && node.getChildren().size() != 0) continue;
        }
        rootRight.setChildren(treeNodes);
        return rootRight;
    }

    private TreeNode generateSelectedTree() {
        TreeNode rootRight = new TreeNode();
        rootRight.setId(baseDataTreeRootNodeId);
        rootRight.setText(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"DataModelExportBillV2Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rootRight.setParentid("");
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("name", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"DataModelExportBillV2Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        data.put("level", "1");
        data.put("id", baseDataTreeRootNodeId);
        rootRight.setData(data);
        return rootRight;
    }

    private String getCacheExportMode() {
        return this.getPageCache().get(EXPORT_TAB);
    }

    private void cacheModelNode(String nodeId) {
        this.getPageCache().put(CURRENT_MODEL_NODE_ID, nodeId);
        this.getPageCache().remove(CURRENT_DIM_NODE_ID);
        TreeNode root = this.getCacheRootNode(CACHE_MODEL_TREE);
        if (root != null) {
            TreeNode node = root.getTreeNode(nodeId, 10);
            this.putClickNodeToCache(node, CLICK_LEFT_NODE_CACHE);
        }
    }

    private String getCacheCurrentLeftNodeID() {
        return this.getPageCache().get(CURRENT_MODEL_NODE_ID);
    }

    private void addTreeNodeCheckListeners() {
        TreeView treeRight = (TreeView)this.getView().getControl(DIM_TREE_VIEW);
        treeRight.addTreeNodeCheckListener(new TreeNodeCheckListener(){

            public void treeNodeCheck(TreeNodeCheckEvent evt) {
                DataModelExportBillV2Plugin.this.checkTreeNode(evt);
            }
        });
    }

    private TreeNode getCacheRootNode(String cacheTreeKey) {
        String cache = this.getPageCache().get(cacheTreeKey);
        if (StringUtils.isNotEmpty((String)cache)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
        }
        return null;
    }

    private void checkTreeNode(TreeNodeCheckEvent evt) {
        TreeNode root = null;
        TreeView source = (TreeView)evt.getSource();
        String nodeId = evt.getNodeId().toString();
        boolean isChecked = evt.getChecked();
        if (!DIM_TREE_VIEW.equals(source.getKey())) {
            return;
        }
        root = this.getCacheRootNode(CACHE_DIM_TREE);
        if (root != null) {
            TreeNode treeNode = root.getTreeNode(nodeId, 10);
            this.cacheCheckedTreeNodes(treeNode, isChecked);
        }
    }

    private void cacheCheckedTreeNodes(TreeNode treeNode, boolean isChecked) {
        TreeView tree = (TreeView)this.getView().getControl(DIM_TREE_VIEW);
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds.contains(baseDataTreeRootNodeId)) {
            this.cacheAllCheckedModel(true);
        } else {
            this.cacheAllCheckedModel(false);
        }
        Map<String, List<TreeNode>> treeNodeMap = this.getCacheCheckedRightTreeNodes();
        List<TreeNode> treeNodes = treeNodeMap.get(this.getCacheCurrentLeftNodeID());
        if (null == treeNodes) {
            treeNodes = new ArrayList<TreeNode>(16);
        }
        this.putTreeNode2List(treeNodes, treeNode, isChecked);
        treeNodeMap.put(this.getCacheCurrentLeftNodeID(), treeNodes);
        this.getPageCache().put(CACHE_DIM_TREE_NODE, ObjectSerialUtil.toByteSerialized(treeNodeMap));
    }

    private void putTreeNode2List(List<TreeNode> treeNodes, TreeNode treeNode, boolean isChecked) {
        if (null == treeNodes) {
            return;
        }
        ArrayList<TreeNode> allChildren = new ArrayList<TreeNode>(16);
        this.getAllChildren(treeNode, allChildren);
        allChildren.forEach(child -> {
            if (isChecked) {
                if (!this.containsNode(treeNodes, (TreeNode)child)) {
                    treeNodes.add((TreeNode)child);
                }
            } else if (this.containsNode(treeNodes, (TreeNode)child)) {
                this.removeNode(treeNodes, (TreeNode)child);
            }
        });
    }

    private boolean containsNode(List<TreeNode> treeNodes, TreeNode treeNode) {
        for (TreeNode node : treeNodes) {
            if (!StringUtils.equals((String)treeNode.getId(), (String)node.getId())) continue;
            return true;
        }
        return false;
    }

    private void removeNode(List<TreeNode> treeNodes, TreeNode treeNode) {
        Iterator<TreeNode> iterator = treeNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (!StringUtils.equals((String)treeNode.getId(), (String)node.getId())) continue;
            iterator.remove();
        }
    }

    private void getAllChildren(TreeNode treeNode, List<TreeNode> treeNodes) {
        treeNodes.add(treeNode);
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            for (TreeNode node : treeNode.getChildren()) {
                if (node != null && node.getChildren() != null) {
                    treeNodes.addAll(node.getChildren());
                }
                this.getAllChildren(node, treeNodes);
            }
        }
    }

    private Map<String, List<TreeNode>> getCacheCheckedRightTreeNodes() {
        HashMap<String, List<TreeNode>> treeNodeMap = null;
        String treeNodeCache = this.getPageCache().get(CACHE_DIM_TREE_NODE);
        treeNodeMap = StringUtils.isNotBlank((String)treeNodeCache) ? (HashMap<String, List<TreeNode>>)ObjectSerialUtil.deSerializedBytes((String)treeNodeCache) : new HashMap<String, List<TreeNode>>(16);
        return treeNodeMap;
    }

    private void cacheAllCheckedModel(boolean isChecked) {
        Set<String> modelIds = this.getCacheAllCheckedModel();
        if (isChecked) {
            modelIds.add(this.getCacheCurrentLeftNodeID());
        } else {
            Iterator<String> iterator = modelIds.iterator();
            while (iterator.hasNext()) {
                String id = iterator.next();
                if (!StringUtils.equals((String)id, (String)this.getCacheCurrentLeftNodeID())) continue;
                iterator.remove();
            }
        }
        this.getPageCache().put(CACHE_MODEL_CHECK_ALL_NODE, ObjectSerialUtil.toByteSerialized(modelIds));
    }

    private Set<String> getCacheAllCheckedModel() {
        HashSet<String> set = null;
        String cache = this.getPageCache().get(CACHE_MODEL_CHECK_ALL_NODE);
        set = StringUtils.isNotBlank((String)cache) ? (HashSet<String>)ObjectSerialUtil.deSerializedBytes((String)cache) : new HashSet<String>(16);
        return set;
    }

    private void addTreeNodeClickListeners() {
        TreeView treeLeft = (TreeView)this.getView().getControl(MODEL_TREE_VIEW);
        treeLeft.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                if (DataModelExportBillV2Plugin.this.isClickedTheSameNode(evt)) {
                    return;
                }
                DataModelExportBillV2Plugin.this.clickTreeNode(evt);
            }
        });
    }

    private boolean isClickedTheSameNode(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        TreeView source = (TreeView)evt.getSource();
        if (MODEL_TREE_VIEW.equals(source.getKey())) {
            return StringUtils.equals((String)nodeId, (String)this.getCacheCurrentLeftNodeID());
        }
        if (DIM_TREE_VIEW.equals(source.getKey())) {
            return StringUtils.equals((String)nodeId, (String)this.getCacheCurrentRightNodeID());
        }
        return false;
    }

    private String getCacheCurrentRightNodeID() {
        return this.getPageCache().get(CURRENT_DIM_NODE_ID);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
        this.setTabVisible();
        this.cacheExportMode();
    }

    private void setTabVisible() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if ("exportall".equalsIgnoreCase(currentTab)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap8"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9", "flexpanelap10"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap8", "flexpanelap9", "flexpanelap10"});
        }
    }

    private void cacheExportMode() {
        String key = ((Tab)this.getControl("tabap")).getCurrentTab();
        this.getPageCache().put(EXPORT_TAB, key);
    }

    private void initLeftTree() {
        TreeView treeLeft = (TreeView)this.getView().getControl(MODEL_TREE_VIEW);
        TreeNode leftNode = this.generateLeftTree();
        treeLeft.deleteAllNodes();
        treeLeft.addNode(leftNode);
        if (leftNode != null) {
            leftNode.setIsOpened(true);
        }
        this.cacheRootNode(leftNode, CACHE_MODEL_TREE);
    }

    public static List<QFilter> getModelFilter(IFormView view) {
        QFilter qf = ModelUtil.getModelQfilterByApp((IFormView)view);
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        modelQFilters.add(qf);
        if (view.getParentView() != null) {
            if ("epm_user_assignperm".equals(view.getParentView().getEntityId())) {
                Set ids = ModelServiceHelper.getLimitedModelListByUser(null);
                modelQFilters.add(new QFilter("id", "in", (Object)ids));
            } else {
                String source = view.getEntityId();
                if (view instanceof ListView && "bos_list".equals(source)) {
                    source = ((ListView)view).getBillFormId();
                } else if (view instanceof ListView && "bos_templatetreelist".equals(source)) {
                    source = ((ListView)view).getBillFormId();
                } else if (view instanceof ListView && "bos_treelist".equals(source)) {
                    source = ((ListView)view).getBillFormId();
                }
                QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
                modelQFilters.add(superid);
            }
        }
        return modelQFilters;
    }

    private TreeNode generateLeftTree() {
        TreeNode rootleft = new TreeNode();
        rootleft.setId(modelTreeRootNodeId);
        rootleft.setText(ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"DataModelExportBillV2Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rootleft.setParentid("");
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("name", ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"DataModelExportBillV2Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        data.put("level", "1");
        data.put("id", modelTreeRootNodeId);
        rootleft.setData(data);
        Object appId = this.getView().getFormShowParameter().getCustomParam("special_appId");
        QFilter qFilter = appId == null ? ModelUtil.getModelQfilterByApp((IFormView)this.getView()) : new QFilter("ReportType", "=", (Object)appId.toString());
        DynamicObjectCollection modelList = QueryServiceHelper.query((String)"epm_model", (String)"id,name,number,shownumber, level, parentnumber", (QFilter[])qFilter.toArray(), (String)"createtime desc");
        if (CollectionUtils.isEmpty((Collection)modelList)) {
            return rootleft;
        }
        Set limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser();
        HashMap<String, TreeNode> modelTreeNodeMap = new HashMap<String, TreeNode>(16);
        for (Object model : modelList) {
            TreeNode node = new TreeNode();
            node.setId(model.getString("id"));
            node.setText(model.getString("name") + '(' + model.getString("shownumber") + ')');
            node.setLongNumber(model.getString("shownumber"));
            node.setParentid(rootleft.getId());
            HashMap<String, String> data1 = new HashMap<String, String>();
            data1.put("id", model.getString("id"));
            data1.put("name", model.getString("name"));
            data1.put("number", model.getString("shownumber"));
            data1.put("level", model.getInt("level") + 2 + "");
            node.setData(data1);
            modelTreeNodeMap.put(model.getString("shownumber"), node);
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        for (DynamicObject model : modelList) {
            String shownumber = model.getString("shownumber");
            TreeNode treeNode = (TreeNode)modelTreeNodeMap.get(shownumber);
            if (treeNode == null) continue;
            String parentnumber = model.getString("parentnumber");
            if (StringUtils.isEmpty((String)parentnumber)) {
                treeNodes.add(treeNode);
                continue;
            }
            TreeNode parentTreeNode = (TreeNode)modelTreeNodeMap.get(parentnumber);
            if (parentTreeNode == null) {
                treeNodes.add(treeNode);
                continue;
            }
            treeNode.setParentid(parentTreeNode.getId());
            parentTreeNode.addChild(treeNode);
        }
        Iterator iterator = treeNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            String id = treeNode.getId();
            Map dataMap = (Map)treeNode.getData();
            String levelStr = (String)dataMap.get("level");
            int level = Integer.parseInt(levelStr);
            if (level > 3) {
                iterator.remove();
                continue;
            }
            if (limitedModelListByUser.contains(IDUtils.toLong((Object)id))) continue;
            iterator.remove();
        }
        rootleft.setChildren(treeNodes);
        return rootleft;
    }

    private void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
    }

    private void cacheRootNode(TreeNode root, String cacheTreeKey) {
        if (StringUtils.isNotBlank((String)cacheTreeKey)) {
            this.getPageCache().put(cacheTreeKey, SerializationUtils.toJsonString((Object)root));
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey().toLowerCase()) {
            case "searchbefore": {
                if (!this.checkResultList("resultList")) break;
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(MODEL_TREE_VIEW, CACHE_MODEL_TREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                if (!this.checkResultList("resultList")) break;
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(MODEL_TREE_VIEW, CACHE_MODEL_TREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "dimsearchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(DIM_TREE_VIEW, CACHE_DIM_TREE, "_1", TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "dimsearchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(DIM_TREE_VIEW, CACHE_DIM_TREE, "_1", TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "selectsearchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(DIM_SELECT_TREE, CACHE_SELECT_DIM_TREE, "_2", TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "selectsearchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(DIM_SELECT_TREE, CACHE_SELECT_DIM_TREE, "_2", TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "go": {
                this.goNode();
                break;
            }
            case "back": {
                this.backNode();
                break;
            }
        }
    }

    private boolean checkResultList(String resultList) {
        String rowcache = this.getPageCache().get(resultList);
        if (rowcache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u6216\u7f16\u7801\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"DataModelExportBillV2Plugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        String actionKey;
        super.itemClick(evt);
        switch (actionKey = evt.getItemKey()) {
            case "importap": {
                this.doImport();
                break;
            }
            case "exportap": {
                this.exportModel();
                break;
            }
            case "refreshap": {
                this.doRefresh();
                this.getRightTreeByLeftTree();
                TreeNode node = this.getClickNodeFromCache(CLICK_LEFT_NODE_CACHE);
                if (node == null) break;
                TreeView tree = (TreeView)this.getView().getControl(MODEL_TREE_VIEW);
                tree.focusNode(node);
                break;
            }
            case "btn_transport_log": {
                this.openModelTransportLogForm();
                break;
            }
            case "btn_periodtime": {
                this.repairPeriod();
                break;
            }
            case "btn_prepareisleaf": {
                this.repairDimMemberLeaf();
                break;
            }
        }
    }

    private void openModelTransportLogForm() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bgmd_modeltransport_log");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        openStyle.setInlineStyleCss(css);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(true);
        showParameter.setLookUp(false);
        ArrayList filters = Lists.newArrayList();
        filters.add(new QFilter("creater", "=", (Object)this.getUserId()));
        showParameter.getListFilterParameter().setQFilters((List)filters);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void repairDimMemberLeaf() {
        TreeNode node = this.getClickNodeFromCache(CLICK_LEFT_NODE_CACHE);
        if (node != null && !StringUtils.equals((String)modelTreeRootNodeId, (String)node.getId())) {
            DataModelIsLeafUtil.repairDimMemberLeafStatus(Long.parseLong(node.getId()), true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u590d\u5b8c\u6210\u3002", (String)"DataModelExportBillV2Plugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void repairPeriod() {
        TreeNode node = this.getClickNodeFromCache(CLICK_LEFT_NODE_CACHE);
        if (node == null || StringUtils.equals((String)modelTreeRootNodeId, (String)node.getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u4f53\u7cfb\u3002", (String)"DataModelExportBillV2Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (DataModelRepairPeriod.getInstance().repairPeriod(Long.parseLong(node.getId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u590d\u5b8c\u6210\u3002", (String)"DataModelExportBillV2Plugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void doRefresh() {
        this.initLeftTree();
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("exportall");
        tab.selectTab("exportall");
        this.cacheExportMode();
        this.cleanTree();
    }

    private void cleanTree() {
        TreeView tree = (TreeView)this.getView().getControl(DIM_TREE_VIEW);
        TreeView treeSelect = (TreeView)this.getView().getControl(DIM_SELECT_TREE);
        tree.deleteAllNodes();
        treeSelect.deleteAllNodes();
    }

    private void goNode() {
        TreeView treeSelected = (TreeView)this.getView().getControl(DIM_SELECT_TREE);
        TreeView treeRight = (TreeView)this.getView().getControl(DIM_TREE_VIEW);
        TreeNode selectRoot = this.getCacheRootNode(CACHE_SELECT_DIM_TREE);
        Map<String, List<TreeNode>> treeNodeMap = this.getCacheCheckedRightTreeNodes();
        if (treeNodeMap == null || treeNodeMap.size() == 0) {
            return;
        }
        this.addNodeToSelectedTree(selectRoot, treeNodeMap.get(this.getCacheCurrentLeftNodeID()));
        List checkedSelNodeIds = treeSelected.getTreeState().getCheckedNodeIds();
        List checkedRightNodeIds = treeRight.getTreeState().getCheckedNodeIds();
        treeSelected.uncheckNodes(checkedSelNodeIds);
        treeRight.uncheckNodes(checkedRightNodeIds);
        this.cacheRootNode(selectRoot, CACHE_SELECT_DIM_TREE);
        this.getPageCache().put(CACHE_DIM_TREE_NODE, null);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        TreeNodeUtils.treeConvertList((TreeNode)selectRoot, list);
        this.cacheSelectNodeList(list);
    }

    private void cacheSelectNodeList(List<TreeNode> list) {
        this.getPageCache().put(CACHE_SELECT_TREE_NODES, ObjectSerialUtil.toByteSerialized(list));
    }

    private List<TreeNode> getCacheSelectNodeList() {
        ArrayList<TreeNode> treeList = null;
        String treeNodeCache = this.getPageCache().get(CACHE_SELECT_TREE_NODES);
        treeList = StringUtils.isNotBlank((String)treeNodeCache) ? (ArrayList<TreeNode>)ObjectSerialUtil.deSerializedBytes((String)treeNodeCache) : new ArrayList<TreeNode>(16);
        return treeList;
    }

    private void backNode() {
        TreeView treeSelected = (TreeView)this.getView().getControl(DIM_SELECT_TREE);
        List checkedNodeIds = treeSelected.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds == null || checkedNodeIds.size() == 0) {
            return;
        }
        if (checkedNodeIds != null && checkedNodeIds.contains(baseDataTreeRootNodeId)) {
            checkedNodeIds.remove(baseDataTreeRootNodeId);
        }
        treeSelected.deleteNodes(checkedNodeIds);
        TreeNode selectRoot = this.getCacheRootNode(CACHE_SELECT_DIM_TREE);
        if (selectRoot == null) {
            return;
        }
        List<TreeNode> selectNodeList = this.getCacheSelectNodeList();
        Iterator<TreeNode> iterator = selectNodeList.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            String id = node.getId();
            if (!checkedNodeIds.contains(id)) continue;
            iterator.remove();
            selectRoot.deleteChildNode(id);
        }
        this.cacheRootNode(selectRoot, CACHE_SELECT_DIM_TREE);
        this.cacheSelectNodeList(selectNodeList);
    }

    private void addNodeToSelectedTree(TreeNode selectRoot, List<TreeNode> nodes) {
        if (nodes == null) {
            return;
        }
        List nodeIds = nodes.stream().map(e -> e.getId()).collect(Collectors.toList());
        HashSet<String> notExist = new HashSet<String>(16);
        for (TreeNode treeNode : nodes) {
            if (baseDataTreeRootNodeId.equals(treeNode.getId()) || baseDataTreeRootNodeId.equals(treeNode.getParentid()) || nodeIds.contains(treeNode.getParentid())) continue;
            notExist.add(treeNode.getParentid());
        }
        TreeNode root = this.getCacheRootNode(CACHE_DIM_TREE);
        if (root == null) {
            return;
        }
        for (String s : notExist) {
            List childPathNodes = root.getChildPathNodes(s);
            Iterator iterator = childPathNodes.iterator();
            while (iterator.hasNext()) {
                TreeNode node = (TreeNode)iterator.next();
                if (!baseDataTreeRootNodeId.equals(node.getId())) continue;
                iterator.remove();
            }
            nodes.addAll(0, childPathNodes);
        }
        Collections.sort(nodes, new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                Map data1 = (Map)o1.getData();
                Map data2 = (Map)o2.getData();
                if (data1 != null && StringUtils.isNotEmpty((String)((String)data1.get("level"))) && data2 != null && StringUtils.isNotEmpty((String)((String)data2.get("level")))) {
                    return ((String)data1.get("level")).compareTo((String)data2.get("level"));
                }
                return 0;
            }
        });
        for (TreeNode node : nodes) {
            List childrens;
            node.setChildren(null);
            TreeNode parent = selectRoot.getTreeNode(node.getParentid(), 10);
            if (parent == null || (childrens = parent.getChildren()) != null && this.containsNode(childrens, node)) continue;
            parent.addChild(node);
        }
        TreeView treeView = (TreeView)this.getView().getControl(DIM_SELECT_TREE);
        treeView.addNodes(nodes);
    }

    private TreeNode getCurrentSelectTreeNode() {
        return this.getClickNodeFromCache(CLICK_LEFT_NODE_CACHE);
    }

    private void exportModel() {
        TreeNode nodeInTree;
        TreeNode root;
        DataModelReadJsonFile.deleteTimeOutFile(DataModelReadJsonFile.export_temp_file_prefix);
        TreeNode node = this.getCurrentSelectTreeNode();
        if (node == null || StringUtils.equals((String)modelTreeRootNodeId, (String)node.getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"DataModelExportBillV2Plugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectModelId = node.getId();
        if (StringUtils.isEmpty((String)selectModelId)) {
            return;
        }
        String parentid = node.getParentid();
        if (StringUtils.isNotEmpty((String)parentid) && !modelTreeRootNodeId.equals(parentid) && (root = this.getCacheRootNode(CACHE_MODEL_TREE)) != null && (nodeInTree = this.findNodeInTree(root, parentid)) != null && !nodeInTree.getId().equals(root.getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5355\u72ec\u5bfc\u51fa\u5b50\u5b59\u4f53\u7cfb\uff0c\u8bf7\u9009\u62e9\u4e3b\u4f53\u7cfb\u5bfc\u51fa\u3002", (String)"DataModelExportBillV2Plugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set allSubIds = BgmdMainSubControlHelper.getInstance().getAllSubIds(IDUtils.toLong((Object)selectModelId));
        if (CollectionUtils.isEmpty((Collection)allSubIds)) {
            DataModelExportRequest exportRequest = this.createExportRequest(Collections.singletonList(IDUtils.toLong((Object)selectModelId)));
            Map data = (Map)node.getData();
            String name = (String)data.get("name");
            String number = (String)data.get("number");
            DMSpecialFeildTemplate.getInstance().exportCheckTemplateUpdate(IDUtils.toLong((Object)selectModelId), this.getView());
            DataModelExportController.getInstance().exportModel(exportRequest, this.getView(), this, number, name);
            this.writeLog(number, "export", new MultiLangEnumBridge("\u4f53\u7cfb\u5bfc\u51fa", "DataModelExportController_01", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\u201c%1$s\u201d\u5bfc\u51fa\u3002", "DataModelExportController_02", "epm-eb-formplugin"), new String[]{name});
        } else {
            this.openExportRangeForm(node);
        }
    }

    private TreeNode findNodeInTree(TreeNode node, String findNodeId) {
        if (StringUtils.isEmpty((String)findNodeId) || node == null) {
            return null;
        }
        if (StringUtils.equals((String)findNodeId, (String)node.getId())) {
            return node;
        }
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return null;
        }
        for (TreeNode child : children) {
            TreeNode nodeInTree = this.findNodeInTree(child, findNodeId);
            if (nodeInTree == null) continue;
            return nodeInTree;
        }
        return null;
    }

    private void openExportRangeForm(TreeNode node) {
        if (node == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bgmd_modelexportrange");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getCustomParams().put("selectModelId", node.getId());
        Object data = node.getData();
        if (data instanceof Map) {
            Map nodeDataMap = (Map)data;
            String number = (String)nodeDataMap.get("number");
            if (StringUtils.isEmpty((String)number)) {
                return;
            }
            formShowParameter.getCustomParams().put("selectModelNumber", number);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_EXPORT_MODEL_RANGE));
        this.getView().showForm(formShowParameter);
    }

    private DataModelExportRequest createExportRequest(List<Long> modelIdList) {
        DataModelExportRequest dataModelExportRequest = new DataModelExportRequest();
        if (CollectionUtils.isEmpty(modelIdList)) {
            return null;
        }
        dataModelExportRequest.setExportModelIdList(modelIdList);
        dataModelExportRequest.setExportType(OutputTypeEnum.DEFAULT);
        dataModelExportRequest.setCheckDataValiad((Boolean)this.getModel().getValue("docheckdatavaliad"));
        dataModelExportRequest.setBreakOutput((Boolean)this.getModel().getValue("breakoutput"));
        dataModelExportRequest.setUseMultiThread((Boolean)this.getModel().getValue("usemultithread"));
        dataModelExportRequest.setUseEncry((Boolean)this.getModel().getValue("useencry"));
        return dataModelExportRequest;
    }

    private String getExportUrls(DataModelExportParam dmParam) {
        DataModelImportResult result = new DataModelExportMain().dataModelExport(dmParam);
        DataModelFormCommon.logTipInfoToFile(result, dmParam.getModelNumber() + "_out", this.getView());
        return result.getOutFileUrl();
    }

    public void stop() {
    }

    public void start() {
    }

    private TreeNode getClickNodeFromCache(String caheTreeKey) {
        if (StringUtils.isNotBlank((String)caheTreeKey)) {
            String treeNode = this.getPageCache().get(caheTreeKey);
            return StringUtils.isBlank((String)treeNode) ? null : (TreeNode)SerializationUtils.fromJsonString((String)treeNode, TreeNode.class);
        }
        return null;
    }

    private void doImport() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_dataimport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (NewEbAppUtil.isNewEbApp((IFormView)this.getView())) {
            showParameter.setCustomParam("newEbForm", (Object)"true");
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_IMPORT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        block16: {
            super.closedCallBack(evt);
            String actionKey = evt.getActionId();
            Object backData = evt.getReturnData();
            if (StringUtils.equals((String)actionKey, (String)BTN_IMPORT)) {
                if (null == backData) {
                    return;
                }
                this.doRefresh();
                Map backDataMap = null;
                try {
                    backDataMap = (Map)SerializationUtils.fromJsonString((String)backData.toString(), Map.class);
                    String status = (String)backDataMap.get("status");
                    if (StringUtils.equals((String)"success", (String)status)) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DimMemberMapperPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        break block16;
                    }
                    this.getView().showTipNotification((String)backDataMap.get("message"));
                }
                catch (Exception e) {
                    this.getView().showSuccessNotification(backData.toString());
                }
            } else if (ACTION_EXPORT_MODEL_RANGE.equals(actionKey)) {
                DataModelFormClosedResult dataModelFormClosedResult;
                if (backData instanceof DataModelFormClosedResult && (dataModelFormClosedResult = (DataModelFormClosedResult)backData).getCode() == DataModelFormClosedResult.DataModelFormClosedResultCode.SUCCESS) {
                    List<Long> exportModelIdList = dataModelFormClosedResult.getExportModelIdList();
                    DataModelExportRequest exportRequest = this.createExportRequest(exportModelIdList);
                    TreeNode node = this.getCurrentSelectTreeNode();
                    if (node == null) {
                        return;
                    }
                    Map data = (Map)node.getData();
                    String name = (String)data.get("name");
                    String number = (String)data.get("number");
                    DataModelExportController.getInstance().exportModel(exportRequest, this.getView(), this, number, name);
                }
            } else if ("dataModelExportTaskAction".equals(actionKey) && backData != null) {
                Map backDataMap = (Map)backData;
                Map taskInfo = (Map)SerializationUtils.fromJsonString((String)((String)backDataMap.get("taskinfo")), HashMap.class);
                Map data = (Map)SerializationUtils.fromJsonString((String)((String)taskInfo.get("data")), HashMap.class);
                Object status = data.get("status");
                if (status == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"url\u4e3a\u7a7a\uff0c\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u4f53\u7cfb\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("success".equals(status)) {
                    DataModelImportResult result = (DataModelImportResult)SerializationUtils.deSerializeFromBase64((String)data.get("exportResult").toString());
                    if (StringUtils.isEmpty((String)result.getOutFileUrl())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"url\u4e3a\u7a7a\uff0c\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u4f53\u7cfb\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        DataModelFormCommon.getClientViewProxy(this.getView()).addAction("download", (Object)result.getOutFileUrl());
                    }
                } else {
                    this.getView().showTipNotification(data.get("exportResult").toString());
                }
            }
        }
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    private void filter4NewEbApp(List<String> formNumbs) {
        if (this.isNewEbForm()) {
            Set<String> newEbIgnoreForm = DataModelTransEnum.getNewEbIgnoreForm();
            formNumbs.removeIf(number -> newEbIgnoreForm.contains(number));
        }
    }
}

