/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataModelTrans.dto.DataModelFormClosedResult;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildTemplate;
import kd.epm.eb.model.permission.MemberPermHelper;

public class DataModelExportRangePlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
RowClickEventListener {
    private static final String TREEENTRYENTITY = "treeentryentity";
    private Set<Long> manageModelIds;
    private Set<Long> userPerm;
    private Boolean isAllPerm;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.renderTreeEntity();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDefault();
    }

    private void setDefault() {
        this.setDefaultSelectRows();
    }

    private void setDefaultSelectRows() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
        int[] rowsIndexs = new int[entryEntity.size()];
        for (int i = 0; i < entryEntity.size(); ++i) {
            rowsIndexs[i] = i;
        }
        this.getTreeEntryGrid().selectRows(rowsIndexs, 0);
        this.getPageCache().put("preSelectIndex", SerializationUtils.toJsonString((Object)rowsIndexs));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
        this.getTreeEntryGrid().addCellClickListener((TreeNodeQueryListener)this);
        this.getTreeEntryGrid().addRowClickListener((RowClickEventListener)this);
    }

    private Long getSelectModelId() {
        Object selectModelId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (selectModelId = customParams.get("selectModelId")) != null) {
            return IDUtils.toLong(selectModelId);
        }
        return 0L;
    }

    private String getSelectModelNumber() {
        Object selectModelNumber;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (selectModelNumber = customParams.get("selectModelNumber")) != null) {
            return selectModelNumber.toString();
        }
        return null;
    }

    private DynamicObjectCollection queryDirectLevelSubModelList(String selectModelNumber) {
        if (StringUtils.isEmpty((String)selectModelNumber)) {
            return null;
        }
        QFilter qFilter = new QFilter("parentnumber", "=", (Object)selectModelNumber);
        qFilter.and("reporttype", "=", (Object)"7");
        return QueryServiceHelper.query((String)"epm_model", (String)"id, shownumber, level, parentnumber, permcontrol", (QFilter[])qFilter.toArray());
    }

    private void expandAllSubModelList(String selectModelNumber, int beforeRowIndex, List<Integer> expandRows) {
        if (StringUtils.isEmpty((String)selectModelNumber)) {
            return;
        }
        Map<String, List<DynamicObject>> modelNumberMap = this.getSelectModelAllSubModelMap();
        this.expandSubModelList(selectModelNumber, modelNumberMap, beforeRowIndex, expandRows);
    }

    private Map<String, List<DynamicObject>> getSelectModelAllSubModelMap() {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(16);
        QFilter qFilter = new QFilter("reporttype", "=", (Object)"7");
        qFilter.and("parentnumber", "is not null", (Object)"");
        DynamicObjectCollection allSubModelList = QueryServiceHelper.query((String)"epm_model", (String)"id, shownumber, level, parentnumber, permcontrol", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)allSubModelList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u4f53\u7cfb\u3002", (String)"DataModelExportRangePlugin_003", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return result;
        }
        for (DynamicObject dynamicObject : allSubModelList) {
            List subModelList = result.computeIfAbsent(dynamicObject.getString("parentnumber"), t -> new ArrayList(16));
            subModelList.add(dynamicObject);
        }
        return result;
    }

    private List<DynamicObject> expandSubModelList(String parentNumber, Map<String, List<DynamicObject>> modelNumberMap, int beforeRowIndex, List<Integer> expandRows) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (modelNumberMap == null || modelNumberMap.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)parentNumber)) {
            return null;
        }
        List<DynamicObject> dynamicObjects = modelNumberMap.get(parentNumber);
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return null;
        }
        result.addAll(dynamicObjects);
        for (DynamicObject dynamicObject : dynamicObjects) {
            List<DynamicObject> subModelList;
            int newEntryRow = this.getModel().insertEntryRow(TREEENTRYENTITY, beforeRowIndex);
            long id = dynamicObject.getLong("id");
            this.getModel().setValue("model", (Object)id, newEntryRow);
            DynamicObject selectModelRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, newEntryRow);
            if (this.manageModelIds.contains(id)) {
                selectModelRow.set("permission", (Object)"1");
            } else if (this.userPerm.contains(id)) {
                selectModelRow.set("permission", (Object)"2");
            } else if (this.isAllPerm.booleanValue()) {
                selectModelRow.set("permission", (Object)"2");
            }
            if (!CollectionUtils.isNotEmpty(subModelList = this.expandSubModelList(dynamicObject.getString("shownumber"), modelNumberMap, newEntryRow, expandRows))) continue;
            result.addAll(subModelList);
            selectModelRow.set("isgroupnode", (Object)true);
            expandRows.add(newEntryRow);
        }
        return result;
    }

    private TreeEntryGrid getTreeEntryGrid() {
        return (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
    }

    private Boolean checkHasAllPerm() {
        String sql = "select fid from t_perm_superuser where fuserid = " + UserUtils.getUserId();
        try (DataSet ds = DB.queryDataSet((String)"queryPerm", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            if (ds.hasNext()) {
                Boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void renderTreeEntity() {
        String selectModelNumber = this.getSelectModelNumber();
        if (StringUtils.isEmpty((String)selectModelNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u4f53\u7cfb\u3002", (String)"DataModelExportRangePlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dynamicObjects = this.queryDirectLevelSubModelList(selectModelNumber);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u5b50\u4f53\u7cfb\u7684\u4f53\u7cfb\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"DataModelExportRangePlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long selectModelId = this.getSelectModelId();
        this.manageModelIds = MemberPermHelper.getLimitedModelListByUser();
        this.isAllPerm = this.checkHasAllPerm();
        QFilter filter = new QFilter("user.id", "=", (Object)UserUtils.getUserId());
        this.userPerm = FunPermissionHelper.getAllHasPermModel((QFilter[])new QFilter[]{filter});
        if (!this.manageModelIds.contains(selectModelId)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb\u201c%1\u201d\u6ca1\u6709\u7ba1\u7406\u6743\uff0c\u4e0d\u5141\u8bb8\u5bfc\u51fa\u3002", (String)"DataModelExportRangePlugin_004", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getSelectModelNumber()}));
            return;
        }
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        int newEntryRow = this.getModel().createNewEntryRow(TREEENTRYENTITY);
        this.getModel().setValue("model", (Object)selectModelId, newEntryRow);
        DynamicObject selectModelRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, newEntryRow);
        if (this.manageModelIds.contains(selectModelId)) {
            selectModelRow.set("permission", (Object)"1");
        } else if (this.userPerm.contains(selectModelId)) {
            selectModelRow.set("permission", (Object)"2");
        } else if (this.isAllPerm.booleanValue()) {
            selectModelRow.set("permission", (Object)"2");
        }
        selectModelRow.set("isgroupnode", (Object)true);
        ArrayList<Integer> expandRows = new ArrayList<Integer>(16);
        expandRows.add(newEntryRow);
        this.expandAllSubModelList(selectModelNumber, newEntryRow, expandRows);
        if (CollectionUtils.isNotEmpty(expandRows)) {
            int[] ints = expandRows.stream().mapToInt(t -> t).toArray();
            this.getTreeEntryGrid().expand(ints);
        }
        this.getModel().endInit();
        this.getView().updateView(TREEENTRYENTITY);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int[] selectRows = this.getTreeEntryGrid().getSelectRows();
        boolean contains = false;
        for (int selectRow : selectRows) {
            if (selectRow != 0) continue;
            contains = true;
            break;
        }
        if (!contains) {
            String preSelectIndex = this.getPageCache().get("preSelectIndex");
            if (StringUtils.isEmpty((String)preSelectIndex)) {
                this.getTreeEntryGrid().selectRows(0);
            } else {
                this.getTreeEntryGrid().selectRows((int[])SerializationUtils.fromJsonString((String)preSelectIndex, int[].class), 0);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u52fe\u9009\u7b2c\u4e00\u884c\u4f53\u7cfb\u3002", (String)"DataModelExportRangePlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("preSelectIndex", SerializationUtils.toJsonString((Object)selectRows));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(opkey)) {
            int[] selectRows = this.getTreeEntryGrid().getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u8981\u5bfc\u51fa\u7684\u4f53\u7cfb\u3002", (String)"DataModelExportRangePlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> exportModelIdList = new ArrayList<Long>(16);
            LinkedHashMap<String, DynamicObject> modelNumberMap = new LinkedHashMap<String, DynamicObject>(16);
            HashMap<String, String> rowIndexParentNumberMap = new HashMap<String, String>(16);
            HashMap<String, Set<String>> allSubModelParentMap = new HashMap<String, Set<String>>(16);
            this.getDirectSubModelMap(this.getSelectModelNumber(), allSubModelParentMap);
            for (int selectRow : selectRows) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TREEENTRYENTITY, selectRow);
                modelNumberMap.put(entryRowEntity.getString("model.shownumber"), entryRowEntity);
                exportModelIdList.add(entryRowEntity.getLong("model.id"));
                if (selectRow == 0) continue;
                rowIndexParentNumberMap.put(entryRowEntity.getString("model.shownumber"), entryRowEntity.getString("model.parentnumber"));
            }
            if (exportModelIdList.size() < 2) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5b58\u5728\u4e3b\u5b50\u5173\u7cfb\u7684\u4f53\u7cfb\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u5bfc\u51fa\u3002", (String)"DataModelExportRangePlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<String> lackParentNumbers = new HashSet<String>(16);
            HashSet<String> lackSubNumbers = new HashSet<String>(16);
            for (Map.Entry entry : rowIndexParentNumberMap.entrySet()) {
                Set subModelNumbers;
                String number = (String)entry.getKey();
                String parentNumber = (String)entry.getValue();
                DynamicObject dynamicObject = (DynamicObject)modelNumberMap.get(parentNumber);
                if (dynamicObject == null) {
                    lackParentNumbers.add(number);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(subModelNumbers = (Set)allSubModelParentMap.get(number)))) continue;
                boolean flag = false;
                for (String subModelNumber : subModelNumbers) {
                    if (!rowIndexParentNumberMap.containsKey(subModelNumber)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                lackSubNumbers.add(number);
            }
            if (CollectionUtils.isNotEmpty(lackParentNumbers)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u7684\u76f4\u63a5\u4e0a\u7ea7\u4f53\u7cfb\u672a\u52fe\u9009\uff0c\u8bf7\u8865\u5168\u540e\u5bfc\u51fa\u3002", (String)"DataModelExportRangePlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", lackParentNumbers)}));
                return;
            }
            if (CollectionUtils.isNotEmpty(lackSubNumbers)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u7684\u5b50\u4f53\u7cfb\u81f3\u5c11\u52fe\u9009\u4e00\u4e2a\uff0c\u8bf7\u8865\u5168\u540e\u5bfc\u51fa\u3002", (String)"DataModelExportRangePlugin_08", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", lackSubNumbers)}));
                return;
            }
            exportModelIdList.forEach(modelId -> DMSpecialFeildTemplate.getInstance().exportCheckTemplateUpdate((Long)modelId, this.getView().getParentView()));
            DataModelFormClosedResult dataModelFormClosedResult = new DataModelFormClosedResult();
            dataModelFormClosedResult.setCode(DataModelFormClosedResult.DataModelFormClosedResultCode.SUCCESS);
            dataModelFormClosedResult.setExportModelIdList(exportModelIdList);
            this.writeLog(null, "export", new MultiLangEnumBridge("\u4f53\u7cfb\u5bfc\u51fa", "DataModelExportController_01", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\u201c%1$s\u201d\u5bfc\u51fa\u3002", "DataModelExportController_02", "epm-eb-formplugin"), new String[]{StringUtils.join(modelNumberMap.keySet(), (char)',')});
            this.getView().returnDataToParent((Object)dataModelFormClosedResult);
            this.getView().close();
        }
    }

    private Set<Integer> getAllModelLevel(String modelNumber) {
        HashSet<Integer> result = new HashSet<Integer>(16);
        QFilter qFilter = new QFilter("reporttype", "=", (Object)"7");
        qFilter.and("parentnumber", "=", (Object)modelNumber);
        DynamicObjectCollection subModelList = QueryServiceHelper.query((String)"epm_model", (String)"level, shownumber", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)subModelList)) {
            return result;
        }
        for (DynamicObject dynamicObject : subModelList) {
            result.add(dynamicObject.getInt("level"));
            Set<Integer> levels = this.getAllModelLevel(dynamicObject.getString("shownumber"));
            if (!CollectionUtils.isNotEmpty(levels)) continue;
            result.addAll(levels);
        }
        return result;
    }

    private Set<String> getDirectSubModelMap(String modelNumber, Map<String, Set<String>> allSubModelParentMap) {
        Set result = allSubModelParentMap.computeIfAbsent(modelNumber, t -> new HashSet(16));
        QFilter qFilter = new QFilter("reporttype", "=", (Object)"7");
        qFilter.and("parentnumber", "=", (Object)modelNumber);
        DynamicObjectCollection subModelList = QueryServiceHelper.query((String)"epm_model", (String)"level, parentnumber,shownumber", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)subModelList)) {
            return null;
        }
        for (DynamicObject dynamicObject : subModelList) {
            String shownumber = dynamicObject.getString("shownumber");
            result.add(shownumber);
            this.getDirectSubModelMap(shownumber, allSubModelParentMap);
        }
        return result;
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        int rowKey = treeNodeEvent.getRowKey();
        Object model = this.getModel().getValue("model", rowKey);
        if (model == null) {
            return;
        }
        DynamicObject modelObj = (DynamicObject)model;
        DynamicObjectCollection subModelList = this.queryDirectLevelSubModelList(modelObj.getString("shownumber"));
        if (CollectionUtils.isEmpty((Collection)subModelList) || subModelList == null) {
            return;
        }
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        int[] ints = this.getModel().batchInsertEntryRow(TREEENTRYENTITY, rowKey, subModelList.size());
        int index = 0;
        Set<String> hasSubModelNumberSet = this.queryHasSubModelNumberSet(subModelList.stream().map(t -> t.getLong("id")).collect(Collectors.toSet()));
        for (DynamicObject dynamicObject : subModelList) {
            this.getModel().setValue("model", dynamicObject.get("id"), ints[index]);
            this.getModel().setValue("permission", dynamicObject.get("permcontrol"), ints[index]);
            if (hasSubModelNumberSet.contains(dynamicObject.getString("shownumber"))) {
                this.getModel().setValue("isgroupnode", (Object)true, ints[index]);
            }
            ++index;
        }
        this.getModel().endInit();
        this.getView().updateView(TREEENTRYENTITY);
        this.getTreeEntryGrid().selectRows(0);
    }

    private Set<String> queryHasSubModelNumberSet(Set<Long> modelIds) {
        HashSet<String> result = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(modelIds)) {
            return result;
        }
        QFilter qFilter = new QFilter("parentnumber", "is not null", (Object)"");
        qFilter.and("reporttype", "=", (Object)"7");
        DynamicObjectCollection hasParentModelList = QueryServiceHelper.query((String)"epm_model", (String)"parentnumber", (QFilter[])new QFilter[]{qFilter});
        return hasParentModelList.stream().map(t -> t.getString("parentnumber")).collect(Collectors.toSet());
    }
}

