/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.epm.eb.formplugin.dataModelTrans.constant.DataModelConstant;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import org.apache.commons.lang.StringUtils;

public class DataModelFormCommon {
    public static String logTipInfoToFile(DataModelImportResult result, String logFileName, IFormView formView) {
        JSONObject jsonData = DataModelFormCommon.getTipJsonObject(result);
        if (jsonData == null) {
            return null;
        }
        String url = DataModelCommon.getInstance().downloadJsonFile(jsonData, logFileName + "_ERR");
        DataModelFormCommon.getClientViewProxy(formView).addAction("download", (Object)url);
        formView.showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u5b58\u5728\u6570\u636e\u63d0\u793a\u4fe1\u606f\uff0c\u8bf7\u67e5\u770b\u9644\u4ef6\u3002", (String)"DataModelImportBillPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return url;
    }

    public static JSONObject getTipJsonObject(DataModelImportResult result) {
        Set<Object> tipInfos = result.getTipInfos();
        if (tipInfos == null || tipInfos.size() == 0) {
            return null;
        }
        JSONObject jsonData = new JSONObject(new LinkedHashMap(3 * DataModelConstant.ARRAYDEFAULTSIZE));
        JSONArray array = new JSONArray();
        for (Object tipInfo : tipInfos) {
            array.add((Object)tipInfo.toString());
        }
        jsonData.put("tipInfo", (Object)array);
        return jsonData;
    }

    public static void logSqlToFile(DataModelImportResult result, String logFileName, IFormView formView) {
        if (result == null) {
            return;
        }
        Map<String, List<Object[]>> sqlValues = result.getSqlValues();
        if (sqlValues == null || sqlValues.size() == 0) {
            return;
        }
        JSONObject jsonData = new JSONObject(new LinkedHashMap(3 * DataModelConstant.ARRAYDEFAULTSIZE));
        JSONArray array = new JSONArray();
        for (Map.Entry<String, List<Object[]>> entry : sqlValues.entrySet()) {
            array.add((Object)entry.getKey());
            List<Object[]> values = entry.getValue();
            for (Object[] value : values) {
                array.add((Object)StringUtils.join((Object[])value, (String)","));
            }
        }
        jsonData.put("sql", (Object)array);
        String url = DataModelCommon.getInstance().downloadJsonFile(jsonData, logFileName + "_SQL");
        DataModelFormCommon.getClientViewProxy(formView).addAction("download", (Object)url);
    }

    public static void downLoadJsonFile(JSONObject jsonObject, String logFileName, IFormView formView) {
        String url = DataModelCommon.getInstance().downloadJsonFile(jsonObject, logFileName + "_exportData");
        DataModelFormCommon.getClientViewProxy(formView).addAction("download", (Object)url);
    }

    public static IClientViewProxy getClientViewProxy(IFormView formView) {
        return (IClientViewProxy)formView.getService(IClientViewProxy.class);
    }
}

