/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.RedisTempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelTransportLogListPlugin
extends AbstractListPlugin {
    private TempFileCache cache;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    private BillList getBillList() {
        return (BillList)this.getControl("billlistap");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_download".equals(itemKey)) {
            BillList billList = this.getBillList();
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u4f20\u8f93\u65e5\u5fd7\u3002", (String)"DataModelTransportLogListPlugin_003", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bgmd_modeltransport_log", (String)"url, modelname", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
            RedisTempFileCache fileServerTempFileCache = new RedisTempFileCache();
            ArrayList<String> urlEmptyModels = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : query) {
                String url = dynamicObject.getString("url");
                String modelname = dynamicObject.getString("modelname");
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)url)) {
                    urlEmptyModels.add(modelname);
                    continue;
                }
                boolean exists = fileServerTempFileCache.exists(url);
                if (!exists) {
                    urlEmptyModels.add(modelname);
                    continue;
                }
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
            if (CollectionUtils.isNotEmpty(urlEmptyModels)) {
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u9009\u62e9\u7684\u4f53\u7cfb\u65e0\u53ef\u4e0b\u8f7d\u7684\u65e5\u5fd7\uff1a%1\u3002", (String)"DataModelTransportLogListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", urlEmptyModels)}), MessageBoxOptions.OK);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("delete".equals(operateKey)) {
            args.setCancel(true);
            ListSelectedRowCollection selectedRows = source.getListSelectedData();
            if (selectedRows.size() > 0) {
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
                qFilter.and("status", "!=", (Object)"2");
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bgmd_modeltransport_log", (String)"url, id, creater", (QFilter[])new QFilter[]{qFilter});
                ArrayList<Long> ids = new ArrayList<Long>(16);
                if (CollectionUtils.isNotEmpty((Collection)query)) {
                    for (DynamicObject dynamicObject : query) {
                        if (StringUtils.isNotEmpty((String)dynamicObject.getString("url"))) {
                            this.getCache().remove(dynamicObject.getString("url"));
                        }
                        ids.add(dynamicObject.getLong("id"));
                    }
                }
                if (ids.size() > 0) {
                    DeleteServiceHelper.delete((String)"bgmd_modeltransport_log", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                }
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
                billList.clearSelection();
                if (ids.size() > 0 && ids.size() == primaryKeyValues.length) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ExportFileListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (ids.size() > 0 && ids.size() < primaryKeyValues.length) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f,\u5df2\u81ea\u52a8\u6392\u9664\u8fdb\u884c\u4e2d\u7684\u8bb0\u5f55\u3002", (String)"DataModelTransportLogListPlugin_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u8fdb\u884c\u4e2d\u7684\u8bb0\u5f55\u3002", (String)"DataModelTransportLogListPlugin_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public TempFileCache getCache() {
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        }
        return this.cache;
    }
}

