/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.api;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.api.MainSubLoadModelJsonParam;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelICUtil;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubExportMain;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubImportMain;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelImportUtil;
import kd.epm.eb.formplugin.sonmodel.entity.MainSubModelPoJo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MainSubModelTransApi {
    private static volatile MainSubModelTransApi API = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MainSubModelTransApi getInstance() {
        if (API != null) return API;
        Class<MainSubModelTransApi> clazz = MainSubModelTransApi.class;
        synchronized (MainSubModelTransApi.class) {
            if (API != null) return API;
            API = new MainSubModelTransApi();
            // ** MonitorExit[var0] (shouldn't be in output)
            return API;
        }
    }

    private void getIcByEntitys(Long modelId, MainSubModelPoJo modelEntity, Map<String, Set<Long>> param) {
        if (modelEntity == null || modelEntity.getUpDimensionMap() == null) {
            return;
        }
        String entitySerialize = modelEntity.getUpDimensionMap().get(SysDimensionEnum.Entity.getNumber());
        if (!StringUtils.isEmpty((CharSequence)entitySerialize)) {
            Map serializes = (Map)SerializationUtils.deSerializeFromBase64((String)entitySerialize);
            HashMap<Long, Set<Long>> entityViewMemberIds = new HashMap<Long, Set<Long>>(serializes.size());
            for (Map.Entry serialize : serializes.entrySet()) {
                if (SysDimensionEnum.Entity.getNumber().equalsIgnoreCase((String)serialize.getKey()) || !StringUtils.isNumeric((CharSequence)((CharSequence)serialize.getKey()))) continue;
                entityViewMemberIds.put(Long.valueOf((String)serialize.getKey()), (Set<Long>)serialize.getValue());
            }
            DataModelICUtil.getInstance().addICInfos(modelId, entityViewMemberIds, true, param);
        }
    }

    public JSONObject loadModelJson(MainSubLoadModelJsonParam mainSubLoadModelJsonParam) {
        IModelCacheHelper mainModelCacheHelper = mainSubLoadModelJsonParam.getMainModelCacheHelper();
        IModelCacheHelper subModelCacheHelper = mainSubLoadModelJsonParam.getSubModelCacheHelper();
        Map<String, Set<Long>> param = mainSubLoadModelJsonParam.getParam();
        OutputTypeEnum transType = mainSubLoadModelJsonParam.getTransType();
        Long mainModelId = mainSubLoadModelJsonParam.getMainModelId();
        Date syncDate = mainSubLoadModelJsonParam.getSyncDate();
        MainSubModelPoJo modelEntity = mainSubLoadModelJsonParam.getModelEntity();
        if (mainModelCacheHelper == null) {
            mainModelCacheHelper = subModelCacheHelper;
        }
        Map<String, Set<Long>> arrangeParam = null;
        if (OutputTypeEnum.ALL != transType && param != null) {
            HashMap<String, Set<Long>> paramTemp = new HashMap<String, Set<Long>>(16);
            paramTemp.putAll(param);
            Set<Long> bizModelIdSet = param.get(DataModelTransEnum.bizmodel.getFormID());
            Set<Long> datasetIds = this.queryDatasetNumberList(bizModelIdSet, mainModelId);
            paramTemp.computeIfAbsent("eb_dataset", t -> new HashSet(16)).addAll(datasetIds);
            this.getIcByEntitys(mainModelId, modelEntity, paramTemp);
            arrangeParam = this.arrangeParam(paramTemp, mainModelCacheHelper, syncDate);
        } else {
            arrangeParam = param;
        }
        DMMainSubExportMain.LoadDataModelExportParam loadDataModelExportParam = new DMMainSubExportMain.LoadDataModelExportParam();
        loadDataModelExportParam.setTargetModelCacheHelper(subModelCacheHelper);
        loadDataModelExportParam.setFilterMap(arrangeParam);
        loadDataModelExportParam.setTransType(transType);
        loadDataModelExportParam.setSubModelSync(mainSubLoadModelJsonParam.isSubModelSync());
        loadDataModelExportParam.setSyncSpecialFilter(mainSubLoadModelJsonParam.isSyncSpecialFilter());
        loadDataModelExportParam.setSyncDate(mainSubLoadModelJsonParam.getSyncDate());
        Map<String, Object> resultMap = new DMMainSubExportMain(modelEntity).loadDataModelExport(loadDataModelExportParam);
        return (JSONObject)resultMap.get("data");
    }

    private Set<Long> queryDatasetNumberList(Set<Long> bizModelIdSet, Long mainModelId) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(bizModelIdSet) || IDUtils.isEmptyLong((Long)mainModelId).booleanValue()) {
            return result;
        }
        QFilter filter = new QFilter("model", "=", (Object)mainModelId);
        filter.and("businessmodel.id", "in", bizModelIdSet);
        DynamicObjectCollection datasetList = QueryServiceHelper.query((String)"eb_dataset", (String)"id,number", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)datasetList)) {
            return result;
        }
        for (DynamicObject dynamicObject : datasetList) {
            result.add(dynamicObject.getLong("id"));
        }
        return result;
    }

    private Map<String, Set<Long>> arrangeParam(Map<String, Set<Long>> param, IModelCacheHelper modelCacheHelper, Date syncDate) {
        Set datasetIdSet;
        LinkedHashMap<String, Set<Long>> result = new LinkedHashMap<String, Set<Long>>(16);
        if (param != null) {
            result.putAll(param);
        }
        if (CollectionUtils.isNotEmpty((Collection)(datasetIdSet = (Set)result.get(DataModelTransEnum.dataset.getFormID())))) {
            for (Long datasetId : datasetIdSet) {
                List dimensionList = modelCacheHelper.getDimensionList(datasetId);
                for (Dimension dimension : dimensionList) {
                    Map viewGroupViewsByDataSet;
                    List viewIds;
                    SysDimensionEnum enumByNumber;
                    if (dimension == null || SysDimensionEnum.Entity.getNumber().equalsIgnoreCase(dimension.getNumber()) || SysDimensionEnum.Account.getNumber().equalsIgnoreCase(dimension.getNumber()) || DataModelTransEnum.userdefine.getNumber().equalsIgnoreCase(dimension.getNumber()) || DataModelTransEnum.InternalCompany.getNumber().equalsIgnoreCase(dimension.getNumber()) || (enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimension.getNumber())) == null) continue;
                    Set strings = result.computeIfAbsent(enumByNumber.getMemberTreemodel(), t -> new HashSet(16));
                    List members = modelCacheHelper.getMembers(null, dimension.getNumber());
                    if (DataModelTransEnum.ChangeType.getNumber().equalsIgnoreCase(dimension.getNumber()) && CollectionUtils.isNotEmpty((Collection)(viewIds = (List)(viewGroupViewsByDataSet = modelCacheHelper.getViewGroupViewsByDataSet(datasetId)).get("ChangeType")))) {
                        Set ids = result.computeIfAbsent("eb_viewmember", v -> new HashSet(16));
                        for (Long viewId : viewIds) {
                            List memberList = modelCacheHelper.getMembers(viewId, "ChangeType");
                            ids.addAll(memberList.stream().map(member -> ((ViewMember)member).getVid()).collect(Collectors.toSet()));
                        }
                    }
                    for (Member member2 : members) {
                        strings.add(member2.getId());
                    }
                }
            }
        }
        return result;
    }

    public DataModelImportParam importModel(JSONObject json, DataModelImportResult[] resultArr, Long toModelId, String toModelNumber, String toModelName, Long toMainModelAdmin, Long datasourceId, String importType, boolean isSubSync, Date syncDate, Long executeUserId, int level, String description, String parentNumber, boolean isforceimport, Map<Long, Set<Long>> entityByIc, Set<String> excludeFormIds) {
        if (resultArr == null) {
            resultArr = new DataModelImportResult[1];
        }
        DataModelImportParam importParam = DataModelImportUtil.getImportParam(json.toString(), toModelNumber, toModelId, toModelName, datasourceId, importType);
        importParam.getMainSubImportParam().setMainSubModel(true);
        importParam.getMainSubImportParam().setSubSync(isSubSync);
        importParam.getMainSubImportParam().setToMainSubModelAdmin(toMainModelAdmin);
        importParam.getMainSubImportParam().setSyncDate(syncDate);
        importParam.getMainSubImportParam().setExecuteUserId(executeUserId);
        importParam.getMainSubImportParam().setParentLevel(level);
        importParam.getMainSubImportParam().setDescription(description);
        importParam.getMainSubImportParam().setParentNumber(parentNumber);
        importParam.getMainSubImportParam().setEntityByIc(entityByIc);
        importParam.setBreakImport(!isforceimport);
        importParam.getMainSubImportParam().setExcludeImportFormIds(excludeFormIds);
        resultArr[0] = new DMMainSubImportMain().doSave(importParam);
        return importParam;
    }
}

