/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.async.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataModelTrans.controller.DataModelTransportLogController;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportRequest;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelExportMain;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelExportTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(DataModelExportTask.class);
    private Long transportLogId;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        if (map == null) {
            this.feedbackProgress(100);
            return;
        }
        Object dataModelExportRequestObj = map.get("dataModelExportRequest");
        if (dataModelExportRequestObj == null) {
            this.feedbackProgress(100);
            return;
        }
        String errorMessage = "";
        try {
            DataModelExportRequest dataModelExportRequest = (DataModelExportRequest)SerializationUtils.deSerializeFromBase64((String)dataModelExportRequestObj.toString());
            List<DataModelExportParam> dataModelExportParamList = dataModelExportRequest.getDataModelExportParamList();
            if (CollectionUtils.isEmpty(dataModelExportParamList)) {
                this.feedbackProgress(100);
                return;
            }
            if (CollectionUtils.isEmpty(dataModelExportParamList)) {
                return;
            }
            DataModelExportMain dataModelExportMain = new DataModelExportMain(this);
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u4f53\u7cfb\u5bfc\u51fa", (String)"DataModelExportTask_04", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            this.transportLogId = dataModelExportRequest.getTransportLogId();
            DataModelImportResult result = dataModelExportParamList.size() == 1 ? dataModelExportMain.dataModelExport(dataModelExportParamList.get(0)) : dataModelExportMain.exportMainSubModel(dataModelExportRequest);
            if (result == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u4f53\u7cfb\u7684url\u4e3a\u7a7a\u3002", (String)"DataModelExportTask_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            returnData.put("exportResult", SerializationUtils.serializeToBase64((Object)result));
            returnData.put("status", "success");
            DataModelTransportLogController.getInstance().updateLog(IDUtils.toLong((Object)this.transportLogId), "1", null, result.getOutFileUrl(), 100);
            this.feedbackProgress(100);
            Thread.sleep(0L);
        }
        catch (Exception e) {
            DataModelUtil.doLog("export exception.", log);
            String message = e.getMessage();
            errorMessage = e instanceof KDBizException ? e.getMessage() : (e instanceof RuntimeException && StringUtils.isNotEmpty((String)message) && message.contains("java.lang.InterruptedException") ? ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u51fa\u8d85\u65f6\uff0c\u8bf7\u51cf\u5c11\u4f53\u7cfb\u4e2a\u6570\u6216\u8005\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DataModelExportTask_02", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u51fa\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"DataModelExportTask_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            returnData.put("status", "failed");
            returnData.put("exportResult", errorMessage);
            DataModelTransportLogController.getInstance().updateLog(IDUtils.toLong((Object)this.transportLogId), "0", errorMessage, null, -1);
            DataModelUtil.doLog("export exception.", log);
            log.error((Throwable)e);
        }
        this.feedbackCustomdata(returnData);
    }

    public void feedBackExportProgress(int progress) {
        this.feedbackProgress(progress);
        DataModelTransportLogController.getInstance().updateProgress(this.transportLogId, progress);
    }

    public boolean isTaskStop() {
        return this.isStop();
    }
}

