/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.async.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.DataModelFormCommon;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.controller.DataModelTransportLogController;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportRequest;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportMain;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class DataModelImportTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(DataModelImportTask.class);

    private DataModelImportParam getImportParam(DataModelImportRequest dataModelImportRequest) {
        String fileUrl = dataModelImportRequest.getFileUrl();
        String fromModelID = dataModelImportRequest.getFromModelId() == null ? "" : dataModelImportRequest.getFromModelId() + "";
        String toModelID = dataModelImportRequest.getToModelId() == null ? "" : dataModelImportRequest.getToModelId() + "";
        DataModelImportParam ImportParam = new DataModelImportParam(dataModelImportRequest.isExist(), dataModelImportRequest.getImportType(), dataModelImportRequest.getImportModelTypeEnum());
        ImportParam.setFromModelID(StringUtils.isEmpty((String)fromModelID) ? null : Long.valueOf(fromModelID));
        ImportParam.setToModelID(StringUtils.isEmpty((String)toModelID) ? null : Long.valueOf(toModelID));
        ImportParam.setDatasourceId(dataModelImportRequest.getDatasourceId());
        ImportParam.setFileUrl(fileUrl);
        ImportParam.setExist(dataModelImportRequest.isExist());
        ImportParam.setFileName(dataModelImportRequest.getFileName());
        ImportParam.setBreakImport(dataModelImportRequest.isBreakImport());
        ImportParam.setSkipErrData(dataModelImportRequest.isSkipErrData());
        ImportParam.setSqlBatch(dataModelImportRequest.getSqlBatch());
        ImportParam.setUseSync(dataModelImportRequest.isUseSync());
        return ImportParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DataModelUtil.doLog("begin import task.", log);
        if (map == null) {
            DataModelUtil.doLog("map is null.", log);
            this.feedbackProgress(100);
            return;
        }
        Object dataModelImportRequestObj = map.get("dataModelImportRequest");
        if (dataModelImportRequestObj == null) {
            DataModelUtil.doLog("dataModelImportRequestObj is null.", log);
            this.feedbackProgress(100);
            return;
        }
        DataModelImportRequest dataModelImportRequest = (DataModelImportRequest)SerializationUtils.deSerializeFromBase64((String)dataModelImportRequestObj.toString());
        try (DLock lock = DLock.create((String)("epm-eb-dataModelImportTask-" + RequestContext.get().getTenantId()));){
            boolean isLock = lock.tryLock();
            try {
                if (!isLock) {
                    HashMap<String, Object> feedBackData = new HashMap<String, Object>(16);
                    feedBackData.put("transportLogId", dataModelImportRequest.getTransportLogId());
                    feedBackData.put("importModelType", dataModelImportRequest.getImportModelTypeEnum().getCode());
                    feedBackData.put("status", "error");
                    feedBackData.put("errorMessage", ResManager.loadKDString((String)"\u5df2\u6709\u7528\u6237\u6b63\u5728\u8fdb\u884c\u6a21\u578b\u4f20\u8f93\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DataModelImportTask_002", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    DataModelTransportLogController.getInstance().updateLog(IDUtils.toLong((Object)dataModelImportRequest.getTransportLogId()), "0", ResManager.loadKDString((String)"\u5df2\u6709\u7528\u6237\u6b63\u5728\u8fdb\u884c\u6a21\u578b\u4f20\u8f93\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DataModelImportTask_002", (String)"epm-eb-formplugin", (Object[])new Object[0]), "", -1);
                    this.feedbackCustomdata(feedBackData);
                    this.feedbackProgress(100);
                    return;
                }
                this.doExecute(dataModelImportRequest);
            }
            finally {
                if (isLock) {
                    lock.unlock();
                }
            }
        }
    }

    private void doExecute(DataModelImportRequest dataModelImportRequest) {
        List<String> tempFileNames = dataModelImportRequest.getTempFileNames();
        Long transportLogId = dataModelImportRequest.getTransportLogId();
        HashMap<String, Object> feedBackData = new HashMap<String, Object>(16);
        feedBackData.put("transportLogId", transportLogId);
        feedBackData.put("importModelType", dataModelImportRequest.getImportModelTypeEnum().getCode());
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u4f53\u7cfb\u5bfc\u5165", (String)"DataModelExportMain_007", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
        if (CollectionUtils.isEmpty(tempFileNames)) {
            this.doSingleModelImport(dataModelImportRequest, feedBackData);
        } else {
            this.doMainSubModelImport(dataModelImportRequest, feedBackData);
        }
        this.feedbackCustomdata(feedBackData);
        this.feedbackProgress(100);
    }

    private void doSingleModelImport(DataModelImportRequest dataModelImportRequest, Map<String, Object> feedBackData) {
        Long transportLogId = dataModelImportRequest.getTransportLogId();
        try {
            DataModelImportParam importParam = this.getImportParam(dataModelImportRequest);
            DataModelImportResult result = new DataModelImportMain().doSave(importParam);
            feedBackData.put("status", "success");
            feedBackData.put("importResult", SerializationUtils.serializeToBase64((Object)result));
            importParam.setJsonAllObject(null);
            feedBackData.put("importParam", SerializationUtils.serializeToBase64((Object)importParam));
            DataModelTransportLogController.getInstance().updateLog(IDUtils.toLong((Object)transportLogId), "1", null, "", 100);
        }
        catch (Exception e) {
            feedBackData.put("status", "error");
            feedBackData.put("errorMessage", e.getMessage());
            DataModelTransportLogController.getInstance().updateLog(IDUtils.toLong((Object)transportLogId), "0", e.getMessage(), "", -1);
        }
    }

    private void doMainSubModelImport(DataModelImportRequest dataModelImportRequest, Map<String, Object> feedBackData) {
        Map<String, String> modelNumberResetMap = dataModelImportRequest.getModelNumberResetMap();
        Map<String, String> beforeAfterResetNumberMap = dataModelImportRequest.getBeforeAfterResetNumberMap();
        Long transportLogId = dataModelImportRequest.getTransportLogId();
        List<String> tempFileNames = dataModelImportRequest.getTempFileNames();
        ArrayList<DataModelImportParam> importParams = new ArrayList<DataModelImportParam>(16);
        ArrayList<DataModelImportResult> results = new ArrayList<DataModelImportResult>(16);
        ArrayList<DataModelImportResult> results1 = new ArrayList<DataModelImportResult>(16);
        HashSet<String> hasErrorDataModelNumbers = new HashSet<String>(16);
        HashMap<String, Map<String, Map<String, Map<String, Map<Long, Set<Long>>>>>> mainSubModelUpdateMap = new HashMap<String, Map<String, Map<String, Map<String, Map<Long, Set<Long>>>>>>(16);
        LinkedHashMap<String, Map<Long, String>> idAndNumberMapFromJson = new LinkedHashMap<String, Map<Long, String>>(16);
        String errorMessage = "";
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u4f53\u7cfb\u5bfc\u5165", (String)"DataModelExportMain_007", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
        try (TXHandle txHandle = TX.requiresNew((String)"epm-eb-dataModelImportTask");){
            try {
                int index = 1;
                for (String tempFileName : tempFileNames) {
                    String fnumber;
                    String jsonStr;
                    int progress = (int)(99.0 * (double)index / (double)tempFileNames.size());
                    String name = DataModelReadJsonFile.getInstance().unCompressFile(new ZipInputStream(CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(tempFileName)));
                    if (name == null) {
                        DataModelUtil.doLog("name is null.", log);
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u975e\u539f\u5bfc\u51fa\u7684zip\u6587\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"DataModelImportBillPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    File file = new File(FilenameUtils.getName((String)name));
                    try (InputStream inputStream = Files.newInputStream(Paths.get(FilenameUtils.getName((String)file.getPath()), new String[0]), new OpenOption[0]);){
                        jsonStr = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        DataModelReadJsonFile.deleteFile(file);
                    }
                    DataModelReadJsonFile.deleteFile(new File(FilenameUtils.getName((String)name)));
                    Object jsonObj = DataModelReadJsonFile.getInstance().getEncryptJson(jsonStr);
                    JSONObject jsonObject = jsonObj instanceof String ? JSONObject.parseObject((String)((String)jsonObj), (Feature[])new Feature[]{Feature.OrderedField}) : (JSONObject)jsonObj;
                    DataModelImportParam importParam = this.getImportParam(dataModelImportRequest);
                    importParam.setExist(false);
                    importParam.setFromModelID(null);
                    importParam.setToModelID(null);
                    importParam.setToModelNumber(null);
                    if (modelNumberResetMap != null) {
                        String resetNumber = modelNumberResetMap.get(tempFileName);
                        JSONObject modelJsonObject = jsonObject.getJSONObject(DataModelTransEnum.model.getFormID());
                        if (StringUtils.isNotEmpty((String)resetNumber)) {
                            modelJsonObject.getJSONArray(DataModelTransEnum.model.getTableName()).getJSONObject(1).put("FSHOWNUMBER", (Object)resetNumber);
                            modelJsonObject.getJSONArray(DataModelTransEnum.model.getTableName()).getJSONObject(1).put("FNUMBER", (Object)resetNumber);
                            importParam.setToModelNumber(resetNumber);
                        }
                        String fparentnumber = modelJsonObject.getJSONArray(DataModelTransEnum.model.getTableName()).getJSONObject(1).getString("FPARENTNUMBER");
                        if (beforeAfterResetNumberMap != null) {
                            String afterNumber;
                            JSONObject mainSubModelBaseJson;
                            String afterParentNumber = beforeAfterResetNumberMap.get(fparentnumber);
                            if (StringUtils.isNotEmpty((String)afterParentNumber)) {
                                modelJsonObject.getJSONArray(DataModelTransEnum.model.getTableName()).getJSONObject(1).put("FPARENTNUMBER", (Object)afterParentNumber);
                            }
                            if ((mainSubModelBaseJson = jsonObject.getJSONObject(DataModelTransEnum.mainsubmodelbase.getFormID())) != null && StringUtils.isNotEmpty((String)(afterNumber = beforeAfterResetNumberMap.get(fnumber = mainSubModelBaseJson.getJSONArray(DataModelTransEnum.mainsubmodelbase.getTableName()).getJSONObject(1).getString("FNUMBER"))))) {
                                mainSubModelBaseJson.getJSONArray(DataModelTransEnum.mainsubmodelbase.getTableName()).getJSONObject(1).put("FNUMBER", (Object)afterNumber);
                            }
                        }
                    }
                    String modelNumber = "";
                    String parentNumber = "";
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        JSONArray jsonArray;
                        String formId = (String)entry.getKey();
                        JSONObject value = (JSONObject)entry.getValue();
                        if ("mask".equals(formId) || DataModelTransEnum.mainsubmodelbase.getFormID().equalsIgnoreCase(formId) || DataModelTransEnum.mainsubmodelsynclog.getFormID().equalsIgnoreCase(formId)) continue;
                        if (DataModelTransEnum.model.getFormID().equalsIgnoreCase(formId)) {
                            jsonArray = value.getJSONArray(DataModelTransEnum.model.getTableName());
                            if (jsonArray == null) {
                                log.info("model json is null.");
                                break;
                            }
                            JSONObject modelJsonObj = jsonArray.getJSONObject(1);
                            if (modelJsonObj == null) {
                                log.info("model json is null.");
                                break;
                            }
                            modelNumber = modelJsonObj.getString("FSHOWNUMBER");
                            Long fid = modelJsonObj.getLong("FID");
                            parentNumber = modelJsonObj.getString("FPARENTNUMBER");
                            Map longStringMap = idAndNumberMapFromJson.computeIfAbsent(formId, t -> new LinkedHashMap(16));
                            longStringMap.put(fid, modelNumber);
                            continue;
                        }
                        Map longStringMap = idAndNumberMapFromJson.computeIfAbsent(formId, t -> new LinkedHashMap(16));
                        DataModelTransEnum enumByFormID = DataModelTransEnum.getEnumByFormID(formId);
                        if (enumByFormID == null) continue;
                        jsonArray = value.getJSONArray(enumByFormID.getTableName());
                        if (jsonArray == null) break;
                        if (jsonArray.size() < 2) continue;
                        int jsonIndex = 0;
                        for (Object o : jsonArray) {
                            JSONObject jsonObjTemp = (JSONObject)o;
                            if (jsonIndex == 0) {
                                ++jsonIndex;
                                continue;
                            }
                            fnumber = jsonObjTemp.getString(enumByFormID.getFnumber());
                            Long fid = jsonObjTemp.getLong(enumByFormID.getFID());
                            longStringMap.put(fid, fnumber);
                            ++jsonIndex;
                        }
                    }
                    importParam.setJsonAllObject(jsonObject);
                    log.info("begin doSave.");
                    this.feedBackImportProgress((int)((double)progress / 2.0), transportLogId);
                    DataModelImportResult result = new DataModelImportMain().doSave(importParam);
                    results1.add(result);
                    importParams.add(importParam);
                    if (DataModelCommon.getInstance().isBreakImport(result, importParam)) {
                        DataModelUtil.doLog("after_saveJson_isBreakImport: ture", log);
                        importParam.setJsonAllObject(null);
                        hasErrorDataModelNumbers.add(modelNumber);
                        results.add(result);
                        continue;
                    }
                    if (result.getMainSubModelUpdateMap().size() > 0) {
                        mainSubModelUpdateMap.computeIfAbsent(parentNumber + "#" + modelNumber, t -> result.getMainSubModelUpdateMap());
                    }
                    this.feedBackImportProgress(progress, transportLogId);
                    ++index;
                }
                this.beforeCommitTransaction(mainSubModelUpdateMap, idAndNumberMapFromJson);
                feedBackData.put("status", "success");
                if (CollectionUtils.isNotEmpty(results)) {
                    ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(16);
                    int index1 = 0;
                    for (DataModelImportResult result : results) {
                        JSONObject tipJsonObject = DataModelFormCommon.getTipJsonObject(result);
                        if (tipJsonObject == null) continue;
                        DataModelImportParam importParam1 = (DataModelImportParam)importParams.get(index1++);
                        tipJsonObject.put("modelNumber", (Object)(importParam1.getToModelNumber() + "_ERR"));
                        jsonObjectList.add(tipJsonObject);
                    }
                    String url = DataModelCommon.downloadZipFile(null, jsonObjectList);
                    feedBackData.put("url", url);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u5bfc\u5165\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u8bf7\u4e0b\u8f7d\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u6587\u4ef6\u3002", (String)"DataModelImportTask_001", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", hasErrorDataModelNumbers)}));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error((Throwable)e);
                errorMessage = e.getMessage();
            }
        }
        this.feedbackProgress(99, ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4f53\u7cfb\u5173\u8054\u6570\u636e", (String)"DataModelExportMain_008", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
        DataModelImportMain dataModelImportMain = new DataModelImportMain();
        try {
            for (int i = 0; i < importParams.size(); ++i) {
                DataModelImportParam importParam = (DataModelImportParam)importParams.get(i);
                DataModelImportResult dataModelImportResult = (DataModelImportResult)results1.get(i);
                dataModelImportMain.SyncProcess(dataModelImportResult, importParam);
                dataModelImportMain.SyncProcessOther(dataModelImportResult, importParam);
            }
            this.feedBackImportProgress(100, transportLogId);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errorMessage = e.getMessage();
        }
        if (StringUtils.isNotEmpty((String)errorMessage)) {
            feedBackData.put("status", "error");
            feedBackData.put("errorMessage", errorMessage);
            DataModelTransportLogController.getInstance().updateLog(IDUtils.toLong((Object)transportLogId), "0", errorMessage, feedBackData.get("url") + "", -1);
        } else {
            DataModelTransportLogController.getInstance().updateLog(IDUtils.toLong((Object)transportLogId), "1", null, "", 100);
        }
    }

    private void executeSql(SqlBuilder sqlBuilder) {
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    private void beforeCommitTransaction(Map<String, Map<String, Map<String, Map<String, Map<Long, Set<Long>>>>>> mainSubModelUpdateMap, Map<String, Map<Long, String>> idAndNumberMapFromJson) {
        String numberFlag = "number";
        String selectFields = "id, number";
        for (Map.Entry<String, Map<String, Map<String, Map<String, Map<Long, Set<Long>>>>>> entry : mainSubModelUpdateMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("#");
            String parentModelNumber = split[0];
            String modelNumber = split[1];
            Map<String, Map<String, Map<String, Map<Long, Set<Long>>>>> value = entry.getValue();
            for (Map.Entry<String, Map<String, Map<String, Map<Long, Set<Long>>>>> stringMapEntry : value.entrySet()) {
                String needUpdateTableName = stringMapEntry.getKey();
                Map<String, Map<String, Map<Long, Set<Long>>>> needUpdateValue = stringMapEntry.getValue();
                for (Map.Entry<String, Map<String, Map<Long, Set<Long>>>> mapEntry : needUpdateValue.entrySet()) {
                    String needUpdateField = mapEntry.getKey();
                    Map<String, Map<Long, Set<Long>>> needUpdateFormIdMap = mapEntry.getValue();
                    for (Map.Entry<String, Map<Long, Set<Long>>> entry1 : needUpdateFormIdMap.entrySet()) {
                        String formId = entry1.getKey();
                        DataModelTransEnum enumByFormID = DataModelTransEnum.getEnumByFormID(formId);
                        if (enumByFormID != null) {
                            numberFlag = enumByFormID.getFnumber().substring(1);
                            selectFields = "id, " + numberFlag;
                        }
                        Map<Long, Set<Long>> needUpdateIdMap = entry1.getValue();
                        Map<Long, String> idAndNumberMap = idAndNumberMapFromJson.get(formId);
                        if (idAndNumberMap == null) continue;
                        HashMap<String, Long> parentNumberAndIdMap = new HashMap<String, Long>(16);
                        QFilter qFilter = new QFilter("model.shownumber", "=", (Object)parentModelNumber);
                        if (DataModelTransEnum.model.getFormID().equalsIgnoreCase(formId)) {
                            qFilter = new QFilter("reporttype", "=", (Object)"7");
                        }
                        DynamicObjectCollection query = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])qFilter.toArray());
                        for (DynamicObject dynamicObject : query) {
                            parentNumberAndIdMap.put(dynamicObject.getString(numberFlag), dynamicObject.getLong("id"));
                        }
                        HashMap<String, Long> childNumberAndIdMap = new HashMap<String, Long>(16);
                        if (!DataModelTransEnum.model.getFormID().equalsIgnoreCase(formId)) {
                            QFilter qFilter1 = new QFilter("model.shownumber", "=", (Object)modelNumber);
                            DynamicObjectCollection query1 = QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])qFilter1.toArray());
                            for (DynamicObject dynamicObject : query1) {
                                childNumberAndIdMap.put(dynamicObject.getString(numberFlag), dynamicObject.getLong("id"));
                            }
                        }
                        for (Map.Entry<Long, Set<Long>> longSetEntry : needUpdateIdMap.entrySet()) {
                            Long needUpdateId = longSetEntry.getKey();
                            Set<Long> needUpdatePkIds = longSetEntry.getValue();
                            String number = idAndNumberMap.get(needUpdateId);
                            if (number == null) {
                                log.info("DataModelImportTask beforecommitTransaction number is null.");
                                continue;
                            }
                            Long realId = (Long)parentNumberAndIdMap.get(number);
                            if (IDUtils.isEmptyLong((Long)realId).booleanValue()) {
                                realId = (Long)childNumberAndIdMap.get(number);
                            }
                            if (realId == null) {
                                log.info("number:" + number);
                                log.info("DataModelImportTask beforecommitTransaction realId is null.");
                                continue;
                            }
                            SqlBuilder sqlBuilder = new SqlBuilder();
                            sqlBuilder.append("update " + needUpdateTableName + " set " + needUpdateField + " = ? where ", new Object[]{realId});
                            if ("t_eb_mainsubmodel_bizmode".equals(needUpdateTableName)) {
                                sqlBuilder.appendIn(" fpkid ", needUpdatePkIds.toArray());
                            } else if ("t_eb_submodelsync_log".equals(needUpdateTableName) || DataModelTransEnum.mainsubmodelbase.getTableName().equalsIgnoreCase(needUpdateTableName)) {
                                sqlBuilder.appendIn(" fid ", needUpdatePkIds.toArray());
                            } else {
                                sqlBuilder.appendIn(" fentryid ", needUpdatePkIds.toArray());
                            }
                            this.executeSql(sqlBuilder);
                        }
                    }
                }
            }
        }
    }

    public void feedBackImportProgress(int progress, Long transportLogId) {
        this.feedbackProgress(progress);
        DataModelTransportLogController.getInstance().updateProgress(transportLogId, progress);
    }
}

